/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dsops.Ops;

public class ValuesTreeModel
extends DefaultTreeModel {
    private static final int TAIL_COUNT = 3;
    QDataSet ds;
    String dsLabel;
    MutableTreeNode mroot;

    public ValuesTreeModel(QDataSet ds) {
        this(null, ds);
    }

    public ValuesTreeModel(String prefix, QDataSet ds) {
        super(new DefaultMutableTreeNode((prefix == null ? "" : prefix) + DataSetUtil.toString(ds)));
        this.mroot = (MutableTreeNode)this.root;
        ValuesTreeModel.valuesTreeNode("HELP", this.mroot, ds, 10);
    }

    public static TreeNode valuesTreeNode2(final String prefix, final TreeNode parent, final QDataSet ds) {
        final Units units = (Units)ds.property("UNITS");
        final QDataSet wds = DataSetUtil.weightsDataSet(ds);
        final QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        final Units depu = dep0 == null ? null : (Units)dep0.property("UNITS");
        return new TreeNode(){

            public TreeNode getChildAt(int i) {
                if (ds.rank() == 1) {
                    String sval;
                    String string = sval = units == null ? String.valueOf(ds.value(i)) : String.valueOf(units.createDatum(ds.value(i)));
                    if (wds.value(i) > 0.0) {
                        sval = "fill (" + ds.value(i) + ")";
                    }
                    return new DefaultMutableTreeNode(prefix + "" + i + ")=" + sval);
                }
                String sdepu = dep0 == null ? String.valueOf(i) : String.valueOf(depu.createDatum(dep0.value(i)));
                DefaultMutableTreeNode sliceNode = new DefaultMutableTreeNode("values @ " + sdepu);
                return sliceNode;
            }

            public int getChildCount() {
                return Math.min(ds.length(), 10);
            }

            public TreeNode getParent() {
                return parent;
            }

            public int getIndex(TreeNode node) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean getAllowsChildren() {
                return true;
            }

            public boolean isLeaf() {
                return false;
            }

            public Enumeration children() {
                return new Enumeration(){
                    int i = 0;

                    public boolean hasMoreElements() {
                        return this.i < this.getChildCount();
                    }

                    public Object nextElement() {
                        return this.getChildAt(this.i++);
                    }
                };
            }
        };
    }

    private static String svalRank1(QDataSet wds, QDataSet ds, int i) {
        if (ds.rank() == 2 && ds.property("BINS_1").equals("min,max")) {
            return DataSetUtil.asDatumRange(ds.slice(i), true).toString();
        }
        try {
            String s = DataSetUtil.getStringValue(ds, ds.value(i));
            return wds.value(i) > 0.0 ? s : "fill (" + s + ")";
        }
        catch (IllegalArgumentException ex) {
            return "Error: " + ex;
        }
    }

    public static MutableTreeNode valuesTreeNode(String prefix, MutableTreeNode aroot, QDataSet ds, int sizeLimit) {
        Units depu;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QDataSet bundle = (QDataSet)ds.property("BUNDLE_0");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet wdsDep0 = null;
        if (dep0 != null) {
            wdsDep0 = DataSetUtil.weightsDataSet(dep0);
        }
        Units units = depu = dep0 == null ? Units.dimensionless : (Units)dep0.property("UNITS");
        if (depu == null) {
            depu = Units.dimensionless;
        }
        if (ds.rank() == 0) {
            String sval = DataSetUtil.asDatum((RankZeroDataSet)ds).toString();
            aroot.insert(new DefaultMutableTreeNode(prefix + ")=" + sval), aroot.getChildCount());
        } else if (ds.rank() == 1) {
            String sval;
            Units u;
            int i;
            Units units2 = (Units)ds.property("UNITS");
            if (units2 == null) {
                units2 = Units.dimensionless;
            }
            for (i = 0; i < Math.min(ds.length(), sizeLimit); ++i) {
                u = units2;
                if (bundle != null && (u = (Units)bundle.property("UNITS", i)) == null) {
                    u = Units.dimensionless;
                }
                if (u instanceof EnumerationUnits) {
                    try {
                        sval = ValuesTreeModel.svalRank1(wds, ds, i);
                    }
                    catch (IllegalArgumentException ex) {
                        sval = "" + ds.value(i) + " (error)";
                    }
                } else {
                    sval = ValuesTreeModel.svalRank1(wds, ds, i);
                }
                if (dep0 != null) {
                    sval = sval + " @ " + ValuesTreeModel.svalRank1(wdsDep0, dep0, i);
                }
                if (bundle != null) {
                    sval = bundle.property("NAME", i) + " = " + ValuesTreeModel.svalRank1(wds, ds, i);
                    aroot.insert(new DefaultMutableTreeNode(sval), aroot.getChildCount());
                    continue;
                }
                aroot.insert(new DefaultMutableTreeNode(prefix + "" + i + ")=" + sval), aroot.getChildCount());
            }
            if (ds.length() >= sizeLimit) {
                aroot.insert(new DefaultMutableTreeNode("..."), aroot.getChildCount());
            }
            for (i = Math.max(ds.length() - 3, sizeLimit); i < ds.length(); ++i) {
                u = units2;
                if (bundle != null && (u = (Units)bundle.property("UNITS", i)) == null) {
                    u = Units.dimensionless;
                }
                if (u instanceof EnumerationUnits) {
                    try {
                        sval = ValuesTreeModel.svalRank1(wds, ds, i);
                    }
                    catch (IllegalArgumentException ex) {
                        sval = "" + ds.value(i) + " (error)";
                    }
                } else {
                    sval = ValuesTreeModel.svalRank1(wds, ds, i);
                }
                if (dep0 != null) {
                    sval = sval + " @ " + ValuesTreeModel.svalRank1(wdsDep0, dep0, i);
                }
                if (bundle != null) {
                    sval = bundle.property("NAME", i) + " = " + ValuesTreeModel.svalRank1(wds, ds, i);
                    aroot.insert(new DefaultMutableTreeNode(sval), aroot.getChildCount());
                    continue;
                }
                aroot.insert(new DefaultMutableTreeNode(prefix + "" + i + ")=" + sval), aroot.getChildCount());
            }
        } else {
            DefaultMutableTreeNode sliceNode;
            int i;
            if (dep0 == null) {
                dep0 = Ops.dindgen(ds.length());
            }
            if (depu == null) {
                depu = Units.dimensionless;
            }
            for (i = 0; i < Math.min(ds.length(), sizeLimit); ++i) {
                if (dep0.rank() != 1) continue;
                sliceNode = new DefaultMutableTreeNode("values @ " + depu.createDatum(dep0.value(i)));
                aroot.insert(sliceNode, aroot.getChildCount());
                ValuesTreeModel.valuesTreeNode(prefix + i + ",", sliceNode, DataSetOps.slice0(ds, i), 20);
            }
            if (ds.length() >= sizeLimit) {
                aroot.insert(new DefaultMutableTreeNode("..."), aroot.getChildCount());
            }
            for (i = Math.max(ds.length() - 3, sizeLimit); i < ds.length(); ++i) {
                if (dep0.rank() != 1) continue;
                sliceNode = new DefaultMutableTreeNode("values @ " + depu.createDatum(dep0.value(i)));
                aroot.insert(sliceNode, aroot.getChildCount());
                ValuesTreeModel.valuesTreeNode(prefix + i + ",", sliceNode, DataSetOps.slice0(ds, i), 20);
            }
        }
        return aroot;
    }
}

