/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsutil.AsciiParser;

public class AsciiParserDemo {
    public static void main(String[] args) throws Exception {
        AsciiParserDemo.testRich();
        System.err.println(",hello,".split(",").length);
        System.err.println(" hello ".split("\\s+").length);
        System.err.println(TimeParser.iso8601String((String)"2008-09-04T00:00:22"));
        System.err.println(TimeParser.iso8601String((String)"2008-004 00:00"));
        System.err.println(TimeParser.iso8601String((String)"2008-09-04T00:00:22.000000"));
        System.err.println(TimeParser.iso8601String((String)"19951231T235959"));
    }

    private static void test1() throws IOException, MalformedURLException {
        AsciiParser parser = new AsciiParser();
        URL testFile = new URL("file:///N:/data/examples/asciitable/omni2_1965.dat");
        parser.setDelimParser(new InputStreamReader(testFile.openStream()), "\\s+");
        WritableDataSet ds = parser.readStream(new InputStreamReader(testFile.openStream()), (ProgressMonitor)new NullProgressMonitor());
        TimeParser p = TimeParser.create((String)"%Y %j %H");
        TimeLocationUnits u = Units.t2000;
        for (int i = 0; i < ds.length(); ++i) {
            p.setDigit(0, (int)ds.value(i, 0));
            p.setDigit(1, (int)ds.value(i, 1));
            p.setDigit(2, (int)ds.value(i, 2));
            ds.putValue(i, 0, p.getTime((Units)Units.t2000));
        }
        System.err.println(ds);
    }

    private static void testRich() throws Exception {
        String sfile = "/home/jbf/ct/hudson/data.backup/dat/headers/CRRES_mod.txt";
        AsciiParser parser = new AsciiParser();
        parser.setKeepFileHeader(true);
        parser.setDelimParser(new InputStreamReader(new FileInputStream(sfile)), "\\s+");
        WritableDataSet ds = parser.readStream(new InputStreamReader(new FileInputStream(sfile)), (ProgressMonitor)new NullProgressMonitor());
        QDataSet rgeo = DataSetOps.unbundle((QDataSet)ds, "Rgeo");
        System.err.println(rgeo);
        QDataSet ii = DataSetOps.unbundle((QDataSet)ds, "I");
        System.err.println(ii);
    }
}

