/*
 * Decompiled with CFR 0.152.
 */
package org.tsds.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.dataset.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.tsds.datasource.TsmlNcml;
import org.virbo.binarydatasource.BufferDataSet;
import org.virbo.binarydatasource.Double;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.dsops.Ops;
import org.virbo.metatree.MetadataUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TsdsDataSource
extends AbstractDataSource {
    long t0 = System.currentTimeMillis();
    DatumRange timeRange;
    Datum resolution;
    int currentPpd = -1;
    private static final int SIZE_DOUBLE = 8;
    private static final Logger logger = Logger.getLogger("virbo.tsds.datasource");
    Document initialDocument;
    DatumRange parameterRange = null;
    int parameterPpd = -1;
    boolean haveInitialTsml = false;
    Exception exceptionFromConstruct = null;
    boolean inRequest = false;

    public TsdsDataSource(URI uri) {
        super(uri);
        try {
            this.addCability(TimeSeriesBrowse.class, this.getTimeSeriesBrowse());
            this.setTSBParameters();
            NullProgressMonitor mon = new NullProgressMonitor();
            URL url0 = new URL("" + this.resourceURI + "?" + URISplit.formatParams((Map)this.params));
            logger.log(Level.FINE, "tsds url= {0}", url0);
            if (this.params.get("out") == null) {
                this.exceptionFromConstruct = new IllegalArgumentException("url must contain out=");
                return;
            }
            mon.setProgressMessage("loading parameter metadata");
            LinkedHashMap<String, String> params3 = new LinkedHashMap<String, String>(this.params);
            params3.put("out", "tsml");
            params3.remove("ppd");
            String sparams = URISplit.formatParams(params3);
            sparams = sparams.replace("out=tsml", "out=tsml&ext=" + (String)this.params.get("out"));
            this.logit("post first request in construct TsdsDataSource", this.t0);
            URL url3 = new URL("" + this.resourceURI + "?" + sparams);
            logger.log(Level.FINE, "opening {0}", url3);
            this.initialTsml(url3.openStream());
            this.logit("read initial tsml", this.t0);
            this.haveInitialTsml = true;
            this.setTSBParameters();
            this.parameterPpd = this.currentPpd;
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(TsdsDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TsdsDataSource.class.getName()).log(Level.SEVERE, null, ex);
            this.exceptionFromConstruct = ex;
        }
        catch (SAXException ex) {
            Logger.getLogger(TsdsDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void logit(String string, long t0) {
    }

    private DatumRange quantizeTimeRange(DatumRange timeRange) {
        timeRange = new DatumRange(TimeUtil.prevMidnight((Datum)timeRange.min()), TimeUtil.nextMidnight((Datum)timeRange.max()));
        return timeRange;
    }

    private int quantizePpd(Datum resolution) {
        int[] ppds = new int[]{1, 8, 24, 96, 144, 4320, 17280, 86400, 864000};
        if (resolution == null) {
            return 1;
        }
        double resdays = resolution.doubleValue(Units.days);
        double dppd = 1.0 / resdays;
        int ppd = ppds[ppds.length - 1];
        for (int i = 0; i < ppds.length && ppds[i] <= this.parameterPpd; ++i) {
            if (!((double)ppds[i] > dppd)) continue;
            ppd = ppds[i];
            return ppd;
        }
        return this.parameterPpd;
    }

    private void setTSBParameters() {
        LinkedHashMap params2 = new LinkedHashMap(this.params);
        DatumRange dr0 = DatumRangeUtil.parseTimeRangeValid((String)((String)params2.get("StartDate")));
        DatumRange dr1 = DatumRangeUtil.parseTimeRangeValid((String)((String)params2.get("EndDate")));
        this.timeRange = this.quantizeTimeRange(new DatumRange(dr0.min(), dr1.max()));
        String sppd = (String)params2.get("ppd");
        if (sppd != null) {
            int ppd = Integer.parseInt(sppd);
            this.currentPpd = ppd > this.parameterPpd ? this.parameterPpd : ppd;
            this.resolution = Units.days.createDatum(1.0).divide((double)this.currentPpd);
        } else {
            int ppd = -1;
            this.currentPpd = -1;
            this.resolution = null;
        }
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        QDataSet result;
        int ppd;
        this.logit("enter getDataSet", this.t0);
        if (this.inRequest) {
            logger.fine("came back again");
        } else {
            this.inRequest = true;
        }
        LinkedHashMap<String, String> params2 = new LinkedHashMap<String, String>(this.params);
        TimeDatumFormatter df = new TimeDatumFormatter("%Y%m%d");
        if (this.timeRange != null) {
            this.timeRange = this.quantizeTimeRange(this.timeRange);
            params2.put("StartDate", "" + df.format(this.timeRange.min()));
            params2.put("EndDate", "" + df.format(TimeUtil.prev((int)3, (Datum)this.timeRange.max())));
        } else {
            this.setTSBParameters();
        }
        if (this.currentPpd == -1) {
            params2.put("ppd", "1");
        } else {
            params2.put("ppd", "" + this.currentPpd);
        }
        mon.setTaskSize(-1L);
        mon.started();
        if (!this.haveInitialTsml) {
            if (this.exceptionFromConstruct != null) {
                throw this.exceptionFromConstruct;
            }
            mon.setProgressMessage("loading parameter metadata");
            LinkedHashMap<String, String> params3 = new LinkedHashMap<String, String>(params2);
            params3.remove("ppd");
            params3.put("out", "tsml");
            URL url3 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params3));
            logger.log(Level.FINE, "opening {0}", url3);
            this.initialTsml(url3.openStream());
            this.haveInitialTsml = true;
            this.logit("got initial tsml", this.t0);
        }
        if (this.currentPpd == -1) {
            ppd = 1;
            params2.put("ppd", "" + ppd);
        } else {
            ppd = this.currentPpd;
        }
        URL url2 = new URL("" + this.resourceURI + "?" + URISplit.formatParams(params2));
        int points = (int)Math.ceil(this.timeRange.width().doubleValue(Units.days)) * ppd;
        int size = points * 8;
        this.logit("making url2 connection", this.t0);
        logger.log(Level.FINE, "{0}", url2);
        HttpURLConnection connect = (HttpURLConnection)url2.openConnection();
        connect.connect();
        String type = connect.getContentType();
        this.logit("made url2 connection", this.t0);
        if (((String)this.params.get("out")).equals("ncml")) {
            result = new TsmlNcml().doRead(url2, connect);
        } else if (type.startsWith("text/xml")) {
            result = this.tsml(connect.getInputStream(), mon);
            this.logit("done text/xml from url2", this.t0);
        } else {
            result = this.dataUrl(connect, size, points, -1, mon);
            this.logit("done dataUrl from url2", this.t0);
        }
        mon.finished();
        this.inRequest = false;
        return result;
    }

    public TimeSeriesBrowse getTimeSeriesBrowse() {
        return new TimeSeriesBrowse(){

            public void setTimeRange(DatumRange dr) {
                System.out.println(dr);
                TsdsDataSource.this.timeRange = TsdsDataSource.this.quantizeTimeRange(dr);
                System.out.println(TsdsDataSource.this.timeRange);
                System.out.println(TsdsDataSource.this.timeRange.width());
            }

            public void setTimeResolution(Datum d) {
                TsdsDataSource.this.resolution = d;
                if (TsdsDataSource.this.resolution == null) {
                    TsdsDataSource.this.currentPpd = -1;
                } else {
                    TsdsDataSource.this.currentPpd = TsdsDataSource.this.quantizePpd(TsdsDataSource.this.resolution);
                    TsdsDataSource.this.resolution = Units.days.createDatum(1.0).divide((double)TsdsDataSource.this.currentPpd);
                }
            }

            public String getURI() {
                TimeParser tp = TimeParser.create((String)"%Y%m%d");
                String sparams = "StartDate=" + tp.format(TsdsDataSource.this.timeRange.min(), null) + "&EndDate=" + tp.format(TsdsDataSource.this.timeRange.max(), null) + "&ppd=" + TsdsDataSource.this.currentPpd + "&ext=" + (String)TsdsDataSource.this.params.get("ext") + "&out=" + (String)TsdsDataSource.this.params.get("out") + "&param1=" + (String)TsdsDataSource.this.params.get("param1");
                return "vap+tsds:" + DataSetURI.fromUri((URI)TsdsDataSource.this.resourceURI) + "?" + sparams;
            }

            public DatumRange getTimeRange() {
                return TsdsDataSource.this.timeRange;
            }

            public Datum getTimeResolution() {
                return TsdsDataSource.this.resolution;
            }

            public void setURI(String suri) throws ParseException {
            }
        };
    }

    private BufferDataSet dataUrl(HttpURLConnection connection, int size, int points, int len1, ProgressMonitor mon) throws IOException {
        InputStream in = connection.getInputStream();
        String encoding = connection.getContentEncoding();
        logger.log(Level.FINER, "downloading {0}", connection.getURL());
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            logger.finer("got gzip encoding");
            in = new GZIPInputStream(in);
        } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
            logger.finer("got deflate encoding");
            in = new InflaterInputStream(in, new Inflater(true));
        }
        ReadableByteChannel bin = Channels.newChannel(in);
        ByteBuffer bbuf = ByteBuffer.allocate(size);
        int totalBytesRead = 0;
        int bytesRead = bin.read(bbuf);
        mon.setTaskSize((long)size);
        while (bytesRead >= 0 && bytesRead + totalBytesRead < size) {
            totalBytesRead += bytesRead;
            bytesRead = bin.read(bbuf);
            if (mon.isCancelled()) {
                throw new InterruptedIOException("cancel read in TSDS");
            }
            mon.setTaskProgress((long)totalBytesRead);
        }
        in.close();
        bbuf.flip();
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        int expectedPoints = points;
        points = bbuf.limit() / 8;
        if (points == 0 && points < expectedPoints) {
            throw new IOException("No data returned from " + connection.getURL());
        }
        if (len1 == -1) {
            return new Double(1, 8, 0, points, 1, 1, 1, bbuf);
        }
        return new Double(2, len1 * 8, 0, points, len1, 1, 1, bbuf);
    }

    private QDataSet ttags(String sStartTime, int ppd, int points, String sTimePos) {
        Datum cadence = Units.days.createDatum(1).divide((double)ppd);
        Datum startTime = TimeUtil.createValid((String)sStartTime);
        Datum endTime = startTime.add(Units.days.createDatum(1.0 * (double)points / (double)ppd));
        Datum t0_1 = startTime;
        if (sTimePos.equals("center")) {
            t0_1 = t0_1.add(cadence.divide(2.0));
        }
        try {
            DDataSet result = (DDataSet)ArrayDataSet.copy(java.lang.Double.TYPE, (QDataSet)Ops.timegen((String)String.valueOf(t0_1), (String)String.valueOf(cadence), (int)points));
            DatumRange timeRange_1 = new DatumRange(startTime, endTime);
            result.putProperty("CACHE_TAG", (Object)new CacheTag(timeRange_1, cadence));
            return result;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initialNcml(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        try {
            int ppd;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            this.initialDocument = builder.parse(source);
            in.close();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            String sStartTime = xpath.evaluate("//netcdf/StartDate/text()", this.initialDocument);
            String sEndTime = xpath.evaluate("//netcdf/EndDate/text()", this.initialDocument);
            String sppd = xpath.evaluate("//netcdf/IntervalsPerDay/text()", this.initialDocument);
            this.parameterPpd = ppd = Integer.parseInt(sppd);
            DatumRange dr0 = DatumRangeUtil.parseTimeRangeValid((String)sStartTime);
            DatumRange dr1 = DatumRangeUtil.parseTimeRangeValid((String)sEndTime);
            this.parameterRange = new DatumRange(dr0.min(), dr1.max());
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(TsdsDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initialTsml(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        try {
            int ppd;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            this.initialDocument = builder.parse(source);
            in.close();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            String sStartTime = xpath.evaluate("//TSML/StartDate/text()", this.initialDocument);
            String sEndTime = xpath.evaluate("//TSML/EndDate/text()", this.initialDocument);
            String sppd = xpath.evaluate("//TSML/IntervalsPerDay/text()", this.initialDocument);
            this.parameterPpd = ppd = Integer.parseInt(sppd);
            DatumRange dr0 = DatumRangeUtil.parseTimeRangeValid((String)sStartTime);
            DatumRange dr1 = DatumRangeUtil.parseTimeRangeValid((String)sEndTime);
            this.parameterRange = new DatumRange(dr0.min(), dr1.max());
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(TsdsDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private BufferDataSet tsml(InputStream in, ProgressMonitor mon) throws ParserConfigurationException, IOException, SAXException {
        try {
            BufferDataSet data;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource source = new InputSource(in);
            Document document = builder.parse(source);
            in.close();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            String surl = xpath.evaluate("//TSML/DataURL/text()", document);
            String sunits = xpath.evaluate("//TSML/Unit/text()", document);
            String sStartTime = xpath.evaluate("//TSML/StartDate/text()", document);
            String sEndTime = xpath.evaluate("//TSML/EndDate/text()", document);
            String sppd = xpath.evaluate("//TSML/IntervalsPerDay/text()", document);
            int ppd = Integer.parseInt(sppd);
            if (this.parameterPpd == -1) {
                this.parameterPpd = ppd;
            }
            DatumRange dr0 = DatumRangeUtil.parseTimeRangeValid((String)sStartTime);
            DatumRange dr1 = DatumRangeUtil.parseTimeRangeValid((String)sEndTime);
            this.timeRange = new DatumRange(dr0.min(), dr1.max());
            int points = (int)Math.ceil(this.timeRange.width().doubleValue(Units.days)) * ppd;
            int size = points * 8;
            String sTimePos = xpath.evaluate("//TSML/TimeStampPosition/text()", document);
            QDataSet ttags = !sTimePos.equals("") ? this.ttags(sStartTime, ppd, points, sTimePos) : null;
            String title = xpath.evaluate("//TSML/Name/text()", document);
            String name = xpath.evaluate("//TSML/DataKey/text()", document);
            name = name.replaceAll("-", "_");
            this.logit("done parse tsml", this.t0);
            boolean minMax = ppd < this.parameterPpd;
            boolean useFilter4 = true;
            if (minMax && useFilter4 && surl.contains("-filter_0-")) {
                String surl4 = surl.replace("-filter_0-", "-filter_4-");
                mon.setProgressMessage("loading data and ranges");
                URL dataUrl = new URL(surl4);
                HttpURLConnection connect = (HttpURLConnection)dataUrl.openConnection();
                connect.setRequestProperty("Accept-Encoding", "gzip, deflate");
                logger.log(Level.FINE, "loading {0}", surl4);
                Double data3 = (Double)this.dataUrl(connect, 3 * size, 3 * points, -1, mon);
                this.logit("done loading mean", this.t0);
                data = (BufferDataSet)data3.trim(0, points);
                BufferDataSet dataMin = (BufferDataSet)data3.trim(2 * points, 3 * points);
                dataMin.putProperty("NAME", (Object)"binmin");
                BufferDataSet dataMax = (BufferDataSet)data3.trim(1 * points, 2 * points);
                dataMax.putProperty("NAME", (Object)"binmax");
                data.putProperty("DELTA_PLUS", (Object)Ops.subtract((QDataSet)dataMax, (QDataSet)data));
                data.putProperty("DELTA_MINUS", (Object)Ops.subtract((QDataSet)data, (QDataSet)dataMin));
            } else {
                mon.setProgressMessage("loading mean");
                URL dataUrl = new URL(surl);
                HttpURLConnection connect = (HttpURLConnection)dataUrl.openConnection();
                connect.setRequestProperty("Accept-Encoding", "gzip, deflate");
                logger.log(Level.FINE, "loading {0}", dataUrl);
                data = this.dataUrl(connect, size, points, -1, mon);
                this.logit("done loading mean", this.t0);
            }
            if (!useFilter4 && minMax && surl.contains("-filter_0-")) {
                String sDataMax = surl.replace("-filter_0-", "-filter_2-");
                logger.log(Level.FINE, "loading {0}", sDataMax);
                mon.setProgressMessage("loading max");
                URL maxUrl = new URL(sDataMax);
                HttpURLConnection connect = (HttpURLConnection)maxUrl.openConnection();
                connect.setRequestProperty("Accept-Encoding", "gzip, deflate");
                BufferDataSet dataMax = this.dataUrl(connect, size, points, -1, mon);
                this.logit("done loading max", this.t0);
                dataMax.putProperty("NAME", (Object)"binmax");
                String sDataMin = surl.replace("-filter_0-", "-filter_3-");
                logger.log(Level.FINE, "loading {0}", sDataMin);
                mon.setProgressMessage("loading min");
                URL minUrl = new URL(sDataMin);
                connect = (HttpURLConnection)minUrl.openConnection();
                connect.setRequestProperty("Accept-Encoding", "gzip, deflate");
                BufferDataSet dataMin = this.dataUrl(connect, size, points, -1, mon);
                this.logit("done loading min", this.t0);
                dataMin.putProperty("NAME", (Object)"binmin");
                data.putProperty("DELTA_PLUS", (Object)Ops.subtract((QDataSet)dataMax, (QDataSet)data));
                data.putProperty("DELTA_MINUS", (Object)Ops.subtract((QDataSet)data, (QDataSet)dataMin));
            }
            data.putProperty("UNITS", (Object)SemanticOps.lookupUnits((String)sunits));
            data.putProperty("DEPEND_0", (Object)ttags);
            data.putProperty("NAME", (Object)name);
            data.putProperty("TITLE", (Object)title);
            return data;
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        Node n = this.initialDocument.getFirstChild();
        return MetadataUtil.toMetaTree((Node)n);
    }

    public String getURI() {
        return super.getURI();
    }
}

