/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import java.io.Serializable;
import java.util.Vector;

public class Attribute
implements CDFConstants,
CDFObject {
    private CDF myCDF;
    private long scope;
    private long id;
    private long cdfID;
    private String name;
    private long numEntries;
    private long maxEntryNumber;
    private Vector entries = null;

    private Attribute(CDF myCDF) {
        this.myCDF = myCDF;
        this.entries = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static final Attribute retrieve(CDF myCDF, long id) throws CDFException {
        CDF cDF = myCDF;
        // MONITORENTER : cDF
        Attribute theAttr = new Attribute(myCDF);
        myCDF.addAttribute(theAttr);
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(85L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(87L));
        item0.addElement("name");
        item0.addElement("Ljava/lang/String;");
        cmds.addElement(item0);
        cmds.addElement(new Long(86L));
        item1.addElement("scope");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        theAttr.cdfID = myCDF.getID();
        theAttr.id = id;
        myCDF.executeCommand(theAttr, cmds);
        cmds.removeAllElements();
        item0.removeAllElements();
        item1.removeAllElements();
        itemA.removeAllElements();
        itemB.removeAllElements();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(85L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1007L));
        cmds.addElement(theAttr.getScope() == 1L ? new Long(90L) : new Long(94L));
        item0.addElement("numEntries");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(theAttr.getScope() == 1L ? new Long(89L) : new Long(93L));
        item1.addElement("maxEntryNumber");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        myCDF.executeCommand(theAttr, cmds);
        long entryID = -1L;
        long numRead = 0L;
        if (theAttr.numEntries == 0L) {
            // MONITOREXIT : cDF
            return theAttr;
        }
        while (true) {
            try {
                do {
                    Entry curEntry = Entry.retrieve(theAttr, ++entryID);
                    if (++numRead != theAttr.numEntries) continue;
                    return theAttr;
                } while (numRead <= theAttr.maxEntryNumber);
                throw new CDFException(-2043L);
            }
            catch (CDFException e) {
                theAttr.entries.addElement(null);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attribute create(CDF myCDF, String name, long scope) throws CDFException {
        CDF cDF = myCDF;
        synchronized (cDF) {
            if (scope != 1L && scope != 2L) {
                throw new CDFException(-2010L);
            }
            long ij = myCDF.getAttributeID(name);
            if (ij != -1L) {
                throw new CDFException(-2001L);
            }
            if (name == null || name.length() == 0) {
                throw new CDFException(-2044L);
            }
            Vector<Serializable> cmds = new Vector<Serializable>();
            Vector<String> item0 = new Vector<String>();
            Vector<String> item1 = new Vector<String>();
            Vector<String> item2 = new Vector<String>();
            Vector<String> itemA = new Vector<String>();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(1001L));
            cmds.addElement(new Long(85L));
            item0.addElement("name");
            item0.addElement("Ljava/lang/String;");
            cmds.addElement(item0);
            item1.addElement("scope");
            item1.addElement("J");
            cmds.addElement(item1);
            item2.addElement("id");
            item2.addElement("J");
            cmds.addElement(item2);
            cmds.addElement(new Long(1000L));
            Attribute theAttr = new Attribute(myCDF);
            theAttr.name = name;
            theAttr.scope = scope;
            theAttr.cdfID = myCDF.getID();
            theAttr.myCDF.executeCommand(theAttr, cmds);
            myCDF.addAttribute(theAttr);
            if (scope == 2L) {
                for (int i = 0; i < (int)theAttr.myCDF.getNumVars(); ++i) {
                    theAttr.entries.addElement(null);
                }
            }
            return theAttr;
        }
    }

    public synchronized void delete() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(85L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1003L));
        cmds.addElement(new Long(85L));
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        this.myCDF.removeAttribute(this);
    }

    public synchronized Entry getEntry(long entryID) throws CDFException {
        if ((long)this.entries.size() <= entryID) {
            throw new CDFException(-2018L);
        }
        if (this.entries.elementAt((int)entryID) == null) {
            throw new CDFException(-2018L);
        }
        return (Entry)this.entries.elementAt((int)entryID);
    }

    public synchronized Entry getEntry(Variable var) throws CDFException {
        if (this.scope != 2L) {
            throw new CDFException(-2010L);
        }
        if (var.getID() < 0L) {
            throw new CDFException(-2019L);
        }
        return this.getEntry(var.getID());
    }

    protected final synchronized void addEntry(Entry newEntry, int id) {
        int eSize = this.entries.size();
        if (eSize > id) {
            this.entries.insertElementAt(newEntry, id);
            this.entries.removeElementAt(id + 1);
        } else {
            if (this.scope == 1L && eSize < id) {
                for (int i = 0; i < id - eSize; ++i) {
                    this.entries.addElement(null);
                }
            }
            this.entries.addElement(newEntry);
        }
    }

    protected final synchronized void removeEntry(Entry oldEntry) {
        int idx = this.entries.indexOf(oldEntry);
        if (this.scope == 2L || this.scope == 1L && idx != this.entries.size() - 1) {
            this.entries.insertElementAt(null, idx);
            this.entries.removeElementAt(idx + 1);
        } else {
            this.entries.removeElementAt(idx);
        }
    }

    protected final synchronized void removeEntry(int id) {
        this.entries.removeElementAt(id);
    }

    protected final synchronized void addNullEntry() {
        this.entries.addElement(null);
    }

    public synchronized void deleteEntry(long entryID) throws CDFException {
        if (entryID < 0L) {
            throw new CDFException(-2043L);
        }
        if (this.entries.elementAt((int)entryID) == null) {
            throw new CDFException(-2018L);
        }
        ((Entry)this.entries.elementAt((int)entryID)).delete();
    }

    public synchronized void deleteEntry(Variable var) throws CDFException {
        if (this.scope != 2L) {
            throw new CDFException(-2010L);
        }
        if (var.getID() < 0L) {
            throw new CDFException(-2019L);
        }
        this.deleteEntry(var.getID());
    }

    public synchronized Vector getEntries() {
        return this.entries;
    }

    public synchronized long getEntryID(Entry entry) {
        return this.entries.indexOf(entry);
    }

    public synchronized void rename(String newName) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(85L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(87L));
        item0.addElement("name");
        item0.addElement("Ljava/lang/String;");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.name = newName;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    protected final void select() throws CDFException {
        Vector<Long> cmds = new Vector<Long>();
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized long getNumEntries() {
        int count = 0;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (this.entries.elementAt(i) == null) continue;
            ++count;
        }
        return count;
    }

    public synchronized long getMaxEntryNumber() {
        return this.entries.size();
    }

    public synchronized long getID() {
        return this.id;
    }

    public synchronized CDF getMyCDF() {
        return this.myCDF;
    }

    public synchronized String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public synchronized long getScope() {
        return this.scope;
    }
}

