/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFDelegate;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFNativeLibrary;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class CDF
implements CDFObject,
CDFConstants {
    private CDFDelegate delegate;
    private static Object Monitor = new Object();
    private String path;
    private long id;
    private File theFile = null;
    private long cdfStatus;
    private long cType;
    private long cTypeX;
    private long cPct;
    private long[] cParms = new long[1];
    private long[] cParmsX = new long[1];
    private long cSize;
    private long uSize;
    private String copyright = null;
    private String version = null;
    private long vers;
    private long libVersion;
    private long rel;
    private long libRelease;
    private long inc;
    private long libIncrement;
    private String libsubIncrement;
    private String libCopyright;
    private long encoding;
    private long encodingX;
    private long decoding;
    private long cacheSize;
    private long compressCacheSize;
    private long stageCacheSize;
    private long negtoPosfp0;
    private long format;
    private long formatX;
    private long majority;
    private long majorityX;
    private long numAttrs;
    private long numGattrs;
    private long numVattrs;
    private long numRvars;
    private long numZvars;
    private long readOnly;
    private long zmode;
    private long numDims;
    private long[] dimSizes;
    private boolean closed;
    private long infoWarning;
    private static long backward = 0L;
    private static boolean backwardFlagSet = false;
    private long fromEnvVar;
    private static long backwardEnvVar = -1L;
    private long checksum;
    private long checksumX = -1L;
    private static long checksumEnvVar = -1L;
    private Vector attributes;
    private Vector variables;

    private CDF(String path, CDFDelegate delegate) throws CDFException {
        if (path == null || path.length() == 0) {
            throw new CDFException(-2049L);
        }
        String tmpStr = null;
        tmpStr = path.trim();
        if (tmpStr == null || tmpStr.length() == 0) {
            throw new CDFException(-2049L);
        }
        while (tmpStr.startsWith(" ")) {
            tmpStr = tmpStr.substring(1);
        }
        this.path = tmpStr;
        this.delegate = delegate;
        this.zmode = 2L;
        this.attributes = new Vector();
        this.variables = new Vector();
        this.closed = false;
        checksumEnvVar = CDF.getChecksumEnvVar();
    }

    private CDF(CDFDelegate delegate) throws CDFException {
        this.delegate = delegate;
    }

    public static CDF create(String path) throws CDFException {
        CDF theCDF = new CDF(path, new CDFNativeLibrary());
        theCDF.numDims = 0L;
        theCDF.dimSizes = new long[]{2L};
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        Vector<String> item3 = new Vector<String>();
        Vector<String> item4 = new Vector<String>();
        cmds.addElement(new Long(1001L));
        cmds.addElement(new Long(1L));
        item1.addElement("path");
        item1.addElement("Ljava/lang/String;");
        cmds.addElement(item1);
        item2.addElement("numDims");
        item2.addElement("J");
        cmds.addElement(item2);
        item3.addElement("dimSizes");
        item3.addElement("[J");
        cmds.addElement(item3);
        item4.addElement("id");
        item4.addElement("J");
        cmds.addElement(item4);
        cmds.addElement(new Long(1000L));
        theCDF.executeCommand(theCDF, cmds);
        String pathT = theCDF.FindCDFName(path);
        if (pathT != null) {
            theCDF.theFile = new File(pathT);
        }
        theCDF.selectzMode(2L);
        theCDF.selectReadOnlyMode(0L);
        theCDF.getCDFInfo();
        return theCDF;
    }

    public static CDF create(String path, int flag) throws CDFException {
        CDF theCDF = new CDF(path, new CDFNativeLibrary());
        CDF.setFileBackward(flag);
        theCDF.numDims = 0L;
        theCDF.dimSizes = new long[]{2L};
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        Vector<String> item3 = new Vector<String>();
        Vector<String> item4 = new Vector<String>();
        cmds.addElement(new Long(1001L));
        cmds.addElement(new Long(1L));
        item1.addElement("path");
        item1.addElement("Ljava/lang/String;");
        cmds.addElement(item1);
        item2.addElement("numDims");
        item2.addElement("J");
        cmds.addElement(item2);
        item3.addElement("dimSizes");
        item3.addElement("[J");
        cmds.addElement(item3);
        item4.addElement("id");
        item4.addElement("J");
        cmds.addElement(item4);
        cmds.addElement(new Long(1000L));
        theCDF.executeCommand(theCDF, cmds);
        String pathT = theCDF.FindCDFName(path);
        if (pathT != null) {
            theCDF.theFile = new File(pathT);
        }
        theCDF.selectzMode(2L);
        theCDF.selectReadOnlyMode(0L);
        theCDF.getCDFInfo();
        return theCDF;
    }

    public static CDF open(String path) throws CDFException {
        return CDF.open(path, 0L);
    }

    public static CDF open(String path, long readOnly) throws CDFException {
        CDF theCDF = new CDF(path, new CDFNativeLibrary());
        theCDF.infoWarning = 0L;
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        cmds.addElement(new Long(1002L));
        cmds.addElement(new Long(1L));
        item1.addElement("path");
        item1.addElement("Ljava/lang/String;");
        cmds.addElement(item1);
        item2.addElement("id");
        item2.addElement("J");
        cmds.addElement(item2);
        cmds.addElement(new Long(1000L));
        theCDF.executeCommand(theCDF, cmds);
        long statusopen = theCDF.getStatus();
        String pathT = theCDF.FindCDFName(path);
        if (pathT != null) {
            theCDF.theFile = new File(pathT);
        }
        theCDF.selectReadOnlyMode(readOnly);
        theCDF.selectzMode(2L);
        theCDF.getCDFInfo();
        long n = theCDF.numAttrs;
        for (long attrID = 0L; attrID < n; ++attrID) {
            Attribute curAttr = Attribute.retrieve(theCDF, attrID);
        }
        n = theCDF.numZvars;
        Variable v = null;
        for (long varID = 0L; varID < n; ++varID) {
            v = Variable.retrieve(theCDF, varID);
        }
        if (statusopen < theCDF.getStatus()) {
            theCDF.setStatus(statusopen);
        }
        return theCDF;
    }

    public static String getLibraryVersion() throws CDFException {
        CDF theCDF = new CDF(new CDFNativeLibrary());
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        Vector<String> item3 = new Vector<String>();
        Vector<String> item4 = new Vector<String>();
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(21L));
        item1.addElement("libVersion");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(22L));
        item2.addElement("libRelease");
        item2.addElement("J");
        cmds.addElement(item2);
        cmds.addElement(new Long(23L));
        item3.addElement("libIncrement");
        item3.addElement("J");
        cmds.addElement(item3);
        cmds.addElement(new Long(24L));
        item4.addElement("libsubIncrement");
        item4.addElement("Ljava/lang/String;");
        cmds.addElement(item4);
        cmds.addElement(new Long(1000L));
        theCDF.executeCommand(theCDF, cmds);
        return new StringBuffer().append(theCDF.libVersion).append(".").append(theCDF.libRelease).append(".").append(theCDF.libIncrement).append(theCDF.libsubIncrement).toString();
    }

    public static String getLibraryCopyright() throws CDFException {
        CDF theCDF = new CDF(new CDFNativeLibrary());
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item1 = new Vector<String>();
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(20L));
        item1.addElement("libCopyright");
        item1.addElement("Ljava/lang/String;");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        theCDF.executeCommand(theCDF, cmds);
        return theCDF.libCopyright;
    }

    private synchronized void getCDFInfo() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        Vector<String> item3 = new Vector<String>();
        Vector<String> item4 = new Vector<String>();
        Vector<String> item5 = new Vector<String>();
        Vector<String> item6 = new Vector<String>();
        Vector<String> item7 = new Vector<String>();
        Vector<String> item8 = new Vector<String>();
        Vector<String> item9 = new Vector<String>();
        Vector<String> item10 = new Vector<String>();
        Vector<String> item11 = new Vector<String>();
        Vector<String> item12 = new Vector<String>();
        Vector<String> item13 = new Vector<String>();
        Vector<String> item14 = new Vector<String>();
        Vector<String> item15 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(3L));
        item0.addElement("encoding");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(6L));
        item1.addElement("format");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(13L));
        item2.addElement("vers");
        item2.addElement("J");
        cmds.addElement(item2);
        cmds.addElement(new Long(14L));
        item3.addElement("rel");
        item3.addElement("J");
        cmds.addElement(item3);
        cmds.addElement(new Long(15L));
        item4.addElement("inc");
        item4.addElement("J");
        cmds.addElement(item4);
        cmds.addElement(new Long(5L));
        item5.addElement("majority");
        item5.addElement("J");
        cmds.addElement(item5);
        cmds.addElement(new Long(10L));
        item6.addElement("numAttrs");
        item6.addElement("J");
        cmds.addElement(item6);
        cmds.addElement(new Long(11L));
        item7.addElement("numGattrs");
        item7.addElement("J");
        cmds.addElement(item7);
        cmds.addElement(new Long(12L));
        item8.addElement("numVattrs");
        item8.addElement("J");
        cmds.addElement(item8);
        cmds.addElement(new Long(8L));
        item9.addElement("numRvars");
        item9.addElement("J");
        cmds.addElement(item9);
        cmds.addElement(new Long(9L));
        item10.addElement("numZvars");
        item10.addElement("J");
        cmds.addElement(item10);
        cmds.addElement(new Long(156L));
        item15.addElement("checksum");
        item15.addElement("J");
        cmds.addElement(item15);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(7L));
        item11.addElement("copyright");
        item11.addElement("Ljava/lang/String;");
        cmds.addElement(item11);
        cmds.addElement(new Long(130L));
        item12.addElement("cType");
        item12.addElement("J");
        cmds.addElement(item12);
        item13.addElement("cParms");
        item13.addElement("[J");
        cmds.addElement(item13);
        item14.addElement("cPct");
        item14.addElement("J");
        cmds.addElement(item14);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        this.version = new StringBuffer().append(this.vers).append(".").append(this.rel).append(".").append(this.inc).toString();
        this.closed = false;
    }

    public synchronized void close() throws CDFException {
        if (!this.closed) {
            Vector<Serializable> cmds = new Vector<Serializable>();
            Vector<String> item = new Vector<String>();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            item.addElement("id");
            item.addElement("J");
            cmds.addElement(item);
            cmds.addElement(new Long(1004L));
            cmds.addElement(new Long(1L));
            cmds.addElement(new Long(1000L));
            this.id = this.getID();
            this.executeCommand(this, cmds);
            this.closed = true;
        }
    }

    public synchronized long getID() {
        return this.id;
    }

    public synchronized long getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(long encoding) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(3L));
        item0.addElement("encodingX");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.encodingX = encoding;
        this.id = this.getID();
        this.executeCommand(this, cmds);
        this.encoding = encoding;
    }

    public synchronized void selectDecoding(long decoding) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        this.id = this.getID();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(4L));
        item0.addElement("decoding");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.decoding = decoding;
        this.id = this.getID();
        this.executeCommand(this, cmds);
    }

    public synchronized long confirmDecoding() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(4L));
        item0.addElement("decoding");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        return this.decoding;
    }

    public synchronized void selectCDFCacheSize(long cacheSize) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(117L));
        item0.addElement("cacheSize");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.cacheSize = cacheSize;
        this.id = this.getID();
        this.executeCommand(this, cmds);
    }

    public synchronized long confirmCDFCacheSize() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(117L));
        item0.addElement("cacheSize");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        return this.cacheSize;
    }

    public synchronized void selectNegtoPosfp0(long negtoPosfp0) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(19L));
        item0.addElement("negtoPosfp0");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.negtoPosfp0 = negtoPosfp0;
        this.id = this.getID();
        this.executeCommand(this, cmds);
    }

    public synchronized long confirmNegtoPosfp0() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(19L));
        item0.addElement("negtoPosfp0");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        return this.negtoPosfp0;
    }

    public synchronized long getFormat() {
        return this.format;
    }

    public synchronized void setFormat(long format) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(6L));
        item0.addElement("formatX");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.formatX = format;
        this.id = this.getID();
        this.executeCommand(this, cmds);
        this.format = format;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    public synchronized long getMajority() {
        return this.majority;
    }

    public synchronized void setMajority(long majority) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(5L));
        item0.addElement("majorityX");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.majorityX = majority;
        this.id = this.getID();
        this.executeCommand(this, cmds);
        this.majority = majority;
    }

    public synchronized long getNumAttrs() {
        return this.attributes.size();
    }

    public synchronized long getNumGattrs() {
        long count = 0L;
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Attribute a = (Attribute)e.nextElement();
            if (a.getScope() != 1L) continue;
            ++count;
        }
        return count;
    }

    public synchronized long getNumVattrs() {
        long count = 0L;
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Attribute a = (Attribute)e.nextElement();
            if (a.getScope() != 2L) continue;
            ++count;
        }
        return count;
    }

    public synchronized long getNumRvars() {
        return this.numRvars;
    }

    public synchronized long getNumZvars() {
        return this.variables.size();
    }

    public synchronized String getCopyright() {
        return this.copyright;
    }

    public synchronized void selectReadOnlyMode(long readOnly) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(17L));
        item1.addElement("readOnly");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.readOnly = readOnly;
        this.id = this.getID();
        this.executeCommand(this, cmds);
    }

    public synchronized long confirmReadOnlyMode() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(17L));
        item1.addElement("readOnly");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        return this.readOnly;
    }

    public synchronized long getCompressionType() {
        return this.cType;
    }

    public synchronized long getCompressionPct() {
        return this.cPct;
    }

    public synchronized long[] getCompressionParms() {
        return this.cParms;
    }

    public synchronized void setCompression(long cType, long[] cParms) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(130L));
        item0.addElement("cTypeX");
        item0.addElement("J");
        cmds.addElement(item0);
        item1.addElement("cParmsX");
        item1.addElement("[J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.cTypeX = cType;
        this.cParmsX = cParms;
        this.id = this.getID();
        this.executeCommand(this, cmds);
        this.cType = cType;
        this.cParms = cParms;
    }

    public synchronized String getCompression() throws CDFException {
        StringBuffer temp = new StringBuffer();
        if (this.cType == 0L) {
            temp.append("No compression");
        } else {
            temp.append(CDFUtils.getStringCompressionType(this.cType)).append(".").append(this.cParms[0]);
        }
        return temp.toString();
    }

    private void selectzMode(long zmode) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(18L));
        item0.addElement("zmode");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.zmode = zmode;
        this.id = this.getID();
        this.executeCommand(this, cmds);
    }

    public synchronized long confirmzMode() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(18L));
        item0.addElement("zmode");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        return this.zmode;
    }

    public synchronized void selectCompressCacheSize(long compressCacheSize) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(155L));
        item0.addElement("compressCacheSize");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.compressCacheSize = compressCacheSize;
        this.id = this.getID();
        this.executeCommand(this, cmds);
    }

    public synchronized long confirmCompressCacheSize() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(155L));
        item0.addElement("compressCacheSize");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        return this.compressCacheSize;
    }

    public synchronized void selectStageCacheSize(long stageCacheSize) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(154L));
        item0.addElement("stageCacheSize");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.stageCacheSize = stageCacheSize;
        this.id = this.getID();
        this.executeCommand(this, cmds);
    }

    public synchronized long confirmStageCacheSize() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(154L));
        item0.addElement("stageCacheSize");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        return this.stageCacheSize;
    }

    public synchronized String getName() {
        return this.path;
    }

    public synchronized void rename(String path) {
        this.path = path;
        this.theFile.renameTo(new File(path));
    }

    public synchronized void delete() throws CDFException {
        Vector<Serializable> cmd = new Vector<Serializable>();
        Vector<String> itemA = new Vector<String>();
        cmd.addElement(new Long(1005L));
        cmd.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmd.addElement(itemA);
        cmd.addElement(new Long(1003L));
        cmd.addElement(new Long(1L));
        cmd.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmd);
    }

    public synchronized void save() throws CDFException {
        Vector<Long> cmd = new Vector<Long>();
        Vector itemA = new Vector();
        cmd.addElement(new Long(1009L));
        this.id = this.getID();
        this.executeCommand(this, cmd);
    }

    public static void setFileBackward(long flag) throws CDFException {
        String libVersion = CDF.getLibraryVersion();
        if (libVersion.charAt(0) == '3') {
            CDF theCDF = new CDF(new CDFNativeLibrary());
            Vector<Long> cmd = new Vector<Long>();
            cmd.addElement(new Long(1010L));
            cmd.addElement(new Long(flag));
            theCDF.executeCommand(theCDF, cmd);
            backwardFlagSet = true;
            backward = flag == 1L || flag != 0L ? 1L : 0L;
        }
    }

    public static boolean getFileBackward() {
        if (backwardFlagSet) {
            return backward == 1L;
        }
        return false;
    }

    public static int getFileBackwardEnvVar() throws CDFException {
        if (backwardEnvVar == -1L) {
            CDF theCDF = new CDF(new CDFNativeLibrary());
            Vector<Serializable> cmd = new Vector<Serializable>();
            Vector<String> item = new Vector<String>();
            cmd.addElement(new Long(1011L));
            item.addElement("fromEnvVar");
            item.addElement("J");
            cmd.addElement(item);
            theCDF.executeCommand(theCDF, cmd);
            backwardEnvVar = theCDF.fromEnvVar;
        }
        return (int)backwardEnvVar;
    }

    public static long getChecksumEnvVar() throws CDFException {
        if (checksumEnvVar == -1L) {
            CDF theCDF = new CDF(new CDFNativeLibrary());
            Vector<Serializable> cmd = new Vector<Serializable>();
            Vector<String> item = new Vector<String>();
            cmd.addElement(new Long(1013L));
            item.addElement("fromEnvVar");
            item.addElement("J");
            cmd.addElement(item);
            theCDF.executeCommand(theCDF, cmd);
            checksumEnvVar = theCDF.fromEnvVar;
        }
        return checksumEnvVar;
    }

    public synchronized long getStatus() {
        return this.cdfStatus;
    }

    private synchronized void setStatus(long inStatus) {
        this.cdfStatus = inStatus;
    }

    public static String getStatusText(long statusCode) {
        StringBuffer statusText = new StringBuffer();
        if (statusCode > 0L) {
            statusText.append("INFO: ");
        } else if (statusCode < 0L && statusCode > -2000L) {
            statusText.append("WARNING: ");
        }
        return statusText.append(CDFException.getStatusMsg(statusCode)).toString();
    }

    public synchronized void setInfoWarningOff() {
        this.infoWarning = 0L;
    }

    public synchronized void setInfoWarningOn() {
        this.infoWarning = 1L;
    }

    private final synchronized void select() throws CDFException {
        Vector<Long> cmds = new Vector<Long>();
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
    }

    public String toString() {
        return this.path;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public synchronized CDFDelegate getDelegate() {
        return this.delegate;
    }

    public synchronized void setDelegate(CDFDelegate delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void executeCommand(CDFObject obj, Vector command) throws CDFException {
        Object object = Monitor;
        synchronized (object) {
            this.delegate.cdflib(this, obj, command);
        }
    }

    public synchronized long getAttributeID(String attrName) {
        int i = 0;
        if (this.attributes.size() == 0) {
            return -1L;
        }
        while (!this.attributes.elementAt(i).toString().equals(attrName) && ++i < this.attributes.size()) {
        }
        if (i == this.attributes.size()) {
            return -1L;
        }
        return i;
    }

    protected final synchronized void addAttribute(Attribute newAttribute) {
        this.attributes.addElement(newAttribute);
    }

    protected final synchronized void removeAttribute(Attribute oldAttribute) {
        this.attributes.removeElement(oldAttribute);
    }

    public synchronized Attribute getAttribute(long attrNum) throws CDFException {
        if (attrNum > (long)this.attributes.size()) {
            throw new CDFException(-2017L);
        }
        return (Attribute)this.attributes.elementAt((int)attrNum);
    }

    public synchronized Attribute getAttribute(String attrName) throws CDFException {
        long idx = this.getAttributeID(attrName);
        if (idx == -1L) {
            throw new CDFException(-2017L);
        }
        return (Attribute)this.attributes.elementAt((int)idx);
    }

    public synchronized Vector getAttributes() {
        return this.attributes;
    }

    public synchronized Vector getGlobalAttributes() {
        Vector<Attribute> ga = new Vector<Attribute>();
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Attribute a = (Attribute)e.nextElement();
            if (a.getScope() != 1L) continue;
            ga.addElement(a);
        }
        return ga;
    }

    public synchronized Vector getVariableAttributes() {
        Vector<Attribute> va = new Vector<Attribute>();
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Attribute a = (Attribute)e.nextElement();
            if (a.getScope() != 2L) continue;
            va.addElement(a);
        }
        return va;
    }

    public synchronized Vector getOrphanAttributes() {
        boolean emptyAttr = true;
        Vector<Attribute> emptyAttrs = new Vector<Attribute>();
        if (this.getNumVars() <= 0L) {
            return emptyAttrs;
        }
        Vector va = this.getVariableAttributes();
        Vector vars = this.getVariables();
        Enumeration e = va.elements();
        while (e.hasMoreElements()) {
            Attribute a = (Attribute)e.nextElement();
            emptyAttr = true;
            Enumeration e1 = vars.elements();
            while (e1.hasMoreElements()) {
                Variable v = (Variable)e1.nextElement();
                try {
                    Entry entry = a.getEntry(v);
                    if (entry == null) continue;
                    emptyAttr = false;
                    break;
                }
                catch (CDFException ex) {
                    if (ex.getCurrentStatus() == -2018L) continue;
                    System.out.println("** Error occurred in getOrphanAttributes");
                    System.out.println(ex);
                    System.exit(0);
                }
            }
            if (!emptyAttr) continue;
            emptyAttrs.addElement(a);
        }
        return emptyAttrs;
    }

    public synchronized long getVariableID(String varName) {
        long i = 0L;
        if (this.variables.size() == 0) {
            return -1L;
        }
        while (!this.variables.elementAt((int)i).toString().equals(varName) && ++i < (long)this.variables.size()) {
        }
        if (i == (long)this.variables.size()) {
            return -1L;
        }
        return i;
    }

    protected final synchronized void addVariable(Variable newVariable) {
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Attribute curAttr = (Attribute)e.nextElement();
            if (curAttr.getScope() != 2L) continue;
            curAttr.addNullEntry();
        }
        this.variables.addElement(newVariable);
    }

    protected final synchronized void removeVariable(Variable oldVariable) {
        int idx = this.variables.indexOf(oldVariable);
        Enumeration e = this.attributes.elements();
        while (e.hasMoreElements()) {
            Attribute curAttr = (Attribute)e.nextElement();
            if (curAttr.getScope() != 2L) continue;
            curAttr.removeEntry(idx);
        }
        this.variables.removeElement(oldVariable);
    }

    public synchronized Variable getVariable(long varNum) throws CDFException {
        if (varNum > (long)this.variables.size()) {
            throw new CDFException(-2019L);
        }
        return (Variable)this.variables.elementAt((int)varNum);
    }

    public synchronized Variable getVariable(String varName) throws CDFException {
        long idx = this.getVariableID(varName);
        if (idx == -1L) {
            throw new CDFException(-2019L);
        }
        return (Variable)this.variables.elementAt((int)idx);
    }

    public synchronized Vector getVariables() {
        return this.variables;
    }

    public synchronized long getNumVars() {
        return this.variables.size();
    }

    public synchronized Vector getRecord(long recNum, String[] strVars) throws CDFException {
        return this.getRecord(recNum, strVars, null);
    }

    public synchronized Vector getRecord(long recNum, String[] strVars, long[] status) throws CDFException {
        if (recNum < 0L || strVars == null || strVars.length == 0) {
            return null;
        }
        int varsNum = strVars.length;
        long[] varIDs = new long[varsNum];
        for (int i = 0; i < varsNum; ++i) {
            varIDs[i] = this.getVariableID(strVars[i]);
            if (varIDs[i] != -1L) continue;
            System.err.println("Error: Variable: " + strVars[i] + " not exists!!!");
            throw new CDFException(-2019L);
        }
        return this.getRecord(recNum, varIDs, status);
    }

    public synchronized Vector getRecord(long recNum, long[] varIDs) throws CDFException {
        return this.getRecord(recNum, varIDs, null);
    }

    public synchronized Vector getRecord(long recNum, long[] varIDs, long[] status) throws CDFException {
        if (recNum < 0L || varIDs == null || varIDs.length == 0) {
            return null;
        }
        int varsNum = varIDs.length;
        Vector<Object> myData = new Vector<Object>();
        for (int i = 0; i < varsNum; ++i) {
            Variable var;
            try {
                var = this.getVariable(varIDs[i]);
            }
            catch (CDFException e) {
                System.err.println("Error: Variable: " + varIDs[i] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            myData.add(var.getRecord(recNum));
            if (status == null) continue;
            status[i] = this.getStatus();
        }
        return myData;
    }

    public synchronized void putRecord(long recNum, String[] strVars, Vector myData) throws CDFException {
        this.putRecord(recNum, strVars, myData, null);
    }

    public synchronized void putRecord(long recNum, String[] strVars, Vector myData, long[] status) throws CDFException {
        if (recNum < 0L || strVars == null || strVars.length == 0 || myData == null || myData.isEmpty()) {
            return;
        }
        int varsNum = strVars.length;
        long[] varIDs = new long[varsNum];
        for (int i = 0; i < varsNum; ++i) {
            varIDs[i] = this.getVariableID(strVars[i]);
            if (varIDs[i] != -1L) continue;
            System.err.println("Error: Variable: " + strVars[i] + " not exists!!!");
            throw new CDFException(-2019L);
        }
        this.putRecord(recNum, varIDs, myData, status);
    }

    public synchronized void putRecord(long recNum, long[] varIDs, Vector myData) throws CDFException {
        this.putRecord(recNum, varIDs, myData, null);
    }

    public synchronized void putRecord(long recNum, long[] varIDs, Vector myData, long[] status) throws CDFException {
        if (recNum < 0L || varIDs == null || varIDs.length == 0 || myData == null || myData.isEmpty()) {
            return;
        }
        if (varIDs.length != myData.size()) {
            System.err.println("Error: the variables' count: " + varIDs.length + " does not match the record objects' count: " + myData.size());
            return;
        }
        if (status != null && status.length < varIDs.length) {
            System.err.println("Error: the variables' count: " + varIDs.length + " does not match the status' count: " + status.length);
            return;
        }
        int varsNum = varIDs.length;
        for (int i = 0; i < varsNum; ++i) {
            Variable var;
            try {
                var = this.getVariable(varIDs[i]);
            }
            catch (CDFException e) {
                System.err.println("Error: Variable: " + varIDs[i] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            var.putRecord(recNum, myData.elementAt(i));
            if (status == null) continue;
            status[i] = this.getStatus();
        }
    }

    public synchronized void setChecksum(long checksum) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        if (checksum != 0L && checksum != 1L) {
            throw new CDFException(-2225L);
        }
        this.checksumX = checksum;
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        item1.addElement("id");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(156L));
        item2.addElement("checksumX");
        item2.addElement("J");
        cmds.addElement(item2);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        this.checksum = checksum;
    }

    public synchronized long getChecksum() {
        return this.checksum;
    }

    public synchronized long verifyChecksum() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("id");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(156L));
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.executeCommand(this, cmds);
        return this.getStatus();
    }

    private String FindCDFName(String path) {
        if (new File(path).isFile()) {
            return path;
        }
        String pathT = new StringBuffer().append(path).append(".cdf").toString();
        if (new File(pathT).isFile()) {
            return pathT;
        }
        pathT = new StringBuffer().append(path).append(".CDF").toString();
        if (new File(pathT).isFile()) {
            return pathT;
        }
        pathT = new StringBuffer().append(path).append(".cdf;1").toString();
        if (new File(pathT).isFile()) {
            return pathT;
        }
        pathT = new StringBuffer().append(path).append(".CDF;1").toString();
        if (new File(pathT).isFile()) {
            return pathT;
        }
        return null;
    }
}

