/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Vector;

public class CDFData
implements CDFObject,
CDFConstants {
    private Variable _myVar;
    private Object _data = null;
    private Object _dataArray = null;
    private long id;
    private long cdfID;
    private long numValues;
    private long numElements;
    private long numDims;
    private String dataSignature;
    private long dataType;
    private int nDims = 0;
    private int[] dimSizes;
    private long recStart;
    private long recCount;
    private long recInterval;
    private long[] dimIndices;
    private long[] dimCounts;
    private long[] dimIntervals;

    public Object getData() {
        return this._dataArray;
    }

    public Object getRawData() {
        return this._data;
    }

    public int getnDims() {
        return this.nDims;
    }

    public int[] getDimSizes() {
        return this.dimSizes;
    }

    public long getRecStart() {
        return this.recStart;
    }

    public long getRecCount() {
        return this.recCount;
    }

    public long getRecInterval() {
        return this.recInterval;
    }

    public long[] getDimIndices() {
        return this.dimIndices;
    }

    public long[] getDimCounts() {
        return this.dimCounts;
    }

    public long[] getDimIntervals() {
        return this.dimIntervals;
    }

    private CDFData(Variable v) {
        this._myVar = v;
        this.id = this._myVar.getID();
        this.cdfID = this._myVar.getMyCDF().getID();
        this.dataType = this._myVar.getDataType();
        this.numElements = this._myVar.getNumElements();
        this.numDims = this._myVar.getNumDims();
    }

    protected static final CDFData get(Variable v, long recStart, long recCount, long recInterval, long[] dimIndices, long[] dimCounts, long[] dimIntervals) throws CDFException {
        return CDFData.get(v, recStart, recCount, recInterval, dimIndices, dimCounts, dimIntervals, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CDFData get(Variable v, long recStart, long recCount, long recInterval, long[] dimIndices, long[] dimCounts, long[] dimIntervals, boolean arrayify) throws CDFException {
        Variable variable = v;
        synchronized (variable) {
            CDFData theData = new CDFData(v);
            theData.recStart = recStart;
            theData.recCount = recCount;
            theData.recInterval = recInterval;
            if (v.getNumDims() > 0L) {
                theData.dimIndices = dimIndices;
                theData.dimCounts = dimCounts;
                theData.dimIntervals = dimIntervals;
            } else {
                theData.dimIndices = new long[]{0L};
                theData.dimCounts = new long[]{0L};
                theData.dimIntervals = new long[]{0L};
            }
            theData.initDimAndSizes();
            Vector<Serializable> cmds = new Vector<Serializable>();
            Vector<String> item0 = new Vector<String>();
            Vector<String> item1 = new Vector<String>();
            Vector<String> item2 = new Vector<String>();
            Vector<String> item3 = new Vector<String>();
            Vector<String> item4 = new Vector<String>();
            Vector<String> item5 = new Vector<String>();
            Vector<String> item6 = new Vector<String>();
            Vector<String> item7 = new Vector<String>();
            Vector<String> itemA = new Vector<String>();
            theData.buildDataObject();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(57L));
            item0.addElement("id");
            item0.addElement("J");
            cmds.addElement(item0);
            cmds.addElement(new Long(79L));
            item1.addElement("recStart");
            item1.addElement("J");
            cmds.addElement(item1);
            cmds.addElement(new Long(80L));
            item2.addElement("recCount");
            item2.addElement("J");
            cmds.addElement(item2);
            cmds.addElement(new Long(81L));
            item3.addElement("recInterval");
            item3.addElement("J");
            cmds.addElement(item3);
            cmds.addElement(new Long(82L));
            item4.addElement("dimIndices");
            item4.addElement("[J");
            cmds.addElement(item4);
            cmds.addElement(new Long(83L));
            item5.addElement("dimCounts");
            item5.addElement("[J");
            cmds.addElement(item5);
            cmds.addElement(new Long(84L));
            item6.addElement("dimIntervals");
            item6.addElement("[J");
            cmds.addElement(item6);
            cmds.addElement(new Long(1007L));
            cmds.addElement(new Long(67L));
            item7.addElement("_data");
            item7.addElement("Ljava/lang/Object;");
            cmds.addElement(item7);
            cmds.addElement(new Long(1000L));
            theData._myVar.getMyCDF().executeCommand(theData, cmds);
            if (arrayify) {
                theData.arrayify();
            }
            return theData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final CDFData put(Variable v, long recStart, long recCount, long recInterval, long[] dimIndices, long[] dimCounts, long[] dimIntervals, Object data) throws CDFException {
        Variable variable = v;
        synchronized (variable) {
            String dataClassName = data.getClass().getName();
            switch ((int)v.getDataType()) {
                case 51: 
                case 52: {
                    if (dataClassName.indexOf("java.lang.String") != -1 || dataClassName.indexOf("[B") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 1: 
                case 41: {
                    if (dataClassName.indexOf("[B") != -1 || dataClassName.indexOf("Byte") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 2: 
                case 11: {
                    if (dataClassName.indexOf("[S") != -1 || dataClassName.indexOf("Short") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 4: 
                case 12: {
                    if (dataClassName.indexOf("[I") != -1 || dataClassName.indexOf("Integer") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 14: {
                    if (dataClassName.indexOf("[J") != -1 || dataClassName.indexOf("Long") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 21: 
                case 44: {
                    if (dataClassName.indexOf("[F") != -1 || dataClassName.indexOf("Float") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 22: 
                case 31: 
                case 45: {
                    if (dataClassName.indexOf("[D") != -1 || dataClassName.indexOf("Double") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 32: {
                    if (dataClassName.indexOf("[D") != -1) break;
                }
            }
            CDFData theData = new CDFData(v);
            theData._dataArray = data;
            theData.recStart = recStart;
            theData.recCount = recCount;
            theData.recInterval = recInterval;
            theData.dimIndices = dimIndices;
            theData.dimCounts = dimCounts;
            theData.dimIntervals = dimIntervals;
            theData.initDimAndSizes();
            theData.vectorize();
            theData.dataSignature = CDFUtils.getSignature(theData._data);
            Vector<Serializable> cmds = new Vector<Serializable>();
            Vector<String> item0 = new Vector<String>();
            Vector<String> item1 = new Vector<String>();
            Vector<String> item2 = new Vector<String>();
            Vector<String> item3 = new Vector<String>();
            Vector<String> item4 = new Vector<String>();
            Vector<String> item5 = new Vector<String>();
            Vector<String> item6 = new Vector<String>();
            Vector<String> item7 = new Vector<String>();
            Vector<String> itemA = new Vector<String>();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(57L));
            item0.addElement("id");
            item0.addElement("J");
            cmds.addElement(item0);
            cmds.addElement(new Long(79L));
            item1.addElement("recStart");
            item1.addElement("J");
            cmds.addElement(item1);
            cmds.addElement(new Long(80L));
            item2.addElement("recCount");
            item2.addElement("J");
            cmds.addElement(item2);
            cmds.addElement(new Long(81L));
            item3.addElement("recInterval");
            item3.addElement("J");
            cmds.addElement(item3);
            cmds.addElement(new Long(82L));
            item4.addElement("dimIndices");
            item4.addElement("[J");
            cmds.addElement(item4);
            cmds.addElement(new Long(83L));
            item5.addElement("dimCounts");
            item5.addElement("[J");
            cmds.addElement(item5);
            cmds.addElement(new Long(84L));
            item6.addElement("dimIntervals");
            item6.addElement("[J");
            cmds.addElement(item6);
            cmds.addElement(new Long(1008L));
            cmds.addElement(new Long(67L));
            item7.addElement("_data");
            item7.addElement("Ljava/lang/Object;");
            cmds.addElement(item7);
            cmds.addElement(new Long(1000L));
            theData._myVar.getMyCDF().executeCommand(theData, cmds);
            return theData;
        }
    }

    private long product(int[] array, int start, int stop) {
        long product = 1L;
        for (int i = start; i < stop; ++i) {
            if (array[i] <= 1) continue;
            product *= (long)array[i];
        }
        return product;
    }

    private void arrayify() throws CDFException {
        if (this.nDims <= 1) {
            if (this.dataType == 51L || this.dataType == 52L) {
                if (this.nDims == 0) {
                    this._dataArray = new String((byte[])this._data);
                } else {
                    this.buildDataArray();
                    int n = 0;
                    byte[] aByteArray = new byte[(int)this.numElements];
                    for (int i = 0; i < this.dimSizes[0]; ++i) {
                        System.arraycopy(this._data, n, aByteArray, 0, (int)this.numElements);
                        Array.set(this._dataArray, i, new String(aByteArray));
                        n = (int)((long)n + this.numElements);
                    }
                }
            } else {
                this._dataArray = this._data;
            }
        } else {
            this.buildDataArray();
            Object[] aRow = null;
            Object[] subArrays = new Object[this.nDims - 1];
            int[] cIndex = new int[this.nDims - 1];
            long[] boundary = new long[this.nDims - 1];
            subArrays[0] = this._dataArray;
            cIndex[0] = 0;
            boundary[0] = this.product(this.dimSizes, 0, this.nDims);
            for (int i = 1; i < this.nDims - 1; ++i) {
                subArrays[i] = Array.get(subArrays[i - 1], 0);
                boundary[i] = this.product(this.dimSizes, i, this.nDims);
                cIndex[i] = 0;
            }
            int n = 0;
            Object cObject = this._dataArray;
            while ((long)n < this.numValues) {
                int i;
                if (n != 0) {
                    for (i = 0; i < this.nDims - 1; ++i) {
                        boolean boundaryCrossed;
                        boolean bl = boundaryCrossed = (long)n % boundary[i] == 0L;
                        if (boundaryCrossed) {
                            int n2 = i;
                            cIndex[n2] = cIndex[n2] + 1;
                            subArrays[i] = cObject = Array.get(cObject, cIndex[i]);
                            for (int j = i + 1; j < this.nDims - 1; ++j) {
                                cIndex[j] = 0;
                                subArrays[j] = Array.get(subArrays[j - 1], 0);
                            }
                            break;
                        }
                        cObject = subArrays[i];
                    }
                }
                for (i = 0; i < this.dimSizes[this.nDims - 2]; ++i) {
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            byte[] aByteArray = new byte[(int)this.numElements];
                            aRow = new String[this.dimSizes[this.nDims - 1]];
                            for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                System.arraycopy(this._data, n, aByteArray, 0, (int)this.numElements);
                                ((String[])aRow)[j] = new String(aByteArray);
                                n = (int)((long)n + this.numElements);
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            aRow = new byte[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, aRow, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 2: 
                        case 11: {
                            aRow = new short[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, aRow, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 4: 
                        case 12: {
                            aRow = new int[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, aRow, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 14: {
                            aRow = new long[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, aRow, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 21: 
                        case 44: {
                            aRow = new float[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, aRow, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 22: 
                        case 31: 
                        case 45: {
                            aRow = new double[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, aRow, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 32: {
                            aRow = new double[2 * this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, aRow, 0, 2 * this.dimSizes[this.nDims - 1]);
                            n += 2 * this.dimSizes[this.nDims - 1];
                            break;
                        }
                    }
                    Array.set(subArrays[this.nDims - 2], i, aRow);
                }
            }
        }
    }

    private void vectorize() throws CDFException {
        if (this.nDims <= 1) {
            if (this.dataType == 51L || this.dataType == 52L) {
                String dataClassName = this._dataArray.getClass().getName();
                if (dataClassName.indexOf("[B") == -1) {
                    int n = 0;
                    if (this.nDims == 0) {
                        this._data = new byte[(int)this.numElements];
                        int i = 0;
                        while ((long)i < this.numElements) {
                            ((byte[])this._data)[i] = 32;
                            ++i;
                        }
                        System.arraycopy(((String)this._dataArray).getBytes(), 0, this._data, 0, ((String)this._dataArray).length());
                    } else {
                        this.buildDataObject();
                        for (int i = 0; i < this.dimSizes[0]; ++i) {
                            System.arraycopy(((String[])this._dataArray)[i].getBytes(), 0, this._data, n, ((String[])this._dataArray)[i].length());
                            n = (int)((long)n + this.numElements);
                        }
                    }
                } else {
                    this._data = this._dataArray;
                }
            } else {
                this._data = this._dataArray;
            }
        } else {
            this.buildDataObject();
            Object[] aRow = null;
            Object[] subArrays = new Object[this.nDims - 1];
            int[] cIndex = new int[this.nDims - 1];
            long[] boundary = new long[this.nDims - 1];
            subArrays[0] = this._dataArray;
            cIndex[0] = 0;
            boundary[0] = this.product(this.dimSizes, 0, this.nDims);
            for (int i = 1; i < this.nDims - 1; ++i) {
                subArrays[i] = Array.get(subArrays[i - 1], 0);
                boundary[i] = this.product(this.dimSizes, i, this.nDims);
                cIndex[i] = 0;
            }
            int n = 0;
            Object cObject = this._dataArray;
            while ((long)n < this.numValues) {
                int j;
                int i;
                if (n != 0) {
                    for (i = 0; i < this.nDims - 1; ++i) {
                        boolean boundaryCrossed;
                        boolean bl = boundaryCrossed = (long)n % boundary[i] == 0L;
                        if (boundaryCrossed) {
                            int n2 = i;
                            cIndex[n2] = cIndex[n2] + 1;
                            subArrays[i] = cObject = Array.get(cObject, cIndex[i]);
                            for (j = i + 1; j < this.nDims - 1; ++j) {
                                cIndex[j] = 0;
                                subArrays[j] = Array.get(subArrays[j - 1], cIndex[j]);
                            }
                            break;
                        }
                        cObject = subArrays[i];
                    }
                }
                block16: for (i = 0; i < this.dimSizes[this.nDims - 2]; ++i) {
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            aRow = (String[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (((String[])aRow)[j] != null) {
                                    System.arraycopy(((String[])aRow)[j].getBytes(), 0, this._data, n, ((String[])aRow)[j].length());
                                }
                                n = (int)((long)n + this.numElements);
                            }
                            continue block16;
                        }
                        case 1: 
                        case 41: {
                            aRow = (byte[])Array.get(subArrays[this.nDims - 2], i);
                            System.arraycopy(aRow, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 2: 
                        case 11: {
                            aRow = new short[this.dimSizes[this.nDims - 1]];
                            aRow = (short[])Array.get(subArrays[this.nDims - 2], i);
                            System.arraycopy(aRow, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 4: 
                        case 12: {
                            aRow = (int[])Array.get(subArrays[this.nDims - 2], i);
                            System.arraycopy(aRow, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 14: {
                            aRow = (long[])Array.get(subArrays[this.nDims - 2], i);
                            System.arraycopy(aRow, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 21: 
                        case 44: {
                            aRow = (float[])Array.get(subArrays[this.nDims - 2], i);
                            System.arraycopy(aRow, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 22: 
                        case 31: 
                        case 45: {
                            aRow = (double[])Array.get(subArrays[this.nDims - 2], i);
                            System.arraycopy(aRow, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 32: {
                            aRow = (double[])Array.get(subArrays[this.nDims - 2], i);
                            System.arraycopy(aRow, 0, this._data, n, 2 * this.dimSizes[this.nDims - 1]);
                            n += 2 * this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                    }
                }
            }
        }
    }

    private void initDimAndSizes() {
        this.numValues = 1L;
        if (this._dataArray != null) {
            this.nDims = this._dataArray.getClass().getName().lastIndexOf("[") + 1;
            if (this._dataArray.getClass().isArray()) {
                Object tempArray = this._dataArray;
                this.dimSizes = new int[this.nDims];
                for (int i = 0; i < this.nDims; ++i) {
                    this.dimSizes[i] = Array.getLength(tempArray);
                    this.numValues *= (long)this.dimSizes[i];
                    tempArray = Array.get(tempArray, 0);
                }
            } else {
                this.dimSizes = new int[1];
                this.dimSizes[0] = 1;
            }
            this.numValues *= this.numElements;
        } else {
            int j;
            int i;
            this.nDims = this.recCount > 1L ? 1 : 0;
            int len = this.dimCounts.length;
            if (len == 1) {
                if (this.dimCounts[0] > 1L) {
                    ++this.nDims;
                }
            } else {
                boolean multi = false;
                for (i = 0; i < len; ++i) {
                    if (this.dimCounts[i] <= 1L) continue;
                    ++this.nDims;
                }
            }
            this.dimSizes = new int[this.nDims];
            if (this.nDims == 1) {
                this.dimSizes[0] = this.recCount > 1L ? (int)this.recCount : (int)this.dimCounts[0];
            } else if (this.recCount > 1L) {
                j = 0;
                this.dimSizes[0] = (int)this.recCount;
                i = 0;
                while ((long)i < this.numDims) {
                    if (this.dimCounts[i] > 1L) {
                        this.dimSizes[++j] = (int)this.dimCounts[i];
                    }
                    ++i;
                }
            } else {
                j = -1;
                i = 0;
                while ((long)i < this.numDims) {
                    if (this.dimCounts[i] > 1L) {
                        this.dimSizes[++j] = (int)this.dimCounts[i];
                    }
                    ++i;
                }
            }
            if (this.nDims > 0) {
                for (int dimN = 0; dimN < this.nDims; ++dimN) {
                    this.numValues *= (long)this.dimSizes[dimN];
                }
            }
            this.numValues *= this.numElements;
        }
    }

    private void buildDataArray() throws CDFException {
        int[] tempSizes = new int[this.nDims - 1];
        System.arraycopy(this.dimSizes, 0, tempSizes, 0, this.nDims - 1);
        String className = null;
        switch ((int)this._myVar.getDataType()) {
            case 51: 
            case 52: {
                className = "java.lang.String";
                tempSizes = this.dimSizes;
                break;
            }
            case 1: 
            case 41: {
                className = "[B";
                break;
            }
            case 2: 
            case 11: {
                className = "[S";
                break;
            }
            case 4: 
            case 12: {
                className = "[I";
                break;
            }
            case 14: {
                className = "[J";
                break;
            }
            case 21: 
            case 44: {
                className = "[F";
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                className = "[D";
                break;
            }
            case 32: {
                className = "[D";
                break;
            }
        }
        try {
            Class<?> arrayClass = Class.forName(className);
            this._dataArray = Array.newInstance(arrayClass, tempSizes);
        }
        catch (ClassNotFoundException e) {
            throw new CDFException(-2022L);
        }
    }

    private void buildDataObject() throws CDFException {
        int dataTypeX = (int)this._myVar.getDataType();
        Object padValue = null;
        if (this._myVar.checkPadValueExistence()) {
            padValue = this._myVar.getPadValue();
        }
        switch (dataTypeX) {
            case 51: 
            case 52: {
                this.dataSignature = "[B";
                this._data = new byte[(int)this.numValues];
                if (padValue == null) {
                    int i = 0;
                    while ((long)i < this.numValues) {
                        ((byte[])this._data)[i] = dataTypeX == 51 ? new Character(' ').toString().getBytes()[0] : new Character(' ').toString().getBytes()[0];
                        ++i;
                    }
                } else {
                    byte[] myBytes = ((String)padValue).getBytes();
                    int ilen = myBytes.length;
                    int i = 0;
                    int j = 0;
                    while ((long)i < this.numValues) {
                        if (j == ilen) {
                            j = 0;
                        }
                        ((byte[])this._data)[i] = myBytes[j];
                        ++i;
                        ++j;
                    }
                }
                break;
            }
            case 1: 
            case 41: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[B";
                    this._data = new byte[(int)this.numValues];
                    if (padValue == null) {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((byte[])this._data)[i] = dataTypeX == 1 ? (byte)0 : 0;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((byte[])this._data)[i] = (Byte)padValue;
                            ++i;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Byte;";
                if (padValue == null) {
                    if (dataTypeX == 1) {
                        this._data = new Byte(0);
                        break;
                    }
                    this._data = new Byte(0);
                    break;
                }
                this._data = new Byte((Byte)padValue);
                break;
            }
            case 2: 
            case 11: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[S";
                    this._data = new short[(int)this.numValues];
                    if (padValue == null) {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((short[])this._data)[i] = dataTypeX == 2 ? (short)0 : 0;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((short[])this._data)[i] = (Short)padValue;
                            ++i;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Short;";
                if (padValue == null) {
                    if (dataTypeX == 2) {
                        this._data = new Short(0);
                        break;
                    }
                    this._data = new Short(0);
                    break;
                }
                this._data = new Short((Short)padValue);
                break;
            }
            case 4: 
            case 12: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[I";
                    this._data = new int[(int)this.numValues];
                    if (padValue == null) {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((int[])this._data)[i] = dataTypeX == 4 ? 0 : 0;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((int[])this._data)[i] = (Integer)padValue;
                            ++i;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Integer;";
                if (padValue == null) {
                    if (dataTypeX == 4) {
                        this._data = new Integer(0);
                        break;
                    }
                    this._data = new Integer(0);
                    break;
                }
                this._data = new Integer((Integer)padValue);
                break;
            }
            case 14: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[J";
                    this._data = new long[(int)this.numValues];
                    if (padValue == null) {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((long[])this._data)[i] = 0L;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((long[])this._data)[i] = (Long)padValue;
                            ++i;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Long;";
                if (padValue == null) {
                    this._data = new Long(0L);
                    break;
                }
                this._data = new Long((Long)padValue);
                break;
            }
            case 21: 
            case 44: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[F";
                    this._data = new float[(int)this.numValues];
                    if (padValue == null) {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((float[])this._data)[i] = dataTypeX == 21 ? 0.0f : 0.0f;
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((float[])this._data)[i] = ((Float)padValue).floatValue();
                            ++i;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Float;";
                if (padValue == null) {
                    if (dataTypeX == 21) {
                        this._data = new Float(0.0f);
                        break;
                    }
                    this._data = new Float(0.0f);
                    break;
                }
                this._data = new Float(((Float)padValue).floatValue());
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[D";
                    this._data = new double[(int)this.numValues];
                    if (padValue == null) {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((double[])this._data)[i] = dataTypeX == 22 ? 0.0 : (dataTypeX == 45 ? 0.0 : 0.0);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.numValues) {
                            ((double[])this._data)[i] = (Double)padValue;
                            ++i;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Double;";
                if (padValue == null) {
                    if (dataTypeX == 22) {
                        this._data = new Double(0.0);
                        break;
                    }
                    if (dataTypeX == 45) {
                        this._data = new Double(0.0);
                        break;
                    }
                    this._data = new Double(0.0);
                    break;
                }
                this._data = new Double((Double)padValue);
                break;
            }
            case 32: {
                this.dataSignature = "[D";
                this._data = new double[2 * (int)this.numValues];
                if (padValue == null) {
                    int i = 0;
                    while ((long)i < this.numValues) {
                        ((double[])this._data)[2 * i] = 0.0;
                        ((double[])this._data)[2 * i + 1] = 0.0;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while ((long)i < this.numValues) {
                        ((double[])this._data)[2 * i] = ((double[])padValue)[0];
                        ((double[])this._data)[2 * i + 1] = ((double[])padValue)[1];
                        ++i;
                    }
                }
                break;
            }
        }
    }

    public void dumpData() {
        if (this.nDims <= 1) {
            if (this.nDims == 0) {
                if (this._myVar.getDataType() == 31L) {
                    Double lEpoch = (Double)this._dataArray;
                    System.out.println(Epoch.encode(lEpoch));
                } else if (this._myVar.getDataType() == 32L) {
                    double[] lEpoch16 = (double[])this._dataArray;
                    System.out.println(Epoch16.encode(lEpoch16));
                } else {
                    System.out.println(this._dataArray.toString());
                }
            } else {
                System.out.print("[");
                switch ((int)this._myVar.getDataType()) {
                    case 51: 
                    case 52: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((String[])this._dataArray)[j]);
                        }
                        break;
                    }
                    case 1: 
                    case 41: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((byte[])this._dataArray)[j]);
                        }
                        break;
                    }
                    case 2: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((short[])this._dataArray)[j]);
                        }
                        break;
                    }
                    case 11: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            if (((short[])this._dataArray)[j] >= 0) {
                                System.out.print(((short[])this._dataArray)[j]);
                                continue;
                            }
                            short tmp = (short)(((short[])this._dataArray)[j] + 256);
                            System.out.print(tmp);
                        }
                        break;
                    }
                    case 4: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((int[])this._dataArray)[j]);
                        }
                        break;
                    }
                    case 12: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            if (((int[])this._dataArray)[j] >= 0) {
                                System.out.print(((int[])this._dataArray)[j]);
                                continue;
                            }
                            int tmp = ((int[])this._dataArray)[j] + 65536;
                            System.out.print(tmp);
                        }
                        break;
                    }
                    case 14: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            if (((long[])this._dataArray)[j] >= 0L) {
                                System.out.print(((long[])this._dataArray)[j]);
                                continue;
                            }
                            long tmp = ((long[])this._dataArray)[j] + 0x100000000L;
                            System.out.print(tmp);
                        }
                        break;
                    }
                    case 21: 
                    case 44: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((float[])this._dataArray)[j]);
                        }
                        break;
                    }
                    case 22: 
                    case 45: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((double[])this._dataArray)[j]);
                        }
                        break;
                    }
                    case 31: {
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            System.out.print(Epoch.encode(((double[])this._dataArray)[j]));
                        }
                        break;
                    }
                    case 32: {
                        double[] tmp = new double[2];
                        for (int j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                            if (j > 0) {
                                System.out.print(",");
                            }
                            tmp[0] = ((double[])this._dataArray)[2 * j];
                            tmp[1] = ((double[])this._dataArray)[2 * j + 1];
                            System.out.print(Epoch16.encode(tmp));
                        }
                        break;
                    }
                }
                System.out.println("]");
            }
        } else {
            Object[] aRow = null;
            Object[] subArrays = new Object[this.nDims - 1];
            int[] cIndex = new int[this.nDims - 1];
            long[] boundary = new long[this.nDims - 1];
            subArrays[0] = this._dataArray;
            cIndex[0] = 0;
            boundary[0] = this.product(this.dimSizes, 0, this.nDims);
            for (int i = 1; i < this.nDims - 1; ++i) {
                subArrays[i] = Array.get(subArrays[i - 1], 0);
                boundary[i] = this.product(this.dimSizes, i, this.nDims);
                cIndex[i] = 0;
            }
            int n = 0;
            Object cObject = this._dataArray;
            while ((long)n < boundary[0]) {
                int j;
                int i;
                if (n != 0) {
                    for (i = 0; i < this.nDims - 1; ++i) {
                        boolean boundaryCrossed;
                        boolean bl = boundaryCrossed = (long)n % boundary[i] == 0L;
                        if (boundaryCrossed) {
                            int n2 = i;
                            cIndex[n2] = cIndex[n2] + 1;
                            subArrays[i] = cObject = Array.get(cObject, cIndex[i]);
                            for (j = i + 1; j < this.nDims - 1; ++j) {
                                cIndex[j] = 0;
                                subArrays[j] = Array.get(subArrays[j - 1], cIndex[j]);
                            }
                            break;
                        }
                        cObject = subArrays[i];
                    }
                }
                for (i = 0; i < this.dimSizes[this.nDims - 2]; ++i) {
                    System.out.print("[");
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            aRow = (String[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(aRow[j]);
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            aRow = (byte[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((byte[])aRow)[j]);
                            }
                            break;
                        }
                        case 2: {
                            aRow = (short[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((short[])aRow)[j]);
                            }
                            break;
                        }
                        case 11: {
                            aRow = (short[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                if (((short[])aRow)[j] >= 0) {
                                    System.out.print(((short[])aRow)[j]);
                                    continue;
                                }
                                short tmp = (short)(((short[])aRow)[j] + 256);
                                System.out.print(tmp);
                            }
                            break;
                        }
                        case 4: {
                            aRow = (int[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((int[])aRow)[j]);
                            }
                            break;
                        }
                        case 12: {
                            aRow = (int[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                if (((int[])aRow)[j] >= 0) {
                                    System.out.print(((int[])aRow)[j]);
                                    continue;
                                }
                                int tmp = ((int[])aRow)[j] + 65536;
                                System.out.print(tmp);
                            }
                            break;
                        }
                        case 14: {
                            aRow = (long[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                if (((long[])aRow)[j] >= 0L) {
                                    System.out.print(((long[])aRow)[j]);
                                    continue;
                                }
                                long tmp = ((long[])aRow)[j] + 0x100000000L;
                                System.out.print(tmp);
                            }
                            break;
                        }
                        case 21: 
                        case 44: {
                            aRow = (float[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((float[])aRow)[j]);
                            }
                            break;
                        }
                        case 22: 
                        case 45: {
                            aRow = (double[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((double[])aRow)[j]);
                            }
                            break;
                        }
                        case 31: {
                            aRow = (double[])Array.get(subArrays[this.nDims - 2], i);
                            for (j = 0; j < this.dimSizes[this.nDims - 1]; ++j) {
                                if (j > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(Epoch.encode(((double[])aRow)[j]));
                            }
                            break;
                        }
                        case 32: {
                            double[] tmp = new double[2];
                            aRow = (double[])Array.get(subArrays[this.nDims - 2], i);
                            for (int j2 = 0; j2 < this.dimSizes[this.nDims - 1]; ++j2) {
                                if (j2 > 0) {
                                    System.out.print(",");
                                }
                                tmp[0] = ((double[])aRow)[2 * j2];
                                tmp[1] = ((double[])aRow)[2 * j2 + 1];
                                System.out.print(Epoch16.encode(tmp));
                            }
                            break;
                        }
                    }
                    System.out.println("]");
                    n += this.dimSizes[this.nDims - 1];
                }
            }
        }
    }

    public void dump() {
        int i;
        StringBuffer sb = new StringBuffer();
        StringBuffer specs = new StringBuffer();
        System.err.println("Data dump for " + this._myVar + ": ");
        sb.append(CDFUtils.getStringDataType(this._myVar.getDataType()));
        sb.append("/");
        sb.append(this._myVar.getNumElements());
        int nSpaces = 12 - sb.length();
        for (i = 0; i < nSpaces; ++i) {
            sb.append(" ");
        }
        specs.append(sb.toString());
        sb.setLength(0);
        specs.append(String.valueOf(this.nDims));
        specs.append(":[");
        for (i = 0; i < this.nDims; ++i) {
            if (i > 0) {
                specs.append(",");
            }
            specs.append(String.valueOf(this.dimSizes[i]));
        }
        specs.append("]\t");
        specs.append(String.valueOf(this.recStart));
        specs.append("/");
        specs.append(String.valueOf(this.recCount));
        specs.append("/");
        specs.append(String.valueOf(this.recInterval));
        specs.append("/[");
        for (i = 0; i < this.dimIndices.length; ++i) {
            if (i > 0) {
                specs.append(",");
            }
            specs.append(String.valueOf(this.dimIndices[i]));
        }
        specs.append("]/[");
        for (i = 0; i < this.dimCounts.length; ++i) {
            if (i > 0) {
                specs.append(",");
            }
            specs.append(String.valueOf(this.dimCounts[i]));
        }
        specs.append("]/[");
        for (i = 0; i < this.dimIntervals.length; ++i) {
            if (i > 0) {
                specs.append(",");
            }
            specs.append(String.valueOf(this.dimIntervals[i]));
        }
        specs.append("]/");
        specs.append(this._dataArray.getClass().getName());
        System.err.println(specs.toString());
        this.dumpData();
    }

    public String getName() {
        return "Data";
    }

    public void rename(String name) throws CDFException {
    }

    public void delete() throws CDFException {
    }
}

