/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDFConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class CDFTools
implements CDFConstants {
    private static String cdfbase = System.getProperty("cdf.base");
    private static String separator = System.getProperty("file.separator");
    private static String cmdBase = cdfbase + separator + "bin" + separator;
    private static OutputStream err = System.err;
    public static final int NO_VALUES = 0;
    public static final int NRV_VALUES = 1;
    public static final int RV_VALUES = 2;
    public static final int ALL_VALUES = 3;
    public static final int NAMED_VALUES = 4;
    public static final int NO_REPORTS = 0;
    public static final int REPORT_ERRORS = 1;
    public static final int REPORT_WARNINGS = 2;
    public static final int REPORT_INFORMATION = 4;

    public static void skeletonTable(String skeletonName, String cdfName, boolean log, boolean format, boolean neg2posfp0, boolean statistics, boolean screen, boolean page, int values, String[] valueList, int zMode, int reportType, int cacheSize) throws IOException, InterruptedException {
        String line;
        StringBuffer cmd = new StringBuffer();
        cmd.append(cmdBase).append("skeletontable ");
        if (skeletonName != null) {
            cmd.append("-skeleton ");
            cmd.append(skeletonName + " ");
        }
        switch (values) {
            case 0: {
                break;
            }
            case 1: {
                cmd.append("-values nrv ");
                break;
            }
            case 2: {
                cmd.append("-values rv ");
                break;
            }
            case 3: {
                cmd.append("-values all");
                break;
            }
            case 4: {
                cmd.append("-values ");
                for (int i = 0; i < valueList.length; ++i) {
                    cmd.append(valueList[i] + ",");
                }
                cmd.setLength(cmd.length() - 1);
                cmd.append(" ");
            }
        }
        cmd.append("-");
        if (!log) {
            cmd.append("no");
        }
        cmd.append("log ");
        cmd.append("-zmode " + zMode + " ");
        cmd.append("-");
        if (!format) {
            cmd.append("no");
        }
        cmd.append("format ");
        cmd.append("-");
        if (!neg2posfp0) {
            cmd.append("no");
        }
        cmd.append("neg2posfp0 ");
        if (reportType != 0) {
            cmd.append("-report \"");
            if ((reportType & 1) != 0) {
                cmd.append("errors, ");
            }
            if ((reportType & 2) != 0) {
                cmd.append("warnings, ");
            }
            if ((reportType & 4) != 0) {
                cmd.append("informationals, ");
            }
            cmd.setLength(cmd.length() - 2);
            cmd.append("\" ");
        }
        if (cacheSize != 0) {
            cmd.append("-cache ");
            cmd.append("\"" + cacheSize + "\"");
        }
        cmd.append("-");
        if (!statistics) {
            cmd.append("no");
        }
        cmd.append("statistics ");
        cmd.append("-");
        if (!screen) {
            cmd.append("no");
        }
        cmd.append("screen ");
        cmd.append("-");
        if (!page) {
            cmd.append("no");
        }
        cmd.append("page ");
        cmd.append(cdfName);
        Process p = Runtime.getRuntime().exec(cmd.toString());
        int retcode = p.waitFor();
        BufferedReader inStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = inStream.readLine()) != null) {
            if (!(err instanceof PrintStream)) continue;
            ((PrintStream)err).println(line);
        }
    }

    public static void skeletonCDF(String skeletonName, String cdfName, boolean delete, boolean log, boolean neg2posfp0, boolean statistics, int zMode, int reportType, int cacheSize) throws IOException, InterruptedException {
        String line;
        StringBuffer cmd = new StringBuffer();
        cmd.append(cmdBase).append("skeletoncdf ");
        if (cdfName != null) {
            cmd.append("-cdf ");
            cmd.append(cdfName + " ");
        }
        cmd.append("-");
        if (!delete) {
            cmd.append("no");
        }
        cmd.append("delete ");
        cmd.append("-");
        if (!log) {
            cmd.append("no");
        }
        cmd.append("log ");
        cmd.append("-zmode " + zMode + " ");
        cmd.append("-");
        if (!neg2posfp0) {
            cmd.append("no");
        }
        cmd.append("neg2posfp0 ");
        if (reportType != 0) {
            cmd.append("-report ");
            if ((reportType & 1) != 0) {
                cmd.append("errors, ");
            }
            if ((reportType & 2) != 0) {
                cmd.append("warnings, ");
            }
            if ((reportType & 4) != 0) {
                cmd.append("informationals, ");
            }
            cmd.setLength(cmd.length() - 2);
            cmd.append(" ");
        }
        if (cacheSize != 0) {
            cmd.append("-cache ");
            cmd.append("\"" + cacheSize + "\"");
        }
        cmd.append("-");
        if (!statistics) {
            cmd.append("no");
        }
        cmd.append("statistics ");
        cmd.append(skeletonName);
        Process p = Runtime.getRuntime().exec(cmd.toString());
        int returnCode = p.waitFor();
        BufferedReader inStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = inStream.readLine()) != null) {
            if (!(err instanceof PrintStream)) continue;
            ((PrintStream)err).println(line);
        }
    }
}

