/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.io.Serializable;
import java.util.Vector;

public class Entry
implements CDFObject,
CDFConstants {
    private long id;
    private long attrID;
    private long cdfID;
    private long scope;
    private long dataType;
    private long xdataType;
    private long numElements;
    private long xnumElements;
    private Object data = null;
    private Object xdata = null;
    private String dataSignature;
    private String xdataSignature;
    private Attribute myAttribute;

    private Entry(Attribute myAttribute, long id) {
        this.myAttribute = myAttribute;
        this.id = id;
        this.scope = myAttribute.getScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Entry retrieve(Attribute myAttribute, long id) throws CDFException {
        Attribute attribute = myAttribute;
        synchronized (attribute) {
            Entry theEntry = new Entry(myAttribute, id);
            Vector<Serializable> cmds = new Vector<Serializable>();
            Vector<String> item0 = new Vector<String>();
            Vector<String> item1 = new Vector<String>();
            Vector<String> itemA = new Vector<String>();
            Vector<String> itemB = new Vector<String>();
            Vector<String> itemC = new Vector<String>();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(85L));
            itemB.addElement("attrID");
            itemB.addElement("J");
            cmds.addElement(itemB);
            cmds.addElement(theEntry.scope == 1L ? new Long(96L) : new Long(109L));
            itemC.addElement("id");
            itemC.addElement("J");
            cmds.addElement(itemC);
            cmds.addElement(new Long(1007L));
            cmds.addElement(theEntry.scope == 1L ? new Long(98L) : new Long(112L));
            item0.addElement("dataType");
            item0.addElement("J");
            cmds.addElement(item0);
            cmds.addElement(theEntry.scope == 1L ? new Long(99L) : new Long(113L));
            item1.addElement("numElements");
            item1.addElement("J");
            cmds.addElement(item1);
            cmds.addElement(new Long(1000L));
            theEntry.cdfID = myAttribute.getMyCDF().getID();
            theEntry.attrID = myAttribute.getID();
            theEntry.myAttribute.getMyCDF().executeCommand(theEntry, cmds);
            theEntry.buildDataObject();
            cmds.removeAllElements();
            item0.removeAllElements();
            itemA.removeAllElements();
            itemB.removeAllElements();
            itemC.removeAllElements();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(85L));
            itemB.addElement("attrID");
            itemB.addElement("J");
            cmds.addElement(itemB);
            cmds.addElement(theEntry.scope == 1L ? new Long(96L) : new Long(109L));
            itemC.addElement("id");
            itemC.addElement("J");
            cmds.addElement(itemC);
            cmds.addElement(new Long(1007L));
            cmds.addElement(theEntry.scope == 1L ? new Long(101L) : new Long(115L));
            item0.addElement("data");
            item0.addElement("Ljava/lang/Object;");
            cmds.addElement(item0);
            cmds.addElement(new Long(1000L));
            theEntry.myAttribute.getMyCDF().executeCommand(theEntry, cmds);
            myAttribute.addEntry(theEntry, (int)id);
            return theEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry create(Attribute myAttribute, long id, long dataType, Object data) throws CDFException {
        Attribute attribute = myAttribute;
        synchronized (attribute) {
            if (id < 0L) {
                throw new CDFException(-2043L);
            }
            if (myAttribute.getMaxEntryNumber() < id && myAttribute.getScope() == 2L) {
                throw new CDFException(-2019L);
            }
            if (myAttribute.getMaxEntryNumber() > id) {
                try {
                    myAttribute.getEntry(id).delete();
                }
                catch (CDFException e) {
                    // empty catch block
                }
            }
            Entry theEntry = new Entry(myAttribute, id);
            theEntry.dataType = dataType;
            theEntry.data = data;
            theEntry.dataSignature = CDFUtils.getSignature(data);
            theEntry.numElements = CDFUtils.getNumElements(dataType, data);
            Vector<Serializable> cmds = new Vector<Serializable>();
            Vector<String> item0 = new Vector<String>();
            Vector<String> item1 = new Vector<String>();
            Vector<String> item2 = new Vector<String>();
            Vector<String> itemA = new Vector<String>();
            Vector<String> itemB = new Vector<String>();
            Vector<String> itemC = new Vector<String>();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(85L));
            itemB.addElement("attrID");
            itemB.addElement("J");
            cmds.addElement(itemB);
            cmds.addElement(theEntry.scope == 1L ? new Long(96L) : new Long(109L));
            itemC.addElement("id");
            itemC.addElement("J");
            cmds.addElement(itemC);
            cmds.addElement(new Long(1008L));
            cmds.addElement(theEntry.scope == 1L ? new Long(101L) : new Long(115L));
            item0.addElement("dataType");
            item0.addElement("J");
            cmds.addElement(item0);
            item1.addElement("numElements");
            item1.addElement("J");
            cmds.addElement(item1);
            item2.addElement("data");
            item2.addElement("Ljava/lang/Object;");
            cmds.addElement(item2);
            cmds.addElement(new Long(1000L));
            theEntry.attrID = myAttribute.getID();
            theEntry.cdfID = myAttribute.getMyCDF().getID();
            myAttribute.getMyCDF().executeCommand(theEntry, cmds);
            myAttribute.addEntry(theEntry, (int)id);
            return theEntry;
        }
    }

    private void buildDataObject() {
        if (this.dataType == 51L || this.dataType == 52L) {
            this.data = new String();
            this.dataSignature = "Ljava/lang/String;";
        } else {
            switch ((int)this.dataType) {
                case 1: 
                case 41: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[B";
                        this.data = new byte[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Byte;";
                    this.data = new Byte(0);
                    break;
                }
                case 2: 
                case 11: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[S";
                        this.data = new short[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Short;";
                    this.data = new Short(0);
                    break;
                }
                case 4: 
                case 12: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[I";
                        this.data = new int[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Integer;";
                    this.data = new Integer(0);
                    break;
                }
                case 14: {
                    if (this.numElements > 1L) {
                        this.data = new long[(int)this.numElements];
                        this.dataSignature = "[J";
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Long;";
                    this.data = new Long(0L);
                    break;
                }
                case 21: 
                case 44: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[F";
                        this.data = new float[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Float;";
                    this.data = new Float(0.0f);
                    break;
                }
                case 22: 
                case 31: 
                case 45: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[D";
                        this.data = new double[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Double;";
                    this.data = new Double(0.0);
                    break;
                }
                case 32: {
                    this.dataSignature = "[D";
                    this.data = new double[2 * (int)this.numElements];
                    break;
                }
            }
        }
    }

    public synchronized void delete() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(85L));
        itemB.addElement("attrID");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(this.scope == 1L ? new Long(96L) : new Long(109L));
        item0.addElement("id");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1003L));
        cmds.addElement(this.scope == 1L ? new Long(96L) : new Long(109L));
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myAttribute.getMyCDF().getID();
        this.attrID = this.myAttribute.getID();
        this.myAttribute.getMyCDF().executeCommand(this, cmds);
        this.myAttribute.removeEntry(this);
    }

    public synchronized long getDataType() {
        return this.dataType;
    }

    public synchronized long getNumElements() {
        return this.numElements;
    }

    public synchronized Object getData() {
        return this.data;
    }

    public synchronized long getID() {
        return this.myAttribute.getEntryID(this);
    }

    public synchronized String getName() {
        return Long.toString(this.id);
    }

    public synchronized void rename(String name) throws CDFException {
    }

    public synchronized void updateDataSpec(long dataType, long numElements) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        Vector<String> itemC = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(85L));
        itemB.addElement("attrID");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(this.scope == 1L ? new Long(96L) : new Long(109L));
        itemC.addElement("id");
        itemC.addElement("J");
        cmds.addElement(itemC);
        cmds.addElement(new Long(1008L));
        cmds.addElement(this.scope == 1L ? new Long(100L) : new Long(114L));
        item0.addElement("xdataType");
        item0.addElement("J");
        cmds.addElement(item0);
        item1.addElement("xnumElements");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.attrID = this.myAttribute.getID();
        this.cdfID = this.myAttribute.getMyCDF().getID();
        this.xdataType = dataType;
        this.xnumElements = numElements;
        this.myAttribute.getMyCDF().executeCommand(this, cmds);
        this.dataType = this.xdataType;
        this.numElements = this.xnumElements;
        this.data = null;
        this.buildDataObject();
        cmds.removeAllElements();
        item0.removeAllElements();
        itemA.removeAllElements();
        itemB.removeAllElements();
        itemC.removeAllElements();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(85L));
        itemB.addElement("attrID");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(this.scope == 1L ? new Long(96L) : new Long(109L));
        itemC.addElement("id");
        itemC.addElement("J");
        cmds.addElement(itemC);
        cmds.addElement(new Long(1007L));
        cmds.addElement(this.scope == 1L ? new Long(101L) : new Long(115L));
        item0.addElement("data");
        item0.addElement("Ljava/lang/Object;");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.myAttribute.getMyCDF().executeCommand(this, cmds);
    }

    public synchronized void putData(long dataType, Object data) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        Vector<String> itemC = new Vector<String>();
        try {
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(85L));
            itemB.addElement("attrID");
            itemB.addElement("J");
            cmds.addElement(itemB);
            cmds.addElement(this.scope == 1L ? new Long(96L) : new Long(109L));
            itemC.addElement("id");
            itemC.addElement("J");
            cmds.addElement(itemC);
            cmds.addElement(new Long(1008L));
            cmds.addElement(this.scope == 1L ? new Long(101L) : new Long(115L));
            item0.addElement("dataType");
            item0.addElement("J");
            cmds.addElement(item0);
            item1.addElement("numElements");
            item1.addElement("J");
            cmds.addElement(item1);
            item2.addElement("data");
            item2.addElement("Ljava/lang/Object;");
            cmds.addElement(item2);
            cmds.addElement(new Long(1000L));
            this.id = this.getID();
            this.xdataType = this.dataType;
            this.xnumElements = this.numElements;
            this.xdataSignature = this.dataSignature;
            this.xdata = this.data;
            this.dataType = dataType;
            this.numElements = CDFUtils.getNumElements(dataType, data);
            this.dataSignature = CDFUtils.getSignature(data);
            this.data = data;
            this.attrID = this.myAttribute.getID();
            this.cdfID = this.myAttribute.getMyCDF().getID();
            this.myAttribute.getMyCDF().executeCommand(this, cmds);
        }
        catch (CDFException ex) {
            this.dataType = this.xdataType;
            this.numElements = this.xnumElements;
            this.data = this.xdata;
            this.dataSignature = this.xdataSignature;
            throw new CDFException(ex.getCurrentStatus());
        }
    }

    protected final synchronized void select() throws CDFException {
        Vector<Long> cmds = new Vector<Long>();
        this.id = this.getID();
        cmds.addElement(new Long(1000L));
        this.myAttribute.getMyCDF().executeCommand(this, cmds);
    }
}

