/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFData;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Variable
implements CDFObject,
CDFConstants {
    private CDF myCDF;
    private String name = null;
    private long id;
    private long cdfID;
    private long cType;
    private long cTypeX;
    private long cPct;
    private long[] cParms = new long[1];
    private long[] cParmsX = new long[1];
    private long dataType;
    private long xdataType;
    private long numDims;
    private long numElements;
    private long xnumElements;
    private long[] dimSizes;
    private long[] dimVariances;
    private long[] dimVariancesX;
    private long maxRec;
    private Object data = null;
    private String dataSignature;
    private long recNum;
    private long recCount;
    private long recInterval;
    private long[] dimCounts;
    private long[] dimIndices;
    private long[] dimIntervals;
    private long num0toRecords;
    private long numRecords;
    private long numAllocRecords;
    private long maxAllocRecord;
    private long nRecords;
    private Object padValue = null;
    private Object padValueX = null;
    private long sparseRecords;
    private long sparseRecordsX;
    private long recVariance;
    private long recVarianceX;
    private long blockingFactor;
    private long blockingFactorX;
    private long cacheSize;
    private long reservePercent;
    private long firstRec;
    private long lastRec;

    private Variable(CDF myCDF) {
        this.myCDF = myCDF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Variable retrieve(CDF myCDF, long id) throws CDFException {
        CDF cDF = myCDF;
        synchronized (cDF) {
            Variable v = new Variable(myCDF);
            v.id = id;
            Vector<Serializable> cmds = new Vector<Serializable>();
            Vector<String> item0 = new Vector<String>();
            Vector<String> item1 = new Vector<String>();
            Vector<String> item2 = new Vector<String>();
            Vector<String> item3 = new Vector<String>();
            Vector<String> item4 = new Vector<String>();
            Vector<String> item5 = new Vector<String>();
            Vector<String> item6 = new Vector<String>();
            Vector<String> item7 = new Vector<String>();
            Vector<String> item8 = new Vector<String>();
            Vector<String> item9 = new Vector<String>();
            Vector<String> itemA = new Vector<String>();
            Vector<String> itemB = new Vector<String>();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(57L));
            itemB.addElement("id");
            itemB.addElement("J");
            cmds.addElement(itemB);
            cmds.addElement(new Long(1007L));
            cmds.addElement(new Long(58L));
            item0.addElement("name");
            item0.addElement("Ljava/lang/String;");
            cmds.addElement(item0);
            cmds.addElement(new Long(60L));
            item1.addElement("numElements");
            item1.addElement("J");
            cmds.addElement(item1);
            cmds.addElement(new Long(59L));
            item2.addElement("dataType");
            item2.addElement("J");
            cmds.addElement(item2);
            cmds.addElement(new Long(61L));
            item3.addElement("numDims");
            item3.addElement("J");
            cmds.addElement(item3);
            cmds.addElement(new Long(63L));
            item4.addElement("recVariance");
            item4.addElement("J");
            cmds.addElement(item4);
            cmds.addElement(new Long(75L));
            item5.addElement("blockingFactor");
            item5.addElement("J");
            cmds.addElement(item5);
            cmds.addElement(new Long(132L));
            item6.addElement("sparseRecords");
            item6.addElement("J");
            cmds.addElement(item6);
            cmds.addElement(new Long(131L));
            item7.addElement("cType");
            item7.addElement("J");
            cmds.addElement(item7);
            item8.addElement("cParms");
            item8.addElement("[J");
            cmds.addElement(item8);
            item9.addElement("cPct");
            item9.addElement("J");
            cmds.addElement(item9);
            cmds.addElement(new Long(1000L));
            v.cdfID = myCDF.getID();
            myCDF.executeCommand(v, cmds);
            cmds.removeAllElements();
            item0.removeAllElements();
            item1.removeAllElements();
            itemA.removeAllElements();
            itemB.removeAllElements();
            if (v.numDims > 0L) {
                v.dimSizes = new long[(int)v.numDims];
                v.dimVariances = new long[(int)v.numDims];
                v.dimCounts = new long[(int)v.numDims];
                v.dimIndices = new long[(int)v.numDims];
                v.dimIntervals = new long[(int)v.numDims];
                cmds.addElement(new Long(1005L));
                cmds.addElement(new Long(1L));
                itemA.addElement("cdfID");
                itemA.addElement("J");
                cmds.addElement(itemA);
                cmds.addElement(new Long(57L));
                itemB.addElement("id");
                itemB.addElement("J");
                cmds.addElement(itemB);
                cmds.addElement(new Long(1007L));
                cmds.addElement(new Long(62L));
                item0.addElement("dimSizes");
                item0.addElement("[J");
                cmds.addElement(item0);
                cmds.addElement(new Long(64L));
                item1.addElement("dimVariances");
                item1.addElement("[J");
                cmds.addElement(item1);
                cmds.addElement(new Long(1000L));
                myCDF.executeCommand(v, cmds);
            }
            cmds.removeAllElements();
            item0.removeAllElements();
            itemA.removeAllElements();
            itemB.removeAllElements();
            v.setSignature();
            if (v.getDataType() == 32L) {
                v.padValue = new double[2];
            }
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(57L));
            itemB.addElement("id");
            itemB.addElement("J");
            cmds.addElement(itemB);
            cmds.addElement(new Long(1007L));
            cmds.addElement(new Long(73L));
            item0.addElement("padValue");
            item0.addElement("Ljava/lang/Object;");
            cmds.addElement(item0);
            cmds.addElement(new Long(1000L));
            myCDF.executeCommand(v, cmds);
            myCDF.addVariable(v);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Variable create(CDF myCDF, String varName, long dataType, long numElements, long numDims, long[] dimSizes, long recVary, long[] dimVarys) throws CDFException {
        CDF cDF = myCDF;
        synchronized (cDF) {
            long idx = myCDF.getVariableID(varName);
            if (idx != -1L) {
                throw new CDFException(-2025L);
            }
            if (varName == null || varName.length() == 0) {
                throw new CDFException(-2045L);
            }
            Vector<Serializable> cmds = new Vector<Serializable>();
            Vector<String> item0 = new Vector<String>();
            Vector<String> item1 = new Vector<String>();
            Vector<String> item2 = new Vector<String>();
            Vector<String> item3 = new Vector<String>();
            Vector<String> item4 = new Vector<String>();
            Vector<String> item5 = new Vector<String>();
            Vector<String> item6 = new Vector<String>();
            Vector<String> item7 = new Vector<String>();
            Vector<String> itemA = new Vector<String>();
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(1001L));
            cmds.addElement(new Long(57L));
            item0.addElement("name");
            item0.addElement("Ljava/lang/String;");
            cmds.addElement(item0);
            item1.addElement("dataType");
            item1.addElement("J");
            cmds.addElement(item1);
            item2.addElement("numElements");
            item2.addElement("J");
            cmds.addElement(item2);
            item3.addElement("numDims");
            item3.addElement("J");
            cmds.addElement(item3);
            item4.addElement("dimSizes");
            item4.addElement("[J");
            cmds.addElement(item4);
            item5.addElement("recVariance");
            item5.addElement("J");
            cmds.addElement(item5);
            item6.addElement("dimVariances");
            item6.addElement("[J");
            cmds.addElement(item6);
            item7.addElement("id");
            item7.addElement("J");
            cmds.addElement(item7);
            cmds.addElement(new Long(1000L));
            Variable v = new Variable(myCDF);
            v.myCDF = myCDF;
            v.name = varName;
            v.dataType = dataType;
            v.numElements = numElements;
            v.numDims = numDims;
            v.dimSizes = dimSizes;
            v.recVariance = recVary;
            v.dimVariances = dimVarys;
            v.dimIndices = new long[(int)numDims];
            v.dimCounts = new long[(int)numDims];
            v.dimIntervals = new long[(int)numDims];
            v.cdfID = myCDF.getID();
            myCDF.executeCommand(v, cmds);
            v.setSignature();
            myCDF.addVariable(v);
            return v;
        }
    }

    public synchronized void delete() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1003L));
        cmds.addElement(new Long(57L));
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        this.myCDF.removeVariable(this);
    }

    public synchronized void rename(String newName) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(58L));
        item0.addElement("name");
        item0.addElement("Ljava/lang/String;");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.name = newName;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized Variable copy(String varName) throws CDFException {
        return this.copy(this.myCDF, varName);
    }

    public synchronized Variable copy(CDF destCDF, String varName) throws CDFException {
        long[] varys;
        long[] sizes;
        long idx = destCDF.getVariableID(varName);
        if (idx != -1L) {
            throw new CDFException(-2025L);
        }
        if (this.getNumDims() == 0L) {
            sizes = new long[]{1L};
            varys = new long[]{-1L};
        } else {
            sizes = this.dimSizes;
            varys = this.dimVariances;
        }
        Variable newVar = Variable.create(destCDF, varName, this.dataType, this.numElements, this.numDims, sizes, this.recVariance, varys);
        Vector attributes = this.myCDF.getAttributes();
        Enumeration e = attributes.elements();
        while (e.hasMoreElements()) {
            Attribute curAttr = (Attribute)e.nextElement();
            if (curAttr.getScope() != 2L) continue;
            try {
                Entry curEntry = curAttr.getEntry(this.getID());
                if (this.myCDF != destCDF) {
                    Attribute destAttr = destCDF.getAttributeID(curAttr.getName()) == -1L ? Attribute.create(destCDF, curAttr.getName(), 2L) : destCDF.getAttribute(curAttr.getName());
                    Entry.create(destAttr, newVar.getID(), curEntry.getDataType(), curEntry.getData());
                    continue;
                }
                Entry.create(curAttr, newVar.getID(), curEntry.getDataType(), curEntry.getData());
            }
            catch (CDFException ce) {}
        }
        return newVar;
    }

    public synchronized Variable duplicate(String varName) throws CDFException {
        return this.duplicate(this.myCDF, varName);
    }

    public synchronized Variable duplicate(CDF destCDF, String varName) throws CDFException {
        long[] sizes;
        long[] interval;
        long[] indices;
        Variable newVar = null;
        if (this.numDims > 0L) {
            indices = new long[(int)this.numDims];
            interval = new long[(int)this.numDims];
            sizes = this.dimSizes;
            int i = 0;
            while ((long)i < this.numDims) {
                indices[i] = 0L;
                interval[i] = 1L;
                ++i;
            }
        } else {
            sizes = new long[]{1L};
            indices = new long[]{1L};
            interval = new long[]{1L};
        }
        long maxRecX = this.getMaxWrittenRecord();
        newVar = this.copy(destCDF, varName);
        newVar.setBlockingFactor(this.blockingFactor);
        newVar.setCompression(this.cType, this.cParms);
        newVar.setSparseRecords(this.sparseRecords);
        if (this.padValue != null) {
            newVar.setPadValue(this.padValue);
        }
        if (maxRecX > -1L) {
            this.recNum = 0L;
            while (this.recNum <= maxRecX) {
                this.firstRec = this.getAllocatedFrom(this.recNum);
                this.lastRec = this.getAllocatedTo(this.firstRec);
                this.lastRec = this.lastRec > maxRecX ? maxRecX : this.lastRec;
                Object gotData = this.getHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, indices, sizes, interval);
                newVar.putHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, indices, sizes, interval, gotData);
                this.recNum = this.lastRec + 1L;
            }
        }
        return newVar;
    }

    public synchronized void copyDataRecords(Variable destVar) throws CDFException {
        this.copyDataRecords(destVar, 1L);
    }

    private void copyDataRecords(Variable destVar, long toWhere) throws CDFException {
        long[] sizes;
        long[] interval;
        long[] indices;
        if (this.dataType != destVar.dataType || this.numElements != destVar.numElements || this.numDims != destVar.numDims) {
            throw new CDFException(-2104L);
        }
        int i = 0;
        while ((long)i < this.numDims) {
            if (this.dimSizes[i] != destVar.dimSizes[i] || this.dimVariances[i] != destVar.dimVariances[i]) {
                throw new CDFException(-2104L);
            }
            ++i;
        }
        if (this.numDims > 0L) {
            indices = new long[(int)this.numDims];
            interval = new long[(int)this.numDims];
            sizes = this.dimSizes;
            int i2 = 0;
            while ((long)i2 < this.numDims) {
                indices[i2] = 0L;
                interval[i2] = 1L;
                ++i2;
            }
        } else {
            indices = new long[]{1L};
            interval = new long[]{1L};
            sizes = new long[]{1L};
        }
        long maxRecI = this.getMaxWrittenRecord();
        long maxRecO = toWhere == 1L ? 0L : destVar.getMaxWrittenRecord() + 1L;
        if (maxRecI > -1L) {
            this.recNum = 0L;
            while (this.recNum <= maxRecI) {
                this.firstRec = this.getAllocatedFrom(this.recNum);
                this.lastRec = this.getAllocatedTo(this.firstRec);
                this.lastRec = this.lastRec > maxRecI ? maxRecI : this.lastRec;
                Object gotData = this.getHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, indices, sizes, interval);
                destVar.putHyperData(maxRecO + this.firstRec, this.lastRec - this.firstRec + 1L, 1L, indices, sizes, interval, gotData);
                this.recNum = this.lastRec + 1L;
            }
        }
    }

    public synchronized void concatenateDataRecords(Variable destVar) throws CDFException {
        this.copyDataRecords(destVar, 2L);
    }

    public synchronized Object getEntryData(String attrName) throws CDFException {
        Attribute a = this.myCDF.getAttribute(attrName);
        Object entryData = a.getEntry(this).getData();
        return entryData;
    }

    public synchronized Object getSingleData(long recNum, long[] indices) throws CDFException {
        return this.getSingleDataObject(recNum, indices).getData();
    }

    public synchronized CDFData getSingleDataObject(long recNum, long[] indices) throws CDFException {
        long[] mydices;
        long[] counts;
        long[] interval;
        if (this.numDims > 0L) {
            interval = new long[(int)this.numDims];
            counts = new long[(int)this.numDims];
            mydices = indices;
            int i = 0;
            while ((long)i < this.numDims) {
                counts[i] = 1L;
                interval[i] = 1L;
                ++i;
            }
        } else {
            mydices = new long[]{1L};
            interval = new long[]{1L};
            counts = new long[]{1L};
        }
        return CDFData.get(this, recNum, 1L, 1L, mydices, counts, interval);
    }

    public synchronized Object getRecord(long recNum) throws CDFException {
        return this.getRecordObject(recNum).getData();
    }

    public synchronized CDFData getRecordObject(long recNum) throws CDFException {
        return this.getRecordsObject(recNum, 1L);
    }

    public synchronized CDFData getRecordsObject(long recNum, long numRecs) throws CDFException {
        long[] interval;
        long[] indices;
        long[] sizes;
        if (this.numDims == 0L) {
            sizes = new long[]{1L};
            indices = new long[]{1L};
            interval = new long[]{1L};
        } else {
            sizes = this.dimSizes;
            indices = new long[(int)this.numDims];
            interval = new long[(int)this.numDims];
            int i = 0;
            while ((long)i < this.numDims) {
                indices[i] = 0L;
                interval[i] = 1L;
                ++i;
            }
        }
        return CDFData.get(this, recNum, numRecs, 1L, indices, sizes, interval);
    }

    public synchronized Object getScalarData() throws CDFException {
        return this.getScalarDataObject(0L).getData();
    }

    public synchronized Object getScalarData(long recNum) throws CDFException {
        return this.getScalarDataObject(recNum).getData();
    }

    public synchronized CDFData getScalarDataObject() throws CDFException {
        return this.getScalarDataObject(0L);
    }

    public synchronized CDFData getScalarDataObject(long recNum) throws CDFException {
        long[] indices = new long[]{1L};
        long[] interval = new long[]{1L};
        long[] sizes = new long[]{1L};
        return CDFData.get(this, recNum, 1L, 1L, indices, sizes, interval);
    }

    public synchronized Object getHyperData(long recNum, long recCount, long recInterval, long[] dimIndices, long[] dimCounts, long[] dimIntervals) throws CDFException {
        return CDFData.get(this, recNum, recCount, recInterval, dimIndices, dimCounts, dimIntervals).getData();
    }

    public synchronized CDFData getHyperDataObject(long recNum, long recCount, long recInterval, long[] dimIndices, long[] dimCounts, long[] dimIntervals) throws CDFException {
        return CDFData.get(this, recNum, recCount, recInterval, dimIndices, dimCounts, dimIntervals);
    }

    public synchronized void putEntry(String attrName, long dataType, Object data) throws CDFException {
        Entry.create(this.myCDF.getAttribute(attrName), this.getID(), dataType, data);
    }

    public synchronized void putEntry(Attribute attr, long dataType, Object data) throws CDFException {
        Entry.create(attr, this.getID(), dataType, data);
    }

    public synchronized CDFData putSingleData(long recNum, long[] indices, Object data) throws CDFException {
        long[] mydices;
        long[] counts;
        long[] interval;
        if (this.numDims > 0L) {
            interval = new long[(int)this.numDims];
            counts = new long[(int)this.numDims];
            mydices = indices;
            int i = 0;
            while ((long)i < this.numDims) {
                counts[i] = 1L;
                interval[i] = 1L;
                ++i;
            }
        } else {
            counts = new long[]{1L};
            mydices = new long[]{1L};
            interval = new long[]{1L};
        }
        return CDFData.put(this, recNum, 1L, 1L, mydices, counts, interval, data);
    }

    public synchronized CDFData putScalarData(long recNum, Object data) throws CDFException {
        return this.putSingleData(recNum, new long[]{0L}, data);
    }

    public synchronized CDFData putScalarData(Object data) throws CDFException {
        return this.putSingleData(0L, new long[]{0L}, data);
    }

    public synchronized CDFData putRecord(long recNum, Object data) throws CDFException {
        long[] sizes;
        long[] interval;
        long[] indices;
        if (this.numDims > 0L) {
            indices = new long[(int)this.numDims];
            interval = new long[(int)this.numDims];
            sizes = this.dimSizes;
            int i = 0;
            while ((long)i < this.numDims) {
                indices[i] = 0L;
                interval[i] = 1L;
                ++i;
            }
        } else {
            sizes = new long[]{1L};
            indices = new long[]{1L};
            interval = new long[]{1L};
        }
        return CDFData.put(this, recNum, 1L, 1L, indices, sizes, interval, data);
    }

    public synchronized CDFData putRecord(Object data) throws CDFException {
        return this.putRecord(0L, data);
    }

    public synchronized CDFData putHyperData(long recNum, long recCount, long recInterval, long[] dimIndices, long[] dimCounts, long[] dimIntervals, Object data) throws CDFException {
        return CDFData.put(this, recNum, recCount, recInterval, dimIndices, dimCounts, dimIntervals, data);
    }

    private final void select() throws CDFException {
        Vector<Long> cmds = new Vector<Long>();
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    protected final synchronized void select(long recNum, long[] indices) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        item0.addElement("id");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(79L));
        item1.addElement("recNum");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(82L));
        item2.addElement("dimIndices");
        item2.addElement("[J");
        cmds.addElement(item2);
        cmds.addElement(new Long(1000L));
        this.recNum = recNum;
        int i = 0;
        while ((long)i < this.numDims) {
            this.dimIndices[i] = indices[i];
            ++i;
        }
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    protected final synchronized void select(long recNum, long recCount, long recInterval, long[] dimIndices, long[] dimCounts, long[] dimIntervals) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> item2 = new Vector<String>();
        Vector<String> item3 = new Vector<String>();
        Vector<String> item4 = new Vector<String>();
        Vector<String> item5 = new Vector<String>();
        Vector<String> item6 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        item0.addElement("id");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(79L));
        item1.addElement("recNum");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(80L));
        item2.addElement("recCount");
        item2.addElement("J");
        cmds.addElement(item2);
        cmds.addElement(new Long(81L));
        item3.addElement("recInterval");
        item3.addElement("J");
        cmds.addElement(item3);
        cmds.addElement(new Long(82L));
        item4.addElement("dimIndices");
        item4.addElement("[J");
        cmds.addElement(item4);
        cmds.addElement(new Long(83L));
        item5.addElement("dimCounts");
        item5.addElement("[J");
        cmds.addElement(item5);
        cmds.addElement(new Long(84L));
        item6.addElement("dimIntervals");
        item6.addElement("[J");
        cmds.addElement(item6);
        cmds.addElement(new Long(1000L));
        this.recNum = recNum;
        this.recCount = recCount;
        this.recInterval = recInterval;
        this.dimIndices = dimIndices;
        this.dimCounts = dimCounts;
        this.dimIntervals = dimIntervals;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized CDF getMyCDF() {
        return this.myCDF;
    }

    public synchronized long getCompressionType() {
        return this.cType;
    }

    public synchronized long getCompressionPct() {
        return this.cPct;
    }

    public synchronized long[] getCompressionParms() {
        return this.cParms;
    }

    public synchronized void setCompression(long cType, long[] cParms) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(131L));
        item0.addElement("cTypeX");
        item0.addElement("J");
        cmds.addElement(item0);
        item1.addElement("cParmsX");
        item1.addElement("[J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.cTypeX = cType;
        this.cParmsX = cParms;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        this.cType = cType;
        this.cParms = cParms;
    }

    public synchronized String getCompression() throws CDFException {
        StringBuffer temp = new StringBuffer();
        if (this.cType == 0L) {
            temp.append("No compression");
        } else {
            temp.append(CDFUtils.getStringCompressionType(this.cType)).append(".").append(this.cParms[0]);
        }
        return temp.toString();
    }

    public synchronized long getNumDims() {
        return this.numDims;
    }

    public synchronized long[] getDimSizes() {
        return this.dimSizes;
    }

    public synchronized long getNumElements() {
        return this.numElements;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized long getID() {
        return this.myCDF.getVariableID(this.name);
    }

    public synchronized String toString() {
        return this.name;
    }

    public synchronized void setRecVariance(long recVariance) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(63L));
        item0.addElement("recVarianceX");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.recVarianceX = recVariance;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        this.recVariance = recVariance;
    }

    public synchronized boolean getRecVariance() {
        return this.recVariance == -1L;
    }

    public synchronized void setDimVariances(long[] dimVariances) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(64L));
        item0.addElement("dimVariancesX");
        item0.addElement("[J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.dimVariancesX = dimVariances;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        this.dimVariances = dimVariances;
    }

    public synchronized long[] getDimVariances() {
        return this.dimVariances;
    }

    public synchronized long getDataType() {
        return this.dataType;
    }

    private void setSignature() {
        switch ((int)this.dataType) {
            case 1: 
            case 41: {
                this.dataSignature = "Ljava/lang/Byte;";
                break;
            }
            case 2: 
            case 11: {
                this.dataSignature = "Ljava/lang/Short;";
                break;
            }
            case 4: 
            case 12: {
                this.dataSignature = "Ljava/lang/Integer;";
                break;
            }
            case 14: {
                this.dataSignature = "Ljava/lang/Long;";
                break;
            }
            case 21: 
            case 44: {
                this.dataSignature = "Ljava/lang/Float;";
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                this.dataSignature = "Ljava/lang/Double;";
                break;
            }
            case 32: {
                this.dataSignature = "[D";
                break;
            }
            case 51: 
            case 52: {
                this.dataSignature = "Ljava/lang/String;";
                break;
            }
        }
    }

    public synchronized void deleteRecords(long firstRec, long lastRec) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1003L));
        cmds.addElement(new Long(153L));
        item0.addElement("firstRec");
        item0.addElement("J");
        cmds.addElement(item0);
        item1.addElement("lastRec");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.firstRec = firstRec;
        this.lastRec = lastRec;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized void allocateBlock(long firstRec, long lastRec) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(134L));
        item0.addElement("firstRec");
        item0.addElement("J");
        cmds.addElement(item0);
        item1.addElement("lastRec");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.firstRec = firstRec;
        this.lastRec = lastRec;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized void allocateRecords(long num0toRecords) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(124L));
        item0.addElement("num0toRecords");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.num0toRecords = num0toRecords;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized long getNumWrittenRecords() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(135L));
        item0.addElement("numRecords");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.numRecords;
    }

    public synchronized long getMaxWrittenRecord() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(70L));
        item0.addElement("maxRec");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.maxRec;
    }

    public synchronized long getNumAllocatedRecords() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(136L));
        item0.addElement("numAllocRecords");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.numAllocRecords;
    }

    public synchronized long getMaxAllocatedRecord() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(71L));
        item0.addElement("maxAllocRecord");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.maxAllocRecord;
    }

    public synchronized void setPadValue(Object padValue) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        try {
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(57L));
            itemB.addElement("id");
            itemB.addElement("J");
            cmds.addElement(itemB);
            cmds.addElement(new Long(1008L));
            cmds.addElement(new Long(73L));
            item0.addElement("padValue");
            item0.addElement("Ljava/lang/Object;");
            cmds.addElement(item0);
            cmds.addElement(new Long(1000L));
            this.padValueX = this.padValue;
            this.padValue = padValue;
            this.id = this.getID();
            this.cdfID = this.myCDF.getID();
            this.myCDF.executeCommand(this, cmds);
        }
        catch (CDFException e) {
            this.padValue = this.padValueX;
            throw new CDFException(-2051L);
        }
    }

    public synchronized boolean checkPadValueExistence() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        try {
            cmds.addElement(new Long(1005L));
            cmds.addElement(new Long(1L));
            itemA.addElement("cdfID");
            itemA.addElement("J");
            cmds.addElement(itemA);
            cmds.addElement(new Long(57L));
            itemB.addElement("id");
            itemB.addElement("J");
            cmds.addElement(itemB);
            cmds.addElement(new Long(1006L));
            cmds.addElement(new Long(73L));
            cmds.addElement(new Long(1000L));
            this.id = this.getID();
            this.cdfID = this.myCDF.getID();
            this.myCDF.executeCommand(this, cmds);
            long existing = this.myCDF.getStatus();
            return existing == 0L;
        }
        catch (CDFException e) {
            throw new CDFException(-2034L);
        }
    }

    public synchronized Object getPadValue() {
        return this.padValue;
    }

    public synchronized void setSparseRecords(long sparseRecords) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(132L));
        item0.addElement("sparseRecordsX");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.sparseRecordsX = sparseRecords;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        this.sparseRecords = sparseRecords;
    }

    public synchronized long getSparseRecords() {
        return this.sparseRecords;
    }

    public synchronized void setBlockingFactor(long blockingFactor) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(75L));
        item0.addElement("blockingFactorX");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.blockingFactorX = blockingFactor;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        this.blockingFactor = blockingFactor;
    }

    public synchronized long getBlockingFactor() throws CDFException {
        return this.blockingFactor;
    }

    public synchronized void setInitialRecords(long nRecords) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(74L));
        item0.addElement("nRecords");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.nRecords = nRecords;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized void selectCacheSize(long cacheSize) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(121L));
        item0.addElement("cacheSize");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.cacheSize = cacheSize;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized long confirmCacheSize() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(121L));
        item0.addElement("cacheSize");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.cacheSize;
    }

    public synchronized void selectReservePercent(long reservePercent) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(151L));
        item0.addElement("reservePercent");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.reservePercent = reservePercent;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
    }

    public synchronized long confirmReservePercent() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(151L));
        item0.addElement("reservePercent");
        item0.addElement("J");
        cmds.addElement(item0);
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.reservePercent;
    }

    public synchronized long confirmPadValue() throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1006L));
        cmds.addElement(new Long(73L));
        cmds.addElement(new Long(1000L));
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.myCDF.getStatus();
    }

    public synchronized long getAllocatedFrom(long recNum) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(145L));
        item0.addElement("recNum");
        item0.addElement("J");
        cmds.addElement(item0);
        item1.addElement("firstRec");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.recNum = recNum;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.firstRec;
    }

    public synchronized long getAllocatedTo(long firstRec) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1007L));
        cmds.addElement(new Long(146L));
        item0.addElement("firstRec");
        item0.addElement("J");
        cmds.addElement(item0);
        item1.addElement("lastRec");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.firstRec = firstRec;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        return this.lastRec;
    }

    public synchronized void updateDataSpec(long dataType, long numElements) throws CDFException {
        Vector<Serializable> cmds = new Vector<Serializable>();
        Vector<String> item0 = new Vector<String>();
        Vector<String> item1 = new Vector<String>();
        Vector<String> itemA = new Vector<String>();
        Vector<String> itemB = new Vector<String>();
        cmds.addElement(new Long(1005L));
        cmds.addElement(new Long(1L));
        itemA.addElement("cdfID");
        itemA.addElement("J");
        cmds.addElement(itemA);
        cmds.addElement(new Long(57L));
        itemB.addElement("id");
        itemB.addElement("J");
        cmds.addElement(itemB);
        cmds.addElement(new Long(1008L));
        cmds.addElement(new Long(72L));
        item0.addElement("xdataType");
        item0.addElement("J");
        cmds.addElement(item0);
        item1.addElement("xnumElements");
        item1.addElement("J");
        cmds.addElement(item1);
        cmds.addElement(new Long(1000L));
        this.xdataType = dataType;
        this.xnumElements = numElements;
        this.id = this.getID();
        this.cdfID = this.myCDF.getID();
        this.myCDF.executeCommand(this, cmds);
        this.dataType = dataType;
        this.numElements = numElements;
        this.setSignature();
    }

    public synchronized Vector getAttributes() {
        Variable v = null;
        try {
            v = this.myCDF.getVariable(this.getName());
        }
        catch (CDFException ex) {
            // empty catch block
        }
        Vector<Attribute> attrs = new Vector<Attribute>();
        Vector va = this.myCDF.getVariableAttributes();
        Enumeration e = va.elements();
        while (e.hasMoreElements()) {
            Attribute a = (Attribute)e.nextElement();
            try {
                Entry entry = a.getEntry(v);
                if (entry == null) continue;
                attrs.addElement(a);
            }
            catch (CDFException ex) {}
        }
        return attrs;
    }
}

