/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf.util;

import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.StringTokenizer;

public class CDFUtils
implements CDFConstants {
    public static String getSignature(Object obj) {
        StringBuffer sigBuf = new StringBuffer();
        String clazz = obj.getClass().getName();
        if (clazz.indexOf(91) == 0) {
            sigBuf.append(clazz);
        } else {
            StringTokenizer sigParts = new StringTokenizer(clazz, ".");
            sigBuf.append("L");
            do {
                sigBuf.append(sigParts.nextToken());
                if (!sigParts.hasMoreTokens()) continue;
                sigBuf.append("/");
            } while (sigParts.hasMoreTokens());
            sigBuf.append(";");
        }
        return sigBuf.toString();
    }

    public static long getNumElements(long dataType, Object data) throws CDFException {
        if (dataType == 51L || dataType == 52L) {
            return ((String)data).length();
        }
        int which = dataType == 32L ? 2 : 1;
        String signature = CDFUtils.getSignature(data);
        if (signature.charAt(0) == '[') {
            switch (signature.charAt(1)) {
                case 'B': {
                    return ((byte[])data).length / which;
                }
                case 'S': {
                    return ((short[])data).length / which;
                }
                case 'I': {
                    return ((int[])data).length / which;
                }
                case 'J': {
                    return ((long[])data).length / which;
                }
                case 'F': {
                    return ((float[])data).length / which;
                }
                case 'D': {
                    return ((double[])data).length / which;
                }
            }
            throw new CDFException(-2022L);
        }
        return 1L;
    }

    public static void printData(Object data) {
        CDFUtils.printData(data, 0);
    }

    public static void printData(Object data, int which) {
        int jj = 1;
        String signature = CDFUtils.getSignature(data);
        if (which == 2) {
            jj = 2;
        }
        if (signature.charAt(0) == '[') {
            int arrayLength = Array.getLength(data);
            for (int i = 0; i < arrayLength; i += jj) {
                if (signature.charAt(1) == 'B') {
                    System.out.print(Array.getByte(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) == 'S') {
                    System.out.print(Array.getShort(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) == 'I') {
                    System.out.print(Array.getInt(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) == 'J') {
                    System.out.print(Array.getLong(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) == 'F') {
                    System.out.print(Array.getFloat(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) != 'D') continue;
                if (which == 1) {
                    System.out.print(Epoch.encode(Array.getDouble(data, i)) + " ");
                    continue;
                }
                if (which == 2) {
                    double[] mmm = new double[]{Array.getDouble(data, i), Array.getDouble(data, i + 1)};
                    System.out.print(Epoch16.encode(mmm) + " ");
                    continue;
                }
                System.out.print(Array.getDouble(data, i) + " ");
            }
        } else if (which == 1) {
            System.out.print(Epoch.encode((Double)data) + " ");
        } else {
            System.out.print(data);
        }
    }

    public static void printData(Object data, PrintWriter outWriter) {
        CDFUtils.printData(data, outWriter, 0);
    }

    public static void printData(Object data, PrintWriter outWriter, int which) {
        int jj = 1;
        String signature = CDFUtils.getSignature(data);
        if (which == 2) {
            jj = 2;
        }
        if (signature.charAt(0) == '[') {
            int arrayLength = Array.getLength(data);
            for (int i = 0; i < arrayLength; i += jj) {
                if (signature.charAt(1) == 'B') {
                    outWriter.print(Array.getByte(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) == 'S') {
                    outWriter.print(Array.getShort(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) == 'I') {
                    outWriter.print(Array.getInt(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) == 'J') {
                    outWriter.print(Array.getLong(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) == 'F') {
                    outWriter.print(Array.getFloat(data, i) + " ");
                    continue;
                }
                if (signature.charAt(1) != 'D') continue;
                if (which == 1) {
                    outWriter.print(Epoch.encode(Array.getDouble(data, i)) + " ");
                    continue;
                }
                if (which == 2) {
                    double[] mmm = new double[]{Array.getDouble(data, i), Array.getDouble(data, i + 1)};
                    outWriter.print(Epoch16.encode(mmm) + " ");
                    continue;
                }
                outWriter.print(Array.getDouble(data, i) + " ");
            }
        } else if (which == 1) {
            outWriter.print(Epoch.encode((Double)data));
        } else {
            outWriter.print(data);
        }
    }

    public static String getStringData(Object data) {
        return CDFUtils.getStringData(data, " ", 0);
    }

    public static String getStringData(Object data, int epochType) {
        return CDFUtils.getStringData(data, " ", epochType);
    }

    public static String getStringData(Object data, String separator) {
        return CDFUtils.getStringData(data, separator, 0);
    }

    public static String getStringData(Object data, String separator, int epochType) {
        String signature = CDFUtils.getSignature(data);
        StringBuffer buffer = new StringBuffer();
        int jj = epochType == 2 ? 2 : 1;
        if (signature.charAt(0) == '[') {
            int arrayLength = Array.getLength(data);
            for (int i = 0; i < arrayLength; i += jj) {
                if (signature.charAt(1) == 'B') {
                    buffer.append(Array.getByte(data, i)).append(separator);
                    continue;
                }
                if (signature.charAt(1) == 'S') {
                    buffer.append(Array.getShort(data, i)).append(separator);
                    continue;
                }
                if (signature.charAt(1) == 'I') {
                    buffer.append(Array.getInt(data, i)).append(separator);
                    continue;
                }
                if (signature.charAt(1) == 'J') {
                    buffer.append(Array.getLong(data, i)).append(separator);
                    continue;
                }
                if (signature.charAt(1) == 'F') {
                    buffer.append(Array.getFloat(data, i)).append(separator);
                    continue;
                }
                if (signature.charAt(1) == 'D') {
                    if (epochType == 1) {
                        String tmp = Epoch.encode(Array.getDouble(data, i));
                        buffer.append(tmp).append(separator);
                        continue;
                    }
                    if (epochType == 2) {
                        double[] mmm = new double[]{Array.getDouble(data, i), Array.getDouble(data, i + 1)};
                        String tmp = Epoch16.encode(mmm);
                        buffer.append(tmp).append(separator);
                        continue;
                    }
                    buffer.append(Array.getDouble(data, i)).append(separator);
                    continue;
                }
                if (signature.charAt(1) == 'C') {
                    buffer.append(Array.getChar(data, i)).append(separator);
                    continue;
                }
                if (signature.indexOf("String") == -1) continue;
                buffer.append(((String[])data)[i]).append(separator);
            }
            buffer.setLength(buffer.length() - separator.length());
        } else if (signature.indexOf("Byte") != -1) {
            buffer.append(((Byte)data).toString());
        } else if (signature.indexOf("Short") != -1) {
            buffer.append(((Short)data).toString());
        } else if (signature.indexOf("Integer") != -1) {
            buffer.append(((Integer)data).toString());
        } else if (signature.indexOf("Long") != -1) {
            buffer.append(((Long)data).toString());
        } else if (signature.indexOf("Float") != -1) {
            buffer.append(((Float)data).toString());
        } else if (signature.indexOf("Double") != -1) {
            if (epochType == 1) {
                String tmp = Epoch.encode((Double)data);
                buffer.append(tmp).append(separator);
            } else {
                buffer.append(((Double)data).toString());
            }
        } else if (signature.indexOf("Character") != -1) {
            buffer.append(((Character)data).toString());
        } else if (signature.indexOf("String") != -1) {
            buffer.append((String)data);
        }
        return buffer.toString();
    }

    public static String getStringDataType(Variable var) {
        return CDFUtils.getStringDataType(var.getDataType());
    }

    public static String getStringDataType(Entry entry) {
        return CDFUtils.getStringDataType(entry.getDataType());
    }

    public static String getStringDataType(long cdfDataType) {
        String cDataType = cdfDataType == 41L ? "CDF_BYTE" : (cdfDataType == 51L ? "CDF_CHAR" : (cdfDataType == 52L ? "CDF_UCHAR" : (cdfDataType == 1L ? "CDF_INT1" : (cdfDataType == 11L ? "CDF_UINT1" : (cdfDataType == 2L ? "CDF_INT2" : (cdfDataType == 12L ? "CDF_UINT2" : (cdfDataType == 4L ? "CDF_INT4" : (cdfDataType == 14L ? "CDF_UINT4" : (cdfDataType == 21L ? "CDF_REAL4" : (cdfDataType == 44L ? "CDF_FLOAT" : (cdfDataType == 22L ? "CDF_REAL8" : (cdfDataType == 45L ? "CDF_DOUBLE" : (cdfDataType == 31L ? "CDF_EPOCH" : (cdfDataType == 32L ? "CDF_EPOCH16" : "UNKNOWN"))))))))))))));
        return cDataType;
    }

    public static long getDataTypeValue(String cdfDataType) {
        long lDataType = cdfDataType.equals("CDF_BYTE") ? 41L : (cdfDataType.equals("CDF_CHAR") ? 51L : (cdfDataType.equals("CDF_UCHAR") ? 52L : (cdfDataType.equals("CDF_INT1") ? 1L : (cdfDataType.equals("CDF_UINT1") ? 11L : (cdfDataType.equals("CDF_INT2") ? 2L : (cdfDataType.equals("CDF_UINT2") ? 12L : (cdfDataType.equals("CDF_INT4") ? 4L : (cdfDataType.equals("CDF_UINT4") ? 14L : (cdfDataType.equals("CDF_REAL4") ? 21L : (cdfDataType.equals("CDF_FLOAT") ? 44L : (cdfDataType.equals("CDF_REAL8") ? 22L : (cdfDataType.equals("CDF_DOUBLE") ? 45L : (cdfDataType.equals("CDF_EPOCH") ? 31L : (cdfDataType.equals("CDF_EPOCH16") ? 32L : -1L))))))))))))));
        return lDataType;
    }

    public static String getStringCompressionType(long compressionType) {
        String[] cDataTypes = new String[]{"NONE", "RLE", "Huffman", "Adaptive Huffman", " ", "GZIP"};
        if (compressionType > 5L || compressionType == 4L) {
            return "UNKNOWN";
        }
        return cDataTypes[(int)compressionType];
    }

    public static long getLongCompressionType(String compressionType) {
        String[] cDataTypes = new String[]{"NONE", "RLE", "Huffman", "Adaptive Huffman", " ", "GZIP"};
        for (int i = 0; i < cDataTypes.length; ++i) {
            if (!compressionType.equalsIgnoreCase(cDataTypes[i])) continue;
            return i;
        }
        if (compressionType.equalsIgnoreCase("NONE")) {
            return 0L;
        }
        return -1L;
    }

    public static String getStringCompressionType(Variable var) {
        return CDFUtils.getStringCompressionType(var.getCompressionType());
    }

    public static String getStringCompressionType(CDF cdf) {
        return CDFUtils.getStringCompressionType(cdf.getCompressionType());
    }

    public static String getStringEncoding(long encodingType) {
        String[] eDataTypes = new String[]{" ", "NETWORK", "SUN", "VAX", "DECSTATION", "SGi", "IBMPC", "IBMRS", "HOST", "MAC", " ", "HP", "NeXT", "ALPHAOSF1", "ALPHAVMSd", "ALPHAVMSg", "ALPHAVMSi"};
        if (encodingType == 0L || encodingType == 10L || encodingType > 16L) {
            return "UNKNOWN";
        }
        return eDataTypes[(int)encodingType];
    }

    public static long getLongEncoding(String encodingType) {
        String[] eDataTypes = new String[]{" ", "NETWORK", "SUN", "VAX", "DECSTATION", "SGi", "IBMPC", "IBMRS", "HOST", "MAC", " ", "HP", "NeXT", "ALPHAOSF1", "ALPHAVMSd", "ALPHAVMSg", "ALPHAVMSi"};
        if ("".equals(encodingType) || encodingType.equals(" ")) {
            return -1L;
        }
        for (int i = 0; i < eDataTypes.length; ++i) {
            if (i == 0 || i == 10 || !encodingType.equalsIgnoreCase(eDataTypes[i])) continue;
            return i;
        }
        return -1L;
    }

    public static String getStringEncoding(CDF cdf) {
        return CDFUtils.getStringEncoding(cdf.getEncoding());
    }

    public static String getStringDecoding(long decodingType) throws CDFException {
        return CDFUtils.getStringEncoding(decodingType);
    }

    public static String getStringDecoding(CDF cdf) throws CDFException {
        return CDFUtils.getStringEncoding(cdf.confirmDecoding());
    }

    public static String getStringMajority(long majorityType) {
        String mType = null;
        mType = majorityType == 1L ? "ROW" : (majorityType == 2L ? "COLUMN" : "UNKNOWN");
        return mType;
    }

    public static long getLongMajority(String majorityType) {
        long mType = majorityType.equalsIgnoreCase("ROW") ? 1L : (majorityType.equalsIgnoreCase("COLUMN") ? 2L : -1L);
        return mType;
    }

    public static String getStringMajority(CDF cdf) {
        return CDFUtils.getStringMajority(cdf.getMajority());
    }

    public static String getStringFormat(long formatType) {
        String fType = null;
        fType = formatType == 1L ? "SINGLE" : (formatType == 2L ? "MULTI" : "UNKNOWN");
        return fType;
    }

    public static long getLongFormat(String formatType) {
        long fType = formatType.equalsIgnoreCase("SINGLE") ? 1L : (formatType.equalsIgnoreCase("MULTI") ? 2L : -1L);
        return fType;
    }

    public static String getStringFormat(CDF cdf) {
        return CDFUtils.getStringFormat(cdf.getFormat());
    }

    public static String getStringSparseRecord(long sparseRecordType) {
        String sType = null;
        sType = sparseRecordType == 0L ? "None" : (sparseRecordType == 1L ? "PAD" : (sparseRecordType == 2L ? "PREV" : "UNKNOWN"));
        return sType;
    }

    public static String getStringChecksum(CDF cdf) {
        return CDFUtils.getStringChecksum(cdf.getChecksum());
    }

    public static String getStringChecksum(long checksumType) {
        String cType = null;
        cType = checksumType == 0L ? "NONE" : (checksumType == 1L ? "MD5" : "OTHER");
        return cType;
    }

    public static long getLongSparseRecord(String sparseRecordType) {
        long sType = sparseRecordType.equalsIgnoreCase("None") ? 0L : (sparseRecordType.equalsIgnoreCase("sRecords.PAD") || sparseRecordType.equalsIgnoreCase("PAD") ? 1L : (sparseRecordType.equalsIgnoreCase("sRecords.PREV") || sparseRecordType.equalsIgnoreCase("PREV") ? 2L : -1L));
        return sType;
    }

    public static String getStringSparseRecord(Variable var) {
        return CDFUtils.getStringSparseRecord(var.getSparseRecords());
    }

    public static boolean cdfFileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        String file1 = null;
        String file2 = null;
        if (fileName.indexOf(".cdf") == -1 && fileName.indexOf(".CDF") == -1) {
            file1 = new StringBuffer(fileName).append(".cdf").toString();
            file2 = new StringBuffer(fileName).append(".CDF").toString();
        } else {
            file1 = fileName;
        }
        File cdfFile = new File(file1);
        if (cdfFile.exists()) {
            return true;
        }
        return file2 != null && (cdfFile = new File(file2)).exists();
    }
}

