/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf.util;

import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;

public class Epoch
implements CDFConstants {
    private static double MAX_EPOCH_BINARY = 3.15569519999998E14;
    private static int MAX_ePART_LEN = 25;
    private static String[] _monthToken = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static double parse(String inString) throws CDFException {
        long year = 0L;
        long month = 0L;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        long msec = 0L;
        try {
            StringTokenizer st = new StringTokenizer(inString, " ");
            String date = st.nextToken();
            String time = st.nextToken();
            st = new StringTokenizer(date, "-");
            day = Long.parseLong(st.nextToken());
            String monthStr = st.nextToken();
            year = Long.parseLong(st.nextToken());
            for (int monthX = 1; monthX <= 12; ++monthX) {
                if (!monthStr.equals(_monthToken[monthX - 1])) continue;
                month = monthX;
                break;
            }
            if (month == 0L) {
                throw new CDFException(-2224L);
            }
            st = new StringTokenizer(time, ":");
            hour = Long.parseLong(st.nextToken());
            minute = Long.parseLong(st.nextToken());
            String secondStr = st.nextToken();
            st = new StringTokenizer(secondStr, ".");
            second = Long.parseLong(st.nextToken());
            msec = Long.parseLong(st.nextToken());
            return Epoch.compute(year, month, day, hour, minute, second, msec);
        }
        catch (Exception e) {
            throw new CDFException(-2224L);
        }
    }

    public static double parse1(String inString) throws CDFException {
        StringTokenizer st = new StringTokenizer(inString, ".");
        String date = st.nextToken();
        String time = st.nextToken();
        long year = 0L;
        long month = 0L;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        long msec = 0L;
        long fractionL = 0L;
        double fraction = 0.0;
        try {
            year = Long.parseLong(date.substring(0, 4));
            month = Long.parseLong(date.substring(4, 6));
            day = Long.parseLong(date.substring(6));
            fractionL = Long.parseLong(time);
            fraction = (double)fractionL / 1.0E7;
            hour = (long)(fraction * 24.0);
            minute = (long)((fraction -= (double)hour / 24.0) * 1440.0);
            second = (long)((fraction -= (double)minute / 1440.0) * 86400.0);
            msec = (long)((fraction -= (double)second / 86400.0) * 8.64E7);
            return Epoch.compute(year, month, day, hour, minute, second, msec);
        }
        catch (NumberFormatException e) {
            throw new CDFException(-2224L);
        }
    }

    public static double parse2(String inString) throws CDFException {
        long year = 0L;
        long month = 0L;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        try {
            year = Long.parseLong(inString.substring(0, 4));
            month = Long.parseLong(inString.substring(4, 6));
            day = Long.parseLong(inString.substring(6, 8));
            hour = Long.parseLong(inString.substring(8, 10));
            minute = Long.parseLong(inString.substring(10, 12));
            second = Long.parseLong(inString.substring(12));
            return Epoch.compute(year, month, day, hour, minute, second, 0L);
        }
        catch (NumberFormatException e) {
            throw new CDFException(-2224L);
        }
    }

    public static double parse3(String inString) throws CDFException {
        long year = 0L;
        long month = 0L;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        long msec = 0L;
        try {
            StringTokenizer st = new StringTokenizer(inString, "T");
            String date = st.nextToken();
            String tt = st.nextToken();
            String time = tt.substring(0, tt.length() - 1);
            st = new StringTokenizer(date, "-");
            year = Long.parseLong(st.nextToken());
            month = Long.parseLong(st.nextToken());
            day = Long.parseLong(st.nextToken());
            st = new StringTokenizer(time, ":");
            hour = Long.parseLong(st.nextToken());
            minute = Long.parseLong(st.nextToken());
            String secondStr = st.nextToken();
            st = new StringTokenizer(secondStr, ".");
            second = Long.parseLong(st.nextToken());
            msec = Long.parseLong(st.nextToken());
            return Epoch.compute(year, month, day, hour, minute, second, msec);
        }
        catch (Exception e) {
            throw new CDFException(-2224L);
        }
    }

    public static String encode(double epoch) {
        if (epoch == -1.0E31) {
            return "31-Dec-9999 23:59:59.999";
        }
        return Epoch.encodex(epoch, "<dom.02>-<month>-<year> <hour>:<min>:<sec>.<fos>");
    }

    public static String encode1(double epoch) {
        if (epoch == -1.0E31) {
            return "99991231.9999999";
        }
        return Epoch.encodex(epoch, "<year><mm.02><dom.02>.<fod.7>");
    }

    public static String encode2(double epoch) {
        if (epoch == -1.0E31) {
            return "99991231235959";
        }
        return Epoch.encodex(epoch, "<year><mm.02><dom.02><hour><min><sec>");
    }

    public static String encode3(double epoch) {
        if (epoch == -1.0E31) {
            return "9999-12-31T23:59:59.999Z";
        }
        return Epoch.encodex(epoch, "<year>-<mm.02>-<dom.02>T<hour>:<min>:<sec>.<fos>Z");
    }

    public static String encodex(double epoch, String formatString) {
        StringBuffer encoded = new StringBuffer();
        StringBuffer part = new StringBuffer();
        StringBuffer mod = new StringBuffer();
        int ptr = 0;
        long[] components = new long[7];
        if (formatString == null || formatString.equals("")) {
            return Epoch.encode(epoch);
        }
        char[] format = formatString.toCharArray();
        components = Epoch.breakdown(epoch);
        for (ptr = 0; ptr < format.length; ++ptr) {
            if (format[ptr] == '<') {
                int p;
                if (format[ptr + 1] == '<') {
                    encoded.append("<");
                    System.out.println("append a literal \"<\"");
                    continue;
                }
                int ptrE = formatString.indexOf(62, ptr + 1);
                if (ptrE == -1) {
                    encoded.append("?");
                    System.out.println("appending ? (1)");
                    return encoded.toString();
                }
                part.setLength(0);
                for (p = ptr + 1; p != ptrE; ++p) {
                    part.append(format[p]);
                }
                int ptrD = formatString.indexOf(".", ptr + 1);
                mod = new StringBuffer();
                if (ptrD != -1 && ptrD < ptrE) {
                    for (p = ptrD + 1; p != ptrE; ++p) {
                        mod.append(format[p]);
                    }
                }
                ptr = ptrE;
                String sPart = part.toString();
                if (sPart.indexOf("dom") == 0) {
                    Epoch.appendIntegerPart(encoded, components[2], 0, false, mod.toString());
                    continue;
                }
                if (sPart.indexOf("doy") == 0) {
                    long doy = Epoch.JulianDay(components[0], components[1], components[2]) - Epoch.JulianDay(components[0], 1L, 1L) + 1L;
                    Epoch.appendIntegerPart(encoded, doy, 3, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("month") == 0) {
                    encoded.append(_monthToken[(int)components[1] - 1]);
                    continue;
                }
                if (sPart.indexOf("mm") == 0) {
                    Epoch.appendIntegerPart(encoded, components[1], 0, false, mod.toString());
                    continue;
                }
                if (sPart.indexOf("year") == 0) {
                    Epoch.appendIntegerPart(encoded, components[0], 4, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("yr") == 0) {
                    long yr = components[0] % 100L;
                    Epoch.appendIntegerPart(encoded, yr, 2, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("hour") == 0) {
                    Epoch.appendIntegerPart(encoded, components[3], 2, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("min") == 0) {
                    Epoch.appendIntegerPart(encoded, components[4], 2, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("sec") == 0) {
                    Epoch.appendIntegerPart(encoded, components[5], 2, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("fos") == 0) {
                    double fos = (double)components[6] / 1000.0;
                    Epoch.appendFractionPart(encoded, fos, 3, mod.toString());
                    continue;
                }
                if (sPart.indexOf("fod") == 0) {
                    double fod = (double)components[3] / 24.0 + (double)components[4] / 1440.0 + (double)components[5] / 86400.0 + (double)components[6] / 8.64E7;
                    Epoch.appendFractionPart(encoded, fod, 8, mod.toString());
                    continue;
                }
                encoded.append("?");
                System.out.println("append ? (2)");
                continue;
            }
            if (ptr >= format.length) break;
            encoded.append(format[ptr]);
        }
        return encoded.toString();
    }

    private static void appendFractionPart(StringBuffer encoded, double fraction, int defaultWidth, String modifier) {
        int i;
        int width;
        StringBuffer format;
        StringBuffer ePart;
        block8: {
            ePart = new StringBuffer(MAX_ePART_LEN + 1);
            NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
            format = new StringBuffer();
            nf.setParseIntegerOnly(true);
            if (!modifier.equals("")) {
                try {
                    width = nf.parse(modifier).intValue();
                    if (width < 1) {
                        encoded.append("?");
                        System.out.println("append ? (3)");
                        return;
                    }
                    break block8;
                }
                catch (ParseException e) {
                    encoded.append("?");
                    System.out.println("append ? (4)");
                    return;
                }
            }
            width = defaultWidth;
        }
        for (i = 0; i < width + 2; ++i) {
            format.append("0");
        }
        format.append(".");
        for (i = 0; i < width; ++i) {
            format.append("0");
        }
        DecimalFormat df = new DecimalFormat(format.toString());
        ePart.append(df.format(fraction));
        if (ePart.charAt(0) == '1') {
            for (i = 0; i < width; ++i) {
                ePart.setCharAt(i + 2, '9');
            }
        }
        String ePartStr = ePart.toString();
        char sp = new DecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
        Epoch.appendPart(encoded, ePartStr.substring(ePartStr.indexOf(sp) + 1), width, false);
    }

    private static void appendIntegerPart(StringBuffer encoded, long integer, int defaultWidth, boolean defaultLeading0, String modifier) {
        boolean leading0;
        int width;
        StringBuffer ePart = new StringBuffer(MAX_ePART_LEN + 1);
        char[] modArray = modifier.toCharArray();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setParseIntegerOnly(true);
        if (!modifier.equals("")) {
            try {
                width = nf.parse(modifier).intValue();
                if (width < 0) {
                    encoded.append("?");
                    System.out.println("append ? (5)");
                    return;
                }
                leading0 = modArray[0] == '0';
            }
            catch (ParseException e) {
                encoded.append("?");
                System.out.println("append ? (6)");
                return;
            }
        } else {
            width = defaultWidth;
            leading0 = defaultLeading0;
        }
        ePart.append("" + integer);
        Epoch.appendPart(encoded, ePart.toString(), width, leading0);
    }

    private static void appendPart(StringBuffer encoded, String ePart, int width, boolean leading0) {
        if (width == 0) {
            encoded.append(ePart);
        } else {
            int length = ePart.length();
            if (length > width) {
                for (int i = 0; i < width; ++i) {
                    encoded.append("*");
                }
            } else {
                int pad = width - length;
                if (pad > 0) {
                    for (int i = 0; i < pad; ++i) {
                        encoded.append(leading0 ? "0" : " ");
                    }
                }
                encoded.append(ePart);
            }
        }
    }

    public static double compute(long year, long month, long day, long hour, long minute, long second, long msec) throws CDFException {
        long msecInDay;
        long daysSince0AD;
        if (year == 9999L && month == 12L && day == 31L && hour == 23L && minute == 59L && second == 59L && msec == 999L) {
            return -1.0E31;
        }
        if (year < 0L || year > 9999L) {
            throw new CDFException(-2224L);
        }
        if (month < 0L || month > 12L) {
            throw new CDFException(-2224L);
        }
        if (month == 0L) {
            if (day < 1L || day > 366L) {
                throw new CDFException(-2224L);
            }
            daysSince0AD = Epoch.JulianDay(year, 1L, 1L) + (day - 1L) - 1721060L;
        } else {
            if (day < 1L || day > 31L) {
                throw new CDFException(-2224L);
            }
            daysSince0AD = Epoch.JulianDay(year, month, day) - 1721060L;
        }
        if (hour == 0L && minute == 0L && second == 0L) {
            if (msec < 0L || msec > 86399999L) {
                throw new CDFException(-2224L);
            }
            msecInDay = msec;
        } else {
            if (hour < 0L || hour > 23L) {
                throw new CDFException(-2224L);
            }
            if (minute < 0L || minute > 59L) {
                throw new CDFException(-2224L);
            }
            if (second < 0L || second > 59L) {
                throw new CDFException(-2224L);
            }
            if (msec < 0L || msec > 999L) {
                throw new CDFException(-2224L);
            }
            msecInDay = 3600000L * hour + 60000L * minute + 1000L * second + msec;
        }
        return 8.64E7 * (double)daysSince0AD + (double)msecInDay;
    }

    public static long[] breakdown(double epoch) {
        long[] components = new long[7];
        if (epoch == -1.0E31) {
            components[0] = 9999L;
            components[1] = 12L;
            components[2] = 31L;
            components[3] = 23L;
            components[4] = 59L;
            components[5] = 59L;
            components[6] = 999L;
            return components;
        }
        if (epoch < 0.0) {
            epoch = -epoch;
        }
        double msec_AD = epoch = MAX_EPOCH_BINARY < epoch ? MAX_EPOCH_BINARY : epoch;
        double second_AD = msec_AD / 1000.0;
        double minute_AD = second_AD / 60.0;
        double hour_AD = minute_AD / 60.0;
        double day_AD = hour_AD / 24.0;
        long jd = (long)(1721060.0 + day_AD);
        long l = jd + 68569L;
        long n = 4L * l / 146097L;
        long i = 4000L * ((l -= (146097L * n + 3L) / 4L) + 1L) / 1461001L;
        l = l - 1461L * i / 4L + 31L;
        long j = 80L * l / 2447L;
        long k = l - 2447L * j / 80L;
        l = j / 11L;
        j = j + 2L - 12L * l;
        components[0] = i = 100L * (n - 49L) + i + l;
        components[1] = j;
        components[2] = k;
        components[3] = (long)(hour_AD % 24.0);
        components[4] = (long)(minute_AD % 60.0);
        components[5] = (long)(second_AD % 60.0);
        components[6] = (long)(msec_AD % 1000.0);
        return components;
    }

    private static long JulianDay(long y, long m, long d) {
        return 367L * y - 7L * (y + (m + 9L) / 12L) / 4L - 3L * ((y + (m - 9L) / 7L) / 100L + 1L) / 4L + 275L * m / 9L + d + 1721029L;
    }
}

