/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf.util;

import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;

public class Epoch16
implements CDFConstants {
    private static double MAX_EPOCH16_1_BINARY = 3.15569519999E11;
    private static double MAX_EPOCH16_2_BINARY = 9.99999999998E11;
    private static int MAX_ePART_LEN = 25;
    private static String[] _monthToken = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static Object parse(String inString) throws CDFException {
        long year = 0L;
        long month = 0L;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        long msec = 0L;
        long usec = 0L;
        long nsec = 0L;
        long psec = 0L;
        double[] epoch16 = new double[2];
        try {
            double mmm;
            StringTokenizer st = new StringTokenizer(inString, " ");
            String date = st.nextToken();
            String time = st.nextToken();
            st = new StringTokenizer(date, "-");
            day = Long.parseLong(st.nextToken());
            String monthStr = st.nextToken();
            year = Long.parseLong(st.nextToken());
            for (int monthX = 1; monthX <= 12; ++monthX) {
                if (!monthStr.equals(_monthToken[monthX - 1])) continue;
                month = monthX;
                break;
            }
            if (month == 0L) {
                throw new CDFException(-2224L);
            }
            st = new StringTokenizer(time, ":");
            hour = Long.parseLong(st.nextToken());
            minute = Long.parseLong(st.nextToken());
            String secondStr = st.nextToken();
            if ((st = new StringTokenizer(secondStr, ".")).hasMoreElements()) {
                second = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreElements()) {
                msec = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreElements()) {
                usec = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreElements()) {
                nsec = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreElements()) {
                psec = Long.parseLong(st.nextToken());
            }
            if ((mmm = Epoch16.compute(year, month, day, hour, minute, second, msec, usec, nsec, psec, epoch16)) == -1.0) {
                throw new CDFException(-2224L);
            }
            return epoch16;
        }
        catch (Exception e) {
            throw new CDFException(-2224L);
        }
    }

    public static Object parse1(String inString) throws CDFException {
        StringTokenizer st = new StringTokenizer(inString, ".");
        String date = st.nextToken();
        String time = st.nextToken();
        long year = 0L;
        long month = 0L;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        long msec = 0L;
        long usec = 0L;
        long nsec = 0L;
        long psec = 0L;
        long fractionL = 0L;
        double fraction = 0.0;
        double[] epoch16 = new double[2];
        try {
            year = Long.parseLong(date.substring(0, 4));
            month = Long.parseLong(date.substring(4, 6));
            day = Long.parseLong(date.substring(6));
            fractionL = Long.parseLong(time);
            int len = time.length();
            fraction = (double)fractionL / Math.pow(10.0, len);
            hour = (long)(fraction * 24.0);
            minute = (long)((fraction -= (double)hour / 24.0) * 1440.0);
            second = (long)((fraction -= (double)minute / 1440.0) * 86400.0);
            msec = (long)((fraction -= (double)second / 86400.0) * 86400.0 * Math.pow(10.0, 3.0));
            usec = (long)((fraction -= (double)msec / (86400.0 * Math.pow(10.0, 3.0))) * 86400.0 * Math.pow(10.0, 6.0));
            nsec = (long)((fraction -= (double)usec / (86400.0 * Math.pow(10.0, 6.0))) * 86400.0 * Math.pow(10.0, 9.0));
            psec = (long)((fraction -= (double)nsec / (86400.0 * Math.pow(10.0, 9.0))) * 86400.0 * Math.pow(10.0, 12.0));
            double mmm = Epoch16.compute(year, month, day, hour, minute, second, msec, usec, nsec, psec, epoch16);
            if (mmm == -1.0) {
                throw new CDFException(-2224L);
            }
            return epoch16;
        }
        catch (NumberFormatException e) {
            throw new CDFException(-2224L);
        }
    }

    public static Object parse2(String inString) throws CDFException {
        long year = 0L;
        long month = 0L;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        double[] epoch16 = new double[2];
        try {
            year = Long.parseLong(inString.substring(0, 4));
            month = Long.parseLong(inString.substring(4, 6));
            day = Long.parseLong(inString.substring(6, 8));
            hour = Long.parseLong(inString.substring(8, 10));
            minute = Long.parseLong(inString.substring(10, 12));
            second = Long.parseLong(inString.substring(12));
            double mmm = Epoch16.compute(year, month, day, hour, minute, second, 0L, 0L, 0L, 0L, epoch16);
            if (mmm == -1.0) {
                throw new CDFException(-2224L);
            }
            return epoch16;
        }
        catch (NumberFormatException e) {
            throw new CDFException(-2224L);
        }
    }

    public static Object parse3(String inString) throws CDFException {
        long year = 0L;
        long month = 0L;
        long day = 0L;
        long hour = 0L;
        long minute = 0L;
        long second = 0L;
        long msec = 0L;
        long usec = 0L;
        long nsec = 0L;
        long psec = 0L;
        double[] epoch16 = new double[2];
        try {
            double mmm;
            StringTokenizer st = new StringTokenizer(inString, "T");
            String date = st.nextToken();
            String tt = st.nextToken();
            String time = tt.substring(0, tt.length() - 1);
            st = new StringTokenizer(date, "-");
            year = Long.parseLong(st.nextToken());
            month = Long.parseLong(st.nextToken());
            day = Long.parseLong(st.nextToken());
            st = new StringTokenizer(time, ":");
            hour = Long.parseLong(st.nextToken());
            minute = Long.parseLong(st.nextToken());
            String secondStr = st.nextToken();
            st = new StringTokenizer(secondStr, ".");
            second = Long.parseLong(st.nextToken());
            if (st.hasMoreTokens()) {
                msec = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                usec = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                nsec = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                psec = Long.parseLong(st.nextToken());
            }
            if ((mmm = Epoch16.compute(year, month, day, hour, minute, second, msec, usec, nsec, psec, epoch16)) == -1.0) {
                throw new CDFException(-2224L);
            }
            return epoch16;
        }
        catch (Exception e) {
            throw new CDFException(-2224L);
        }
    }

    public static String encode(Object epoch) {
        double[] epoch16 = new double[2];
        String epString1 = new String();
        String epString2 = new String();
        epoch16[0] = ((double[])epoch)[0];
        epoch16[1] = ((double[])epoch)[1];
        if (epoch16[0] == -1.0E31 && epoch16[1] == -1.0E31) {
            return "31-Dec-9999 23:59:59.999.999.999.999";
        }
        epString1 = Epoch16.encodex(epoch16, "<dom.02>-<month>-<year> <hour>:<min>:<sec>.<fos>");
        int ix = epString1.indexOf(".") + 1;
        epString2 = Epoch16.encode_2(epoch16[1]);
        return new StringBuffer(epString1.substring(0, ix)).append(epString2).toString();
    }

    public static String encode1(Object epoch) {
        double[] epoch16 = new double[]{((double[])epoch)[0], ((double[])epoch)[1]};
        if (epoch16[0] == -1.0E31 && epoch16[1] == -1.0E31) {
            return "99991231.999999999999999";
        }
        return Epoch16.encodex(epoch16, "<year><mm.02><dom.02>.<fod.15>");
    }

    public static String encode2(Object epoch) {
        double[] epoch16 = new double[]{((double[])epoch)[0], ((double[])epoch)[1]};
        if (epoch16[0] == -1.0E31 && epoch16[1] == -1.0E31) {
            return "99991231235959";
        }
        return Epoch16.encodex(epoch16, "<year><mm.02><dom.02><hour><min><sec>");
    }

    public static String encode3(Object epoch) {
        double[] epoch16 = new double[]{((double[])epoch)[0], ((double[])epoch)[1]};
        if (epoch16[0] == -1.0E31 && epoch16[1] == -1.0E31) {
            return "9999-12-31T23:59:59.999.999.999.999Z";
        }
        return Epoch16.encodex(epoch16, "<year>-<mm.02>-<dom.02>T<hour>:<min>:<sec>.<fos>Z");
    }

    public static String encodex(Object epoch, String formatString) {
        StringBuffer encoded = new StringBuffer();
        StringBuffer part = new StringBuffer();
        StringBuffer mod = new StringBuffer();
        int ptr = 0;
        long[] components = new long[10];
        double[] epoch16 = new double[]{((double[])epoch)[0], ((double[])epoch)[1]};
        if (formatString == null || formatString.equals("")) {
            return Epoch16.encode(epoch16);
        }
        char[] format = formatString.toCharArray();
        components = Epoch16.breakdown(epoch16);
        for (ptr = 0; ptr < format.length; ++ptr) {
            if (format[ptr] == '<') {
                int p;
                if (format[ptr + 1] == '<') {
                    encoded.append("<");
                    System.out.println("append a literal \"<\"");
                    continue;
                }
                int ptrE = formatString.indexOf(62, ptr + 1);
                if (ptrE == -1) {
                    encoded.append("?");
                    System.out.println("appending ? (1)");
                    return encoded.toString();
                }
                part.setLength(0);
                for (p = ptr + 1; p != ptrE; ++p) {
                    part.append(format[p]);
                }
                int ptrD = formatString.indexOf(".", ptr + 1);
                mod = new StringBuffer();
                if (ptrD != -1 && ptrD < ptrE) {
                    for (p = ptrD + 1; p != ptrE; ++p) {
                        mod.append(format[p]);
                    }
                }
                ptr = ptrE;
                String sPart = part.toString();
                if (sPart.indexOf("dom") == 0) {
                    Epoch16.appendIntegerPart(encoded, components[2], 0, false, mod.toString());
                    continue;
                }
                if (sPart.indexOf("doy") == 0) {
                    long doy = Epoch16.JulianDay(components[0], components[1], components[2]) - Epoch16.JulianDay(components[0], 1L, 1L) + 1L;
                    Epoch16.appendIntegerPart(encoded, doy, 3, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("month") == 0) {
                    encoded.append(_monthToken[(int)components[1] - 1]);
                    continue;
                }
                if (sPart.indexOf("mm") == 0) {
                    Epoch16.appendIntegerPart(encoded, components[1], 0, false, mod.toString());
                    continue;
                }
                if (sPart.indexOf("year") == 0) {
                    Epoch16.appendIntegerPart(encoded, components[0], 4, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("yr") == 0) {
                    long yr = components[0] % 100L;
                    Epoch16.appendIntegerPart(encoded, yr, 2, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("hour") == 0) {
                    Epoch16.appendIntegerPart(encoded, components[3], 2, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("min") == 0) {
                    Epoch16.appendIntegerPart(encoded, components[4], 2, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("sec") == 0) {
                    Epoch16.appendIntegerPart(encoded, components[5], 2, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("fos") == 0) {
                    double fos = (double)components[6] / 1000.0;
                    Epoch16.appendFractionPart(encoded, fos, 3, mod.toString());
                    encoded.append(".");
                    Epoch16.appendIntegerPart(encoded, components[7], 3, true, mod.toString());
                    encoded.append(".");
                    Epoch16.appendIntegerPart(encoded, components[8], 3, true, mod.toString());
                    encoded.append(".");
                    Epoch16.appendIntegerPart(encoded, components[9], 3, true, mod.toString());
                    continue;
                }
                if (sPart.indexOf("fod") == 0) {
                    double fod = (double)components[3] / 24.0 + (double)components[4] / 1440.0 + (double)components[5] / 86400.0 + (double)components[6] / 8.64E7 + (double)components[7] / 8.64E10 + (double)components[8] / 8.64E13 + (double)components[9] / 8.64E16;
                    Epoch16.appendFractionPart(encoded, fod, 15, mod.toString());
                    continue;
                }
                encoded.append("?");
                System.out.println("append ? (2)");
                continue;
            }
            if (ptr >= format.length) break;
            encoded.append(format[ptr]);
        }
        return encoded.toString();
    }

    private static void appendFractionPart(StringBuffer encoded, double fraction, int defaultWidth, String modifier) {
        int i;
        int width;
        StringBuffer format;
        StringBuffer ePart;
        block8: {
            ePart = new StringBuffer(MAX_ePART_LEN + 1);
            NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
            format = new StringBuffer();
            nf.setParseIntegerOnly(true);
            if (!modifier.equals("")) {
                try {
                    width = nf.parse(modifier).intValue();
                    if (width < 1) {
                        encoded.append("?");
                        System.out.println("append ? (3)");
                        return;
                    }
                    break block8;
                }
                catch (ParseException e) {
                    encoded.append("?");
                    System.out.println("append ? (4)");
                    return;
                }
            }
            width = defaultWidth;
        }
        for (i = 0; i < width + 2; ++i) {
            format.append("0");
        }
        format.append(".");
        for (i = 0; i < width; ++i) {
            format.append("0");
        }
        DecimalFormat df = new DecimalFormat(format.toString());
        ePart.append(df.format(fraction));
        if (ePart.charAt(0) == '1') {
            for (i = 0; i < width; ++i) {
                ePart.setCharAt(i + 2, '9');
            }
        }
        String ePartStr = ePart.toString();
        char sp = new DecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
        Epoch16.appendPart(encoded, ePartStr.substring(ePartStr.indexOf(sp) + 1), width, false);
    }

    private static void appendIntegerPart(StringBuffer encoded, long integer, int defaultWidth, boolean defaultLeading0, String modifier) {
        boolean leading0;
        int width;
        StringBuffer ePart = new StringBuffer(MAX_ePART_LEN + 1);
        char[] modArray = modifier.toCharArray();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setParseIntegerOnly(true);
        if (!modifier.equals("")) {
            try {
                width = nf.parse(modifier).intValue();
                if (width < 0) {
                    encoded.append("?");
                    System.out.println("append ? (5)");
                    return;
                }
                leading0 = modArray[0] == '0';
            }
            catch (ParseException e) {
                encoded.append("?");
                System.out.println("append ? (6)");
                return;
            }
        } else {
            width = defaultWidth;
            leading0 = defaultLeading0;
        }
        ePart.append("" + integer);
        Epoch16.appendPart(encoded, ePart.toString(), width, leading0);
    }

    private static void appendPart(StringBuffer encoded, String ePart, int width, boolean leading0) {
        if (width == 0) {
            encoded.append(ePart);
        } else {
            int length = ePart.length();
            if (length > width) {
                for (int i = 0; i < width; ++i) {
                    encoded.append("*");
                }
            } else {
                int pad = width - length;
                if (pad > 0) {
                    for (int i = 0; i < pad; ++i) {
                        encoded.append(leading0 ? "0" : " ");
                    }
                }
                encoded.append(ePart);
            }
        }
    }

    public static double compute(long year, long month, long day, long hour, long minute, long second, long msec, long usec, long nsec, long psec, Object epoch) throws CDFException {
        long daysSince0AD;
        double[] epoch16 = new double[2];
        if (year == 9999L && month == 12L && day == 31L && hour == 23L && minute == 59L && second == 59L && msec == 999L && usec == 999L && nsec == 999L && psec == 999L) {
            ((double[])epoch)[0] = -1.0E31;
            ((double[])epoch)[1] = -1.0E31;
            return 0.0;
        }
        if (year < 0L || year > 9999L) {
            throw new CDFException(-2224L);
        }
        if (month < 0L || month > 12L) {
            throw new CDFException(-2224L);
        }
        if (month == 0L) {
            if (day < 1L || day > 366L) {
                throw new CDFException(-2224L);
            }
            daysSince0AD = Epoch16.JulianDay(year, 1L, 1L) + (day - 1L) - 1721060L;
        } else {
            if (day < 1L || day > 31L) {
                throw new CDFException(-2224L);
            }
            daysSince0AD = Epoch16.JulianDay(year, month, day) - 1721060L;
        }
        if (hour < 0L || hour > 23L) {
            throw new CDFException(-2224L);
        }
        if (minute < 0L || minute > 59L) {
            throw new CDFException(-2224L);
        }
        if (second < 0L || second > 59L) {
            throw new CDFException(-2224L);
        }
        if (msec < 0L || msec > 999L) {
            throw new CDFException(-2224L);
        }
        if (usec < 0L || usec > 999L) {
            throw new CDFException(-2224L);
        }
        if (nsec < 0L || nsec > 999L) {
            throw new CDFException(-2224L);
        }
        if (psec < 0L || psec > 999L) {
            throw new CDFException(-2224L);
        }
        long secInDay = 3600L * hour + 60L * minute + second;
        epoch16[0] = 86400.0 * (double)daysSince0AD + (double)secInDay;
        epoch16[1] = (double)psec + (double)nsec * Math.pow(10.0, 3.0) + (double)usec * Math.pow(10.0, 6.0) + (double)msec * Math.pow(10.0, 9.0);
        ((double[])epoch)[0] = epoch16[0];
        ((double[])epoch)[1] = epoch16[1];
        return 0.0;
    }

    public static long[] breakdown(Object epoch) {
        long[] components = new long[10];
        double[] epoch16 = new double[]{((double[])epoch)[0], ((double[])epoch)[1]};
        if (epoch16[0] == -1.0E31 && epoch16[1] == -1.0E31) {
            components[0] = 9999L;
            components[1] = 12L;
            components[2] = 31L;
            components[3] = 23L;
            components[4] = 59L;
            components[5] = 59L;
            components[6] = 999L;
            components[7] = 999L;
            components[8] = 999L;
            components[9] = 999L;
            return components;
        }
        if (epoch16[0] < 0.0) {
            epoch16[0] = -epoch16[0];
        }
        if (epoch16[1] < 0.0) {
            epoch16[1] = -epoch16[1];
        }
        double d = epoch16[0] = MAX_EPOCH16_1_BINARY < epoch16[0] ? MAX_EPOCH16_1_BINARY : epoch16[0];
        epoch16[1] = epoch16[0] == MAX_EPOCH16_1_BINARY ? (MAX_EPOCH16_2_BINARY < epoch16[1] ? MAX_EPOCH16_2_BINARY : epoch16[1]) : (MAX_EPOCH16_2_BINARY + 1.0 < epoch16[1] ? MAX_EPOCH16_2_BINARY + 1.0 : epoch16[1]);
        double second_AD = epoch16[0];
        double minute_AD = second_AD / 60.0;
        double hour_AD = minute_AD / 60.0;
        double day_AD = hour_AD / 24.0;
        long jd = (long)(1721060.0 + day_AD);
        long l = jd + 68569L;
        long n = 4L * l / 146097L;
        long i = 4000L * ((l -= (146097L * n + 3L) / 4L) + 1L) / 1461001L;
        l = l - 1461L * i / 4L + 31L;
        long j = 80L * l / 2447L;
        long k = l - 2447L * j / 80L;
        l = j / 11L;
        j = j + 2L - 12L * l;
        components[0] = i = 100L * (n - 49L) + i + l;
        components[1] = j;
        components[2] = k;
        components[3] = (long)(hour_AD % 24.0);
        components[4] = (long)(minute_AD % 60.0);
        components[5] = (long)(second_AD % 60.0);
        double msec = epoch16[1];
        components[9] = (long)(msec % 1000.0);
        components[8] = (long)((msec /= 1000.0) % 1000.0);
        components[7] = (long)((msec /= 1000.0) % 1000.0);
        components[6] = (long)(msec /= 1000.0);
        return components;
    }

    private static long JulianDay(long y, long m, long d) {
        return 367L * y - 7L * (y + (m + 9L) / 12L) / 4L - 3L * ((y + (m - 9L) / 7L) / 100L + 1L) / 4L + 275L * m / 9L + d + 1721029L;
    }

    private static String encode_2(double epoch) {
        StringBuffer encoded = new StringBuffer();
        StringBuffer fracString = new StringBuffer();
        long psec = (long)(epoch % 1000.0);
        double mmm = epoch / 1000.0;
        long nsec = (long)(mmm % 1000.0);
        long usec = (long)((mmm /= 1000.0) % 1000.0);
        long msec = (long)(mmm / 1000.0);
        Epoch16.appendIntegerPart(encoded, msec, 3, true, "");
        fracString.append(encoded).append(".");
        encoded.setLength(0);
        Epoch16.appendIntegerPart(encoded, usec, 3, true, "");
        fracString.append(encoded).append(".");
        encoded.setLength(0);
        Epoch16.appendIntegerPart(encoded, nsec, 3, true, "");
        fracString.append(encoded).append(".");
        encoded.setLength(0);
        Epoch16.appendIntegerPart(encoded, psec, 3, true, "");
        fracString.append(encoded);
        return fracString.toString();
    }
}

