/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datasource;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.client.DasServer;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Das2ServerDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private String DEFAULT_TIMERANGE = "2001-01-01";
    public JTextArea ReaderParamsTextArea;
    public JLabel descriptionLabel;
    public JCheckBox discoveryCb;
    public JComboBox examplesComboBox;
    public JComboBox jComboBox1;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JLabel jLabel6;
    public JLabel jLabel7;
    public JScrollPane jScrollPane1;
    public JScrollPane jScrollPane2;
    public JTree jTree1;
    public JTextField tcaItem;
    public JTextField tcaTextField;
    public JTextField timeRangeTextField;
    public JLabel validRangeLabel;
    public JButton viewDsdfButton;
    protected String serverURL = null;
    public static final String PROP_SERVERURL = "serverURL";
    protected String dataSetId = null;
    public static final String PROP_DATASETID = "dataSetId";

    public Das2ServerDataSourceEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jLabel2 = new JLabel();
        this.timeRangeTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.ReaderParamsTextArea = new JTextArea();
        this.jLabel5 = new JLabel();
        this.tcaTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.tcaItem = new JTextField();
        this.viewDsdfButton = new JButton();
        this.validRangeLabel = new JLabel();
        this.discoveryCb = new JCheckBox();
        this.examplesComboBox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.descriptionLabel = new JLabel();
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"http://www-pw.physics.uiowa.edu/das/das2Server", "http://cassini.physics.uiowa.edu/das/das2Server"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Das2 Server URL:");
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Loading DataSets List...");
        this.jTree1.setModel(new DefaultTreeModel(treeNode1));
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jLabel2.setText("Data Set Id:");
        this.timeRangeTextField.setText("2000-01-01");
        this.jLabel3.setText("Time Range:");
        this.jLabel4.setText("Reader Parameters:");
        this.ReaderParamsTextArea.setColumns(20);
        this.ReaderParamsTextArea.setRows(5);
        this.jScrollPane2.setViewportView(this.ReaderParamsTextArea);
        this.jLabel5.setText("TCA Interval (sec):");
        this.jLabel5.setToolTipText("<html>\nInterval (in seconds) to use for TCA (ephemeris) data.<br>\nLeave blank for most datasets.<br>\n</html>\n");
        this.tcaTextField.setText(" ");
        this.tcaTextField.setToolTipText("<html> Interval (in seconds) to use for TCA (ephemeris) data.<br> Leave blank for most datasets.<br> </html> ");
        this.jLabel6.setText("TCA Item:");
        this.jLabel6.setToolTipText("The optional item number for TCAs.");
        this.tcaItem.setToolTipText("The optional item number for TCAs.");
        this.viewDsdfButton.setText("View DSDF");
        this.viewDsdfButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.viewDsdfButtonActionPerformed(evt);
            }
        });
        this.validRangeLabel.setFont(new Font("DejaVu LGC Sans", 0, 10));
        this.validRangeLabel.setText("<html><em>no valid range for dataset provided</em></html>");
        this.discoveryCb.setText("require example time");
        this.discoveryCb.setToolTipText("Show only datasets that have identified example times.");
        this.discoveryCb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.discoveryCbActionPerformed(evt);
            }
        });
        this.examplesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Examples", " "}));
        this.examplesComboBox.setToolTipText("Example times specified in the data set descriptor file");
        this.examplesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Das2ServerDataSourceEditorPanel.this.examplesComboBoxActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Description:");
        this.descriptionLabel.setText(" ");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(24, 24, 24).add((Component)this.jScrollPane2, -1, 400, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 412, Short.MAX_VALUE).add((Component)this.jComboBox1, 0, 412, Short.MAX_VALUE).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0, 177, Short.MAX_VALUE).add((Component)this.discoveryCb)))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.tcaTextField, -2, 70, -2).addPreferredGap(0).add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.tcaItem, -2, 42, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(33, 33, 33).add((Component)this.validRangeLabel, -1, 234, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.examplesComboBox, 0, 145, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.descriptionLabel, -1, 330, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.timeRangeTextField, -1, 238, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.viewDsdfButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBox1, -2, -1, -2).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.discoveryCb)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 94, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.descriptionLabel)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.timeRangeTextField, -2, -1, -2).add((Component)this.viewDsdfButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.validRangeLabel, -2, -1, -2).add((Component)this.examplesComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 65, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.tcaTextField, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.tcaItem, -2, -1, -2)).addContainerGap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        TreePath p = evt.getPath();
        TreeModel m = ((JTree)evt.getSource()).getModel();
        if (!m.isLeaf(p.getLastPathComponent())) {
            this.descriptionLabel.setText("");
            this.validRangeLabel.setText("<html><em>no dataset selected</em></html>");
            this.viewDsdfButton.setEnabled(false);
        } else {
            this.viewDsdfButton.setEnabled(true);
            this.validRangeLabel.setText("<html><em>retrieving dataset info...</em></html>");
            Object[] oo = p.getPath();
            String ds = String.valueOf(oo[1]);
            for (int i = 2; i < oo.length; ++i) {
                ds = ds + "/" + oo[i];
            }
            String surl = oo[0] + "?server=dsdf&dataset=" + ds;
            InputStream in = null;
            try {
                Node validRange;
                DefaultComboBoxModel<String> model;
                URL url = new URL(surl);
                in = url.openStream();
                StringBuilder sb = new StringBuilder();
                int by = in.read();
                while (by != -1) {
                    sb.append((char)by);
                    by = in.read();
                }
                in.close();
                String s = sb.toString();
                int contentLength = Integer.parseInt(s.substring(4, 10));
                String sxml = s.substring(10, 10 + contentLength);
                BufferedReader xin = new BufferedReader(new StringReader(sxml));
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                InputSource source = new InputSource(xin);
                Document document = builder.parse(source);
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                String curr = this.timeRangeTextField.getText();
                Node description = (Node)xpath.evaluate("/stream/properties/@description", document, XPathConstants.NODE);
                this.descriptionLabel.setText(description == null ? "" : description.getNodeValue());
                Node exampleRange = (Node)xpath.evaluate("/stream/properties/@exampleRange", document, XPathConstants.NODE);
                if (exampleRange != null && curr.equals(this.DEFAULT_TIMERANGE)) {
                    this.timeRangeTextField.setText(exampleRange.getNodeValue());
                }
                if (exampleRange != null) {
                    model = new DefaultComboBoxModel<String>(new String[]{"Examples", exampleRange.getNodeValue()});
                    this.examplesComboBox.setModel(model);
                    this.examplesComboBox.setEnabled(true);
                } else {
                    model = new DefaultComboBoxModel<String>(new String[]{"Examples"});
                    this.examplesComboBox.setModel(model);
                    this.examplesComboBox.setEnabled(false);
                }
                if (exampleRange == null && (exampleRange = (Node)xpath.evaluate("/stream/properties/@x_range", document, XPathConstants.NODE)) != null && curr.equals(this.DEFAULT_TIMERANGE)) {
                    this.timeRangeTextField.setText(exampleRange.getNodeValue());
                }
                if ((validRange = (Node)xpath.evaluate("/stream/properties/@validRange", document, XPathConstants.NODE)) != null) {
                    this.validRangeLabel.setText("valid range: " + validRange.getNodeValue());
                } else {
                    this.validRangeLabel.setText("<html><em>no valid range for dataset provided</em></html>");
                }
            }
            catch (XPathExpressionException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewDsdfButtonActionPerformed(ActionEvent evt) {
        TreePath p = this.jTree1.getSelectionPath();
        TreeModel m = this.jTree1.getModel();
        if (m.isLeaf(p.getLastPathComponent())) {
            InputStream in = null;
            try {
                Object[] oo = p.getPath();
                String ds = String.valueOf(oo[1]);
                for (int i = 2; i < oo.length; ++i) {
                    ds = ds + "/" + oo[i];
                }
                String surl = oo[0] + "?server=dsdf&dataset=" + ds;
                URL url = new URL(surl);
                in = url.openStream();
                StringBuilder sb = new StringBuilder();
                int by = in.read();
                while (by != -1) {
                    sb.append((char)by);
                    by = in.read();
                }
                in.close();
                String s = sb.toString();
                int contentLength = Integer.parseInt(s.substring(4, 10));
                String sxml = s.substring(10, 10 + contentLength);
                BufferedReader xin = new BufferedReader(new StringReader(sxml));
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                InputSource source = new InputSource(xin);
                Document document = builder.parse(source);
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                NodeList o = (NodeList)xpath.evaluate("/stream/properties/@*", document, XPathConstants.NODESET);
                String result = "";
                for (int ii = 0; ii < o.getLength(); ++ii) {
                    result = result + "\n" + o.item(ii).getNodeName() + "  =  " + o.item(ii).getNodeValue();
                }
                in.close();
                JTextArea area = new JTextArea();
                area.setText(result);
                area.setEditable(false);
                final JPopupMenu copyMenu = new JPopupMenu();
                copyMenu.add(new DefaultEditorKit.CopyAction()).setText("Copy");
                area.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            copyMenu.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }

                    public void mouseReleased(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            copyMenu.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                });
                JScrollPane sp = new JScrollPane(area, 20, 30);
                sp.setPreferredSize(new Dimension(480, 480));
                JOptionPane.showMessageDialog(this, sp);
            }
            catch (XPathExpressionException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.setServerURL(String.valueOf(this.jComboBox1.getSelectedItem()));
    }

    private void discoveryCbActionPerformed(ActionEvent evt) {
        this.getDataSetsRunnable().run();
    }

    private void examplesComboBoxActionPerformed(ActionEvent evt) {
        String item = (String)this.examplesComboBox.getSelectedItem();
        if (!item.equals("Examples")) {
            this.timeRangeTextField.setText(item);
        }
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        String oldServerURL = this.serverURL;
        this.serverURL = serverURL;
        new Thread(this.getDataSetsRunnable()).start();
        this.firePropertyChange(PROP_SERVERURL, oldServerURL, serverURL);
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(String dataSetId) {
        String oldDataSetId = this.dataSetId;
        this.dataSetId = dataSetId;
        this.firePropertyChange(PROP_DATASETID, oldDataSetId, dataSetId);
    }

    public JPanel getPanel() {
        return this;
    }

    public boolean reject(String uri) throws Exception {
        String s;
        URISplit split = URISplit.parse((String)uri);
        if (split.file == null || split.file.equals("file:///")) {
            split.file = "http://www-pw.physics.uiowa.edu/das/das2Server";
        }
        if ((s = split.file.toString()).equals("http://www-pw.physics.uiowa.edu/das/das2Server")) {
            return false;
        }
        URL url = new URL(s + "?server=logo");
        URLConnection connect = url.openConnection();
        try {
            InputStream in = connect.getInputStream();
            if (connect.getContentType().startsWith("image")) {
                in.close();
                return false;
            }
            in.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) {
        return true;
    }

    public void setURI(String uri) {
        String item;
        URI home = null;
        try {
            home = new URI("http://www-pw.physics.uiowa.edu/das/das2Server");
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        URISplit split = URISplit.parse((String)uri);
        if (split.file == null || split.file.equals("file:///")) {
            split.resourceUri = home;
        }
        ArrayList<URI> servers = new ArrayList<URI>();
        servers.add(home);
        try {
            servers.add(new URI("http://cassini.physics.uiowa.edu/das/das2Server"));
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!split.resourceUri.equals(home)) {
            servers.add(split.resourceUri);
        }
        this.serverURL = DataSetURI.fromUri((URI)split.resourceUri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        this.dataSetId = (String)params.remove("dataset");
        String startTime = (String)params.remove("start_time");
        String endTime = (String)params.remove("end_time");
        if (startTime != null) {
            try {
                DatumRange dr = DatumRangeUtil.parseTimeRange((String)(startTime + " to " + endTime));
                this.timeRangeTextField.setText(dr.toString());
            }
            catch (ParseException ex) {
                Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.timeRangeTextField.setText(this.DEFAULT_TIMERANGE);
        }
        String interval = (String)params.remove("interval");
        if (interval != null) {
            this.tcaTextField.setText(interval);
        }
        if ((item = (String)params.remove("item")) != null) {
            this.tcaItem.setText(item);
        }
        StringBuffer paramsStr = new StringBuffer();
        for (Map.Entry e : params.entrySet()) {
            if (((String)e.getKey()).startsWith("arg_")) {
                paramsStr.append((String)e.getValue() + "\n");
                continue;
            }
            paramsStr.append((String)e.getKey() + "=" + (String)e.getValue() + "\n");
        }
        this.ReaderParamsTextArea.setText(paramsStr.toString());
        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(servers.toArray()));
        this.jComboBox1.setSelectedItem(split.resourceUri);
        new Thread(this.getDataSetsRunnable()).start();
    }

    Runnable getDataSetsRunnable() {
        Runnable run = new Runnable(){

            public void run() {
                String ss = Das2ServerDataSourceEditorPanel.this.jComboBox1.getSelectedItem().toString();
                try {
                    DasServer server = DasServer.create((URL)new URL(ss));
                    TreeModel model = Das2ServerDataSourceEditorPanel.this.discoveryCb.isSelected() ? server.getDataSetListWithDiscovery() : server.getDataSetList();
                    Das2ServerDataSourceEditorPanel.this.jTree1.setModel(model);
                    if (Das2ServerDataSourceEditorPanel.this.dataSetId != null) {
                        Das2ServerDataSourceEditorPanel.this.selectDataSetId();
                    }
                }
                catch (DasException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Error connecting to " + ss + ", \n" + (Object)((Object)ex));
                    Das2ServerDataSourceEditorPanel.this.jTree1.setModel(new DefaultTreeModel(treeNode1));
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
                    DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)ex);
                }
            }
        };
        return run;
    }

    private void selectDataSetId() {
        String[] ss = this.dataSetId.split("/");
        Object[] oo = new TreeNode[ss.length + 1];
        oo[0] = (TreeNode)this.jTree1.getModel().getRoot();
        for (int i = 1; i < oo.length; ++i) {
            for (int j = 0; j < oo[i - 1].getChildCount(); ++j) {
                DefaultMutableTreeNode kid = (DefaultMutableTreeNode)oo[i - 1].getChildAt(j);
                if (!kid.getUserObject().equals(ss[i - 1])) continue;
                oo[i] = kid;
                break;
            }
            if (oo[i] != null) continue;
            return;
        }
        final TreePath tp = new TreePath(oo);
        Runnable run = new Runnable(){

            public void run() {
                Das2ServerDataSourceEditorPanel.this.jTree1.setSelectionPath(tp);
                Das2ServerDataSourceEditorPanel.this.jTree1.scrollPathToVisible(tp);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public String getURI() {
        DatumRange timeRange = null;
        try {
            timeRange = DatumRangeUtil.parseTimeRange((String)this.timeRangeTextField.getText());
        }
        catch (ParseException ex) {
            Logger.getLogger(Das2ServerDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        TreePath tp = this.jTree1.getSelectionPath();
        Object[] tp0 = tp.getPath();
        String dataSetId = (String)((DefaultMutableTreeNode)tp0[1]).getUserObject();
        for (int i = 2; i < tp0.length; ++i) {
            dataSetId = dataSetId + "/" + (String)((DefaultMutableTreeNode)tp0[i]).getUserObject();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String readerParams = this.ReaderParamsTextArea.getText();
        String[] ss = readerParams.split("\n");
        int iargc = 0;
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i].trim();
            if (s.length() == 0) continue;
            String[] ss2 = s.split("=", -2);
            if (ss2.length == 1) {
                map.put("arg_" + iargc, ss2[0]);
                ++iargc;
                continue;
            }
            map.put(ss2[0], ss2[1]);
        }
        String params = URISplit.formatParams(map);
        String result = "vap+das2server:" + this.serverURL + "?" + "dataset=" + dataSetId + "&start_time=" + timeRange.min() + "&end_time=" + timeRange.max();
        String tcaInterval = this.tcaTextField.getText().trim();
        if (!tcaInterval.equals("")) {
            result = result + "&interval=" + tcaInterval;
        }
        if (!this.tcaItem.getText().trim().equals("")) {
            result = result + "&item=" + this.tcaItem.getText().trim();
        }
        if (params.length() > 0) {
            result = result + "&" + params;
        }
        return result;
    }

    public void setExpertMode(boolean expert) {
        this.discoveryCb.setSelected(!expert);
    }
}

