/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datasource;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;

public class Das2ServerTimeSeriesBrowse
implements TimeSeriesBrowse {
    DatumRange timeRange;
    Datum resolution;
    String uri;
    static final Logger logger = Logger.getLogger("das2serverDataSource");

    public void setTimeRange(DatumRange dr) {
        this.timeRange = dr;
    }

    public void setTimeResolution(Datum d) {
        this.resolution = d;
    }

    public String getURI() {
        URISplit split = URISplit.parse((String)this.uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String stime = this.timeRange.min().toString().replace(" ", "+");
        String etime = this.timeRange.max().toString().replace(" ", "+");
        params.put("start_time", stime);
        params.put("end_time", etime);
        if (this.resolution == null) {
            params.remove("resolution");
        } else {
            params.put("resolution", String.valueOf(this.resolution.doubleValue(Units.seconds)));
        }
        split.params = URISplit.formatParams((Map)params);
        return URISplit.format((URISplit)split);
    }

    public DatumRange getTimeRange() {
        return this.timeRange;
    }

    public Datum getTimeResolution() {
        return this.resolution;
    }

    public void setURI(String suri) throws ParseException {
        this.uri = suri;
        URISplit split = URISplit.parse((String)suri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        String startTime = (String)params.remove("start_time");
        String endTime = (String)params.get("end_time");
        String sresolution = (String)params.get("resolution");
        if (startTime != null && endTime != null) {
            this.timeRange = new DatumRange(Units.us2000.parse(startTime), Units.us2000.parse(endTime));
        }
        if (sresolution != null) {
            this.resolution = Units.seconds.parse(sresolution);
        }
    }
}

