/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.autoplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.CrossHairRenderer;
import org.das2.event.DragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.util.AboutUtil;
import org.das2.util.ExceptionHandler;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.autoplot.ApplicationModel;
import org.virbo.autoplot.RenderType;
import org.virbo.autoplot.Util;
import org.virbo.autoplot.dom.Application;
import org.virbo.autoplot.dom.ApplicationController;
import org.virbo.autoplot.dom.Axis;
import org.virbo.autoplot.dom.Canvas;
import org.virbo.autoplot.dom.Diff;
import org.virbo.autoplot.dom.DomNode;
import org.virbo.autoplot.dom.DomUtil;
import org.virbo.autoplot.dom.Plot;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.dsutil.AsciiParser;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.SerializeRegistry;

public class AutoplotApplet
extends JApplet {
    ApplicationModel model;
    Application dom;
    boolean initializing = true;
    private static final Logger logger = Logger.getLogger("autoplot.applet");
    String statusCallback;
    String timeCallback;
    String clickCallback;
    ProgressMonitor loadInitialMonitor;
    long t0 = System.currentTimeMillis();
    public static final String VERSION = "20110317.1";
    private Image splashImage;
    private JCheckBoxMenuItem overviewMenuItem = null;
    private JComponent progressComponent = new JComponent(){

        protected void paintComponent(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            int leftJust = 70;
            if (AutoplotApplet.this.initializing) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int em = g.getFontMetrics().getHeight();
                if (AutoplotApplet.this.splashImage != null && !g.drawImage(AutoplotApplet.this.splashImage, 0, 0, this)) {
                    AutoplotApplet.this.drawString(g, "loading splash", leftJust, this.getHeight() / 2 - em);
                }
                AutoplotApplet.this.drawString(g, "initializing...", leftJust, this.getHeight() / 2);
                if (AutoplotApplet.this.loadInitialMonitor != null) {
                    Color c0 = g.getColor();
                    g.setColor(new Color(0, 0, 255, 200));
                    long size = AutoplotApplet.this.loadInitialMonitor.getTaskSize();
                    long pos = AutoplotApplet.this.loadInitialMonitor.getTaskProgress();
                    int x0 = leftJust;
                    int y0 = this.getHeight() / 2 + em / 2;
                    int w = 100;
                    int h = 5;
                    if (size == -1L) {
                        long t = System.currentTimeMillis() % 2000L;
                        int x = (int)(t * (long)w / 2000L);
                        int x1 = (int)(t * (long)w / 2000L) + h * 2;
                        int ww = x1 - x;
                        g.fillRect(x0 + x, y0, Math.min(w - x, x1 - x), h);
                        Timer timer = new Timer(100, new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                this.repaint();
                            }
                        });
                        timer.setRepeats(false);
                        timer.restart();
                    } else {
                        if (pos > size) {
                            pos = size;
                        }
                        g.fillRect(x0, y0, (int)(pos * (long)w / size), h);
                    }
                    g.setColor(c0);
                    g.drawRect(x0, y0, w, h);
                }
            } else {
                AutoplotApplet.this.drawString(g, "done initializing", leftJust, this.getHeight() / 2);
            }
        }
    };
    protected String timeRange;
    public static final String PROP_TIMERANGE = "timeRange";
    protected String font;
    public static final String PROP_FONT = "canvasFont";

    private String getStringParameter(String name, String deft) {
        String result = this.getParameter(name);
        if (result == null) {
            return deft;
        }
        return result;
    }

    private int getIntParameter(String name, int deft) {
        String result = this.getParameter(name);
        if (result == null) {
            return deft;
        }
        return Integer.parseInt(result);
    }

    private void setInitializationStatus(String val) {
        if (!this.statusCallback.equals("")) {
            try {
                this.getAppletContext().showDocument(new URL("javascript:" + this.statusCallback + "(\"" + val + "\")"));
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void timeCallback(String val) {
        if (!this.timeCallback.equals("")) {
            try {
                this.getAppletContext().showDocument(new URL("javascript:" + this.timeCallback + "(\"" + val + "\")"));
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void clickCallback(String plotid, DasPlot plot, MouseEvent e) {
        try {
            Datum xdatum = plot.getXAxis().invTransform((double)e.getX());
            Datum ydatum = plot.getYAxis().invTransform((double)e.getY());
            String jscall = String.format("%s('%s','%s','%s',%d,%d,%d )", this.clickCallback, plotid, xdatum, ydatum, e.getX(), e.getY(), e.getID());
            this.getAppletContext().showDocument(new URL("javascript:" + jscall));
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void drawString(Graphics g, String s, int x, int y) {
        Color c0 = g.getColor();
        g.setColor(Color.WHITE);
        g.drawString(s, x - 1, y - 1);
        g.setColor(c0);
        g.drawString(s, x, y);
    }

    private ProgressMonitor myMon() {
        return new NullProgressMonitor(){

            public void setTaskProgress(long position) throws IllegalArgumentException {
                super.setTaskProgress(position);
                AutoplotApplet.this.repaint();
            }

            public void setTaskSize(long taskSize) {
                super.setTaskSize(taskSize);
                AutoplotApplet.this.repaint();
            }
        };
    }

    public void init() {
        super.init();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        String fontParam = this.getParameter("font");
        if (fontParam != null) {
            Font f = Font.decode(fontParam);
            f = f.deriveFont(f.getSize2D() + 2.0f);
            this.setFont(f);
        }
        this.loadInitialMonitor = this.myMon();
        String si = this.getStringParameter("splashImage", "");
        if (!si.equals("")) {
            this.splashImage = this.getImage(this.getDocumentBase(), si);
            this.repaint();
        }
        this.initializing = true;
        this.getContentPane().add(this.progressComponent);
        this.validate();
        System.err.println("init AutoplotApplet 20110317.1 @ " + (System.currentTimeMillis() - this.t0) + " msec");
        System.err.println("done init AutoplotApplet 20110317.1 @ " + (System.currentTimeMillis() - this.t0) + " msec");
        this.repaint();
    }

    public void destroy() {
        super.destroy();
    }

    public void stop() {
        System.err.println("stop AutoplotApplet20110317.1");
        this.remove((Component)this.model.getCanvas());
        this.model = null;
        this.dom = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        DatumRange newRange;
        Units u;
        System.err.println("start AutoplotApplet 20110317.1 @ " + (System.currentTimeMillis() - this.t0) + " msec");
        super.start();
        this.model = new ApplicationModel();
        this.model.setExceptionHandler(new ExceptionHandler(){

            public void handle(Throwable t) {
                t.printStackTrace();
            }

            public void handleUncaught(Throwable t) {
                t.printStackTrace();
            }
        });
        this.model.setApplet(true);
        this.model.dom.getOptions().setAutolayout(false);
        System.err.println("ApplicationModel created @ " + (System.currentTimeMillis() - this.t0) + " msec");
        this.model.addDasPeersToApp();
        System.err.println("done addDasPeersToApp @ " + (System.currentTimeMillis() - this.t0) + " msec");
        try {
            System.err.println("Formatters: " + DataSourceRegistry.getInstance().getFormatterExtensions());
        }
        catch (Exception ex) {
            Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
        }
        ApplicationModel appmodel = this.model;
        this.dom = this.model.getDocumentModel();
        String debug = this.getParameter("debug");
        if (debug == null || !debug.equals("true")) {
            // empty if block
        }
        int width = this.getIntParameter("width", 700);
        int height = this.getIntParameter("height", 400);
        String fontParam = this.getStringParameter("font", "");
        String column = this.getStringParameter("column", "");
        String row = this.getStringParameter("row", "");
        String scolor = this.getStringParameter("color", "");
        String srenderType = this.getStringParameter("renderType", "");
        String stimeRange = this.getStringParameter(PROP_TIMERANGE, "");
        String sfillColor = this.getStringParameter("fillColor", "");
        String sforegroundColor = this.getStringParameter("foregroundColor", "");
        String sbackgroundColor = this.getStringParameter("backgroundColor", "");
        String title = this.getStringParameter("plot.title", "");
        String xlabel = this.getStringParameter("plot.xaxis.label", "");
        String xrange = this.getStringParameter("plot.xaxis.range", "");
        String xlog = this.getStringParameter("plot.xaxis.log", "");
        String xdrawTickLabels = this.getStringParameter("plot.xaxis.drawTickLabels", "");
        String ylabel = this.getStringParameter("plot.yaxis.label", "");
        String yrange = this.getStringParameter("plot.yaxis.range", "");
        String ylog = this.getStringParameter("plot.yaxis.log", "");
        String ydrawTickLabels = this.getStringParameter("plot.yaxis.drawTickLabels", "");
        String zlabel = this.getStringParameter("plot.zaxis.label", "");
        String zrange = this.getStringParameter("plot.zaxis.range", "");
        String zlog = this.getStringParameter("plot.zaxis.log", "");
        String zdrawTickLabels = this.getStringParameter("plot.zaxis.drawTickLabels", "");
        this.statusCallback = this.getStringParameter("statusCallback", "");
        this.timeCallback = this.getStringParameter("timeCallback", "");
        this.clickCallback = this.getStringParameter("clickCallback", "");
        if (srenderType.equals("fill_to_zero")) {
            srenderType = "fillToZero";
        }
        this.setInitializationStatus("readParameters");
        System.err.println("done readParameters @ " + (System.currentTimeMillis() - this.t0) + " msec");
        String vap = this.getParameter("vap");
        if (vap != null) {
            InputStream in = null;
            try {
                URL url = new URL(vap);
                System.err.println("load vap " + url + " @ " + (System.currentTimeMillis() - this.t0) + " msec");
                in = url.openStream();
                System.err.println("open vap stream " + url + " @ " + (System.currentTimeMillis() - this.t0) + " msec");
                appmodel.doOpen(in, null);
                System.err.println("done open vap @ " + (System.currentTimeMillis() - this.t0) + " msec");
                appmodel.waitUntilIdle(false);
                System.err.println("done load vap and waitUntilIdle @ " + (System.currentTimeMillis() - this.t0) + " msec");
                Canvas cc = appmodel.getDocumentModel().getCanvases(0);
                System.err.println("vap height, width= " + cc.getHeight() + "," + cc.getWidth());
                width = this.getIntParameter("width", cc.getWidth());
                height = this.getIntParameter("height", cc.getHeight());
                System.err.println("output height, width= " + width + "," + height);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        appmodel.getCanvas().setSize(width, height);
        appmodel.getCanvas().revalidate();
        appmodel.getCanvas().setPrintingTag("");
        this.dom.getOptions().setAutolayout("true".equals(this.getParameter("autolayout")));
        if (!this.dom.getOptions().isAutolayout()) {
            if (!row.equals("")) {
                this.dom.getController().getCanvas().getController().setRow(row);
            }
            if (!column.equals("")) {
                this.dom.getController().getCanvas().getController().setColumn(column);
            }
            this.dom.getCanvases(0).getRows(0).setTop("0%");
            this.dom.getCanvases(0).getRows(0).setBottom("100%");
        }
        if (!fontParam.equals("")) {
            appmodel.canvas.setBaseFont(Font.decode(fontParam));
        }
        JMenuItem item = new JMenuItem(new AbstractAction("Reset Zoom"){

            public void actionPerformed(ActionEvent e) {
                AutoplotApplet.this.resetZoom();
            }
        });
        this.dom.getPlots(0).getController().getDasPlot().getDasMouseInputAdapter().addMenuItem((Component)item);
        this.overviewMenuItem = new JCheckBoxMenuItem(new AbstractAction("Context Overview"){

            public void actionPerformed(ActionEvent e) {
                AutoplotApplet.this.addOverview();
            }
        });
        this.dom.getPlots(0).getController().getDasPlot().getDasMouseInputAdapter().addMenuItem((Component)this.overviewMenuItem);
        if (sforegroundColor != null && !sforegroundColor.equals("")) {
            appmodel.canvas.setForeground(Color.decode(sforegroundColor));
        }
        if (sbackgroundColor != null && !sbackgroundColor.equals("")) {
            appmodel.canvas.setBackground(Color.decode(sbackgroundColor));
        }
        this.getContentPane().setLayout(new BorderLayout());
        System.err.println("done set parameters @ " + (System.currentTimeMillis() - this.t0) + " msec");
        String surl = this.getParameter("url");
        String process = this.getStringParameter("process", "");
        String script = this.getStringParameter("script", "");
        if (surl == null) {
            surl = this.getParameter("dataSetURL");
        }
        if (surl != null && !surl.equals("")) {
            TimeSeriesBrowse tsb;
            DataSource dsource;
            try {
                dsource = DataSetURI.getDataSource((String)surl);
                System.err.println("get dsource for " + surl + " @ " + (System.currentTimeMillis() - this.t0) + " msec");
            }
            catch (NullPointerException ex) {
                throw new RuntimeException("No such data source: ", ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                dsource = null;
            }
            DatumRange timeRange1 = null;
            if (!stimeRange.equals("")) {
                timeRange1 = DatumRangeUtil.parseTimeRangeValid((String)stimeRange);
                TimeSeriesBrowse tsb2 = (TimeSeriesBrowse)dsource.getCapability(TimeSeriesBrowse.class);
                if (tsb2 != null) {
                    System.err.println("do tsb.setTimeRange @ " + (System.currentTimeMillis() - this.t0) + " msec");
                    tsb2.setTimeRange(timeRange1);
                    System.err.println("done tsb.setTimeRange @ " + (System.currentTimeMillis() - this.t0) + " msec");
                }
            }
            if (dsource != null && (tsb = (TimeSeriesBrowse)dsource.getCapability(TimeSeriesBrowse.class)) == null) {
                try {
                    System.err.println("do getDataSet @ " + (System.currentTimeMillis() - this.t0) + " msec");
                    QDataSet ds = dsource == null ? null : dsource.getDataSet(this.loadInitialMonitor);
                    System.err.println("loaded ds: " + ds);
                    System.err.println("done getDataSet @ " + (System.currentTimeMillis() - this.t0) + " msec");
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            System.err.println("do setDataSource @ " + (System.currentTimeMillis() - this.t0) + " msec");
            appmodel.setDataSource(dsource);
            System.err.println("done setDataSource @ " + (System.currentTimeMillis() - this.t0) + " msec");
            this.setInitializationStatus("dataSourceSet");
            if (stimeRange != null && !stimeRange.equals("")) {
                try {
                    System.err.println("wait for idle @ " + (System.currentTimeMillis() - this.t0) + " msec (due to stimeRange)");
                    appmodel.waitUntilIdle(true);
                    System.err.println("done wait for idle @ " + (System.currentTimeMillis() - this.t0) + " msec");
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (UnitsUtil.isTimeLocation((Units)this.dom.getTimeRange().getUnits())) {
                    this.dom.setTimeRange(timeRange1);
                }
            }
            this.setInitializationStatus("dataSetLoaded");
        }
        System.err.println("done dataSetLoaded @ " + (System.currentTimeMillis() - this.t0) + " msec");
        Plot p = this.dom.getController().getPlot();
        if (!title.equals("")) {
            p.setTitle(title);
        }
        Axis axis = p.getXaxis();
        if (!xlabel.equals("")) {
            axis.setLabel(xlabel);
        }
        if (!xrange.equals("")) {
            try {
                u = axis.getController().getDasAxis().getUnits();
                newRange = DatumRangeUtil.parseDatumRange((String)xrange, (Units)u);
                axis.setRange(newRange);
            }
            catch (ParseException ex) {
                Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!xlog.equals("")) {
            axis.setLog("true".equals(xlog));
        }
        if (!xdrawTickLabels.equals("")) {
            axis.setDrawTickLabels("true".equals(xdrawTickLabels));
        }
        axis = p.getYaxis();
        if (!ylabel.equals("")) {
            axis.setLabel(ylabel);
        }
        if (!yrange.equals("")) {
            try {
                u = axis.getController().getDasAxis().getUnits();
                newRange = DatumRangeUtil.parseDatumRange((String)yrange, (Units)u);
                axis.setRange(newRange);
            }
            catch (ParseException ex) {
                Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!ylog.equals("")) {
            axis.setLog("true".equals(ylog));
        }
        if (!ydrawTickLabels.equals("")) {
            axis.setDrawTickLabels("true".equals(ydrawTickLabels));
        }
        axis = p.getZaxis();
        if (!zlabel.equals("")) {
            axis.setLabel(zlabel);
        }
        if (!zrange.equals("")) {
            try {
                u = axis.getController().getDasAxis().getUnits();
                newRange = DatumRangeUtil.parseDatumRange((String)zrange, (Units)u);
                axis.setRange(newRange);
            }
            catch (ParseException ex) {
                Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!zlog.equals("")) {
            axis.setLog("true".equals(zlog));
        }
        if (!zdrawTickLabels.equals("")) {
            axis.setDrawTickLabels("true".equals(zdrawTickLabels));
        }
        if (srenderType != null && !srenderType.equals("")) {
            try {
                RenderType renderType = RenderType.valueOf((String)srenderType);
                this.dom.getController().getPlotElement().setRenderType(renderType);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        System.err.println("done setRenderType @ " + (System.currentTimeMillis() - this.t0) + " msec");
        if (!scolor.equals("")) {
            try {
                this.dom.getController().getPlotElement().getStyle().setColor(Color.decode(scolor));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!sfillColor.equals("")) {
            try {
                this.dom.getController().getPlotElement().getStyle().setFillColor(Color.decode(sfillColor));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!sforegroundColor.equals("")) {
            try {
                this.dom.getOptions().setForeground(Color.decode(sforegroundColor));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!sbackgroundColor.equals("")) {
            try {
                this.dom.getOptions().setBackground(Color.decode(sbackgroundColor));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((surl = this.getParameter("dataSetURL")) != null && surl.startsWith("about:")) {
            this.setDataSetURL(surl);
        }
        this.getContentPane().remove(this.progressComponent);
        this.getContentPane().add((Component)this.model.getCanvas());
        System.err.println("done add to applet @ " + (System.currentTimeMillis() - this.t0) + " msec");
        this.validate();
        System.err.println("done applet.validate @ " + (System.currentTimeMillis() - this.t0) + " msec");
        this.repaint();
        appmodel.getCanvas().setVisible(true);
        this.initializing = false;
        this.repaint();
        System.err.println("ready @ " + (System.currentTimeMillis() - this.t0) + " msec");
        this.setInitializationStatus("ready");
        this.dom.getController().getPlot().getXaxis().addPropertyChangeListener("range", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AutoplotApplet.this.timeCallback(String.valueOf(evt.getNewValue()));
            }
        });
        if (!this.clickCallback.equals("")) {
            String clickCallbackLabel = "Applet Click";
            int i = this.clickCallback.indexOf(",");
            if (i != -1) {
                int i2 = this.clickCallback.indexOf("label=");
                if (i2 != -1) {
                    clickCallbackLabel = this.clickCallback.substring(i2 + 6).trim();
                }
                this.clickCallback = this.clickCallback.substring(0, i).trim();
            }
            final DasPlot plot = this.dom.getPlots(0).getController().getDasPlot();
            MouseModule mm = new MouseModule((DasCanvasComponent)plot, (DragRenderer)new CrossHairRenderer(plot, null, plot.getXAxis(), plot.getYAxis()), clickCallbackLabel){

                public void mousePressed(MouseEvent e) {
                    e = SwingUtilities.convertMouseEvent((Component)plot, e, (Component)plot.getCanvas());
                    AutoplotApplet.this.clickCallback(AutoplotApplet.this.dom.getPlots(0).getId(), plot, e);
                }

                public void mouseDragged(MouseEvent e) {
                    e = SwingUtilities.convertMouseEvent((Component)plot, e, (Component)plot.getCanvas());
                    AutoplotApplet.this.clickCallback(AutoplotApplet.this.dom.getPlots(0).getId(), plot, e);
                }

                public void mouseReleased(MouseEvent e) {
                    e = SwingUtilities.convertMouseEvent((Component)plot, e, (Component)plot.getCanvas());
                    AutoplotApplet.this.clickCallback(AutoplotApplet.this.dom.getPlots(0).getId(), plot, e);
                }
            };
            plot.getDasMouseInputAdapter().setPrimaryModule(mm);
        }
        p.getController().getDasPlot().getDasMouseInputAdapter().removeMenuItem("Properties");
        this.dom.getPlots(0).getXaxis().getController().getDasAxis().getDasMouseInputAdapter().removeMenuItem("Properties");
        this.dom.getPlots(0).getYaxis().getController().getDasAxis().getDasMouseInputAdapter().removeMenuItem("Properties");
        this.dom.getPlots(0).getZaxis().getController().getDasAxis().getDasMouseInputAdapter().removeMenuItem("Properties");
        if (this.getStringParameter("contextOverview", "off").equals("on")) {
            Runnable run = new Runnable(){

                public void run() {
                    AutoplotApplet.this.dom.getController().waitUntilIdle();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    AutoplotApplet.this.dom.getController().waitUntilIdle();
                    AutoplotApplet.this.doSetOverview(true);
                }
            };
            new Thread(run).start();
        }
        System.err.println("done start AutoplotApplet 20110317.1 @ " + (System.currentTimeMillis() - this.t0) + " msec");
    }

    private void createAppletTester() {
        JFrame frame = new JFrame();
        JButton button = new JButton(new AbstractAction("pushme"){

            public void actionPerformed(ActionEvent e) {
                URL url = AutoplotApplet.this.getCodeBase();
                String surl = "" + url.toString() + "Capture_00158.jpg?channel=red";
                System.err.println("************************************************");
                System.err.println("************************************************");
                System.err.println(surl);
                System.err.println("************************************************");
                System.err.println("************************************************");
                AutoplotApplet.this.setDataSetURL(surl);
            }
        });
        frame.getContentPane().add(button);
        frame.pack();
        frame.setVisible(true);
    }

    public void setDataSetURL(final String surl) {
        try {
            logger.info(surl);
            System.err.println("***************");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (surl.equals("about:plugins")) {
                        String text = DataSourceRegistry.getPluginsText();
                        JOptionPane.showMessageDialog(AutoplotApplet.this, text);
                        return;
                    }
                    if (surl.equals("about:autoplot")) {
                        try {
                            StringBuilder buffy = new StringBuilder();
                            URL aboutHtml = ApplicationModel.class.getResource("aboutAutoplot.html");
                            BufferedReader reader = new BufferedReader(new InputStreamReader(aboutHtml.openStream()));
                            String s = reader.readLine();
                            while (s != null) {
                                buffy.append(s).append("");
                                s = reader.readLine();
                            }
                            reader.close();
                            buffy.append("    <h2>Build Information:</h2>");
                            buffy.append("<ul>");
                            buffy.append("<li>release tag: ").append(AboutUtil.getReleaseTag()).append("</li>");
                            List bi = Util.getBuildInfos();
                            for (String ss : bi) {
                                buffy.append("    <li>").append(ss).append("");
                            }
                            buffy.append("<ul>    </p></html>");
                            JOptionPane.showMessageDialog(AutoplotApplet.this, buffy.toString());
                            return;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    AutoplotApplet.this.model.setDataSourceURL(surl);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getTimeRange() {
        return this.dom.getTimeRange().toString();
    }

    public void setTimeRange(final String timeRange) {
        Runnable run = new Runnable(){

            public void run() {
                try {
                    String oldv = AutoplotApplet.this.getTimeRange();
                    AutoplotApplet.this.dom.getController().getPlot().getController().getDasPlot().getXAxis().setDatumRange(DatumRangeUtil.parseTimeRangeValid((String)timeRange));
                    AutoplotApplet.this.firePropertyChange(AutoplotApplet.PROP_TIMERANGE, oldv, timeRange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public String getCanvasFont() {
        return this.model.getCanvas().getBaseFont().toString();
    }

    public void setCanvasFont(final String font) {
        Runnable run = new Runnable(){

            public void run() {
                try {
                    String oldFont = AutoplotApplet.this.getCanvasFont();
                    AutoplotApplet.this.model.getCanvas().setBaseFont(Font.decode(font));
                    AutoplotApplet.this.model.getCanvas().repaint();
                    AutoplotApplet.this.firePropertyChange(AutoplotApplet.PROP_FONT, oldFont, font);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public Application getDom() {
        return this.dom;
    }

    public void dumpDom() {
        List diffs = new Application().diffs((DomNode)this.dom);
        for (Diff d : diffs) {
            System.err.println(d);
        }
    }

    public void printDomNode(final String node) {
        Runnable run = new Runnable(){

            public void run() {
                try {
                    Object o = DomUtil.getPropertyValue((DomNode)AutoplotApplet.this.dom, (String)node);
                    System.err.println("dom." + node + "=" + o);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void setDomNode(final String node, final String sval) {
        this.getAppletContext().showStatus("setDomNode( " + node + "," + sval + ")");
        Runnable run = new Runnable(){

            public void run() {
                try {
                    Class c = DomUtil.getPropertyType((DomNode)AutoplotApplet.this.dom, (String)node);
                    SerializeDelegate sd = SerializeRegistry.getDelegate(c);
                    if (sd == null) {
                        System.err.println("unable to find serialize delegate for " + c.getCanonicalName());
                        return;
                    }
                    Object val = sd.parse(sd.typeId(c), sval);
                    DomUtil.setPropertyValue((DomNode)AutoplotApplet.this.dom, (String)node, (Object)val);
                    AutoplotApplet.this.getAppletContext().showStatus("dom." + node + "=" + DomUtil.getPropertyValue((DomNode)AutoplotApplet.this.dom, (String)node));
                    System.err.println("dom." + node + "=" + DomUtil.getPropertyValue((DomNode)AutoplotApplet.this.dom, (String)node));
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void resetZoom() {
        Runnable run = new Runnable(){

            public void run() {
                AutoplotApplet.this.dom.getController().getPlot().getController().resetZoom(true, true, true);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void doSetOverview(boolean t) {
        Plot domPlot = this.dom.getPlots(0);
        if (t) {
            ApplicationController controller = this.dom.getController();
            Plot that = controller.copyPlotAndPlotElements(domPlot, null, false, false);
            that.setTitle("");
            controller.bind((DomNode)domPlot.getZaxis(), "range", (Object)that.getZaxis(), "range");
            controller.bind((DomNode)domPlot.getZaxis(), "log", (Object)that.getZaxis(), "log");
            controller.bind((DomNode)domPlot.getZaxis(), "label", (Object)that.getZaxis(), "label");
            controller.addConnector(domPlot, that);
            this.dom.getCanvases(0).getRows(0).setBottom("60%-2em");
            this.dom.getCanvases(0).getRows(1).setTop("60%+2em");
            that.getXaxis().getController().getDasAxis().getDasMouseInputAdapter().removeMenuItem("Properties");
            that.getYaxis().getController().getDasAxis().getDasMouseInputAdapter().removeMenuItem("Properties");
            that.getZaxis().getController().getDasAxis().getDasMouseInputAdapter().removeMenuItem("Properties");
            that.getController().getDasPlot().getDasMouseInputAdapter().removeMenuItem("Properties");
            that.getController().getDasPlot().getDasMouseInputAdapter().removeMenuItem("Connector Properties");
        } else {
            ApplicationController controller = this.dom.getController();
            controller.deletePlotElement(this.dom.getPlotElements(1));
            controller.deletePlot(this.dom.getPlots(1));
        }
        this.overviewMenuItem.setSelected(t);
    }

    public void addOverview() {
        Runnable run = new Runnable(){

            public void run() {
                AutoplotApplet.this.doSetOverview(AutoplotApplet.this.overviewMenuItem.isSelected());
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void plotData(final String fsdata) {
        Runnable run = new Runnable(){

            public void run() {
                try {
                    String sdata = fsdata;
                    AsciiParser p = new AsciiParser();
                    int i = sdata.indexOf(";");
                    if (i != -1) {
                        sdata = sdata.replaceAll(";", "\n");
                        i = sdata.indexOf("\n");
                    }
                    p.guessDelimParser(sdata.substring(0, i));
                    DasCanvas c = AutoplotApplet.this.dom.getController().getCanvas().getController().getDasCanvas();
                    WritableDataSet data = p.readStream(new StringReader(sdata), AutoplotApplet.this.dom.getController().getMonitorFactory().getMonitor(c, "reading data", "reading data"));
                    MutablePropertyDataSet y = DataSetOps.slice1(data, 1);
                    y.putProperty("DEPEND_0", DataSetOps.slice1(data, 0));
                    AutoplotApplet.this.model.setDataSet((QDataSet)y);
                }
                catch (IOException ex) {
                    Logger.getLogger(AutoplotApplet.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }
}

