/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.help;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.HelpSet;
import javax.help.SwingHelpUtilities;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.autoplot.help.TitledBorderDecorator;
import org.autoplot.help.Util;

public class AutoplotHelpSystem {
    private static AutoplotHelpSystem instance;
    private static final Logger log;
    private HelpSet mainHS;
    private Map<Component, String> helpIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AutoplotHelpSystem(Component uiBase) {
        URL hsurl;
        SwingHelpUtilities.setContentViewerUI((String)"org.autoplot.help.AutoplotHelpViewer");
        this.helpIds = new HashMap<Component, String>();
        try {
            hsurl = this.getClass().getResource("/helpfiles/autoplotHelp.hs");
            this.mainHS = new HelpSet(null, hsurl);
        }
        catch (Exception ex) {
            log.warning("Error loading helpset /helpfiles/autoplotHelp.hs");
        }
        Enumeration<URL> hsurls = null;
        try {
            hsurls = this.getClass().getClassLoader().getResources("META-INF/helpsets.txt");
        }
        catch (IOException ex) {
            log.warning(ex.toString());
        }
        while (hsurls != null && hsurls.hasMoreElements()) {
            hsurl = hsurls.nextElement();
            log.log(Level.FINE, "found /META-INF/helpsets.txt at {0}", hsurl);
            BufferedReader read = null;
            try {
                read = new BufferedReader(new InputStreamReader(hsurl.openStream()));
                String spec = read.readLine();
                while (spec != null) {
                    int i = spec.indexOf("#");
                    if (i != -1) {
                        spec = spec.substring(0, i);
                    }
                    if ((spec = spec.trim()).length() > 0) {
                        URL hsurl1 = null;
                        try {
                            log.log(Level.FINE, "Merging external helpset: {0}", hsurl);
                            hsurl1 = spec.startsWith("/") ? this.getClass().getResource(spec) : new URL(spec);
                            this.mainHS.add(new HelpSet(null, hsurl1));
                        }
                        catch (Exception ex) {
                            log.log(Level.WARNING, "Error loading helpset {0}", hsurl1);
                        }
                    }
                    spec = read.readLine();
                }
            }
            catch (IOException ex) {
                log.warning(ex.toString());
            }
            finally {
                try {
                    if (read == null) continue;
                    read.close();
                }
                catch (IOException ex) {
                    log.warning(ex.toString());
                }
            }
        }
    }

    public static synchronized void initialize(Component uiBase) {
        if (instance == null) {
            instance = new AutoplotHelpSystem(uiBase);
        } else {
            System.err.println("Ignoring attempt to re-initialize help system.");
        }
    }

    public static AutoplotHelpSystem getHelpSystem() {
        return instance;
    }

    public void registerHelpID(final Component c, final String helpID) {
        c.setFocusable(true);
        this.helpIds.put(c, helpID);
        c.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 112) {
                    Util.openBrowser("http://autoplot.org/help#" + helpID);
                    e.consume();
                }
            }
        });
        c.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                c.requestFocus();
            }
        });
        if (c instanceof JPanel) {
            Component[] cc;
            JPanel jPanel1 = (JPanel)c;
            Border b = jPanel1.getBorder();
            if (b instanceof TitledBorder) {
                TitledBorderDecorator.makeLink(jPanel1, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Util.openBrowser("http://autoplot.org/help#" + helpID);
                    }
                });
            }
            for (Component child : cc = jPanel1.getComponents()) {
                JPanel jPanel2;
                if (!(child instanceof JPanel) || !((b = (jPanel2 = (JPanel)child).getBorder()) instanceof TitledBorder)) continue;
                TitledBorderDecorator.makeLink(jPanel2, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Util.openBrowser("http://autoplot.org/help#" + helpID);
                    }
                });
            }
        }
    }

    private Component findRegisteredParent(Component c) {
        while (c != null) {
            String helpId = this.helpIds.get(c);
            if (helpId != null) {
                return c;
            }
            c = c.getParent();
        }
        return null;
    }

    public void displayHelpFromEvent(ActionEvent e) {
        this.displayHelpFromEvent(e, e.getSource());
    }

    public void displayHelpFromEvent(ActionEvent e, Object focus) {
        if (focus == null) {
            focus = e.getSource();
        }
        if (focus instanceof Component) {
            Component c = (Component)focus;
            if ((c = this.findRegisteredParent(c)) == null) {
                Util.openBrowser("http://autoplot.org/help");
            } else {
                String helpId = this.helpIds.get(c);
                Util.openBrowser("http://autoplot.org/help#" + helpId);
            }
        } else {
            Util.openBrowser("http://autoplot.org/help");
        }
    }

    public void displayDefaultHelp() {
        Util.openBrowser("http://autoplot.org/help");
    }

    static {
        log = Logger.getLogger("org.autoplot.help");
    }
}

