/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;

public class LeafTrimDataSet
extends AbstractDataSet {
    final QDataSet ds;
    final int start;
    final int end;

    public LeafTrimDataSet(QDataSet source, int start, int end) {
        Object o;
        int i;
        String bundleNName;
        QDataSet bds;
        if (source.rank() == 0) {
            throw new IllegalArgumentException("source is rank 0");
        }
        this.ds = source;
        this.start = start;
        this.end = end;
        String depNName = "DEPEND_" + (this.ds.rank() - 1);
        QDataSet depN = (QDataSet)this.ds.property(depNName);
        if (depN != null) {
            depN = new LeafTrimDataSet(depN, start, end);
            this.properties.put(depNName, depN);
        }
        if ((bds = (QDataSet)this.ds.property(bundleNName = "BUNDLE_" + (this.ds.rank() - 1))) != null) {
            bds = new LeafTrimDataSet(bds, start, end);
            this.properties.put(bundleNName, bds);
        }
        for (i = 0; i < this.ds.rank() - 1; ++i) {
            o = this.ds.property("DEPEND_" + i);
            if (o == null) continue;
            this.properties.put("DEPEND_" + i, o);
        }
        for (i = 0; i < this.ds.rank() - 1; ++i) {
            o = this.ds.property("BUNDLE_" + i);
            if (o == null) continue;
            this.properties.put("BUNDLE_" + i, o);
        }
        for (i = 0; i < this.ds.rank() - 1; ++i) {
            o = this.ds.property("BINS_" + i);
            if (o == null) continue;
            this.properties.put("BINS_" + i, o);
        }
    }

    public int rank() {
        return this.ds.rank();
    }

    public double value(int i) {
        return this.ds.value(i + this.start);
    }

    public double value(int i0, int i1) {
        return this.ds.value(i0, i1 + this.start);
    }

    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0, i1, i2 + this.start);
    }

    public double value(int i0, int i1, int i2, int i3) {
        return this.ds.value(i0, i1, i2, i3 + this.start);
    }

    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    public Object property(String name, int i) {
        if (DataSetUtil.isInheritedProperty(name) && this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.ds.rank() == 1 ? this.ds.property(name, i - this.start) : this.ds.property(name, i);
    }

    public int length() {
        return this.ds.rank() == 1 ? this.end - this.start : this.ds.length();
    }

    public int length(int i) {
        return this.ds.rank() == 2 ? this.end - this.start : this.ds.length(i);
    }

    public int length(int i, int j) {
        return this.ds.rank() == 3 ? this.end - this.start : this.ds.length(i, j);
    }

    public int length(int i0, int i1, int i2) {
        return this.ds.rank() == 4 ? this.end - this.start : this.ds.length(i0, i1, i2);
    }
}

