/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;

public class Slice0DataSet
extends AbstractDataSet
implements RankZeroDataSet {
    QDataSet ds;
    int index;

    public Slice0DataSet(QDataSet ds, int index) {
        this(ds, index, true);
    }

    public Slice0DataSet(QDataSet ds, int index, boolean addContext) {
        String prop;
        QDataSet plane0;
        DRank0DataSet context;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank limit > 4");
        }
        this.ds = ds;
        this.index = index;
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        if (dep0 != null && dep1 != null && dep0.rank() > 1 && dep1.rank() > 1) {
            this.putProperty("DEPEND_0", new Slice0DataSet(dep0, index, false));
            this.putProperty("DEPEND_1", new Slice0DataSet(dep1, index, false));
        } else if (DataSetUtil.isQube(ds) || dep1 != null) {
            if (addContext) {
                if (dep0 != null) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep0, index, false));
                } else {
                    context = DataSetUtil.asDataSet(index);
                    context.putProperty("NAME", "slice0");
                    DataSetUtil.addContext(this, (QDataSet)context);
                }
            }
            if (dep1 != null && dep1.rank() == 2) {
                this.putProperty("DEPEND_0", new Slice0DataSet(dep1, index, false));
            } else if (ds.rank() > 1 && dep1 != null) {
                this.putProperty("DEPEND_0", dep1);
            }
            this.putProperty("BUNDLE_0", ds.property("BUNDLE_1"));
            this.putProperty("BUNDLE_1", null);
            this.putProperty("BINS_0", ds.property("BINS_1"));
            if (ds.rank() > 2) {
                this.putProperty("DEPEND_1", ds.property("DEPEND_2"));
            }
            if (ds.rank() > 3) {
                this.putProperty("DEPEND_2", ds.property("DEPEND_3"));
            }
        } else {
            if (dep0 != null && dep0.rank() > 1) {
                this.putProperty("DEPEND_0", new Slice0DataSet(dep0, index, false));
            } else if (dep0 != null) {
                if (addContext) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep0, index, false));
                }
            } else if (ds.property("DEPEND_0", index) == null) {
                this.putProperty("DEPEND_0", null);
            } else {
                if (addContext) {
                    context = DataSetUtil.asDataSet(index);
                    context.putProperty("NAME", "slice0");
                    DataSetUtil.addContext(this, (QDataSet)context);
                }
                this.putProperty("DEPEND_0", ds.property("DEPEND_0", index));
            }
            if (ds.rank() > 2) {
                this.putProperty("DEPEND_1", ds.property("DEPEND_1", index));
            }
            this.putProperty("RENDER_TYPE", ds.property("RENDER_TYPE", index));
            this.putProperty("BINS_0", ds.property("BINS_0", index));
            if (ds.rank() > 2) {
                this.putProperty("BINS_1", ds.property("BINS_1", index));
            }
            this.putProperty("BUNDLE_0", ds.property("BUNDLE_0", index));
            if (ds.rank() > 2) {
                this.putProperty("BUNDLE_1", ds.property("BUNDLE_1", index));
            }
        }
        this.putProperty("JOIN_0", null);
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (plane0.rank() < 1) {
                this.putProperty(prop, plane0);
                continue;
            }
            this.putProperty(prop, new Slice0DataSet(plane0, index, addContext));
        }
        String[] p = new String[]{"DELTA_MINUS", "DELTA_PLUS"};
        for (int i = 0; i < p.length; ++i) {
            QDataSet delta = (QDataSet)ds.property(p[i]);
            if (delta == null || delta.rank() <= 0) continue;
            this.putProperty(p[i], new Slice0DataSet(delta, index, addContext));
        }
        this.putProperty("WEIGHTS", null);
        DataSetUtil.copyDimensionProperties(ds, this);
    }

    public int rank() {
        return this.ds.rank() - 1;
    }

    public double value() {
        return this.ds.value(this.index);
    }

    public double value(int i) {
        return this.ds.value(this.index, i);
    }

    public double value(int i0, int i1) {
        return this.ds.value(this.index, i0, i1);
    }

    public double value(int i0, int i1, int i2) {
        return this.ds.value(this.index, i0, i1, i2);
    }

    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name, this.index);
        }
        return null;
    }

    public Object property(String name, int i) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name, this.index);
        }
        return null;
    }

    public int length() {
        return this.ds.length(this.index);
    }

    public int length(int i0) {
        return this.ds.length(this.index, i0);
    }

    public int length(int i0, int i1) {
        return this.ds.length(this.index, i0, i1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Slice0DataSet) {
            Slice0DataSet that = (Slice0DataSet)obj;
            return that.ds.equals(this.ds) && that.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.ds.hashCode() + this.index;
    }
}

