/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.dataset.Slice1DataSet;

public class Slice2DataSet
extends AbstractDataSet {
    QDataSet ds;
    int index;

    public Slice2DataSet(QDataSet ds, int index) {
        this(ds, index, true);
    }

    Slice2DataSet(QDataSet ds, int index, boolean addContext) {
        String prop;
        QDataSet plane0;
        if (ds.rank() > 4) {
            throw new IllegalArgumentException("rank limit > 4");
        }
        if (ds.rank() < 3) {
            throw new IllegalArgumentException("rank limit < 3");
        }
        this.ds = ds;
        this.index = index;
        if (addContext) {
            QDataSet dep2 = (QDataSet)ds.property("DEPEND_2");
            if (dep2 != null) {
                if (dep2.rank() == 1) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice0DataSet(dep2, index, false));
                } else if (dep2.rank() == 2) {
                    DataSetUtil.addContext(this, (QDataSet)new Slice1DataSet(dep2, index, false));
                } else {
                    System.err.println("slice on non-qube, dep3 has rank=" + dep2.rank());
                }
            } else {
                DRank0DataSet context = DataSetUtil.asDataSet(index);
                context.putProperty("NAME", "slice2");
                DataSetUtil.addContext(this, (QDataSet)context);
            }
        }
        this.putProperty("DEPEND_0", ds.property("DEPEND_0"));
        this.putProperty("DEPEND_1", ds.property("DEPEND_1"));
        this.putProperty("DEPEND_2", ds.property("DEPEND_3"));
        this.putProperty("BUNDLE_0", ds.property("BUNDLE_0"));
        this.putProperty("BUNDLE_1", ds.property("BUNDLE_1"));
        this.putProperty("BINS_0", ds.property("BINS_0"));
        this.putProperty("BINS_1", ds.property("BINS_1"));
        for (int i = 0; i < 50 && (plane0 = (QDataSet)ds.property(prop = "PLANE_" + i)) != null; ++i) {
            if (plane0.rank() < 3) {
                this.putProperty(prop, plane0);
                continue;
            }
            this.putProperty(prop, new Slice2DataSet(plane0, index));
        }
        this.putProperty("WEIGHTS", null);
        DataSetUtil.copyDimensionProperties(ds, this);
    }

    public int rank() {
        return this.ds.rank() - 1;
    }

    public double value(int i0, int i1) {
        return this.ds.value(i0, i1, this.index);
    }

    public double value(int i0, int i1, int i2) {
        return this.ds.value(i0, i1, this.index, i2);
    }

    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        if (DataSetUtil.isInheritedProperty(name)) {
            return this.ds.property(name);
        }
        return null;
    }

    public int length() {
        return this.ds.length();
    }

    public int length(int i) {
        return this.ds.length(i);
    }

    public int length(int i0, int i1) {
        return this.ds.length(i0, i1, this.index);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Slice2DataSet) {
            Slice2DataSet that = (Slice2DataSet)obj;
            return that.ds.equals(this.ds) && that.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.ds.hashCode() + this.index;
    }
}

