/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.QDataSet;

public class SubsetDataSet
extends AbstractDataSet {
    QDataSet source;
    QDataSet[] sorts;
    int[] lens;

    public SubsetDataSet(QDataSet source) {
        this.source = source;
        this.sorts = new QDataSet[4];
        this.lens = new int[4];
        if (!DataSetUtil.isQube(source)) {
            System.err.println("source should be qube, warning you!");
        }
        int[] lenss = DataSetUtil.qubeDims(source);
        for (int i = 0; i < lenss.length; ++i) {
            this.lens[i] = lenss[i];
            this.sorts[i] = new IndexGenDataSet(lenss[i]);
        }
    }

    public void applyIndex(int idim, QDataSet idx) {
        this.sorts[idim] = idx;
        this.lens[idim] = idx.length();
        if (idx.rank() > 1) {
            throw new IllegalArgumentException("rank>1");
        }
        QDataSet dep = (QDataSet)this.source.property("DEPEND_" + idim);
        if (dep != null) {
            QDataSet dep1;
            SubsetDataSet dim = new SubsetDataSet((QDataSet)this.source.property("DEPEND_" + idim));
            if (idim == 0 && (dep1 = (QDataSet)this.source.property("DEPEND_1")) != null && dep1.rank() > 1) {
                throw new IllegalArgumentException("not supported--we need to deal with this at some point");
            }
            dim.applyIndex(0, idx);
            this.putProperty("DEPEND_" + idim, dim);
        }
    }

    public int rank() {
        return this.source.rank();
    }

    public int length() {
        return this.lens[0];
    }

    public int length(int i) {
        return this.lens[1];
    }

    public int length(int i, int j) {
        return this.lens[2];
    }

    public int length(int i, int j, int k) {
        return this.lens[3];
    }

    public double value() {
        return this.source.value();
    }

    public double value(int i) {
        return this.source.value((int)this.sorts[0].value(i));
    }

    public double value(int i0, int i1) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1));
    }

    public double value(int i0, int i1, int i2) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1), (int)this.sorts[2].value(i2));
    }

    public double value(int i0, int i1, int i2, int i3) {
        return this.source.value((int)this.sorts[0].value(i0), (int)this.sorts[1].value(i1), (int)this.sorts[2].value(i2), (int)this.sorts[3].value(i3));
    }

    public Object property(String name, int i) {
        Object v = this.properties.get(name);
        return v != null ? v : this.source.property(name, i);
    }

    public Object property(String name) {
        Object v = this.properties.get(name);
        return v != null ? v : this.source.property(name);
    }
}

