/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.voyager.cdf;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DataTypes {
    public static final int ENCODING_COUNT = 17;
    public static final ByteOrder[] endian_ness;
    public static final int EPOCH16 = 32;
    public static final int CDF_TIME_TT2000 = 33;
    public static final int FLOAT = 0;
    public static final int DOUBLE = 1;
    public static final int SIGNED_INTEGER = 2;
    public static final int UNSIGNED_INTEGER = 3;
    public static final int STRING = 4;
    public static final int LONG = 5;
    public static final int LAST_TYPE = 53;
    public static Method[] method;
    public static int[] typeCategory;
    public static int[] size;
    public static long[] longInt;

    public DataTypes() {
        Class<?> tc = this.getClass();
        try {
            Method meth;
            DataTypes.method[51] = meth = tc.getMethod("getString", ByteBuffer.class, Integer.class);
            DataTypes.method[52] = meth;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getString(ByteBuffer buf, Integer nc) {
        int i;
        ByteBuffer slice = buf.slice();
        byte[] ba = new byte[nc.intValue()];
        for (i = 0; i < ba.length; ++i) {
            ba[i] = slice.get();
            if (ba[i] == 0) break;
        }
        return new String(ba, 0, i);
    }

    public static ByteOrder getByteOrder(int encoding) throws Throwable {
        if (endian_ness[encoding] != null) {
            return endian_ness[encoding];
        }
        throw new Throwable("Unsupported encoding " + encoding);
    }

    public static boolean isStringType(int type) {
        return typeCategory[type] == 4;
    }

    static {
        int i;
        endian_ness = new ByteOrder[17];
        for (i = 0; i < 17; ++i) {
            DataTypes.endian_ness[i] = null;
        }
        DataTypes.endian_ness[1] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[2] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[4] = ByteOrder.LITTLE_ENDIAN;
        DataTypes.endian_ness[5] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[6] = ByteOrder.LITTLE_ENDIAN;
        DataTypes.endian_ness[7] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[9] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[12] = ByteOrder.BIG_ENDIAN;
        DataTypes.endian_ness[13] = ByteOrder.LITTLE_ENDIAN;
        DataTypes.endian_ness[16] = ByteOrder.LITTLE_ENDIAN;
        method = new Method[53];
        typeCategory = new int[53];
        size = new int[53];
        longInt = new long[53];
        for (i = 0; i < 53; ++i) {
            DataTypes.method[i] = null;
            DataTypes.size[i] = 1;
            DataTypes.typeCategory[i] = -1;
        }
        Class<ByteBuffer> bb = ByteBuffer.class;
        try {
            Method meth;
            DataTypes.method[1] = meth = bb.getMethod("get", new Class[0]);
            DataTypes.typeCategory[1] = 2;
            DataTypes.method[11] = meth;
            DataTypes.typeCategory[11] = 3;
            DataTypes.method[41] = meth;
            DataTypes.typeCategory[41] = 2;
            DataTypes.method[2] = meth = bb.getMethod("getShort", new Class[0]);
            DataTypes.typeCategory[2] = 2;
            DataTypes.size[2] = 2;
            DataTypes.method[12] = meth;
            DataTypes.typeCategory[12] = 3;
            DataTypes.size[12] = 2;
            DataTypes.method[4] = meth = bb.getMethod("getInt", new Class[0]);
            DataTypes.typeCategory[4] = 2;
            DataTypes.size[4] = 4;
            DataTypes.method[14] = meth;
            DataTypes.typeCategory[14] = 3;
            DataTypes.size[14] = 4;
            DataTypes.method[8] = meth = bb.getMethod("getLong", new Class[0]);
            DataTypes.typeCategory[8] = 5;
            DataTypes.size[8] = 8;
            DataTypes.method[33] = meth;
            DataTypes.typeCategory[33] = 5;
            DataTypes.size[33] = 8;
            DataTypes.method[21] = meth = bb.getMethod("getFloat", new Class[0]);
            DataTypes.typeCategory[21] = 0;
            DataTypes.size[21] = 4;
            DataTypes.method[44] = meth;
            DataTypes.typeCategory[44] = 0;
            DataTypes.size[44] = 4;
            DataTypes.method[22] = meth = bb.getMethod("getDouble", new Class[0]);
            DataTypes.typeCategory[22] = 1;
            DataTypes.size[22] = 8;
            DataTypes.method[45] = meth;
            DataTypes.typeCategory[45] = 1;
            DataTypes.size[45] = 8;
            DataTypes.method[31] = meth;
            DataTypes.typeCategory[31] = 1;
            DataTypes.size[31] = 8;
            DataTypes.method[32] = meth;
            DataTypes.typeCategory[32] = 1;
            DataTypes.size[32] = 8;
            DataTypes.typeCategory[41] = 2;
            DataTypes.typeCategory[51] = 4;
            DataTypes.typeCategory[52] = 4;
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        for (int i2 = 0; i2 < 53; ++i2) {
            if (size[i2] > 4) continue;
            DataTypes.longInt[i2] = 1L << 8 * size[i2];
        }
    }
}

