/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdf;

import gov.nasa.gsfc.voyager.cdf.CDF;
import gov.nasa.gsfc.voyager.cdf.CDFFactory;
import gov.nasa.gsfc.voyager.cdf.Variable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.cdf.CdfDataSetUtil;
import org.virbo.cdf.CdfUtil;
import org.virbo.cdf.CdfVirtualVars;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.datasource.MetadataModel;
import org.virbo.dsops.Ops;
import org.virbo.metatree.IstpMetadataModel;
import org.virbo.metatree.MetadataUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfJavaDataSource
extends AbstractDataSource {
    protected static final String PARAM_ID = "id";
    protected static final String PARAM_INTERPMETA = "interpMeta";
    protected static final String PARAM_DODEP = "doDep";
    protected static final String PARAM_SLICE1 = "slice1";
    static final Logger logger = Logger.getLogger("org.virbo.cdfjava");
    Map<String, Object> attributes;
    protected static final LinkedHashMap<String, CDF> openFiles = new LinkedHashMap();
    protected static final Map<CDF, String> openFilesRev = new HashMap<CDF, String>();
    protected static final Map<String, Long> openFilesFresh = new HashMap<String, Long>();
    protected static final LinkedHashMap<String, MutablePropertyDataSet> dsCache = new LinkedHashMap();
    protected static final HashMap<String, Long> dsCacheFresh = new HashMap();

    CdfJavaDataSource(URI uri) {
        super(uri);
    }

    private static synchronized void cdfCacheUnload(String fileName, boolean unloadDs) {
        CDF cdf = (CDF)openFiles.remove(fileName);
        openFilesRev.remove(cdf);
        openFilesFresh.remove(fileName);
        if (unloadDs) {
            ArrayList<String> unload = new ArrayList<String>();
            for (String ds : dsCache.keySet()) {
                if (!ds.startsWith(fileName)) continue;
                unload.add(ds);
            }
            for (String ds : unload) {
                dsCache.remove(ds);
                dsCacheFresh.remove(ds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDF getCdfFile(String fileName) {
        CDF cdf;
        block14: {
            try {
                cdf = openFiles.get(fileName);
                if (cdf == null) {
                    CdfJavaDataSource cdfJavaDataSource = this;
                    synchronized (cdfJavaDataSource) {
                        File cdfFile = new File(fileName);
                        if (!cdfFile.exists()) {
                            throw new IllegalArgumentException("CDF file does not exist: " + fileName);
                        }
                        if (cdfFile.length() == 0L) {
                            throw new IllegalArgumentException("CDF file length is zero: " + fileName);
                        }
                        cdf = CDFFactory.getCDF(fileName);
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                        if (openFiles.size() > 10) {
                            String oldest = openFiles.entrySet().iterator().next().getKey();
                            CdfJavaDataSource.cdfCacheUnload(oldest, true);
                        }
                        break block14;
                    }
                }
                CdfJavaDataSource cdfJavaDataSource = this;
                synchronized (cdfJavaDataSource) {
                    long date = openFilesFresh.get(fileName);
                    if (new File(fileName).lastModified() > date) {
                        cdf = CDFFactory.getCDF(fileName);
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                    } else {
                        CdfJavaDataSource.cdfCacheUnload(fileName, false);
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                        logger.log(Level.FINE, "using cached open CDF {0}", fileName);
                    }
                }
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return cdf;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        File cdfFile = this.getFile(mon);
        String fileName = cdfFile.toString();
        Map map = this.getParams();
        CDF cdf = this.getCdfFile(fileName);
        String svariable = (String)map.get(PARAM_ID);
        if (svariable == null) {
            svariable = (String)map.get("arg_0");
        }
        String constraint = null;
        String interpMeta = (String)map.get(PARAM_INTERPMETA);
        if (!"no".equals(interpMeta)) {
            int i = svariable.indexOf("[");
            if (i != -1) {
                constraint = svariable.substring(i);
                svariable = svariable.substring(0, i);
            }
            Variable variable = cdf.getVariable(svariable);
            long numRec = variable.getNumberOfValues();
            long[] recs = DataSourceUtil.parseConstraint((String)constraint, (long)numRec);
            if (this.attributes == null) {
                this.attributes = this.readAttributes(cdf, variable, 0);
                if (recs[2] == -1L) {
                    this.attributes = MetadataUtil.sliceProperties(this.attributes, (int)0);
                }
            }
        }
        QDataSet result = this.getDataSet(mon, this.attributes);
        String os1 = (String)map.get(PARAM_SLICE1);
        if (os1 != null && !os1.equals("") && result.rank() > 1) {
            int is = Integer.parseInt(os1);
            result = DataSetOps.slice1((QDataSet)result, (int)is);
            this.attributes = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDataSet getDataSet(ProgressMonitor mon, Map<String, Object> attr1) throws Exception {
        boolean doDep;
        MutablePropertyDataSet result;
        String lsurl = this.uri.toString();
        MutablePropertyDataSet cached = dsCache.get(lsurl);
        if (cached != null) {
            CdfJavaDataSource cdfJavaDataSource = this;
            synchronized (cdfJavaDataSource) {
                dsCache.remove(lsurl);
                dsCache.put(lsurl, cached);
                dsCacheFresh.put(lsurl, System.currentTimeMillis());
            }
        }
        File cdfFile = this.getFile(mon);
        String fileName = cdfFile.toString();
        Map map = this.getParams();
        CDF cdf = this.getCdfFile(fileName);
        String svariable = (String)map.get(PARAM_ID);
        if (svariable == null) {
            svariable = (String)map.get("arg_0");
        }
        if (svariable == null) {
            throw new IllegalArgumentException("CDF URI needs an argument");
        }
        String constraint = null;
        int i = svariable.indexOf("[");
        if (i != -1) {
            constraint = svariable.substring(i);
            svariable = svariable.substring(0, i);
        }
        String interpMeta = (String)map.get(PARAM_INTERPMETA);
        if (attr1 != null && attr1.containsKey("VIRTUAL") && attr1.containsKey("FUNCTION")) {
            ArrayList<QDataSet> attr = new ArrayList<QDataSet>();
            String function = (String)attr1.get("FUNCTION");
            if (attr1.get("COMPONENT_0") != null) {
                attr.add((QDataSet)this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_0"), constraint, false, true, null, mon));
            }
            if (attr1.get("COMPONENT_1") != null) {
                attr.add((QDataSet)this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_1"), constraint, false, true, null, mon));
            }
            if (attr1.get("COMPONENT_2") != null) {
                attr.add((QDataSet)this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_2"), constraint, false, true, null, mon));
            }
            if (attr1.get("COMPONENT_3") != null) {
                attr.add((QDataSet)this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_3"), constraint, false, true, null, mon));
            }
            if (attr1.get("COMPONENT_4") != null) {
                attr.add((QDataSet)this.wrapDataSet(cdf, (String)attr1.get("COMPONENT_4"), constraint, false, true, null, mon));
            }
            try {
                Map qmetadata = new IstpMetadataModel().properties(attr1);
                result = (MutablePropertyDataSet)CdfVirtualVars.execute(qmetadata, function, attr, mon);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("virtual function " + function + " not supported", ex);
            }
        } else {
            result = this.wrapDataSet(cdf, svariable, constraint, false, true, attr1, mon);
        }
        boolean bl = doDep = !"no".equals(map.get(PARAM_DODEP));
        if (!doDep) {
            result.putProperty("DEPEND_0", null);
            result.putProperty("DEPEND_1", null);
            result.putProperty("DEPEND_2", null);
            result.putProperty("DEPEND_3", null);
            if (attr1 != null) {
                attr1.remove("DEPEND_0");
                attr1.remove("DEPEND_1");
                attr1.remove("DEPEND_2");
                attr1.remove("DEPEND_3");
            }
        }
        if (!"no".equals(interpMeta)) {
            IstpMetadataModel model = new IstpMetadataModel();
            Map istpProps = model.properties(attr1);
            CdfUtil.maybeAddValidRange(istpProps, result);
            result.putProperty("FILL_VALUE", istpProps.get("FILL_VALUE"));
            result.putProperty("LABEL", istpProps.get("FIELDNAM"));
            result.putProperty("TITLE", istpProps.get("CATDESC"));
            if (result.rank() < 3 && result.rank() == 2 && result.length() > 0 && result.length(0) < 50) {
                String rt = (String)istpProps.get("RENDER_TYPE");
                if (rt != null) {
                    result.putProperty("RENDER_TYPE", (Object)rt);
                }
                if (istpProps.get("RENDER_TYPE") == null && result.property("DEPEND_1") == null) {
                    result.putProperty("RENDER_TYPE", (Object)"time_series");
                }
            }
            for (int j = 0; j < 4; ++j) {
                MutablePropertyDataSet depds = (MutablePropertyDataSet)result.property("DEPEND_" + j);
                Map depProps = (Map)istpProps.get("DEPEND_" + j);
                if (depds == null || depProps == null) continue;
                CdfUtil.maybeAddValidRange(depProps, depds);
                depds.putProperty("FILL_VALUE", depProps.get("FILL_VALUE"));
                depds.putProperty("LABEL", depProps.get("FIELDNAM"));
                depds.putProperty("TITLE", depProps.get("CATDESC"));
            }
        } else {
            QDataSet dep = (QDataSet)result.property("DEPEND_0");
            if (dep != null && dep.length() != result.length()) {
                result.putProperty("DEPEND_0", null);
            }
            result.putProperty("DEPEND_1", null);
            result.putProperty("DEPEND_2", null);
            result.putProperty("DEPEND_3", null);
        }
        result.putProperty("METADATA", attr1);
        result.putProperty("METADATA_MODEL", (Object)"ISTP-CDF");
        return result;
    }

    private synchronized HashMap<String, Object> readAttributes(CDF cdf, Variable var, int depth) {
        String[] vv;
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        Pattern p = Pattern.compile("DEPEND_[0-9]");
        try {
            vv = cdf.variableAttributeNames(var.getName());
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            throw ex;
        }
        for (int ipass = 0; ipass < 2; ++ipass) {
            for (int i = 0; i < vv.length; ++i) {
                Object val;
                Object attrv = cdf.getAttribute(var.getName(), vv[i]);
                Object entry = null;
                boolean isDep = p.matcher(vv[i]).matches() & depth == 0;
                if (ipass == 0 && isDep) {
                    String name = (String)((Vector)attrv).get(0);
                    if (cdf.getVariable(name) != null) {
                        HashMap<String, Object> newVal = this.readAttributes(cdf, cdf.getVariable(name), depth + 1);
                        newVal.put("NAME", name);
                        props.put(vv[i], newVal);
                        continue;
                    }
                    System.err.println("No such variable: " + name + " in CDF ");
                    continue;
                }
                if (ipass != 1 || isDep || (val = ((Vector)attrv).get(0)) == null) continue;
                if (val.getClass().isArray() && Array.getLength(val) == 1) {
                    val = Array.get(val, 0);
                }
                props.put(vv[i], val);
            }
        }
        return props;
    }

    private MutablePropertyDataSet wrapDataSet(CDF cdf, String svariable, String constraints, boolean reform, boolean depend, Map<String, Object> attr) throws Exception, ParseException {
        return this.wrapDataSet(cdf, svariable, constraints, reform, depend, attr, (ProgressMonitor)new NullProgressMonitor());
    }

    private MutablePropertyDataSet wrapDataSet(CDF cdf, String svariable, String constraints, boolean reform, boolean depend, Map<String, Object> thisAttributes, ProgressMonitor mon) throws Exception, ParseException {
        boolean doFill;
        MutablePropertyDataSet result;
        boolean slice;
        Variable variable = cdf.getVariable(svariable);
        if (variable == null) {
            throw new IllegalArgumentException("No such variable: " + svariable);
        }
        if (thisAttributes == null) {
            thisAttributes = this.readAttributes(cdf, variable, 0);
        }
        long numRec = variable.getNumberOfValues();
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        if (numRec == 0L) {
            if (thisAttributes.containsKey("COMPONENT_0")) {
                MutablePropertyDataSet c0 = this.wrapDataSet(cdf, (String)thisAttributes.get("COMPONENT_0"), constraints, true, false, null);
                if (thisAttributes.containsKey("COMPONENT_1")) {
                    MutablePropertyDataSet c1 = this.wrapDataSet(cdf, (String)thisAttributes.get("COMPONENT_1"), constraints, false, false, null);
                    if (c0.rank() == 1 && CdfDataSetUtil.validCount((QDataSet)c0, 2) == 1 && c1.length() > 1 && Units.cdfEpoch == (c0 = DataSetOps.slice0((QDataSet)c0, (int)0)).property("UNITS")) {
                        double value = ((RankZeroDataSet)c0).value();
                        double valueUs2000 = Units.cdfEpoch.convertDoubleTo((Units)Units.us2000, value);
                        c0 = DataSetUtil.asDataSet((Datum)Units.us2000.createDatum(valueUs2000));
                    }
                    if (c0.property("UNITS") != null && c1.property("UNITS") != null) {
                        c0 = Ops.add((QDataSet)c0, (QDataSet)c1);
                    }
                }
                return DDataSet.maybeCopy((QDataSet)c0);
            }
            throw new IllegalArgumentException("variable " + svariable + " contains no records!");
        }
        long[] recs = DataSourceUtil.parseConstraint((String)constraints, (long)numRec);
        boolean bl = slice = recs[1] == -1L;
        if (reform) {
            result = CdfUtil.wrapCdfHyperDataHacked(cdf, variable, 0L, -1L, 1L, (ProgressMonitor)new NullProgressMonitor());
        } else {
            long recCount = (recs[1] - recs[0]) / recs[2];
            if (slice) {
                recCount = -1L;
                recs[2] = 1L;
            }
            result = CdfUtil.wrapCdfHyperDataHacked(cdf, variable, recs[0], recCount, recs[2], mon);
        }
        result.putProperty("NAME", (Object)svariable);
        boolean doUnits = true;
        Units units = null;
        if (thisAttributes.containsKey("UNITS")) {
            String sunits = (String)thisAttributes.get("UNITS");
            Units mu = sunits.equalsIgnoreCase("row number") || sunits.equalsIgnoreCase("column number") ? Units.dimensionless : SemanticOps.lookupUnits((String)sunits);
            Units u = (Units)result.property("UNITS");
            if (u == null) {
                result.putProperty("UNITS", (Object)mu);
                units = mu;
            } else {
                units = u;
            }
        } else {
            units = Units.dimensionless;
        }
        boolean bl2 = doFill = !UnitsUtil.isTimeLocation((Units)units);
        if (doFill) {
            Object f = thisAttributes.get("FILLVAL");
            double dv = IstpMetadataModel.doubleValue((Object)f, (Units)units, (double)Double.NaN, (Object)IstpMetadataModel.VALUE_MIN);
            if (!Double.isNaN(dv)) {
                result.putProperty("FILL_VALUE", (Object)dv);
            }
            DatumRange vrange = IstpMetadataModel.getValidRange(thisAttributes, (Units)units);
            result.putProperty("VALID_MIN", (Object)vrange.min().doubleValue(units));
            result.putProperty("VALID_MAX", (Object)vrange.max().doubleValue(units));
        }
        int[] qubeDims = DataSetUtil.qubeDims((QDataSet)result);
        if (depend) {
            for (int idep = 0; idep < 4; ++idep) {
                int sidep = slice ? idep + 1 : idep;
                Map dep = (Map)thisAttributes.get("DEPEND_" + sidep);
                String labl = (String)thisAttributes.get("LABL_PTR_" + sidep);
                if (labl == null) {
                    labl = (String)thisAttributes.get("LABEL_" + sidep);
                }
                if (dep != null && qubeDims.length <= idep) {
                    logger.log(Level.INFO, "DEPEND_{0} found but data is lower rank", idep);
                    continue;
                }
                if (dep != null && (qubeDims[idep] > 6 || labl == null)) {
                    try {
                        boolean reformDep;
                        String depName = (String)dep.get("NAME");
                        boolean bl3 = reformDep = idep > 0;
                        if (reformDep && cdf.getVariable(depName).recordVariance()) {
                            reformDep = false;
                        }
                        MutablePropertyDataSet depDs = this.wrapDataSet(cdf, depName, idep == 0 ? constraints : null, reformDep, false, dep, null);
                        if (idep > 0 && !reformDep && depDs.length() == 1 && qubeDims[0] > depDs.length()) {
                            depDs = (MutablePropertyDataSet)depDs.slice(0);
                        }
                        if (idep == 0 && depDs.length() != result.length() && result.length() == 1) continue;
                        if (depDs.rank() == 2 && depDs.length(0) == 2) {
                            MutablePropertyDataSet depDs1 = (MutablePropertyDataSet)Ops.reduceMean((QDataSet)depDs, (int)1);
                            MutablePropertyDataSet binmax = DataSetOps.slice1((QDataSet)depDs, (int)1);
                            MutablePropertyDataSet binmin = DataSetOps.slice1((QDataSet)depDs, (int)0);
                            depDs1.putProperty("DELTA_MINUS", (Object)Ops.subtract((QDataSet)depDs1, (QDataSet)binmin));
                            depDs1.putProperty("DELTA_PLUS", (Object)Ops.subtract((QDataSet)binmax, (QDataSet)depDs1));
                            depDs = depDs1;
                        }
                        if (DataSetUtil.isMonotonic((QDataSet)depDs)) {
                            depDs.putProperty("MONOTONIC", (Object)Boolean.TRUE);
                        }
                        result.putProperty("DEPEND_" + idep, (Object)depDs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (labl == null) continue;
                try {
                    if (cdf.getVariable(labl) == null) {
                        throw new IllegalArgumentException("no such variable: " + labl + " referred to by variable: " + svariable);
                    }
                    MutablePropertyDataSet depDs = this.wrapDataSet(cdf, labl, idep == 0 ? constraints : null, idep > 0, false, null);
                    result.putProperty("DEPEND_" + idep, (Object)depDs);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        boolean swapHack = false;
        if (result.rank() == 3) {
            int n1 = result.length(0);
            int n2 = result.length(0, 0);
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            QDataSet dep2 = (QDataSet)result.property("DEPEND_2");
            if (n1 != n2 && dep1 != null && dep1.length() == n2 && dep2 != null && dep2.length() == n1) {
                swapHack = true;
                System.err.println("swaphack avoids runtime error");
            }
        }
        if (slice && result.rank() == 2) {
            int n0 = result.length();
            int n1 = result.length(0);
            QDataSet dep0 = (QDataSet)result.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            if (n0 != n1 && dep0 != null && dep0.length() == n1 && dep1 != null && dep1.length() == n0) {
                swapHack = true;
                System.err.println("swaphack avoids runtime error");
            }
        }
        if (swapHack && result.rank() == 3) {
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            QDataSet dep2 = (QDataSet)result.property("DEPEND_2");
            result.putProperty("DEPEND_2", (Object)dep1);
            result.putProperty("DEPEND_1", (Object)dep2);
            Object att1 = this.attributes.get("DEPEND_1");
            Object att2 = this.attributes.get("DEPEND_2");
            this.attributes.put("DEPEND_1", att2);
            this.attributes.put("DEPEND_2", att1);
        }
        if (swapHack && slice && result.rank() == 2) {
            QDataSet dep0 = (QDataSet)result.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            result.putProperty("DEPEND_1", (Object)dep0);
            result.putProperty("DEPEND_0", (Object)dep1);
            Object att0 = this.attributes.get("DEPEND_0");
            Object att1 = this.attributes.get("DEPEND_1");
            this.attributes.put("DEPEND_0", att1);
            this.attributes.put("DEPEND_1", att0);
        }
        return result;
    }

    public MetadataModel getMetadataModel() {
        return new IstpMetadataModel();
    }

    public synchronized Map<String, Object> getMetadata(ProgressMonitor mon) throws IOException {
        if (this.attributes == null) {
            try {
                Variable variable;
                File cdfFile = this.getFile(mon);
                String fileName = cdfFile.toString();
                Map map = this.getParams();
                if (map.containsKey(PARAM_SLICE1)) {
                    return null;
                }
                CDF cdf = CDFFactory.getCDF(fileName);
                String svariable = (String)map.get(PARAM_ID);
                if (svariable == null) {
                    svariable = (String)map.get("arg_0");
                }
                if (svariable == null) {
                    throw new IllegalArgumentException("variable not specified");
                }
                int i = svariable.indexOf("[");
                if (i != -1) {
                    svariable = svariable.substring(0, i);
                }
                if ((variable = cdf.getVariable(svariable)) == null) {
                    throw new IllegalArgumentException("No such variable \"" + svariable + "\"");
                }
                this.attributes = this.readAttributes(cdf, variable, 0);
                return this.attributes;
            }
            catch (Throwable ex) {
                if (ex instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)ex;
                }
                throw new IOException(ex.getMessage());
            }
        }
        return this.attributes;
    }

    private QDataSet labelToBundleDs(QDataSet depDs) {
        IDataSet result = IDataSet.createRank2((int)depDs.length(), (int)1);
        Units u = (Units)depDs.property("UNITS");
        for (int i = 0; i < depDs.length(); ++i) {
            String labl1 = u.createDatum(depDs.value()).toString();
            result.putProperty("LABEL__" + i, (Object)labl1);
            result.putProperty("NAME__" + i, (Object)Ops.safeName((String)labl1));
            result.putValue(i, 0, 1.0);
        }
        return result;
    }

    private void newDepLogic(CDF cdf, Variable variable, String constraints, Map<String, Object> thisAttributes, int idep, MutablePropertyDataSet result) throws Exception {
        Map dep = (Map)thisAttributes.get("DEPEND_" + idep);
        String labl = (String)thisAttributes.get("LABL_PTR_" + idep);
        if (labl == null) {
            labl = (String)thisAttributes.get("LABEL_" + idep);
        }
        if (dep != null) {
            boolean reformDep;
            String depName = (String)dep.get("NAME");
            boolean bl = reformDep = idep > 0;
            if (reformDep && cdf.getVariable(depName).recordVariance()) {
                reformDep = false;
            }
            MutablePropertyDataSet depDs = this.wrapDataSet(cdf, depName, idep == 0 ? constraints : null, reformDep, false, dep, null);
            if (idep > 0 && !reformDep && depDs.length() == 1 && variable.getNumberOfValues() > depDs.length()) {
                depDs = (MutablePropertyDataSet)depDs.slice(0);
            }
            if (idep == 0 && depDs.length() != result.length() && result.length() == 1) {
                return;
            }
            if (depDs.rank() == 2 && depDs.length(0) == 2) {
                MutablePropertyDataSet depDs1 = (MutablePropertyDataSet)Ops.reduceMean((QDataSet)depDs, (int)1);
                MutablePropertyDataSet binmax = DataSetOps.slice1((QDataSet)depDs, (int)1);
                MutablePropertyDataSet binmin = DataSetOps.slice1((QDataSet)depDs, (int)0);
                depDs1.putProperty("DELTA_MINUS", (Object)Ops.subtract((QDataSet)depDs1, (QDataSet)binmin));
                depDs1.putProperty("DELTA_PLUS", (Object)Ops.subtract((QDataSet)binmax, (QDataSet)depDs1));
                depDs = depDs1;
            }
            if (DataSetUtil.isMonotonic((QDataSet)depDs)) {
                depDs.putProperty("MONOTONIC", (Object)Boolean.TRUE);
            }
            result.putProperty("DEPEND_" + idep, (Object)depDs);
        }
        if (labl != null) {
            try {
                if (cdf.getVariable(labl) == null) {
                    throw new IllegalArgumentException("no such variable: " + labl + " referred to by variable: " + variable.getName());
                }
                MutablePropertyDataSet depDs = this.wrapDataSet(cdf, labl, idep == 0 ? constraints : null, idep > 0, false, null);
                QDataSet bds = this.labelToBundleDs((QDataSet)depDs);
                result.putProperty("BUNDLE_" + idep, (Object)bds);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

