/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.cdf;

import gov.nasa.gsfc.voyager.cdf.Attribute;
import gov.nasa.gsfc.voyager.cdf.CDF;
import gov.nasa.gsfc.voyager.cdf.Variable;
import gov.nasa.gsfc.voyager.cdf.VariableDataLocator;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.binarydatasource.BufferDataSet;
import org.virbo.cdf.CdfJavaDataSource;
import org.virbo.cdf.CdfVirtualVars;
import org.virbo.cdf.TrArrayDataSet;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.datasource.DataSourceUtil;
import org.virbo.dsops.Ops;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfUtil {
    private static final Logger logger = Logger.getLogger("virbo.cdfdatasource");

    private static double doubleValue(Object o) {
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }

    public static DatumRange getRange(HashMap attrs) {
        DatumRange range = attrs.containsKey("SCALEMIN") && attrs.containsKey("SCALEMAX") ? new DatumRange(CdfUtil.doubleValue(attrs.get("SCALEMIN")), CdfUtil.doubleValue(attrs.get("SCALEMAX")), Units.dimensionless) : new DatumRange(CdfUtil.doubleValue(attrs.get("VALIDMIN")), CdfUtil.doubleValue(attrs.get("VALIDMAX")), Units.dimensionless);
        return range;
    }

    public static String getScaleType(HashMap attrs) {
        String type = "linear";
        if (attrs.containsKey("SCALETYP")) {
            type = (String)attrs.get("SCALETYP");
        }
        return type;
    }

    public static void maybeAddValidRange(Map<String, Object> props, MutablePropertyDataSet ds) {
        String t;
        Number nmin;
        UnitsConverter uc;
        Units pu = (Units)props.get("UNITS");
        Units u = (Units)ds.property("UNITS");
        if (pu == null || u == null) {
            uc = UnitsConverter.IDENTITY;
        } else if (u == Units.cdfEpoch) {
            uc = UnitsConverter.IDENTITY;
        } else if (pu == Units.microseconds && u == Units.us2000) {
            uc = UnitsConverter.IDENTITY;
        } else if (pu == u) {
            uc = UnitsConverter.IDENTITY;
        } else {
            if (UnitsUtil.isOrdinalMeasurement((Units)u) || UnitsUtil.isOrdinalMeasurement((Units)pu)) {
                return;
            }
            try {
                uc = UnitsConverter.getConverter((Units)pu, (Units)u);
            }
            catch (InconvertibleUnitsException ex) {
                uc = UnitsConverter.IDENTITY;
            }
        }
        double dmin = Double.NEGATIVE_INFINITY;
        double dmax = Double.POSITIVE_INFINITY;
        if (ds.rank() == 1) {
            QDataSet range = Ops.extent((QDataSet)ds);
            dmin = uc.convert(range.value(0));
            dmax = uc.convert(range.value(1));
        }
        double vmin = (nmin = (Number)props.get("VALID_MIN")) == null ? Double.POSITIVE_INFINITY : nmin.doubleValue();
        Number nmax = (Number)props.get("VALID_MAX");
        double vmax = nmax == null ? Double.POSITIVE_INFINITY : nmax.doubleValue();
        boolean intersects = false;
        if (dmax > vmin && dmin < vmax) {
            intersects = true;
        }
        if (u instanceof EnumerationUnits) {
            EnumerationUnits eu = (EnumerationUnits)u;
            if (nmax.intValue() <= eu.getHighestOrdinal()) {
                nmax = eu.getHighestOrdinal() + 1;
            }
        }
        if (intersects || dmax == dmin || dmax < -1.0E30 || dmin > 1.0E30) {
            if (nmax != null) {
                ds.putProperty("VALID_MAX", (Object)uc.convert(nmax));
            }
            if (nmin != null) {
                ds.putProperty("VALID_MIN", (Object)uc.convert(nmin));
            }
        }
        if ((t = (String)props.get("SCALE_TYPE")) != null) {
            ds.putProperty("SCALE_TYPE", (Object)t);
        }
    }

    private static long sizeOf(int dims, int[] dimSizes, long itype, long rc) {
        long sizeBytes;
        long size;
        long l = size = dims == 0 ? rc : rc * (long)DataSetUtil.product((int[])dimSizes);
        if (itype == 32L) {
            sizeBytes = 16L;
        } else if (itype == 45L || itype == 22L || itype == 31L) {
            sizeBytes = 8L;
        } else if (itype == 44L || itype == 21L || itype == 4L || itype == 14L) {
            sizeBytes = 4L;
        } else if (itype == 2L || itype == 12L) {
            sizeBytes = 8L;
        } else if (itype == 1L || itype == 11L || itype == 41L || itype == 52L || itype == 51L) {
            sizeBytes = 8L;
        } else {
            throw new IllegalArgumentException("didn't code for type");
        }
        return size *= sizeBytes;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MutablePropertyDataSet wrapCdfHyperDataHacked(CDF cdf, Variable variable, long recStart, long recCount, long recInterval, ProgressMonitor mon) throws Exception {
        void var20_29;
        String cdfFile;
        int tr;
        int i;
        int[] qube;
        int dims;
        String cdfFile2 = CdfJavaDataSource.openFilesRev.get(cdf);
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        long varType = variable.getType();
        int[] dimSizes = variable.getDimensions();
        boolean[] dimVaries = variable.getVarys();
        if (variable.getEffectiveRank() != dimSizes.length) {
            int[] dimSizes1 = new int[variable.getEffectiveRank()];
            System.arraycopy(dimSizes, 0, dimSizes1, 0, variable.getEffectiveRank());
            dimSizes = dimSizes1;
        }
        if ((dims = dimSizes == null ? 0 : dimSizes.length) > 3 && recCount != -1L) {
            throw new IllegalArgumentException("rank 5 not implemented");
        }
        int varRecCount = variable.getNumberOfValues();
        if (recCount == -1L && recStart > 0L && varRecCount == 1) {
            recStart = 0L;
        }
        Object odata = null;
        ByteBuffer[] buf = null;
        boolean useBuf = false;
        long rc = recCount;
        if (rc == -1L) {
            rc = 1L;
        }
        logger.log(Level.FINEST, "size of {0}: {1}  type: {2}", new Object[]{variable.getName(), (double)CdfUtil.sizeOf(dims, dimSizes, varType, rc) / 1024.0 / 1024.0, varType});
        try {
            if (recStart == 0L && (recCount == -1L || recCount == (long)varRecCount) && recInterval == 1L) {
                if (useBuf && variable.rowMajority() && ((long)variable.getType() == 44L || (long)variable.getType() == 21L)) {
                    VariableDataLocator variableDataLocator = variable.getLocator();
                    int[][] intloc = variableDataLocator.getLocations();
                    ByteBuffer buff = variable.getBuffer();
                    buf = new ByteBuffer[intloc.length];
                    for (int part = 0; part < intloc.length; ++part) {
                        ByteBuffer chunk;
                        int nrec = intloc[part][1] - intloc[part][0] + 1;
                        int reclen = variable.getDataItemSize();
                        buff.limit(intloc[part][2] + nrec * reclen);
                        buff.position(intloc[part][2]);
                        buf[part] = chunk = buff.slice();
                    }
                } else {
                    odata = cdf.get1D(variable.getName(), true);
                }
            } else {
                int[] nArray = new int[dims + 1];
                for (int i2 = 0; i2 < dims + 1; ++i2) {
                    nArray[i2] = 1;
                }
                nArray[0] = (int)recInterval;
                odata = cdf.get1D(variable.getName(), (int)recStart, (int)(recStart + rc * recInterval), nArray);
            }
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof Exception)) throw new Exception(throwable);
            throw (Exception)throwable;
        }
        if (odata == null && buf == null && varType != 51L && varType != 52L) {
            System.err.println("something went wrong");
            throw new NullPointerException("something went wrong");
        }
        if (dims == 0) {
            dimSizes = new int[]{};
        }
        if (dimVaries.length > 0 && !dimVaries[0] && dimSizes.length != 0) {
            System.err.println("here at 307 CdfUtil");
        }
        if (!variable.rowMajority()) {
            int n = dimSizes.length;
            for (int i3 = 0; i3 < n / 2; ++i3) {
                int t = dimSizes[i3];
                dimSizes[i3] = dimSizes[n - i3 - 1];
                dimSizes[n - i3 - 1] = t;
            }
        }
        if (recCount == -1L) {
            qube = new int[dimSizes.length];
            for (i = 0; i < dimSizes.length; ++i) {
                qube[i] = dimSizes[i];
            }
        } else {
            qube = new int[1 + dimSizes.length];
            for (i = 0; i < dimSizes.length; ++i) {
                qube[1 + i] = dimSizes[i];
            }
            qube[0] = (int)recCount;
        }
        if (!variable.rowMajority()) {
            buf = null;
        }
        if (variable.rowMajority()) {
            if (useBuf && buf != null) {
                Object type;
                if ((long)variable.getType() != 44L && (long)variable.getType() != 21L) throw new IllegalArgumentException("internal error unimplemented: " + variable.getType());
                int reclen = 1;
                for (int i4 = 1; i4 < qube.length; ++i4) {
                    reclen *= qube[i4];
                }
                switch (variable.getType()) {
                    case 44: {
                        type = BufferDataSet.FLOAT;
                        break;
                    }
                    case 21: {
                        type = BufferDataSet.FLOAT;
                        break;
                    }
                    default: {
                        throw new RuntimeException("bad type!");
                    }
                }
                ByteBuffer aggBuffer = ByteBuffer.allocate((reclen *= BufferDataSet.byteCount((Object)type)) * qube[0]);
                for (int i5 = 0; i5 < buf.length; ++i5) {
                    aggBuffer.put(buf[i5]);
                }
                aggBuffer.flip();
                BufferDataSet bufferDataSet = BufferDataSet.makeDataSet((int)qube.length, (int)reclen, (int)0, (int)qube[0], (int)(qube.length < 2 ? 1 : qube[1]), (int)(qube.length < 3 ? 1 : qube[2]), (int)(qube.length < 4 ? 1 : qube[3]), (ByteBuffer)aggBuffer, (Object)type);
            } else {
                ArrayDataSet arrayDataSet = ArrayDataSet.wrap((Object)odata, (int[])qube, (boolean)false);
            }
        } else if (recCount == -1L) {
            if (qube.length == 2) {
                tr = qube[1];
                qube[1] = qube[0];
                qube[0] = tr;
            } else if (qube.length == 3) {
                tr = qube[2];
                qube[2] = qube[0];
                qube[0] = tr;
            } else if (qube.length > 4) {
                throw new IllegalArgumentException("rank limit");
            }
            int[] qqube = new int[qube.length + 1];
            qqube[0] = 1;
            System.arraycopy(qube, 0, qqube, 1, qube.length);
            MutablePropertyDataSet mutablePropertyDataSet = (MutablePropertyDataSet)TrArrayDataSet.wrap(odata, qqube, false).slice(0);
        } else {
            if (qube.length == 3) {
                tr = qube[2];
                qube[2] = qube[1];
                qube[1] = tr;
            } else if (qube.length == 4) {
                tr = qube[3];
                qube[3] = qube[1];
                qube[1] = tr;
            } else if (qube.length > 4) {
                throw new IllegalArgumentException("rank limit");
            }
            TrArrayDataSet trArrayDataSet = TrArrayDataSet.wrap(odata, qube, false);
        }
        if (varType == 51L || varType == 52L) {
            boolean canSlice;
            String[] sdata;
            Object o;
            EnumerationUnits units = EnumerationUnits.create((Object)variable.getName());
            try {
                if (recInterval > 1L) {
                    throw new IllegalArgumentException("recInterval>1 not supported here");
                }
                o = cdf.get(variable.getName());
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
            Object o0 = Array.get(o, 0);
            if (o0.getClass().isArray()) {
                sdata = new String[Array.getLength(o0)];
                for (int j = 0; j < Array.getLength(o0); ++j) {
                    sdata[j] = Ops.saferName((String)((String)Array.get(o0, j)));
                }
            } else {
                if (o0.getClass() != String.class) throw new IllegalArgumentException("not handled single array where expected double array");
                sdata = new String[]{Ops.saferName((String)String.valueOf(o0))};
            }
            int[] back = new int[sdata.length];
            for (int i6 = 0; i6 < sdata.length; ++i6) {
                back[i6] = (int)units.createDatum((Object)sdata[i6]).doubleValue((Units)units);
            }
            boolean[] varies = variable.getVarys();
            boolean bl = canSlice = recCount == -1L;
            if (canSlice) {
                for (int i7 = 1; i7 < varies.length; ++i7) {
                    canSlice = canSlice && !varies[i7];
                }
            }
            if (canSlice) {
                qube = new int[]{qube[0]};
            }
            ArrayDataSet arrayDataSet = ArrayDataSet.wrap((Object)back, (int[])qube, (boolean)false);
            arrayDataSet.putProperty("UNITS", (Object)units);
        } else if (varType == 31L) {
            if (qube.length == 2 && qube[1] == 1) {
                qube = new int[]{qube[0]};
            }
            ArrayDataSet arrayDataSet = ArrayDataSet.wrap((Object)odata, (int[])qube, (boolean)false);
            arrayDataSet.putProperty("UNITS", (Object)Units.cdfEpoch);
            arrayDataSet.putProperty("VALID_MIN", (Object)1.0);
        } else if (varType == 32L) {
            double[] data = (double[])odata;
            double[] dresult = new double[data.length / 2];
            for (int i8 = 0; i8 < dresult.length; ++i8) {
                double t2000 = data[i8 * 2] - 6.3113904E10;
                dresult[i8] = t2000 * 1000000.0 + data[i8 * 2 + 1] / 1000000.0;
            }
            int[] qube1 = new int[qube.length - 1];
            System.arraycopy(qube, 0, qube1, 0, qube.length - 1);
            ArrayDataSet arrayDataSet = ArrayDataSet.wrap((Object)dresult, (int[])qube1, (boolean)false);
            arrayDataSet.putProperty("UNITS", (Object)Units.us2000);
        }
        if (varType != 31L && varType != 32L || (cdfFile = CdfJavaDataSource.openFilesRev.get(cdf)) == null) return var20_29;
        String uri = cdfFile + "?" + variable.getName();
        if (recStart != 0L || recCount != (long)variable.getNumberOfValues() || recInterval > 1L) {
            uri = uri + "[" + recStart + ":" + (recStart + recCount) + ":" + recInterval + "]";
        }
        CdfJavaDataSource.dsCache.put(uri, (MutablePropertyDataSet)var20_29);
        CdfJavaDataSource.dsCacheFresh.put(uri, System.currentTimeMillis());
        return var20_29;
    }

    public static int jvmMemory(QDataSet ds) {
        if (ds instanceof ArrayDataSet) {
            return ((ArrayDataSet)ds).jvmMemory();
        }
        if (ds instanceof TrArrayDataSet) {
            return ((TrArrayDataSet)ds).jvmMemory();
        }
        if (ds instanceof Slice0DataSet) {
            return 0;
        }
        throw new IllegalArgumentException("not supported type of QDataSet: " + ds);
    }

    public static Map<String, String> getPlottable(CDF cdf, boolean dataOnly, int rankLimit) throws Exception {
        return CdfUtil.getPlottable(cdf, dataOnly, rankLimit, false, false);
    }

    public static String getStringDataType(int type) {
        switch (type) {
            case 1: {
                return "CDF_INT1";
            }
            case 2: {
                return "CDF_INT2";
            }
            case 4: {
                return "CDF_INT4";
            }
            case 11: {
                return "CDF_UINT1";
            }
            case 12: {
                return "CDF_UINT2";
            }
            case 14: {
                return "CDF_UINT4";
            }
            case 41: {
                return "CDF_BYTE";
            }
            case 21: {
                return "CDF_REAL4";
            }
            case 22: {
                return "CDF_REAL8";
            }
            case 44: {
                return "CDF_FLOAT";
            }
            case 45: {
                return "CDF_DOUBLE";
            }
            case 31: {
                return "CDF_EPOCH";
            }
            case 32: {
                return "CDF_EPOCH16";
            }
            case 51: {
                return "CDF_CHAR";
            }
        }
        return String.valueOf(type);
    }

    private static Object getAttribute(CDF cdf, String var, String attrname) {
        Object att = cdf.getAttribute(var, attrname);
        if (att == null) {
            return null;
        }
        if (((Vector)att).size() == 0) {
            return null;
        }
        att = ((Vector)att).get(0);
        return att;
    }

    public static boolean hasAttribute(CDF cdf, String var, String attrname) {
        Object att = cdf.getAttribute(var, attrname);
        return att != null;
    }

    public static Map<String, String> getPlottable(CDF cdf, boolean dataOnly, int rankLimit, boolean deep, boolean master) throws Exception {
        int i;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> dependent = new LinkedHashMap<String, String>();
        boolean isMaster = master;
        logger.fine("getting CDF variables");
        String[] v = cdf.getVariableNames();
        logger.log(Level.FINE, "got {0} variables", v.length);
        Attribute virtual = null;
        logger.fine("getting CDF attributes");
        try {
            virtual = (Attribute)cdf.getAttribute("VIRTUAL");
        }
        catch (Exception e) {
            // empty catch block
        }
        int skipCount = 0;
        for (i = 0; i < v.length; ++i) {
            Object varType;
            Variable var = cdf.getVariable(v[i]);
            if (!dataOnly || (varType = CdfUtil.getAttribute(cdf, var.getName(), "VAR_TYPE")) != null && varType.equals("data")) continue;
            ++skipCount;
        }
        if (skipCount == v.length) {
            System.err.println("turning off dataOnly because it rejects everything");
            dataOnly = false;
        }
        for (i = 0; i < v.length; ++i) {
            Object att;
            Object varType;
            int rank;
            String vdescr = null;
            Variable var = cdf.getVariable(v[i]);
            if ((long)var.getType() == 51L || (long)var.getType() == 52L) continue;
            ArrayList<String> warn = new ArrayList<String>();
            long maxRec = var.getNumberOfValues();
            int[] dims = var.getDimensions();
            boolean[] dimVary = var.getVarys();
            if (dimVary.length > 0 && !dimVary[0]) {
                dims = new int[]{};
            }
            if ((rank = dims == null ? 1 : dims.length + 1) > rankLimit) continue;
            if (var.getName().equals("Time_PB5")) {
                logger.log(Level.FINE, "skipping {0} because we always skip Time_PB5", var.getName());
                continue;
            }
            if (dataOnly && ((varType = CdfUtil.getAttribute(cdf, var.getName(), "VAR_TYPE")) == null || !varType.equals("data"))) continue;
            Variable xDependVariable = null;
            long xMaxRec = -1L;
            Variable yDependVariable = null;
            long yNumRec = -1L;
            Variable zDependVariable = null;
            long zNumRec = -1L;
            Variable z1DependVariable = null;
            long z1NumRec = -1L;
            String scatDesc = null;
            String svarNotes = null;
            try {
                att = CdfUtil.getAttribute(cdf, var.getName(), "VIRTUAL");
                if (att != null) {
                    logger.log(Level.FINE, "get attribute VIRTUAL entry for {0}", var.getName());
                    if (String.valueOf(att).toUpperCase().equals("TRUE")) {
                        String funct = (String)CdfUtil.getAttribute(cdf, var.getName(), "FUNCTION");
                        if (funct == null) {
                            funct = (String)CdfUtil.getAttribute(cdf, var.getName(), "FUNCT");
                        }
                        if (!CdfVirtualVars.isSupported(funct)) {
                            if (funct.startsWith("comp_themis")) continue;
                            System.err.println("virtual function not supported: " + funct);
                            continue;
                        }
                        vdescr = funct + "( ";
                        int icomp = 0;
                        String comp = (String)CdfUtil.getAttribute(cdf, var.getName(), "COMPONENT_" + icomp);
                        if (comp != null) {
                            vdescr = vdescr + comp;
                            ++icomp;
                        }
                        while (icomp < 5 && (comp = (String)CdfUtil.getAttribute(cdf, var.getName(), "COMPONENT_" + icomp)) != null) {
                            vdescr = vdescr + ", " + comp;
                            ++icomp;
                        }
                        vdescr = vdescr + " )";
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (CdfUtil.hasAttribute(cdf, var.getName(), "DEPEND_0") && (att = CdfUtil.getAttribute(cdf, var.getName(), "DEPEND_0")) != null) {
                    logger.log(Level.FINE, "get attribute DEPEND_0 entry for {0}", var.getName());
                    xDependVariable = cdf.getVariable(String.valueOf(String.valueOf(att)));
                    xMaxRec = xDependVariable.getNumberOfValues();
                    if (xMaxRec != maxRec) {
                        if (maxRec == -1L) {
                            ++maxRec;
                        }
                        warn.add("depend0 length is inconsistent with length (" + maxRec + ")");
                    }
                }
            }
            catch (Exception e) {
                warn.add("problem with DEPEND_0: " + e.getMessage());
            }
            try {
                if (CdfUtil.hasAttribute(cdf, var.getName(), "DEPEND_1") && (att = CdfUtil.getAttribute(cdf, var.getName(), "DEPEND_1")) != null && rank > 1) {
                    logger.log(Level.FINE, "get attribute DEPEND_1 entry for {0}", var.getName());
                    yDependVariable = cdf.getVariable(String.valueOf(String.valueOf(att)));
                    yNumRec = yDependVariable.getNumberOfValues();
                    if (yNumRec == 1L) {
                        yNumRec = yDependVariable.getDimensions()[0] - 1;
                    }
                    if (dims.length > 0 && yNumRec != (long)dims[0]) {
                        warn.add("depend1 length is inconsistent with length (" + dims[0] + ")");
                    }
                }
            }
            catch (Exception e) {
                warn.add("problem with DEPEND_1: " + e.getMessage());
            }
            try {
                if (yNumRec == -1L && CdfUtil.hasAttribute(cdf, var.getName(), "LABL_PTR_1") && (att = CdfUtil.getAttribute(cdf, var.getName(), "LABL_PTR_1")) != null && rank > 1) {
                    logger.log(Level.FINE, "get attribute LABL_PTR_1 entry for {0}", var.getName());
                    yDependVariable = cdf.getVariable(String.valueOf(String.valueOf(att)));
                    yNumRec = yDependVariable.getNumberOfValues();
                    if (yNumRec == 1L) {
                        yNumRec = yDependVariable.getDimensions()[0] - 1;
                    }
                    if (dims.length > 0 && yNumRec != (long)dims[0]) {
                        warn.add("LABL_PTR_1 length is inconsistent with length (" + dims[0] + ")");
                    }
                }
            }
            catch (Exception e) {
                warn.add("problem with LABL_PTR_1: " + e.getMessage());
            }
            try {
                if (CdfUtil.hasAttribute(cdf, var.getName(), "DEPEND_2") && (att = CdfUtil.getAttribute(cdf, var.getName(), "DEPEND_2")) != null && rank > 2) {
                    logger.log(Level.FINE, "get attribute DEPEND_2 entry for {0}", var.getName());
                    zDependVariable = cdf.getVariable(String.valueOf(String.valueOf(att)));
                    zNumRec = zDependVariable.getNumberOfValues();
                    if (zNumRec == 1L) {
                        zNumRec = zDependVariable.getDimensions()[0] - 1;
                    }
                }
            }
            catch (Exception e) {
                warn.add("problem with DEPEND_2: " + e.getMessage());
            }
            try {
                if (zNumRec == -1L && CdfUtil.hasAttribute(cdf, var.getName(), "LABL_PTR_2") && (att = CdfUtil.getAttribute(cdf, var.getName(), "LABL_PTR_2")) != null && rank > 2) {
                    logger.log(Level.FINE, "get attribute LABL_PTR_2 entry for {0}", var.getName());
                    zDependVariable = cdf.getVariable(String.valueOf(String.valueOf(att)));
                    zNumRec = zDependVariable.getNumberOfValues();
                    if (zNumRec == 0L) {
                        zNumRec = zDependVariable.getDimensions()[0] - 1;
                    }
                }
            }
            catch (Exception e) {
                warn.add("problem with LABL_PTR_2: " + e.getMessage());
            }
            try {
                if (CdfUtil.hasAttribute(cdf, var.getName(), "DEPEND_3") && (att = CdfUtil.getAttribute(cdf, var.getName(), "DEPEND_3")) != null && rank > 3) {
                    logger.log(Level.FINE, "get attribute DEPEND_3 entry for {0}", var.getName());
                    z1DependVariable = cdf.getVariable(String.valueOf(String.valueOf(att)));
                    z1NumRec = z1DependVariable.getNumberOfValues();
                    if (z1NumRec == 1L) {
                        z1NumRec = z1DependVariable.getDimensions()[0] - 1;
                    }
                }
            }
            catch (Exception e) {
                warn.add("problem with DEPEND_3: " + e.getMessage());
            }
            try {
                if (z1NumRec == -1L && CdfUtil.hasAttribute(cdf, var.getName(), "LABL_PTR_3") && (att = CdfUtil.getAttribute(cdf, var.getName(), "LABL_PTR_3")) != null && rank > 3) {
                    logger.log(Level.FINE, "get attribute LABL_PTR_3 entry for {0}", var.getName());
                    zDependVariable = cdf.getVariable(String.valueOf(String.valueOf(att)));
                    z1NumRec = zDependVariable.getNumberOfValues();
                    if (z1NumRec == 0L) {
                        z1NumRec = zDependVariable.getDimensions()[0] - 1;
                    }
                }
            }
            catch (Exception e) {
                warn.add("problem with LABL_PTR_3: " + e.getMessage());
            }
            if (deep) {
                Object o = CdfUtil.getAttribute(cdf, var.getName(), "CATDESC");
                if (o != null && o instanceof String) {
                    logger.log(Level.FINE, "get attribute CATDESC entry for {0}", var.getName());
                    scatDesc = (String)o;
                }
                if ((o = CdfUtil.getAttribute(cdf, var.getName(), "VAR_NOTES")) != null && o instanceof String) {
                    logger.log(Level.FINE, "get attribute VAR_NOTES entry for {0}", var.getName());
                    svarNotes = (String)o;
                }
            }
            String desc = var.getName();
            if (xDependVariable != null) {
                desc = desc + "(" + xDependVariable.getName();
                if (xMaxRec > 0L || !isMaster) {
                    desc = desc + "=" + xMaxRec;
                }
                if (yDependVariable != null) {
                    desc = desc + "," + yDependVariable.getName() + "=" + yNumRec;
                    if (zDependVariable != null) {
                        desc = desc + "," + zDependVariable.getName() + "=" + zNumRec;
                        if (z1DependVariable != null) {
                            desc = desc + "," + z1DependVariable.getName() + "=" + z1NumRec;
                        }
                    }
                } else if (rank > 1) {
                    desc = desc + "," + DataSourceUtil.strjoin((int[])dims, (String)",");
                }
                desc = desc + ")";
            }
            if (deep) {
                StringBuilder descbuf = new StringBuilder("<html><b>" + desc + "</b><br>");
                String recDesc = "" + CdfUtil.getStringDataType(var.getType());
                if (dims != null) {
                    recDesc = recDesc + "[" + DataSourceUtil.strjoin((int[])dims, (String)",") + "]";
                }
                if (maxRec != xMaxRec) {
                    descbuf.append("").append(maxRec).append(" records of ").append(recDesc).append("<br>");
                }
                if (scatDesc != null) {
                    descbuf.append("").append(scatDesc).append("<br>");
                }
                if (svarNotes != null) {
                    descbuf.append("<br><p><small>").append(svarNotes).append("<small></p>");
                }
                if (vdescr != null && vdescr.length() > 0) {
                    descbuf.append("<br>virtual variable implemented by ").append(vdescr).append("<br>");
                }
                for (String s : warn) {
                    descbuf.append("<br>WARNING: ").append(s);
                }
                descbuf.append("</html>");
                if (xDependVariable != null) {
                    dependent.put(var.getName(), descbuf.toString());
                    continue;
                }
                result.put(var.getName(), descbuf.toString());
                continue;
            }
            if (xDependVariable != null) {
                dependent.put(var.getName(), desc);
                continue;
            }
            result.put(var.getName(), desc);
        }
        logger.fine("done, get plottable ");
        dependent.putAll(result);
        return dependent;
    }
}

