/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.excel.ExcelUtil;

public class ExcelSpreadsheetDataSource
extends AbstractDataSource {
    POIFSFileSystem fs;
    HSSFSheet sheet;
    ExcelSpreadsheetDataSet data;
    static Logger logger = Logger.getLogger("org.autoplot.ExcelSpreadsheetDataSource");

    public ExcelSpreadsheetDataSource(URI uri) throws IOException {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws IOException {
        File file = this.getFile(mon);
        FileInputStream in = new FileInputStream(file);
        this.fs = new POIFSFileSystem((InputStream)in);
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        String ssheet = (String)this.params.get("sheet");
        if (ssheet == null) {
            this.sheet = wb.getSheetAt(0);
        } else {
            ssheet = DataSetURI.maybePlusToSpace((String)ssheet);
            this.sheet = wb.getSheet(ssheet);
            if (this.sheet == null) {
                throw new IllegalArgumentException("no such sheet: " + ssheet);
            }
            logger.fine("found sheet " + ssheet + " with " + this.sheet.getLastRowNum() + " rows");
        }
        if (this.sheet == null) {
            throw new IllegalArgumentException("Sheet not found: " + ssheet);
        }
        String firstRowString = (String)this.params.get("firstRow");
        int firstRow = firstRowString == null ? -1 : Integer.parseInt(firstRowString) - 1;
        String d = (String)this.params.get("column");
        int[] spec = this.parseDataSetSpec(d, firstRow, -1);
        firstRow = spec[1];
        boolean labels = true;
        HSSFRow row = this.sheet.getRow(firstRow);
        for (short i = 0; labels && i < row.getLastCellNum(); i = (short)(i + 1)) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) continue;
            if (cell.getCellType() == 0) {
                labels = false;
            }
            if (i != spec[0] || cell.getCellType() == 1) continue;
            labels = false;
        }
        String recCountString = (String)this.params.get("recCount");
        if (recCountString != null) {
            int recCount = Integer.parseInt(recCountString);
            spec[2] = Math.min(spec[2], spec[1] + recCount);
        }
        this.data = new ExcelSpreadsheetDataSet((short)spec[0], spec[1], spec[2], labels);
        if (d.length() > 1) {
            this.data.putProperty("NAME", d);
        }
        if ((d = (String)this.params.get("depend0")) != null) {
            int[] spec2 = this.parseDataSetSpec(d, firstRow, -1);
            spec[0] = spec2[0];
            ExcelSpreadsheetDataSet depend0 = new ExcelSpreadsheetDataSet((short)spec[0], spec[1], spec[2], labels);
            if (d.length() > 1) {
                depend0.putProperty("NAME", d);
            }
            this.data.putProperty("DEPEND_0", (Object)depend0);
            if (this.data.getFirstRow() != depend0.getFirstRow()) {
                throw new IllegalArgumentException("rows must not contain empty cells in the first row");
            }
        }
        if ((d = (String)this.params.get("plane0")) != null) {
            int[] spec2 = this.parseDataSetSpec(d, firstRow, -1);
            spec[0] = spec2[0];
            ExcelSpreadsheetDataSet p0 = new ExcelSpreadsheetDataSet((short)spec[0], spec[1], spec[2], labels);
            if (d.length() > 1) {
                p0.putProperty("NAME", d);
            }
            this.data.putProperty("PLANE_0", (Object)p0);
            if (this.data.getFirstRow() != p0.getFirstRow()) {
                throw new IllegalArgumentException("rows must not contain empty cells in the first row");
            }
        }
        return this.data;
    }

    private int[] parseDataSetSpec(String spec, int firstRow, int lastRow) {
        Pattern p = Pattern.compile("([a-zA-Z][a-zA-Z0-9_]*)(\\[(\\d+):(\\d+)?\\])?");
        Matcher m = p.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad spec!");
        }
        String col = m.group(1);
        if (m.group(3) == null) {
            if (firstRow == -1) {
                firstRow = 0;
            }
            if (lastRow == -1) {
                lastRow = this.sheet.getLastRowNum();
            }
        } else {
            firstRow = Integer.parseInt(m.group(3));
            if (m.group(4) == null) {
                if (lastRow == -1) {
                    lastRow = this.sheet.getLastRowNum();
                }
            } else {
                lastRow = Integer.parseInt(m.group(4));
            }
        }
        short columnNumber = this.getColumnNumber(col, firstRow);
        return new int[]{columnNumber, firstRow, lastRow};
    }

    private short getColumnNumber(String id, int firstRow) {
        return ExcelUtil.getColumnNumber(this.sheet, id, firstRow);
    }

    protected static int findFirstRow(HSSFSheet sheet, int firstRow) {
        int inextRow;
        int ilastRow = sheet.getPhysicalNumberOfRows();
        int dataCellCount = 0;
        for (inextRow = firstRow; inextRow < ilastRow && inextRow < firstRow + 4; ++inextRow) {
            HSSFRow nextRow = sheet.getRow(inextRow);
            if (nextRow != null) {
                short n = nextRow.getLastCellNum();
                for (int i = nextRow.getFirstCellNum(); i < n; ++i) {
                    HSSFCell nextCell = nextRow.getCell((short)i);
                    if (nextCell == null || nextCell.getCellType() != 0) continue;
                    ++dataCellCount;
                }
            }
            if (dataCellCount != 0) break;
        }
        return inextRow;
    }

    class ExcelSpreadsheetDataSet
    extends AbstractDataSet {
        short columnNumber;
        int firstRow;
        int length;
        boolean isDate;
        Units units;

        ExcelSpreadsheetDataSet(short columnNumber, int firstRow, int lastRow, boolean firstRowIsLabels) {
            if (firstRowIsLabels) {
                firstRow = ExcelSpreadsheetDataSource.findFirstRow(ExcelSpreadsheetDataSource.this.sheet, firstRow);
            }
            this.columnNumber = columnNumber;
            this.firstRow = firstRow;
            this.length = lastRow - firstRow;
            HSSFRow row = ExcelSpreadsheetDataSource.this.sheet.getRow(this.firstRow);
            HSSFCell cell = row.getCell(columnNumber);
            if (cell == null) {
                row = null;
            }
            while (row == null && firstRow < lastRow) {
                if ((cell = (row = ExcelSpreadsheetDataSource.this.sheet.getRow(++firstRow)).getCell(columnNumber)) != null) continue;
                row = null;
            }
            if (row == null) {
                throw new IllegalArgumentException("unable to identify first row");
            }
            this.firstRow = firstRow;
            cell = row.getCell(columnNumber);
            this.units = Units.dimensionless;
            if (cell.getCellType() != 1) {
                this.isDate = HSSFDateUtil.isCellDateFormatted((HSSFCell)cell);
                if (this.isDate) {
                    this.properties.put("UNITS", Units.t1970);
                    this.units = Units.t1970;
                }
            } else if (cell.getCellType() == 1) {
                String s = cell.getStringCellValue();
                try {
                    Units.t1970.parse(s);
                    this.properties.put("UNITS", Units.t1970);
                    this.units = Units.t1970;
                }
                catch (ParseException ex) {
                    this.properties.put("UNITS", Units.dimensionless);
                }
            }
        }

        public int getFirstRow() {
            return this.firstRow;
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            HSSFRow row = null;
            HSSFCell cell = null;
            try {
                row = ExcelSpreadsheetDataSource.this.sheet.getRow(i + this.firstRow);
                cell = row.getCell(this.columnNumber);
                if (this.isDate) {
                    Date d = cell.getDateCellValue();
                    return (double)d.getTime() / 1000.0;
                }
                if (cell == null) {
                    return Double.NaN;
                }
                if (cell.getCellType() == 0) {
                    double d = cell.getNumericCellValue();
                    return d;
                }
                if (cell.getCellType() == 1) {
                    try {
                        double d = this.units.parse(cell.getStringCellValue()).doubleValue(this.units);
                        return d;
                    }
                    catch (ParseException ex) {
                        return Double.NaN;
                    }
                }
                return Double.NaN;
            }
            catch (RuntimeException e) {
                return Double.NaN;
            }
        }

        public int length() {
            return this.length;
        }
    }
}

