/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.excel;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.poi.hssf.contrib.view.SVTableModel;
import org.apache.poi.hssf.contrib.view.SViewer;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSourceEditorPanel;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.ui.TableRowHeader;
import org.virbo.excel.ExcelUtil;

public class ExcelSpreadsheetDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    HSSFWorkbook wb;
    Map<Integer, String> columns;
    boolean focusDepend0 = false;
    Map<String, String> params;
    URISplit split;
    Tool currentTool = Tool.NONE;
    JToggleButton currentToolButton;
    protected File file = null;
    public static final String PROP_FILE = "file";
    protected String sheet;
    public static final String PROP_SHEET = "sheet";
    public static final String PROP_FIRST_ROW = "firstRow";
    public static final String PROP_COLUMN = "column";
    public static final String PROP_DEP0 = "depend0";
    public JComboBox columnsComboBox;
    public JComboBox dep0Columns;
    public JFormattedTextField firstRowTextField;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JLabel jLabel4;
    public JPanel jPanel1;
    public JScrollPane jScrollPane1;
    public JTable jTable1;
    public JToggleButton jToggleButton1;
    public JToggleButton jToggleButton2;
    public JToggleButton jToggleButton3;
    public SViewer sViewer1;
    public JComboBox sheetComboBox;

    public boolean reject(String url) throws IOException, URISyntaxException {
        this.split = URISplit.parse((String)url);
        FileSystem fs = FileSystem.create((URI)DataSetURI.getWebURL((URI)DataSetURI.toUri((String)this.split.path)).toURI());
        return fs.isDirectory(this.split.file.substring(this.split.path.length()));
    }

    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        this.split = URISplit.parse((String)uri);
        this.params = URISplit.parseParams((String)this.split.params);
        File f = DataSetURI.getFile((URL)new URL(this.split.file), (ProgressMonitor)mon);
        return true;
    }

    public ExcelSpreadsheetDataSourceEditorPanel() {
        this.initComponents();
        this.jTable1.setCellSelectionEnabled(true);
        this.jTable1.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ExcelSpreadsheetDataSourceEditorPanel.this.doSelect(ExcelSpreadsheetDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ExcelSpreadsheetDataSourceEditorPanel.this.doSelect(ExcelSpreadsheetDataSourceEditorPanel.this.currentTool);
            }
        });
        this.jScrollPane1.setRowHeaderView((Component)new TableRowHeader(this.jTable1));
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                int col = ExcelSpreadsheetDataSourceEditorPanel.this.jTable1.getTableHeader().columnAtPoint(e.getPoint());
                String name = ExcelSpreadsheetDataSourceEditorPanel.this.columns.get(col);
                if (name == null) {
                    name = String.valueOf((char)(65 + col));
                }
                if (ExcelSpreadsheetDataSourceEditorPanel.this.currentTool == Tool.DEPEND_0) {
                    ExcelSpreadsheetDataSourceEditorPanel.this.params.put(ExcelSpreadsheetDataSourceEditorPanel.PROP_DEP0, name);
                    ExcelSpreadsheetDataSourceEditorPanel.this.dep0Columns.setSelectedItem(name);
                    ExcelSpreadsheetDataSourceEditorPanel.this.clearTool();
                } else if (ExcelSpreadsheetDataSourceEditorPanel.this.currentTool == Tool.COLUMN) {
                    ExcelSpreadsheetDataSourceEditorPanel.this.params.put(ExcelSpreadsheetDataSourceEditorPanel.PROP_COLUMN, name);
                    ExcelSpreadsheetDataSourceEditorPanel.this.columnsComboBox.setSelectedItem(name);
                    ExcelSpreadsheetDataSourceEditorPanel.this.clearTool();
                }
            }
        });
    }

    private void doSelect(Tool tool) {
        if (tool == Tool.NONE) {
            return;
        }
        if (tool == Tool.FIRSTROW) {
            if (this.jTable1.getSelectedRow() > 0) {
                this.params.put(PROP_FIRST_ROW, String.valueOf(this.jTable1.getSelectedRow() + 1));
            } else {
                this.params.remove(PROP_FIRST_ROW);
            }
            this.firstRowTextField.setValue(this.jTable1.getSelectedRow() + 1);
            this.resetFirstRow();
            this.jTable1.getSelectionModel().clearSelection();
        } else if (this.jTable1.getColumnModel().getSelectedColumnCount() != 0) {
            if (this.jTable1.getColumnModel().getSelectedColumnCount() == 1) {
                int col = this.jTable1.getColumnModel().getSelectedColumns()[0];
                String name = this.columns.get(col);
                if (name == null) {
                    name = String.valueOf((char)(65 + col));
                }
                if (this.currentTool == Tool.DEPEND_0) {
                    this.params.put(PROP_DEP0, name);
                    this.dep0Columns.setSelectedItem(name);
                } else if (this.currentTool == Tool.COLUMN) {
                    this.params.put(PROP_COLUMN, name);
                    this.columnsComboBox.setSelectedItem(name);
                }
                this.jTable1.getSelectionModel().clearSelection();
            } else {
                int[] cols = this.jTable1.getColumnModel().getSelectedColumns();
                int first = cols[0];
                int last = cols[cols.length - 1];
                String sfirst = this.columns.get(first);
                if (sfirst == null) {
                    sfirst = "" + first;
                }
                boolean haveColumnNames = true;
                String slast = this.columns.get(last);
                if (slast == null) {
                    slast = "" + last;
                    haveColumnNames = false;
                }
                if (this.currentTool == Tool.DEPEND_0) {
                    if (haveColumnNames) {
                        this.params.put(PROP_DEP0, sfirst + "-" + slast);
                    } else {
                        this.params.put(PROP_DEP0, "" + first + ":" + (last + 1));
                    }
                } else if (this.currentTool == Tool.COLUMN) {
                    if (haveColumnNames) {
                        this.params.put(PROP_COLUMN, sfirst + "-" + slast);
                    } else {
                        this.params.put(PROP_COLUMN, "" + first + ":" + (last + 1));
                    }
                }
                this.jTable1.getSelectionModel().clearSelection();
            }
        }
        this.clearTool();
    }

    Action createToolAction(String label, final Tool t) {
        return new AbstractAction(label){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JToggleButton) {
                    if (ExcelSpreadsheetDataSourceEditorPanel.this.jTable1.getSelectionModel().isSelectionEmpty()) {
                        ExcelSpreadsheetDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        ExcelSpreadsheetDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                        ExcelSpreadsheetDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        ExcelSpreadsheetDataSourceEditorPanel.this.currentTool = t;
                    } else {
                        ExcelSpreadsheetDataSourceEditorPanel.this.currentToolButton = (JToggleButton)e.getSource();
                        ExcelSpreadsheetDataSourceEditorPanel.this.currentTool = t;
                        ExcelSpreadsheetDataSourceEditorPanel.this.doSelect(t);
                        ExcelSpreadsheetDataSourceEditorPanel.this.jTable1.getSelectionModel().clearSelection();
                        ExcelSpreadsheetDataSourceEditorPanel.this.jTable1.getColumnModel().getSelectionModel().clearSelection();
                    }
                }
            }
        };
    }

    private void clearTool() {
        if (this.currentTool != Tool.NONE) {
            this.currentTool = Tool.NONE;
            this.currentToolButton.setSelected(false);
            this.currentToolButton = null;
        }
    }

    private void initComponents() {
        this.sViewer1 = new SViewer();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.dep0Columns = new JComboBox();
        this.columnsComboBox = new JComboBox();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jLabel2 = new JLabel();
        this.sheetComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.firstRowTextField = new JFormattedTextField();
        this.jToggleButton1 = new JToggleButton();
        GroupLayout sViewer1Layout = new GroupLayout(this.sViewer1.getContentPane());
        this.sViewer1.getContentPane().setLayout((LayoutManager)sViewer1Layout);
        sViewer1Layout.setHorizontalGroup((GroupLayout.Group)sViewer1Layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        sViewer1Layout.setVerticalGroup((GroupLayout.Group)sViewer1Layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel3.setText("Column:");
        this.jLabel4.setText("Depends On:");
        this.dep0Columns.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.dep0Columns.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExcelSpreadsheetDataSourceEditorPanel.this.dep0ColumnsItemStateChanged(evt);
            }
        });
        this.dep0Columns.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ExcelSpreadsheetDataSourceEditorPanel.this.dep0ColumnsFocusGained(evt);
            }
        });
        this.columnsComboBox.setEditable(true);
        this.columnsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.columnsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExcelSpreadsheetDataSourceEditorPanel.this.columnsComboBoxItemStateChanged(evt);
            }
        });
        this.columnsComboBox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ExcelSpreadsheetDataSourceEditorPanel.this.columnsComboBoxFocusGained(evt);
            }
        });
        this.jToggleButton2.setAction(this.createToolAction(PROP_COLUMN, Tool.COLUMN));
        this.jToggleButton2.setText("Select");
        this.jToggleButton2.setToolTipText("Select the column to plot by pushing this button and then clicking on a column of the table.\n");
        this.jToggleButton3.setAction(this.createToolAction(PROP_DEP0, Tool.DEPEND_0));
        this.jToggleButton3.setText("Select");
        this.jToggleButton3.setToolTipText("Select the column containing the indepenent variable to plot against by pressing this button and then clicking on the table.\n");
        this.jLabel2.setText("Sheet:");
        this.sheetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sheetComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ExcelSpreadsheetDataSourceEditorPanel.this.sheetComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("First Row:");
        this.firstRowTextField.setText("jFormattedTextField1");
        this.firstRowTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExcelSpreadsheetDataSourceEditorPanel.this.firstRowTextFieldActionPerformed(evt);
            }
        });
        this.firstRowTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ExcelSpreadsheetDataSourceEditorPanel.this.firstRowTextFieldFocusLost(evt);
            }
        });
        this.jToggleButton1.setAction(this.createToolAction(PROP_FIRST_ROW, Tool.FIRSTROW));
        this.jToggleButton1.setText("Select");
        this.jToggleButton1.setToolTipText("Select the first row to start the data by clicking on this button then a row of the table.\n");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel4).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.dep0Columns, 0, 422, Short.MAX_VALUE).add((Component)this.columnsComboBox, 0, 422, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jToggleButton3, -1, -1, Short.MAX_VALUE).add((Component)this.jToggleButton2, -1, 77, Short.MAX_VALUE)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel2).add(28, 28, 28).add((Component)this.sheetComboBox, 0, 119, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.firstRowTextField, -1, 63, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jToggleButton1))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.columnsComboBox, -2, -1, -2).add((Component)this.jToggleButton2, -2, 27, -2).add((Component)this.sheetComboBox, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.dep0Columns, -2, -1, -2).add((Component)this.jToggleButton3, -2, 24, -2).add((Component)this.jToggleButton1).add((Component)this.firstRowTextField, -2, -1, -2).add((Component)this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 819, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, 69, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 381, Short.MAX_VALUE).addContainerGap()));
    }

    private synchronized void maybeInitializeWorkBook() throws IOException, FileNotFoundException {
        if (this.wb == null) {
            FileInputStream in = new FileInputStream(this.file);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)in);
            this.wb = new HSSFWorkbook(fs);
        }
    }

    private void resetFirstRow() {
        String firstRowString = this.params.get(PROP_FIRST_ROW) == null ? "1" : this.params.get(PROP_FIRST_ROW);
        try {
            try {
                this.columns = ExcelUtil.getColumns(this.wb, this.getSheet(), firstRowString, (ProgressMonitor)new NullProgressMonitor());
            }
            catch (IllegalArgumentException ex) {
                this.columns = Collections.singletonMap(0, "A");
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                this.jTable1.getColumnModel().getColumn(i).setHeaderValue(this.columns.get(i));
            }
            this.jTable1.getTableHeader().repaint();
        }
        catch (IOException ex) {
            Logger.getLogger(ExcelSpreadsheetDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        String column = (String)this.columnsComboBox.getSelectedItem();
        String dep0 = (String)this.dep0Columns.getSelectedItem();
        ArrayList<String> colValues = new ArrayList<String>(this.columns.values());
        colValues.add(0, "");
        this.columnsComboBox.setModel(new DefaultComboBoxModel<Object>(colValues.toArray()));
        ArrayList<String> dep0Values = new ArrayList<String>(this.columns.values());
        dep0Values.add(0, "");
        this.dep0Columns.setModel(new DefaultComboBoxModel<Object>(dep0Values.toArray()));
        if (!column.equals("Item 1")) {
            this.columnsComboBox.setSelectedItem(column);
            this.dep0Columns.setSelectedItem(dep0);
        }
    }

    private void resetSheet(String string) {
        try {
            if (this.file == null) {
                return;
            }
            this.maybeInitializeWorkBook();
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
                String s = this.wb.getSheetName(i);
                result.add(s);
            }
            HSSFSheet lsheet = this.wb.getSheet(string);
            this.jTable1.setModel((TableModel)new SVTableModel(lsheet));
            this.resetFirstRow();
            int firstRow = this.params.get(PROP_FIRST_ROW) == null ? 1 : Integer.valueOf(this.params.get(PROP_FIRST_ROW));
            Rectangle rect = this.jTable1.getCellRect(firstRow, 0, true);
            this.jTable1.scrollRectToVisible(rect);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sheetComboBoxItemStateChanged(ItemEvent evt) {
        String sheet = (String)this.sheetComboBox.getSelectedItem();
        this.params.put(PROP_SHEET, sheet);
        this.setSheet(sheet);
        this.resetSheet(sheet);
    }

    private void dep0ColumnsItemStateChanged(ItemEvent evt) {
        this.params.put(PROP_DEP0, (String)this.dep0Columns.getSelectedItem());
    }

    private void dep0ColumnsFocusGained(FocusEvent evt) {
    }

    private void columnsComboBoxItemStateChanged(ItemEvent evt) {
        this.params.put(PROP_COLUMN, (String)this.columnsComboBox.getSelectedItem());
    }

    private void columnsComboBoxFocusGained(FocusEvent evt) {
    }

    private void firstRowTextFieldActionPerformed(ActionEvent evt) {
    }

    private void firstRowTextFieldFocusLost(FocusEvent evt) {
        if ((Integer)this.firstRowTextField.getValue() > 1) {
            this.params.put(PROP_FIRST_ROW, String.valueOf(this.firstRowTextField.getValue()));
        }
        this.resetFirstRow();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) throws IOException {
        this.file = file;
        this.maybeInitializeWorkBook();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
            String s = this.wb.getSheetName(i);
            result.add(s);
        }
        this.sheetComboBox.setModel(new DefaultComboBoxModel<Object>(result.toArray()));
        if (!result.contains(this.getSheet())) {
            this.setSheet((String)result.get(0));
        } else {
            this.resetSheet(this.getSheet());
        }
    }

    public String getSheet() {
        return this.sheet;
    }

    public void setSheet(String sheet) {
        String oldSheet = this.sheet;
        this.sheet = sheet;
        this.resetSheet(this.sheet);
        this.firePropertyChange(PROP_SHEET, oldSheet, sheet);
    }

    public JPanel getPanel() {
        return this;
    }

    private int getIntValue(String name, int def) {
        if (this.params.get(name) == null) {
            return def;
        }
        return Integer.parseInt(this.params.get(name));
    }

    public void setURI(String url) {
        try {
            this.split = URISplit.parse((String)url);
            this.params = URISplit.parseParams((String)this.split.params);
            File f = DataSetURI.getFile((URL)new URL(this.split.file), (ProgressMonitor)new NullProgressMonitor());
            this.setFile(f);
            if (this.params.get(PROP_SHEET) != null) {
                this.sheetComboBox.setSelectedItem(this.params.get(PROP_SHEET));
                this.setSheet(this.params.get(PROP_SHEET));
            }
            if (this.params.get(PROP_COLUMN) != null) {
                this.columnsComboBox.setSelectedItem(this.params.get(PROP_COLUMN));
            }
            if (this.params.get(PROP_DEP0) != null) {
                this.dep0Columns.setSelectedItem(this.params.get(PROP_DEP0));
            }
            this.firstRowTextField.setValue(this.getIntValue(PROP_FIRST_ROW, 1));
        }
        catch (IOException ex) {
            Logger.getLogger(ExcelSpreadsheetDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getURI() {
        if (this.params.containsKey(PROP_COLUMN) && this.params.get(PROP_COLUMN).equals("")) {
            this.params.remove(PROP_COLUMN);
        }
        if (this.params.containsKey(PROP_DEP0) && this.params.get(PROP_DEP0).equals("")) {
            this.params.remove(PROP_DEP0);
        }
        this.split.params = URISplit.formatParams(this.params);
        return URISplit.format((URISplit)this.split);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Tool {
        NONE,
        FIRSTROW,
        COLUMN,
        DEPEND_0,
        TIMEFORMAT;

    }
}

