/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.excel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.URISplit;

public class ExcelSpreadsheetDataSourceFormat
implements DataSourceFormat {
    HSSFCellStyle dateCellStyle;
    Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    private void formatRank2(HSSFSheet sheet, QDataSet data, ProgressMonitor mon) throws IOException {
        Units u;
        HSSFCell cell;
        int irow = 0;
        short icell = 0;
        HSSFRow row = sheet.createRow(irow++);
        QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep1 != null) {
            Units u2;
            if (dep0 != null) {
                String l = (String)dep0.property("LABEL");
                short s = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s);
                cell.setCellValue(l == null ? "dep0" : l);
            }
            if ((u2 = (Units)dep1.property("UNITS")) == null) {
                u2 = Units.dimensionless;
            }
            for (int i = 0; i < dep1.length(); ++i) {
                short s = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s);
                Datum d = u2.createDatum(dep1.value(i));
                if (u2 instanceof EnumerationUnits) {
                    cell.setCellValue(d.toString());
                    continue;
                }
                this.setCellValue(cell, d);
            }
        }
        Units u0 = null;
        if (dep0 != null && (u0 = (Units)dep0.property("UNITS")) == null) {
            u0 = Units.dimensionless;
        }
        if ((u = (Units)data.property("UNITS")) == null) {
            u = Units.dimensionless;
        }
        mon.setTaskSize((long)data.length());
        mon.started();
        for (int i = 0; i < data.length(); ++i) {
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            row = sheet.createRow(irow++);
            icell = 0;
            if (dep0 != null) {
                short s = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s);
                this.setCellValue(cell, u0.createDatum(dep0.value(i)));
            }
            for (int j = 0; j < data.length(i); ++j) {
                short s = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s);
                this.setCellValue(cell, u.createDatum(data.value(i, j)));
            }
        }
        mon.finished();
    }

    private void formatRank1(HSSFSheet sheet, QDataSet data, ProgressMonitor mon) throws IOException {
        Units u;
        HSSFCell cell;
        String l;
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        int irow = 0;
        HSSFRow row = sheet.createRow(irow++);
        short icell = 0;
        if (dep0 != null) {
            l = (String)dep0.property("LABEL");
            short s = icell;
            icell = (short)(icell + 1);
            cell = row.createCell(s);
            cell.setCellValue(new HSSFRichTextString(l == null ? "dep0" : l));
        }
        l = (String)data.property("LABEL");
        short s = icell;
        icell = (short)(icell + 1);
        cell = row.createCell(s);
        cell.setCellValue(new HSSFRichTextString(l == null ? "data" : l));
        Units u0 = null;
        if (dep0 != null && (u0 = (Units)dep0.property("UNITS")) == null) {
            u0 = Units.dimensionless;
        }
        if ((u = (Units)data.property("UNITS")) == null) {
            u = Units.dimensionless;
        }
        mon.setTaskSize((long)data.length());
        mon.started();
        for (int i = 0; i < data.length(); ++i) {
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            row = sheet.createRow(irow++);
            icell = 0;
            if (dep0 != null) {
                short s2 = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s2);
                this.setCellValue(cell, u0.createDatum(dep0.value(i)));
            }
            short s3 = icell;
            icell = (short)(icell + 1);
            cell = row.createCell(s3);
            this.setCellValue(cell, u.createDatum(data.value(i)));
        }
        mon.finished();
    }

    private void setCellValue(HSSFCell cell, Datum datum) {
        Units u = datum.getUnits();
        if (UnitsUtil.isTimeLocation((Units)u)) {
            this.c.setTimeInMillis((long)(datum.doubleValue((Units)Units.t1970) * 1000.0));
            cell.setCellValue(this.c);
            cell.setCellStyle(this.dateCellStyle);
        } else {
            cell.setCellValue(datum.doubleValue(u));
        }
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        FileOutputStream out = new FileOutputStream(new File(split.resourceUri));
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        this.dateCellStyle = wb.createCellStyle();
        this.dateCellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
        if (data.rank() == 2) {
            this.formatRank2(sheet, data, mon);
        } else if (data.rank() == 1) {
            this.formatRank1(sheet, data, mon);
        }
        wb.write((OutputStream)out);
        out.close();
    }
}

