/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.binarydatasource;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.binarydatasource.BufferDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;

public class BinaryDataSource
extends AbstractDataSource {
    public BinaryDataSource(URI uri) {
        super(uri);
    }

    private int getIntParameter(String name, int deflt) {
        String sval = (String)this.params.get(name);
        int result = sval == null ? deflt : Integer.parseInt(sval);
        return result;
    }

    private String getParameter(String name, String deflt) {
        String sval = (String)this.params.get(name);
        String result = sval == null ? deflt : sval;
        return result;
    }

    private static Object getTypeFromCode(String code) {
        Object result;
        block16: {
            block15: {
                if (code.charAt(0) != 'u') break block15;
                switch (code.charAt(1)) {
                    case 'x': {
                        result = null;
                        break block16;
                    }
                    case 'b': {
                        result = BufferDataSet.UBYTE;
                        break block16;
                    }
                    case 's': {
                        result = BufferDataSet.USHORT;
                        break block16;
                    }
                    case 'i': {
                        result = BufferDataSet.UINT;
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("bad format code: " + code);
                    }
                }
            }
            switch (code.charAt(0)) {
                case 'x': {
                    result = null;
                    break;
                }
                case 'b': {
                    result = BufferDataSet.BYTE;
                    break;
                }
                case 's': {
                    result = BufferDataSet.SHORT;
                    break;
                }
                case 'i': {
                    result = BufferDataSet.INT;
                    break;
                }
                case 'l': {
                    result = BufferDataSet.LONG;
                    break;
                }
                case 'f': {
                    result = BufferDataSet.FLOAT;
                    break;
                }
                case 'd': {
                    result = BufferDataSet.DOUBLE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("bad format code: " + code);
                }
            }
        }
        return result;
    }

    public static Object[] parseRecFormat(String recFormat) {
        Integer count = 99;
        int[] offsets = new int[count.intValue()];
        Object[] types = new Object[count.intValue()];
        String[] ss = recFormat.split(",");
        int ioff = 0;
        int ifield = 0;
        for (int i = 0; i < ss.length; ++i) {
            Object type;
            int repeat = 1;
            int n = ss[i].length();
            String code = n > 1 && ss[i].charAt(n - 2) == 'u' ? ss[i].substring(n - 2) : ss[i].substring(n - 1);
            if (code.length() == n) {
                repeat = 1;
                type = BinaryDataSource.getTypeFromCode(code);
            } else {
                type = BinaryDataSource.getTypeFromCode(code);
                repeat = Integer.parseInt(ss[i].substring(0, n - code.length()));
            }
            offsets[ifield] = ioff;
            for (int j = 0; j < repeat; ++j) {
                if (type != null) {
                    types[ifield] = type;
                    offsets[ifield] = ioff;
                    ++ifield;
                    ioff += BufferDataSet.byteCount(type);
                    continue;
                }
                ++ioff;
            }
        }
        Object[] result = new Object[]{offsets, types, ifield, ioff};
        return result;
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        BufferDataSet ds;
        String encoding;
        int recOffset;
        File f = this.getFile(mon);
        FileChannel fc = new FileInputStream(f).getChannel();
        final int offset = this.getIntParameter("byteOffset", 0);
        int defLen = (int)f.length() - offset;
        int length = this.getIntParameter("byteLength", defLen);
        if (length == defLen && f.length() - (long)offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("default length is too big!");
        }
        int fieldCount = this.getIntParameter("fieldCount", this.params.get("depend0") == null ? 1 : 2);
        int recCount = this.getIntParameter("recCount", Integer.MAX_VALUE);
        MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, offset, length);
        fc.close();
        String recFormat = this.getParameter("recFormat", null);
        Object[] recFormatParse = null;
        if (recFormat != null) {
            recFormatParse = BinaryDataSource.parseRecFormat(recFormat);
            fieldCount = (Integer)recFormatParse[2];
        }
        int dep0 = this.getIntParameter("depend0", -1);
        int dep0Offset = this.getIntParameter("depend0Offset", -1);
        int defltcol = dep0 == -1 && dep0Offset == -1 ? 0 : (dep0 > 0 || dep0Offset > 0 ? 0 : 1);
        int col = this.getIntParameter("column", defltcol);
        String colType = String.valueOf(BufferDataSet.UBYTE);
        if (recFormatParse != null) {
            String o = (String)this.params.get("rank2");
            if (o != null) {
                throw new IllegalArgumentException("rank2 and columnFormat are not supported");
            }
            Object[] types = (Object[])recFormatParse[1];
            colType = String.valueOf(types[col]);
        }
        String columnType = this.getParameter("type", colType);
        int recSizeBytes = this.getIntParameter("recLength", -1);
        if (recFormatParse != null) {
            recSizeBytes = (Integer)recFormatParse[3];
        }
        if (recSizeBytes == -1) {
            recSizeBytes = BufferDataSet.byteCount(columnType) * fieldCount;
        }
        if (recFormatParse == null) {
            fieldCount = recSizeBytes / BufferDataSet.byteCount(columnType);
        }
        int frecCount = Math.min(length / recSizeBytes, recCount);
        int[] rank2 = null;
        String o = (String)this.params.get("rank2");
        if (o != null) {
            String s = o;
            int first = 0;
            int last = -999;
            if (s.contains(":")) {
                String[] ss = s.split(":", -2);
                if (ss[0].length() > 0) {
                    first = Integer.parseInt(ss[0]);
                }
                if (ss.length > 1 && ss[1].length() > 0) {
                    last = Integer.parseInt(ss[1]);
                }
            }
            if (last == -999) {
                last = fieldCount;
            }
            rank2 = new int[]{first, last};
            col = first;
            if (col < 0) {
                col = fieldCount + col;
            }
            if (first > fieldCount) {
                throw new IndexOutOfBoundsException("rank 2 index is greater than field count");
            }
            if (last > fieldCount) {
                throw new IndexOutOfBoundsException("rank 2 index is greater than field count");
            }
        }
        if ((recOffset = this.getIntParameter("recOffset", -1)) == -1) {
            recOffset = recFormatParse != null ? ((int[])recFormatParse[0])[col] : col * BufferDataSet.byteCount(columnType);
        }
        if ((encoding = this.getParameter("byteOrder", "little")).equals("big")) {
            buf.order(ByteOrder.BIG_ENDIAN);
        } else {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        }
        if (rank2 != null) {
            if (rank2[1] == -999) {
                rank2[1] = frecCount;
            }
            if (rank2[1] < 0) {
                rank2[1] = fieldCount + rank2[1];
            }
            if (rank2[0] < 0) {
                rank2[0] = fieldCount + rank2[0];
            }
            ds = BufferDataSet.makeDataSet(2, recSizeBytes, recOffset, frecCount, rank2[1] - rank2[0], 1, 1, buf, columnType);
        } else {
            ds = BufferDataSet.makeDataSet(1, recSizeBytes, recOffset, frecCount, 1, 1, 1, buf, columnType);
        }
        if (dep0 > -1 || dep0Offset > -1) {
            String dep0Type = this.getParameter("depend0Type", columnType);
            if (recFormatParse != null) {
                dep0Type = this.getParameter("dep0Type", String.valueOf(((Object[])recFormatParse[1])[dep0]));
            }
            if (dep0Offset == -1) {
                dep0Offset = recFormatParse == null ? BufferDataSet.byteCount(dep0Type) * dep0 : ((int[])recFormatParse[0])[dep0];
            }
            BufferDataSet dep0ds = BufferDataSet.makeDataSet(1, recSizeBytes, dep0Offset, frecCount, 1, 1, 1, buf, dep0Type);
            ds.putProperty("DEPEND_0", (Object)dep0ds);
        } else {
            boolean reportOffset;
            boolean bl = reportOffset = !this.getParameter("reportOffset", "no").equals("no");
            if (reportOffset) {
                final int finalRecSizeBytes = recSizeBytes;
                final int finalRecOffset = recOffset;
                IndexGenDataSet dep0ds = new IndexGenDataSet(frecCount){

                    public double value(int i) {
                        return offset + finalRecOffset + i * finalRecSizeBytes;
                    }
                };
                dep0ds.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((double)recSizeBytes));
                ds.putProperty("DEPEND_0", dep0ds);
            }
        }
        String s = (String)this.params.get("validMin");
        if (s != null) {
            ds.putProperty("VALID_MIN", Double.parseDouble(s));
        }
        if ((s = (String)this.params.get("validMax")) != null) {
            ds.putProperty("VALID_MAX", Double.parseDouble(s));
        }
        return ds;
    }
}

