/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.LinearDomainDivider;
import org.das2.datum.LogDomainDivider;
import org.das2.datum.Units;

public class LogLinDomainDivider
implements DomainDivider {
    private LinearDomainDivider decadeDivider;

    protected LogLinDomainDivider() {
        this(new LinearDomainDivider());
    }

    private LogLinDomainDivider(LinearDomainDivider decadeDivider) {
        this.decadeDivider = decadeDivider;
    }

    public DomainDivider coarserDivider(boolean superset) {
        LinearDomainDivider d = (LinearDomainDivider)this.decadeDivider.coarserDivider(superset);
        if (d.boundaryCount(Datum.create(1.0), Datum.create(10.0)) < 1L) {
            return new LogDomainDivider();
        }
        return new LogLinDomainDivider(d);
    }

    public DomainDivider finerDivider(boolean superset) {
        return new LogLinDomainDivider((LinearDomainDivider)this.decadeDivider.finerDivider(superset));
    }

    public DatumVector boundaries(Datum min, Datum max) {
        int i;
        double[] bounds;
        Datum mmax;
        Datum mmin;
        double decadeOffset;
        long nb = this.boundaryCount(min, max);
        if (nb > 1000000L) {
            throw new IllegalArgumentException("too many divisions requested (" + this.boundaryCount(min, max) + ")");
        }
        LogDomainDivider logDivider = new LogDomainDivider();
        DatumVector logBoundaries = logDivider.boundaries(min, max);
        int numLogBoundaries = logBoundaries.getLength();
        double[] result = new double[(int)nb];
        int index = 0;
        if (numLogBoundaries > 0) {
            decadeOffset = Math.pow(10.0, Math.floor(Math.log10(min.doubleValue())));
            mmin = min.divide(decadeOffset);
            mmax = logBoundaries.get(0).divide(decadeOffset);
            bounds = this.decadeDivider.boundaries(mmin, mmax).toDoubleArray(mmin.getUnits());
            for (i = 0; i < bounds.length - 1; ++i) {
                result[index++] = bounds[i] * decadeOffset;
            }
        }
        if (numLogBoundaries > 1) {
            double[] bounds2 = this.decadeDivider.boundaries(Datum.create(1), Datum.create(10)).toDoubleArray(Units.dimensionless);
            for (int dec = 0; dec < numLogBoundaries - 1; ++dec) {
                double decadeOffset2 = logBoundaries.get(dec).doubleValue();
                for (int i2 = 0; i2 < bounds2.length - 1; ++i2) {
                    result[index++] = bounds2[i2] * decadeOffset2;
                }
            }
        }
        if (numLogBoundaries > 0) {
            decadeOffset = logBoundaries.get(numLogBoundaries - 1).doubleValue();
            mmin = logBoundaries.get(numLogBoundaries - 1).divide(decadeOffset);
            mmax = max.divide(decadeOffset);
            bounds = this.decadeDivider.boundaries(mmin, mmax).toDoubleArray(mmax.getUnits());
            for (i = 0; i < bounds.length; ++i) {
                result[index++] = bounds[i] * decadeOffset;
            }
        } else {
            decadeOffset = Math.pow(10.0, Math.floor(Math.log10(min.doubleValue())));
            mmin = min.divide(decadeOffset);
            mmax = max.divide(decadeOffset);
            bounds = this.decadeDivider.boundaries(mmin, mmax).toDoubleArray(mmin.getUnits());
            for (i = 0; i < bounds.length; ++i) {
                result[index++] = bounds[i] * decadeOffset;
            }
        }
        return DatumVector.newDatumVector(result, min.getUnits());
    }

    public long boundaryCount(Datum min, Datum max) {
        LogDomainDivider logDivider = new LogDomainDivider();
        DatumVector logBoundaries = logDivider.boundaries(min, max);
        long bc = 0L;
        int numLogBoundaries = logBoundaries.getLength();
        if (numLogBoundaries > 1) {
            long divsPerDecade = this.decadeDivider.boundaryCount(Datum.create(0), Datum.create(10)) - 1L;
            bc = divsPerDecade * (long)(numLogBoundaries - 1);
        }
        if (numLogBoundaries > 0) {
            double decadeOffset = Math.pow(10.0, Math.floor(Math.log10(min.doubleValue())));
            Datum mmin = min.divide(decadeOffset);
            Datum mmax = logBoundaries.get(0).divide(decadeOffset);
            bc += this.decadeDivider.boundaryCount(mmin, mmax) - 1L;
            decadeOffset = Math.pow(10.0, Math.floor(Math.log10(max.doubleValue())));
            mmin = logBoundaries.get(numLogBoundaries - 1).divide(decadeOffset);
            mmax = max.divide(decadeOffset);
            bc += this.decadeDivider.boundaryCount(mmin, mmax);
        } else {
            double decadeOffset = Math.pow(10.0, Math.floor(Math.log10(min.doubleValue())));
            Datum mmin = min.divide(decadeOffset);
            Datum mmax = max.divide(decadeOffset);
            bc += this.decadeDivider.boundaryCount(mmin, mmax);
        }
        return bc;
    }

    public DatumRange rangeContaining(Datum v) {
        LogDomainDivider logDivider = new LogDomainDivider();
        DatumRange decade = logDivider.rangeContaining(v);
        double decadeOffset = decade.min().doubleValue();
        DatumRange range = this.decadeDivider.rangeContaining(v.divide(decadeOffset));
        return new DatumRange(range.min().multiply(decadeOffset), range.max().multiply(decadeOffset));
    }

    protected int sigFigs() {
        return 0 - this.decadeDivider.getExponent();
    }

    public String toString() {
        return "loglin decadeDivider=" + this.decadeDivider;
    }

    public static void main(String[] args) {
        int i;
        DomainDivider d = new LogLinDomainDivider();
        DatumRange dr = DatumRangeUtil.newDimensionless(7.9, 218.0);
        System.err.println(d.boundaryCount(dr.min(), dr.max()));
        DatumVector dv = d.boundaries(dr.min(), dr.max());
        for (i = 0; i < dv.getLength(); ++i) {
            System.err.print(dv.get(i).doubleValue() + ", ");
        }
        System.err.println();
        System.err.println(d.rangeContaining(Datum.create(27.3)));
        System.err.println(d.coarserDivider(true).coarserDivider(true).boundaries(dr.min(), dr.max()));
        System.err.println(d.finerDivider(true).finerDivider(true).boundaries(dr.min(), dr.max()));
        d = d.finerDivider(true);
        d = d.finerDivider(true);
        for (i = 0; i < 10; ++i) {
            d = d.coarserDivider(false);
            System.err.println(d);
        }
        for (i = 0; i < 10; ++i) {
            d = d.finerDivider(false);
            System.err.println(d);
        }
    }
}

