/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import org.das2.datum.Basis;
import org.das2.datum.Datum;
import org.das2.datum.LocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatterFactory;
import org.das2.datum.format.TimeDatumFormatterFactory;

public class TimeLocationUnits
extends LocationUnits {
    double vmin;
    double vmax;

    public TimeLocationUnits(String id, String description, Units offsetUnits, Basis basis) {
        super(id, description, offsetUnits, basis);
        if (id.equals("us2000")) {
            this.vmin = -3.15569088E16;
            this.vmax = 2.208987072E17;
        } else {
            this.vmin = Double.NaN;
            this.vmax = Double.NaN;
        }
    }

    public DatumFormatterFactory getDatumFormatterFactory() {
        return TimeDatumFormatterFactory.getInstance();
    }

    public Datum parse(String s) throws ParseException {
        return TimeUtil.toDatum(TimeUtil.parseTime(s));
    }

    public String getTimeZone() {
        return "UT";
    }

    private void calculateRange() {
        this.vmin = Units.us2000.convertDoubleTo(this, Units.us2000.vmin);
        this.vmax = Units.us2000.convertDoubleTo(this, Units.us2000.vmax);
    }

    public boolean isFill(double value) {
        if (Double.isNaN(this.vmin)) {
            this.calculateRange();
        }
        return value < this.vmin || value > this.vmax || Double.isNaN(value);
    }

    public boolean isFill(float value) {
        if (Double.isNaN(this.vmin)) {
            this.calculateRange();
        }
        return (double)value < this.vmin || (double)value > this.vmax || Float.isNaN(value);
    }

    public boolean isFill(long value) {
        if (Double.isNaN(this.vmin)) {
            this.calculateRange();
        }
        return (double)value < this.vmin || (double)value > this.vmax;
    }

    public boolean isFill(int value) {
        if (Double.isNaN(this.vmin)) {
            this.calculateRange();
        }
        return (double)value < this.vmin || (double)value > this.vmax;
    }

    public boolean isValid(double value) {
        if (Double.isNaN(this.vmin)) {
            this.calculateRange();
        }
        return value >= this.vmin && value <= this.vmax && !Double.isNaN(value);
    }

    public double validMin() {
        return this.vmin;
    }

    public double validMax() {
        return this.vmax;
    }
}

