/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSetBuilder;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.SkeletonDescriptor;
import org.das2.stream.StreamComment;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamHandler;
import org.das2.stream.StreamMultiYDescriptor;
import org.das2.stream.StreamYScanDescriptor;
import org.das2.system.DasLogger;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataSetStreamHandler
implements StreamHandler {
    StreamHandlerDelegate delegate;
    StreamDescriptor sd;
    Map extraProperties;
    ProgressMonitor monitor;
    int totalPacketCount = -1;
    int taskSize = -1;
    int packetCount = 0;
    Datum xTagMax = null;
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG);
    private boolean monotonic = true;

    public DataSetStreamHandler(Map extraProperties, ProgressMonitor monitor) {
        this.extraProperties = new HashMap(extraProperties);
        this.monitor = monitor == null ? new NullProgressMonitor() : monitor;
    }

    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        logger.finest("got stream descriptor");
        this.sd = sd;
        Object o = sd.getProperty("taskSize");
        if (o != null) {
            this.taskSize = (Integer)o;
            this.monitor.setTaskSize((long)this.taskSize);
            this.monitor.started();
        } else {
            o = sd.getProperty("packetCount");
            if (o != null) {
                this.totalPacketCount = (Integer)o;
                this.monitor.setTaskSize((long)this.totalPacketCount);
                this.monitor.started();
            }
        }
        o = sd.getProperty("cacheTagString");
        if (o != null) {
            try {
                String[] ss = ((String)o).split(",");
                Datum min = TimeUtil.create((String)ss[0]);
                Datum max = TimeUtil.create((String)ss[2]);
                Datum res = DatumUtil.parse((String)ss[1]);
                if (res.doubleValue(res.getUnits()) == 0.0) {
                    res = null;
                }
                this.extraProperties.put("cacheTag", new CacheTag(min, max, res));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((o = sd.getProperty("xMonotonic")) != null) {
            this.extraProperties.put("xMonotonic", Boolean.valueOf((String)o));
        }
        if ((o = sd.getProperty("pid")) != null) {
            logger.fine("stream pid=" + o);
        }
    }

    public void packetDescriptor(PacketDescriptor pd) throws StreamException {
        logger.finest("got packet descriptor");
        if (this.delegate == null) {
            SkeletonDescriptor descriptor = pd.getYDescriptor(0);
            if (descriptor instanceof StreamMultiYDescriptor) {
                logger.fine("using VectorDS delegate");
                this.delegate = new VectorDataSetStreamHandler(pd);
            } else if (descriptor instanceof StreamYScanDescriptor) {
                logger.fine("using TableDS delegate");
                this.delegate = new TableDataSetStreamHandler(pd);
            }
        } else {
            this.delegate.packetDescriptor(pd);
        }
    }

    public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
        logger.finest("got packet");
        this.ensureNotNullDelegate();
        if (this.xTagMax == null || xTag.ge(this.xTagMax)) {
            this.xTagMax = xTag;
        } else {
            this.monotonic = false;
        }
        this.delegate.packet(pd, xTag, vectors);
        ++this.packetCount;
        if (this.totalPacketCount != -1) {
            this.monitor.setTaskProgress((long)this.packetCount);
        }
    }

    public void streamClosed(StreamDescriptor sd) throws StreamException {
        logger.finest("got streamClosed");
        if (this.delegate != null) {
            this.delegate.streamClosed(sd);
        }
    }

    public void streamException(StreamException se) throws StreamException {
        logger.finest("got stream exception");
    }

    public void streamComment(StreamComment sc) throws StreamException {
        logger.finest("got stream comment: " + sc);
        if (sc.getType().equals(sc.TYPE_TASK_PROGRESS) && this.taskSize != -1) {
            if (!this.monitor.isCancelled()) {
                this.monitor.setTaskProgress(Long.parseLong(sc.getValue()));
            }
        } else if (sc.getType().matches(sc.TYPE_LOG)) {
            String level = sc.getType().substring(4);
            Level l = Level.parse(level.toUpperCase());
            logger.log(l, sc.getValue());
            this.monitor.setProgressMessage(sc.getValue());
        }
    }

    public DataSet getDataSet() {
        if (this.delegate == null) {
            System.err.println("never established delegate, which might mean the stream contains no packets.");
            return null;
        }
        return this.delegate.getDataSet();
    }

    private void ensureNotNullDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Null delegate");
        }
    }

    private static double getXWithBase(Datum base, Datum x) {
        if (base == null) {
            return x.doubleValue(x.getUnits());
        }
        return base.doubleValue(base.getUnits()) + x.doubleValue(base.getUnits().getOffsetUnits());
    }

    private class TableDataSetStreamHandler
    implements StreamHandlerDelegate {
        private TableDataSetBuilder builder;

        private TableDataSetStreamHandler(PacketDescriptor pd) throws StreamException {
            StreamYScanDescriptor y = (StreamYScanDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Units xUnits = base != null ? base.getUnits() : pd.getXDescriptor().getUnits();
            Units yUnits = y.getYUnits();
            Units zUnits = y.getZUnits();
            this.builder = new TableDataSetBuilder(xUnits, yUnits, zUnits);
            this.packetDescriptor(pd);
        }

        public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
            StreamYScanDescriptor yscan = (StreamYScanDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Datum x = base == null ? xTag : base.add(xTag);
            DatumVector y = DatumVector.newDatumVector((double[])yscan.getYTags(), (Units)yscan.getYUnits());
            String[] planeIDs = new String[pd.getYCount()];
            for (int i = 0; i < pd.getYCount(); ++i) {
                planeIDs[i] = ((StreamYScanDescriptor)pd.getYDescriptor(i)).getName();
            }
            this.builder.insertYScan(x, y, vectors, planeIDs);
        }

        public void packetDescriptor(PacketDescriptor pd) throws StreamException {
            StreamYScanDescriptor y = (StreamYScanDescriptor)pd.getYDescriptor(0);
            for (int i = 1; i < pd.getYCount(); ++i) {
                y = (StreamYScanDescriptor)pd.getYDescriptor(i);
                this.builder.addPlane(y.getName(), y.getZUnits());
            }
            Map p = pd.getProperties();
            for (String key : p.keySet()) {
                Object p0 = this.builder.getProperty(key);
                if (p0 == null) {
                    this.builder.setProperty(key, p.get(key));
                    continue;
                }
                if (p0.equals(p.get(key))) continue;
                int i2 = 1;
                while (this.builder.getProperty("" + key + "." + i2) != null) {
                    ++i2;
                }
                this.builder.setProperty("" + key + "." + i2, p.get(key));
            }
        }

        public void streamClosed(StreamDescriptor sd) throws StreamException {
        }

        public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        }

        public void streamException(StreamException se) throws StreamException {
        }

        public void streamComment(StreamComment sc) throws StreamException {
        }

        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            if (DataSetStreamHandler.this.monotonic && this.builder.getProperty("xMonotonic") == null) {
                this.builder.setProperty("xMonotonic", Boolean.TRUE);
            }
            return this.builder.toTableDataSet();
        }
    }

    private class VectorDataSetStreamHandler
    implements StreamHandlerDelegate {
        private VectorDataSetBuilder builder;
        private DatumRange validRange = null;
        private double[] doubles = new double[1];

        private VectorDataSetStreamHandler(PacketDescriptor pd) throws StreamException {
            StreamMultiYDescriptor y = (StreamMultiYDescriptor)pd.getYDescriptor(0);
            Datum base = pd.getXDescriptor().getBase();
            Units xUnits = base == null ? pd.getXDescriptor().getUnits() : base.getUnits();
            Units yUnits = y.getUnits();
            this.builder = new VectorDataSetBuilder(xUnits, yUnits);
            String srange = (String)y.getProperty("valid_range");
            if (srange != null) {
                try {
                    this.validRange = DatumRangeUtil.parseDatumRange((String)srange, (Units)yUnits);
                }
                catch (ParseException ex) {
                    throw new StreamException("Unable to parse valid_range:" + srange);
                }
            }
            this.packetDescriptor(pd);
        }

        public void packet(PacketDescriptor pd, Datum xTag, DatumVector[] vectors) throws StreamException {
            Datum base = pd.getXDescriptor().getBase();
            double x = DataSetStreamHandler.getXWithBase(base, xTag);
            for (int i = 0; i < pd.getYCount(); ++i) {
                if (pd.getYDescriptor(i) instanceof StreamMultiYDescriptor) {
                    StreamMultiYDescriptor my = (StreamMultiYDescriptor)pd.getYDescriptor(i);
                    double y = vectors[i].doubleValue(0, my.getUnits());
                    if (this.validRange != null && !this.validRange.contains(Datum.create((double)y, (Units)my.getUnits()))) {
                        y = my.getUnits().getFillDouble();
                    }
                    if (i != 0) {
                        this.builder.insertY(x, y, my.getName());
                        continue;
                    }
                    this.builder.insertY(x, y);
                    continue;
                }
                throw new StreamException("Mixed data sets are not currently supported");
            }
        }

        public void packetDescriptor(PacketDescriptor pd) throws StreamException {
            logger.fine("got packet descriptor: " + pd);
            for (int i = 1; i < pd.getYCount(); ++i) {
                StreamMultiYDescriptor y = (StreamMultiYDescriptor)pd.getYDescriptor(i);
                this.builder.addPlane(y.getName(), y.getUnits());
            }
        }

        public void streamClosed(StreamDescriptor sd) throws StreamException {
        }

        public void streamDescriptor(StreamDescriptor sd) throws StreamException {
        }

        public void streamException(StreamException se) throws StreamException {
        }

        public void streamComment(StreamComment sc) throws StreamException {
        }

        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            if (DataSetStreamHandler.this.monotonic && this.builder.getProperty("xMonotonic") == null) {
                this.builder.setProperty("xMonotonic", Boolean.TRUE);
            }
            return this.builder.toVectorDataSet();
        }
    }

    private static interface StreamHandlerDelegate
    extends StreamHandler {
        public DataSet getDataSet();
    }
}

