/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.CancelledOperationException;
import org.das2.DasException;
import org.das2.DasIOException;
import org.das2.client.DataSetStreamHandler;
import org.das2.client.StandardDataStreamSource;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetBuilder;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamMultiYDescriptor;
import org.das2.stream.StreamTool;
import org.das2.stream.StreamYScanDescriptor;
import org.das2.system.DasLogger;
import org.das2.util.DasProgressMonitorInputStream;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StreamDataSetDescriptor
extends DataSetDescriptor {
    protected StandardDataStreamSource standardDataStreamSource;
    private boolean serverSideReduction = true;
    private PacketDescriptor defaultPacketDescriptor;
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG);
    private static final byte[] HEADER = new byte[]{100, 97, 115, 50, 127, 127};

    public Units getXUnits() {
        return Units.us2000;
    }

    protected StreamDataSetDescriptor(Map properties) {
        this.setProperties(properties);
    }

    protected StreamDataSetDescriptor(Map properties, boolean legacy) {
        this.setProperties(properties, legacy);
    }

    public StreamDataSetDescriptor(StreamDescriptor sd, StandardDataStreamSource sdss) {
        this(sd.getProperties(), "true".equals(sd.getProperty("legacy")));
        this.standardDataStreamSource = sdss;
    }

    public void setStandardDataStreamSource(StandardDataStreamSource sdss) {
        this.standardDataStreamSource = sdss;
    }

    public StandardDataStreamSource getStandardDataStreamSource() {
        return this.standardDataStreamSource;
    }

    protected final void setProperties(Map properties, boolean legacy) {
        super.setProperties(properties);
        if (properties.containsKey("form") && properties.get("form").equals("x_multi_y") && properties.containsKey("items")) {
            this.setDefaultCaching(false);
        }
        if (legacy) {
            this.defaultPacketDescriptor = PacketDescriptor.createLegacyPacketDescriptor(properties);
        }
    }

    protected final void setProperties(Map properties) {
        this.setProperties(properties, false);
    }

    private ByteBuffer getByteBuffer(InputStream in) throws DasException {
        byte[] data = this.readBytes(in);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return buffer;
    }

    protected byte[] readBytes(InputStream in) throws DasException {
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        byte[] data = new byte[4096];
        int bytesRead = 0;
        int lastBytesRead = -1;
        int offset = 0;
        try {
            bytesRead = in.read(data, offset, 4096 - offset);
            while (bytesRead != -1) {
                lastBytesRead = offset += bytesRead;
                if (offset == 4096) {
                    list.addLast(data);
                    data = new byte[4096];
                    offset = 0;
                }
                bytesRead = in.read(data, offset, 4096 - offset);
            }
        }
        catch (IOException e) {
            throw new DasIOException(e);
        }
        if (lastBytesRead >= 0 && lastBytesRead < 4096) {
            list.addLast(data);
        }
        if (list.size() == 0) {
            throw new DasIOException("Error reading data: no data available");
        }
        int dataLength = (list.size() - 1) * 4096 + lastBytesRead;
        data = new byte[dataLength];
        for (int i = 0; i < list.size() - 1; ++i) {
            System.arraycopy(list.get(i), 0, data, i * 4096, 4096);
        }
        System.arraycopy(list.get(list.size() - 1), 0, data, (list.size() - 1) * 4096, lastBytesRead);
        return data;
    }

    public String toString() {
        return "dsd " + this.getDataSetID();
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        InputStream in;
        if (resolution != null && !resolution.isFinite()) {
            throw new IllegalArgumentException("resolution is not finite");
        }
        if (this.serverSideReduction) {
            logger.info("getting stream from standard data stream source");
            in = this.standardDataStreamSource.getReducedInputStream(this, start, end, resolution);
        } else {
            in = this.standardDataStreamSource.getInputStream(this, start, end);
        }
        logger.info("reading stream");
        DataSet result = this.getDataSetFromStream(in, start, end, monitor);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DataSet getDataSetFromStream(InputStream in, Datum start, Datum end, ProgressMonitor monitor) throws DasException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        PushbackInputStream pin = new PushbackInputStream(in, 4096);
        try {
            byte[] four = new byte[4];
            int bytesRead = pin.read(four);
            logger.log(Level.FINER, "read first four bytes bytesRead={0}", bytesRead);
            if (bytesRead != 4) {
                logger.info("no data returned from server");
                throw new DasIOException("No data returned from server");
            }
            if (new String(four).equals("[00]")) {
                logger.finer("got stream header [00]");
                pin.unread(four);
                if (monitor.isCancelled()) {
                    pin.close();
                    throw new InterruptedIOException("Operation cancelled");
                }
                final DasProgressMonitorInputStream mpin = new DasProgressMonitorInputStream((InputStream)pin, monitor);
                logger.finer("creating Channel");
                ReadableByteChannel channel = Channels.newChannel((InputStream)mpin);
                DataSetStreamHandler handler = new DataSetStreamHandler(this.properties, monitor){

                    public void streamDescriptor(StreamDescriptor sd) throws StreamException {
                        super.streamDescriptor(sd);
                        if (this.taskSize != -1) {
                            mpin.setEnableProgressPosition(false);
                        }
                    }
                };
                logger.finer("using StreamTool to read the stream");
                StreamTool.readStream(channel, handler);
                DataSet dataSet = handler.getDataSet();
                return dataSet;
            }
            pin.unread(four);
            if (monitor.isCancelled()) {
                pin.close();
                throw new InterruptedIOException("Operation cancelled");
            }
            monitor.started();
            DasProgressMonitorInputStream mpin = new DasProgressMonitorInputStream((InputStream)pin, monitor);
            if (this.getProperty("form").equals("x_tagged_y_scan")) {
                DataSet dataSet = this.getLegacyTableDataSet((InputStream)mpin, start);
                return dataSet;
            }
            if (this.getProperty("form").equals("x_multi_y")) {
                DataSet dataSet = this.getLegacyVectorDataSet((InputStream)mpin, start);
                return dataSet;
            }
            throw new IllegalStateException("Unrecognized data set type: " + this.getProperty("form"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        catch (IOException ioe) {
            throw new DasIOException(ioe);
        }
        catch (StreamException se) {
            if (!(se.getCause() instanceof InterruptedIOException)) throw se;
            CancelledOperationException e = new CancelledOperationException();
            e.initCause(se);
            throw e;
        }
        finally {
            try {
                pin.close();
            }
            catch (IOException ioe) {}
        }
    }

    private static String getPacketID(byte[] four) throws DasException {
        if (four[0] == 91 && four[3] == 93 || four[0] == 58 && four[3] == 58) {
            return new String(new char[]{(char)four[1], (char)four[2]});
        }
        throw new DasException("Invalid stream, expecting 4 byte header, encountered '" + new String(four) + "'");
    }

    private DataSet getLegacyVectorDataSet(InputStream in0, Datum start) throws DasException {
        try {
            PushbackInputStream in = new PushbackInputStream(in0, 50);
            PacketDescriptor sd = this.getPacketDescriptor(in);
            VectorDataSetBuilder builder = new VectorDataSetBuilder(start.getUnits(), Units.dimensionless);
            for (Object o : sd.getYDescriptors()) {
                if (o instanceof StreamMultiYDescriptor) {
                    StreamMultiYDescriptor y = (StreamMultiYDescriptor)o;
                    String name = y.getName();
                    if (name != null && !name.equals("")) {
                        builder.addPlane(name, y.getUnits());
                        continue;
                    }
                    if (!"".equals(name)) continue;
                    builder.setYUnits(y.getUnits());
                    continue;
                }
                throw new DasIOException("Invalid Stream Header: Non-Y-descriptor encountered");
            }
            StreamMultiYDescriptor[] yDescriptors = sd.getYDescriptors().toArray(new StreamMultiYDescriptor[0]);
            int planeCount = yDescriptors.length - 1;
            String[] planeIDs = new String[planeCount];
            int recordSize = sd.getXDescriptor().getSizeBytes() + yDescriptors[0].getSizeBytes();
            for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                planeIDs[planeIndex] = yDescriptors[planeIndex + 1].getName();
                recordSize += yDescriptors[planeIndex + 1].getSizeBytes();
            }
            ByteBuffer data = this.getByteBuffer(in);
            double timeBaseValue = start.doubleValue(start.getUnits());
            Units offsetUnits = start.getUnits().getOffsetUnits();
            while (data.remaining() > recordSize) {
                DatumVector vector = sd.getXDescriptor().read(data);
                double xTag = timeBaseValue + vector.doubleValue(0, offsetUnits);
                vector = yDescriptors[0].read(data);
                double yValue = vector.doubleValue(0, yDescriptors[0].getUnits());
                builder.insertY(xTag, yValue);
                for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                    vector = yDescriptors[planeIndex + 1].read(data);
                    yValue = vector.doubleValue(0, yDescriptors[planeIndex + 1].getUnits());
                    builder.insertY(xTag, yValue, yDescriptors[planeIndex + 1].getName());
                }
            }
            if (this.properties.containsKey("x_sample_width")) {
                this.properties.put("xTagWidth", Datum.create((double)((Double)this.properties.get("x_sample_width")), (Units)Units.seconds));
            }
            builder.addProperties(this.properties);
            VectorDataSet result = builder.toVectorDataSet();
            return result;
        }
        catch (DasException de) {
            de.printStackTrace();
            throw de;
        }
    }

    private DataSet getLegacyTableDataSet(InputStream in0, Datum start) throws DasException {
        PushbackInputStream in = new PushbackInputStream(in0, 50);
        PacketDescriptor sd = this.getPacketDescriptor(in);
        TableDataSetBuilder builder = new TableDataSetBuilder(start.getUnits(), Units.dimensionless, Units.dimensionless);
        Units yUnits = Units.dimensionless;
        for (Object o : sd.getYDescriptors()) {
            if (o instanceof StreamYScanDescriptor) {
                StreamYScanDescriptor scan = (StreamYScanDescriptor)o;
                String name = scan.getName();
                if (name == null || name.equals("")) continue;
                builder.addPlane(name, scan.getZUnits());
                continue;
            }
            throw new DasIOException("Invalid Stream Header: Non-yScan descriptor encountered");
        }
        StreamYScanDescriptor[] yScans = sd.getYDescriptors().toArray(new StreamYScanDescriptor[0]);
        int planeCount = yScans.length;
        String[] planeIDs = new String[planeCount];
        int recordSize = sd.getXDescriptor().getSizeBytes();
        for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
            planeIDs[planeIndex] = yScans[planeIndex].getName();
            recordSize += yScans[planeIndex].getSizeBytes();
        }
        ByteBuffer data = this.getByteBuffer(in);
        double[] yCoordinates = yScans[0].getYTags();
        DatumVector y = DatumVector.newDatumVector((double[])yCoordinates, (Units)yUnits);
        while (data.remaining() > recordSize) {
            DatumVector vector = sd.getXDescriptor().read(data);
            Datum xTag = start.add(vector.get(0));
            DatumVector[] z = new DatumVector[planeCount];
            for (int planeIndex = 0; planeIndex < planeCount; ++planeIndex) {
                z[planeIndex] = yScans[planeIndex].read(data);
            }
            builder.insertYScan(xTag, y, z, planeIDs);
        }
        if (this.properties.containsKey("x_sample_width")) {
            this.properties.put("xTagWidth", Datum.create((double)((Double)this.properties.get("x_sample_width")), (Units)Units.seconds));
        }
        builder.addProperties(this.properties);
        TableDataSet result = builder.toTableDataSet();
        return result;
    }

    private PacketDescriptor getPacketDescriptor(PushbackInputStream in) throws DasIOException {
        try {
            byte[] four = new byte[HEADER.length];
            int bytesRead = 0;
            int totalBytesRead = 0;
            do {
                if ((bytesRead = in.read(four, totalBytesRead, HEADER.length - totalBytesRead)) == -1) continue;
                totalBytesRead += bytesRead;
            } while (totalBytesRead < HEADER.length && bytesRead != -1);
            if (Arrays.equals(four, HEADER)) {
                byte[] header = StreamTool.advanceTo(in, "\u007f\u007f".getBytes());
                ByteArrayInputStream source = new ByteArrayInputStream(header);
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(source);
                Element docNode = document.getDocumentElement();
                PacketDescriptor packetDescriptor = new PacketDescriptor(docNode);
                return packetDescriptor;
            }
            in.unread(four, 0, totalBytesRead);
            return this.defaultPacketDescriptor;
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        catch (StreamTool.DelimeterNotFoundException dnfe) {
            DasIOException dioe = new DasIOException(dnfe.getMessage());
            dioe.initCause(dioe);
            throw dioe;
        }
        catch (SAXException ex) {
            DasIOException e = new DasIOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        catch (IOException ex) {
            throw new DasIOException(ex);
        }
    }

    public boolean isRestrictedAccess() {
        boolean result = this.getProperty("groupAccess") != null ? !"".equals(this.getProperty("groupAccess")) : false;
        return result;
    }

    public void setServerSideReduction(boolean x) {
        this.serverSideReduction = x;
    }

    public boolean isServerSideReduction() {
        return this.serverSideReduction;
    }

    public PacketDescriptor getDefaultPacketDescriptor() {
        return this.defaultPacketDescriptor;
    }
}

