/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.util.DasDie;

public class DasAxisSelector
extends JPanel
implements ActionListener {
    private DasAxis axis = null;
    JTextField idStart = null;
    JTextField idStop = null;

    private DasAxisSelector() {
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new FlowLayout(2));
        this.idStart = new JTextField("");
        this.idStart.setSize(9, 1);
        this.idStart.addActionListener(this);
        this.idStart.setActionCommand("setMinimum");
        this.add(this.idStart);
        this.idStop = new JTextField("");
        this.idStop.setSize(9, 1);
        this.idStop.addActionListener(this);
        this.idStop.setActionCommand("setMaximum");
        this.add(this.idStop);
    }

    public DasAxisSelector(DasAxis axis) {
        this();
        this.axis = axis;
        this.update();
    }

    public double getStartTime() {
        double s1 = Double.valueOf(this.idStart.getText());
        return s1;
    }

    public double getEndTime() {
        double s1 = Double.valueOf(this.idStop.getText());
        return s1;
    }

    private void update() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        this.idStart.setText(df.format(this.axis.getDataMinimum()));
        this.idStop.setText(df.format(this.axis.getDataMaximum()));
        this.idStart.setText("" + this.axis.getDataMinimum());
        this.idStop.setText("" + this.axis.getDataMaximum());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        this.update();
        if (command.equals("setMinimum")) {
            try {
                this.axis.setDataRange(Datum.create((double)Double.valueOf(this.idStart.getText()), (Units)this.axis.getUnits()), this.axis.getDataMaximum());
            }
            catch (NumberFormatException e) {
                DasDie.println((Object)e);
            }
        } else if (command.equals("setMaximum")) {
            try {
                this.axis.setDataRange(this.axis.getDataMinimum(), Datum.create((double)Double.valueOf(this.idStop.getText()), (Units)this.axis.getUnits()));
            }
            catch (NumberFormatException e) {
                DasDie.println((Object)e);
            }
        }
    }
}

