/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.DasLogger;
import org.das2.util.NumberFormatUtil;
import org.das2.util.monitor.ProgressMonitor;

public class DasProgressPanel
implements ProgressMonitor {
    public static final String MSG_CANCEL_TASK = "cancel task";
    public static final String MSG_TASK_CANNOT_BE_CANCELED = "task cannot be cancelled";
    private long taskStartedTime;
    private long currentTaskPosition;
    private long maximumTaskPosition;
    private DecimalFormat transferRateFormat;
    private String transferRateString;
    private JLabel taskLabel;
    private boolean labelDirty = false;
    private JLabel progressMessageLabel;
    private String progressMessageString;
    private boolean progressMessageDirty = false;
    private JLabel kbLabel;
    private JProgressBar progressBar;
    private Window jframe = null;
    private boolean isCancelled = false;
    private JButton cancelButton;
    private int cancelCheckFailures = 0;
    private boolean cancelChecked = false;
    private String label;
    private static final int hideInitiallyMilliSeconds = 300;
    private static final int refreshPeriodMilliSeconds = 500;
    private boolean running = false;
    private boolean finished = false;
    private Thread updateThread;
    private static final Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    private boolean showProgressRate;
    private JPanel thePanel;
    private boolean componentsInitialized = false;
    private DasCanvasComponent parentComponent;
    private DasCanvas parentCanvas;
    private static int createComponentCount = 0;
    Exception source;
    Exception consumer;
    ImageIcon cancel = new ImageIcon(DasProgressPanel.class.getResource("/images/cancel14.png"));
    ImageIcon cancelGrey = new ImageIcon(DasProgressPanel.class.getResource("/images/cancelGrey14.png"));

    public DasProgressPanel(String label) {
        this.label = label;
        this.transferRateFormat = NumberFormatUtil.getDecimalFormat();
        this.transferRateFormat.setMaximumFractionDigits(2);
        this.maximumTaskPosition = -1L;
        this.showProgressRate = true;
        this.isCancelled = false;
        this.running = false;
    }

    public Component getComponent() {
        if (!this.componentsInitialized) {
            this.initComponents();
        }
        return this.thePanel;
    }

    public static DasProgressPanel createComponentPanel(DasCanvasComponent component, String initialMessage) {
        DasProgressPanel progressPanel = new DasProgressPanel(initialMessage);
        progressPanel.parentComponent = component;
        return progressPanel;
    }

    public static DasProgressPanel createComponentPanel(DasCanvas canvas, String initialMessage) {
        DasProgressPanel progressPanel = new DasProgressPanel(initialMessage);
        progressPanel.parentCanvas = canvas;
        return progressPanel;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public static DasProgressPanel createFramed(String label) {
        DasProgressPanel result = new DasProgressPanel(label);
        JFrame fr = new JFrame("Progress Monitor");
        result.jframe = fr;
        result.initComponents();
        fr.getContentPane().add(result.thePanel);
        fr.pack();
        fr.setVisible(false);
        fr.setDefaultCloseOperation(2);
        return result;
    }

    public static DasProgressPanel createFramed(Window parent, String label) {
        DasProgressPanel result = new DasProgressPanel(label);
        if (parent instanceof JFrame) {
            result.jframe = new JDialog((Frame)((JFrame)parent), "Progress Monitor");
        } else if (parent instanceof Dialog) {
            result.jframe = new JDialog((Dialog)parent, "Progress Monitor");
        }
        result.initComponents();
        result.jframe.add(result.thePanel);
        result.jframe.pack();
        result.jframe.setLocationRelativeTo(parent);
        result.jframe.setVisible(false);
        return result;
    }

    public void setLabel(String label) {
        this.label = label;
        this.labelDirty = true;
        if (this.thePanel != null) {
            this.thePanel.repaint();
        }
    }

    public String getLabel() {
        return this.label;
    }

    private void initComponents() {
        ++createComponentCount;
        this.taskLabel = new JLabel();
        this.taskLabel.setOpaque(false);
        this.taskLabel.setFont(new Font("Dialog", 1, 14));
        this.taskLabel.setHorizontalAlignment(0);
        this.taskLabel.setText(this.label);
        this.taskLabel.setAlignmentX(0.5f);
        this.progressMessageLabel = new JLabel(){

            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        this.progressMessageLabel.setOpaque(false);
        this.progressMessageLabel.setFont(new Font("Dialog", 1, 8));
        this.progressMessageLabel.setHorizontalAlignment(0);
        this.progressMessageLabel.setText(" ");
        this.progressMessageLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar();
        this.progressBar.setOpaque(false);
        this.progressBar.setPreferredSize(new Dimension(150, 14));
        this.progressBar.setMaximumSize(this.progressBar.getPreferredSize());
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.progressBar.setAlignmentX(0.5f);
        this.kbLabel = new JLabel();
        this.kbLabel.setOpaque(false);
        this.kbLabel.setHorizontalAlignment(0);
        this.kbLabel.setText("0 kb");
        this.kbLabel.setAlignmentX(0.5f);
        this.kbLabel.setMaximumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setMinimumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.kbLabel.setAlignmentX(0.5f);
        JPanel progressBarPanel = new JPanel(new BorderLayout());
        this.cancelButton = new JButton(this.cancelGrey);
        Dimension cs = new Dimension(20, 20);
        this.cancelButton.setMaximumSize(cs);
        this.cancelButton.setMinimumSize(cs);
        this.cancelButton.setPreferredSize(cs);
        this.cancelButton.setMargin(new Insets(2, 2, 2, 2));
        this.cancelButton.setToolTipText(MSG_TASK_CANNOT_BE_CANCELED);
        this.cancelButton.setEnabled(false);
        this.cancelButton.setVerticalAlignment(0);
        this.cancelButton.setOpaque(false);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DasProgressPanel.this.cancel();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.taskLabel);
        mainPanel.add(this.progressMessageLabel);
        progressBarPanel.add((Component)this.progressBar, "Center");
        progressBarPanel.add((Component)this.cancelButton, "East");
        mainPanel.add(progressBarPanel);
        mainPanel.add(this.kbLabel);
        this.thePanel = new MyPanel();
        this.thePanel.setOpaque(false);
        this.thePanel.setLayout(new BorderLayout());
        this.thePanel.add((Component)mainPanel, "Center");
        if (this.parentComponent != null) {
            this.thePanel.setSize(this.thePanel.getPreferredSize());
            int x = this.parentComponent.getColumn().getDMiddle();
            int y = this.parentComponent.getRow().getDMiddle();
            this.thePanel.setLocation(x - this.thePanel.getWidth() / 2, y - this.thePanel.getHeight() / 2);
            ((Container)this.parentComponent.getCanvas().getGlassPane()).add(this.thePanel);
            this.thePanel.setVisible(false);
        } else if (this.parentCanvas != null) {
            this.thePanel.setSize(this.thePanel.getPreferredSize());
            int x = this.parentCanvas.getWidth() / 2;
            int y = this.parentCanvas.getHeight() / 2;
            this.thePanel.setLocation(x - this.thePanel.getWidth() / 2, y - this.thePanel.getHeight() / 2);
            ((Container)this.parentCanvas.getGlassPane()).add(this.thePanel);
            this.thePanel.setVisible(false);
        }
        this.componentsInitialized = true;
    }

    public synchronized void finished() {
        this.running = false;
        this.finished = true;
        if (this.jframe == null) {
            this.setVisible(false);
        } else {
            this.jframe.dispose();
        }
    }

    public void setTaskProgress(long position) throws IllegalStateException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "progressPosition={0}", position);
        }
        if (this.isCancelled) {
            logger.fine("setTaskProgress called when isCancelled true. consider checking isCancelled before calling setTaskProgress.");
            throw new IllegalStateException("Operation cancelled: developers: consider checking isCancelled before calling setTaskProgress.");
        }
        if (!this.running) {
            throw new IllegalStateException("setTaskProgress called before started");
        }
        if (position != 0L && position < this.currentTaskPosition) {
            logger.finest("progress position goes backwards");
        }
        if (!this.cancelChecked) {
            ++this.cancelCheckFailures;
        }
        this.cancelChecked = false;
        if (this.maximumTaskPosition == 0L) {
            throw new IllegalArgumentException("when taskSize is 0, setTaskProgress must not be called.");
        }
        this.currentTaskPosition = position;
        long elapsedTimeMs = System.currentTimeMillis() - this.taskStartedTime;
        if (elapsedTimeMs > 300L && !this.isVisible()) {
            this.setVisible(true);
        }
    }

    private void startUpdateThread() {
        Runnable run = new Runnable(){

            public void run() {
                while (!DasProgressPanel.this.finished) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                DasProgressPanel.this.updateUIComponents();
                                DasProgressPanel.this.thePanel.repaint();
                            }
                        });
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(DasProgressPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(DasProgressPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
        this.updateThread = new Thread(run, "progressMonitorUpdateThread");
        this.updateThread.start();
    }

    private void updateUIComponents() {
        boolean cancelEnabled;
        long elapsedTimeMs = System.currentTimeMillis() - this.taskStartedTime;
        long kb = this.currentTaskPosition;
        if (this.maximumTaskPosition == -1L) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
        }
        if (this.maximumTaskPosition > 0L) {
            this.progressBar.setValue((int)(kb * 100L / this.maximumTaskPosition));
        } else {
            this.progressBar.setValue((int)kb % 100);
        }
        String bytesReadLabel = this.maximumTaskPosition > 0L ? "" + kb + "/" + this.maximumTaskPosition + "" : "" + kb + "";
        if (this.progressMessageDirty) {
            if (this.progressMessageString.length() > 33) {
                int n = this.progressMessageString.length();
                this.progressMessageString = this.progressMessageString.substring(0, 10) + "..." + this.progressMessageString.substring(n - 22, n);
            }
            this.progressMessageLabel.setText(this.progressMessageString);
            this.progressMessageDirty = false;
        }
        if (this.labelDirty) {
            this.taskLabel.setText(this.label);
            this.labelDirty = false;
        }
        if (this.showProgressRate && elapsedTimeMs > 1000L && this.transferRateString != null) {
            this.kbLabel.setText(bytesReadLabel + " " + this.transferRateString);
        } else {
            this.kbLabel.setText(bytesReadLabel);
        }
        boolean bl = cancelEnabled = this.cancelCheckFailures < 2;
        if (cancelEnabled != this.cancelButton.isEnabled()) {
            this.cancelButton.setEnabled(cancelEnabled);
            if (cancelEnabled) {
                this.cancelButton.setIcon(this.cancel);
                this.cancelButton.setToolTipText(MSG_CANCEL_TASK);
            } else {
                this.cancelButton.setIcon(this.cancelGrey);
                this.cancelButton.setToolTipText(MSG_TASK_CANNOT_BE_CANCELED);
            }
        }
    }

    @Deprecated
    public void setAdditionalInfo(String s) {
        this.transferRateString = s;
    }

    public long getTaskProgress() {
        return this.currentTaskPosition;
    }

    public long getTaskSize() {
        return this.maximumTaskPosition;
    }

    public void setTaskSize(long taskSize) {
        if (taskSize < -1L) {
            throw new IllegalArgumentException("taskSize must be positive, -1, or 0, not " + taskSize);
        }
        if (this.componentsInitialized) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DasProgressPanel.this.progressBar.setIndeterminate(false);
                }
            });
        }
        this.maximumTaskPosition = taskSize;
    }

    public synchronized void setVisible(boolean visible) {
        if (!this.componentsInitialized && !visible) {
            return;
        }
        if (!this.componentsInitialized && !this.finished) {
            this.initComponents();
        }
        if (this.thePanel != null) {
            this.thePanel.setVisible(visible);
        }
        if (this.jframe != null) {
            this.jframe.setVisible(visible);
        }
        if (visible) {
            this.startUpdateThread();
        }
    }

    public boolean isVisible() {
        return !this.componentsInitialized || this.thePanel.isVisible();
    }

    public void started() {
        this.taskStartedTime = System.currentTimeMillis();
        this.running = true;
        this.setVisible(false);
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DasProgressPanel.this.running) {
                    logger.log(Level.FINE, "hide time={0}", System.currentTimeMillis() - DasProgressPanel.this.taskStartedTime);
                    DasProgressPanel.this.setVisible(true);
                }
            }
        }, "progressPanelUpdateThread").start();
        if (this.isCancelled) {
            return;
        }
        if (this.maximumTaskPosition > 0L) {
            this.setTaskProgress(0L);
        }
    }

    public void cancel() {
        this.isCancelled = true;
        this.finished();
    }

    public boolean isCancelled() {
        this.cancelCheckFailures = 0;
        this.cancelChecked = true;
        return this.isCancelled;
    }

    public Exception getSource() {
        return this.source;
    }

    public Exception getConsumer() {
        return this.consumer;
    }

    public void setShowProgressRate(boolean showProgressRate) {
        this.showProgressRate = showProgressRate;
    }

    public String toString() {
        if (this.isCancelled) {
            return "cancelled";
        }
        if (this.finished) {
            return "finished";
        }
        if (this.running) {
            return "" + this.currentTaskPosition + " of " + this.maximumTaskPosition;
        }
        return "waiting for start";
    }

    public void setProgressMessage(String message) {
        this.progressMessageString = message;
        this.progressMessageDirty = true;
    }

    public boolean isStarted() {
        return this.running;
    }

    public boolean isFinished() {
        return this.finished;
    }

    class MyPanel
    extends JPanel {
        MyPanel() {
        }

        protected void paintComponent(Graphics g1) {
            Graphics2D g2 = (Graphics2D)g1;
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.setColor(new Color(-587202561, true));
            Rectangle rect = g2.getClipBounds();
            if (rect == null) {
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            super.paintComponent(g1);
        }
    }
}

