/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.ArrayList;
import java.util.List;
import org.das2.dataset.AbstractDataSetCache;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUtil;
import org.das2.datum.Datum;
import org.das2.datum.Units;

public class LimitSizeBytesDataSetCache
extends AbstractDataSetCache {
    List entries = new ArrayList();
    long totalSize = 0L;
    long totalSizeLimit;

    public LimitSizeBytesDataSetCache(long totalSizeLimitBytes) {
        this.totalSizeLimit = totalSizeLimitBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDataSetCache.Entry findStored(DataSetDescriptor dsd, CacheTag cacheTag) {
        AbstractDataSetCache.Entry entry = new AbstractDataSetCache.Entry(dsd, cacheTag, null);
        AbstractDataSetCache.Entry iHit = null;
        List list = this.entries;
        synchronized (list) {
            for (AbstractDataSetCache.Entry testEntry : this.entries) {
                if (!testEntry.satifies(entry)) continue;
                iHit = testEntry;
            }
        }
        return iHit;
    }

    boolean haveStoredImpl(DataSetDescriptor dsd, CacheTag cacheTag) {
        AbstractDataSetCache.Entry entry = this.findStored(dsd, cacheTag);
        return entry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        List list = this.entries;
        synchronized (list) {
            this.entries.clear();
            this.totalSize = 0L;
        }
    }

    DataSet retrieveImpl(DataSetDescriptor dsd, CacheTag cacheTag) {
        AbstractDataSetCache.Entry entry = this.findStored(dsd, cacheTag);
        if (entry != null) {
            ++entry.nhits;
            return entry.getData();
        }
        throw new IllegalArgumentException("not found in cache");
    }

    private AbstractDataSetCache.Entry leastValuableEntry() {
        AbstractDataSetCache.Entry result = (AbstractDataSetCache.Entry)this.entries.get(0);
        long value = this.cacheValue(result);
        for (AbstractDataSetCache.Entry test : this.entries) {
            long testValue = this.cacheValue(test);
            if (testValue >= value) continue;
            result = test;
            value = testValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(DataSetDescriptor dsd, CacheTag cacheTag, DataSet data) {
        long sizeBytes = DataSetUtil.guessSizeBytes(data);
        if (sizeBytes > this.totalSizeLimit) {
            return;
        }
        List list = this.entries;
        synchronized (list) {
            while (sizeBytes + this.totalSize > this.totalSizeLimit) {
                AbstractDataSetCache.Entry e = this.leastValuableEntry();
                long s = DataSetUtil.guessSizeBytes(e.data);
                this.entries.remove(e);
                this.totalSize -= s;
            }
            this.entries.add(new AbstractDataSetCache.Entry(dsd, cacheTag, data));
            this.totalSize += sizeBytes;
        }
    }

    public AbstractDataSetCache.Entry[] getEntries() {
        return this.entries.toArray(new AbstractDataSetCache.Entry[this.entries.size()]);
    }

    public AbstractDataSetCache.Entry getEntries(int i) {
        return (AbstractDataSetCache.Entry)this.entries.get(i);
    }

    public Datum getTotalSize() {
        return Units.kiloBytes.createDatum((double)this.totalSize / 1000.0, 0.1);
    }

    public Datum getTotalSizeLimit() {
        return Units.kiloBytes.createDatum((double)this.totalSizeLimit / 1000.0, 0.1);
    }

    public void setTotalSizeLimit(Datum d) {
        this.totalSizeLimit = (long)(d.doubleValue(Units.kiloBytes) * 1000.0);
    }

    public Datum getHitRate() {
        return Units.percent.createDatum((double)this.hits * 100.0 / (double)(this.hits + this.misses), 0.1);
    }

    public String getDisplayString() {
        StringBuffer result = new StringBuffer("LimitSizeBytesDataSetCache with " + this.entries.size() + " datasets");
        for (int i = 0; i < this.entries.size(); ++i) {
            result.append("\n" + this.entries.get(i));
        }
        result.append("\n");
        return result.toString();
    }
}

