/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.DatumVectorAdapter;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.Slice0DataSet;

public class Rank3TableDataSetAdapter
implements TableDataSet {
    Units xunits;
    Units yunits;
    Units zunits;
    QDataSet x;
    QDataSet y;
    QDataSet z;
    HashMap properties = new HashMap();
    int[] tables;
    HashMap<String, QDataSet> planes = new LinkedHashMap<String, QDataSet>();

    public static TableDataSet create(QDataSet z) {
        QDataSet sort;
        QDataSet yds;
        QDataSet xds = (QDataSet)z.property("DEPEND_0");
        if (xds == null) {
            xds = new IndexGenDataSet(z.length());
        }
        if ((yds = (QDataSet)z.property("DEPEND_1")) == null) {
            yds = new IndexGenDataSet(z.length(0));
        }
        if (!DataSetUtil.isMonotonic((QDataSet)xds)) {
            sort = DataSetOps.sort((QDataSet)xds);
            z = DataSetOps.applyIndex((QDataSet)z, (int)0, (QDataSet)sort, (boolean)false);
            xds = DataSetOps.applyIndex((QDataSet)xds, (int)0, (QDataSet)sort, (boolean)false);
        }
        if (!DataSetUtil.isMonotonic((QDataSet)yds)) {
            sort = DataSetOps.sort((QDataSet)yds);
            z = DataSetOps.applyIndex((QDataSet)z, (int)1, (QDataSet)sort, (boolean)false);
            yds = DataSetOps.applyIndex((QDataSet)yds, (int)0, (QDataSet)sort, (boolean)false);
        }
        return new Rank3TableDataSetAdapter(z, xds, yds);
    }

    public Rank3TableDataSetAdapter(QDataSet z, QDataSet x, QDataSet y) {
        Datum dcadence;
        RankZeroDataSet cadence;
        this.planes.put("", z);
        this.xunits = (Units)x.property("UNITS");
        this.yunits = (Units)y.property("UNITS");
        this.zunits = (Units)z.property("UNITS");
        if (this.xunits == null) {
            this.xunits = Units.dimensionless;
        }
        if (this.yunits == null) {
            this.yunits = Units.dimensionless;
        }
        if (this.zunits == null) {
            this.zunits = Units.dimensionless;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        Boolean xMono = (Boolean)x.property("MONOTONIC", 0);
        if (xMono != null && xMono.booleanValue()) {
            this.properties.put("xMonotonic", Boolean.TRUE);
        }
        if ((cadence = (RankZeroDataSet)x.property("CADENCE", 0)) != null) {
            dcadence = DataSetUtil.asDatum((RankZeroDataSet)cadence);
            this.properties.put("xTagWidth", dcadence);
        }
        if ((cadence = (RankZeroDataSet)y.property("CADENCE", 0)) != null) {
            dcadence = DataSetUtil.asDatum((RankZeroDataSet)cadence);
            this.properties.put("yTagWidth", dcadence);
        }
        if (z.property("FILL_VALUE", 0) != null || z.property("VALID_MIN", 0) != null || z.property("VALID_MAX", 0) != null) {
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)z);
            this.planes.put("weights", wds);
        }
        this.tables = new int[z.length() + 1];
        for (int i = 1; i <= z.length(); ++i) {
            this.tables[i] = this.tables[i - 1] + z.length(i - 1);
        }
    }

    public Units getZUnits() {
        return this.zunits;
    }

    public Datum getDatum(int i, int j) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return this.zunits.createDatum(this.z.value(i0, i1, j));
    }

    public double getDouble(int i, int j, Units units) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return this.zunits.convertDoubleTo(units, this.z.value(i0, i1, j));
    }

    public double[] getDoubleScan(int i, Units units) {
        int i0 = this.tableOfIndex(i);
        double[] zz = new double[this.getYLength(i0)];
        for (int j = 0; j < zz.length; ++j) {
            zz[j] = this.getDouble(i, j, this.getZUnits());
        }
        return zz;
    }

    public DatumVector getScan(int i) {
        double[] zz = this.getDoubleScan(i, this.getZUnits());
        return DatumVector.newDatumVector((double[])zz, (Units)this.getZUnits());
    }

    public int getInt(int i, int j, Units units) {
        return (int)this.getDouble(i, j, units);
    }

    public DatumVector getYTags(int table) {
        return DatumVectorAdapter.toDatumVector((QDataSet)new Slice0DataSet(this.y, table));
    }

    public Datum getYTagDatum(int table, int j) {
        return this.yunits.createDatum(this.y.value(table, j));
    }

    public double getYTagDouble(int table, int j, Units units) {
        return this.yunits.convertDoubleTo(units, this.y.value(table, j));
    }

    public int getYTagInt(int table, int j, Units units) {
        return (int)this.getYTagDouble(table, j, units);
    }

    public int getYLength(int table) {
        return this.y.length(table);
    }

    public int tableStart(int table) {
        return this.tables[table];
    }

    public int tableEnd(int table) {
        return this.tables[table + 1];
    }

    public int tableCount() {
        return this.z.length();
    }

    public int tableOfIndex(int i) {
        for (int j = 0; j < this.tables.length - 1; ++j) {
            if (i < this.tables[j] || i >= this.tables[j + 1]) continue;
            return j;
        }
        throw new IndexOutOfBoundsException("index out of bounds: " + i);
    }

    public VectorDataSet getXSlice(int i) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return new VectorDataSetAdapter((QDataSet)DataSetOps.slice0((QDataSet)DataSetOps.slice0((QDataSet)this.z, (int)i0), (int)i1), (QDataSet)DataSetOps.slice0((QDataSet)this.y, (int)i0));
    }

    public VectorDataSet getYSlice(int j, int table) {
        return new VectorDataSetAdapter((QDataSet)DataSetOps.slice1((QDataSet)DataSetOps.slice0((QDataSet)this.z, (int)table), (int)j), (QDataSet)DataSetOps.slice0((QDataSet)this.x, (int)table));
    }

    public Object getProperty(String name) {
        Object result = this.properties.get(name);
        return result != null ? result : this.z.property(name);
    }

    public Object getProperty(int table, String name) {
        return this.getProperty(name);
    }

    public Map getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("UNITS", null);
        HashMap m = new HashMap(DataSetUtil.getProperties((QDataSet)this.z, result));
        m.putAll(this.properties);
        return m;
    }

    public Units getXUnits() {
        return this.xunits;
    }

    public Units getYUnits() {
        return this.yunits;
    }

    public Datum getXTagDatum(int i) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return this.xunits.createDatum(this.x.value(i0, i1));
    }

    public double getXTagDouble(int i, Units units) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return this.xunits.convertDoubleTo(units, this.x.value(i0, i1));
    }

    public int getXTagInt(int i, Units units) {
        int i0 = this.tableOfIndex(i);
        int i1 = i - this.tableStart(i0);
        return (int)this.xunits.convertDoubleTo(units, this.x.value(i0, i1));
    }

    public int getXLength() {
        return this.tables[this.tables.length - 1];
    }

    public DataSet getPlanarView(String planeID) {
        if (planeID.equals("")) {
            return this;
        }
        if (this.planes.containsKey(planeID)) {
            return new TableDataSetAdapter(this.planes.get(planeID), this.x, this.y);
        }
        return null;
    }

    public String[] getPlaneIds() {
        return this.planes.keySet().toArray(new String[this.planes.keySet().size()]);
    }

    public String toString() {
        return DataSetUtil.toString((QDataSet)this.z);
    }
}

