/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;

public class VectorDataSetAdapter
implements VectorDataSet {
    Units xunits;
    Units yunits;
    Units zunits;
    QDataSet x;
    QDataSet y;
    HashMap<String, QDataSet> planes;
    HashMap properties = new HashMap();

    public static VectorDataSet create(QDataSet y) {
        QDataSet xds = (QDataSet)y.property("DEPEND_0");
        Units xunits = SemanticOps.getUnits((QDataSet)xds);
        if (UnitsUtil.isTimeLocation((Units)xunits)) {
            UnitsConverter uc = UnitsConverter.getConverter((Units)xunits, (Units)Units.us2000);
            ArrayDataSet xx = ArrayDataSet.copy((QDataSet)xds);
            for (int i = 0; i < xds.length(); ++i) {
                xx.putValue(i, uc.convert(xx.value(i)));
            }
            xx.putProperty("UNITS", (Object)Units.us2000);
            xds = xx;
        }
        return new VectorDataSetAdapter(y, xds);
    }

    public static VectorDataSet createFromBundle(QDataSet bds) {
        QDataSet bdesc = (QDataSet)bds.property("BUNDLE_1");
        int dependentParameter = bdesc.length() - 1;
        QDataSet y = DataSetOps.unbundle((QDataSet)bds, (int)dependentParameter);
        QDataSet x = (QDataSet)y.property("DEPEND_0");
        String context = (String)bdesc.property("CONTEXT_0", dependentParameter);
        if (context != null) {
            String[] ss = context.split(",");
            if (ss.length == 1 && x != null) {
                y = DataSetOps.unbundle((QDataSet)bds, (String)ss[0]);
            } else if (ss.length == 2) {
                QDataSet z = y;
                if (x == null) {
                    x = DataSetOps.unbundle((QDataSet)bds, (String)ss[0]);
                }
                y = DataSetOps.unbundle((QDataSet)bds, (String)ss[1]);
                ((MutablePropertyDataSet)y).putProperty("PLANE_0", (Object)z);
            } else if (ss.length == 1) {
                x = DataSetOps.unbundle((QDataSet)bds, (String)ss[0]);
            }
        }
        return new VectorDataSetAdapter(y, x);
    }

    public VectorDataSetAdapter(QDataSet y, QDataSet x) {
        QDataSet dp;
        RankZeroDataSet cadence;
        String name;
        QDataSet pds;
        if (y.rank() != 1) {
            throw new IllegalArgumentException("y (rank=" + y.rank() + ") is not rank 1");
        }
        if (x == null) {
            x = new IndexGenDataSet(y.length());
        }
        if (x != null && x.rank() != 1) {
            throw new IllegalArgumentException("x (rank=" + x.rank() + ") is not rank 1");
        }
        this.xunits = (Units)x.property("UNITS");
        if (this.xunits == null) {
            this.xunits = Units.dimensionless;
        }
        this.yunits = (Units)y.property("UNITS");
        if (this.yunits == null) {
            this.yunits = Units.dimensionless;
        }
        this.x = x;
        this.y = y;
        this.planes = new LinkedHashMap<String, QDataSet>();
        this.planes.put("", y);
        for (int i = 0; i < 50 && (pds = (QDataSet)y.property(name = "PLANE_" + i)) != null; ++i) {
            if (i == 0) {
                this.planes.put(name, pds);
            }
            if (pds.property("NAME") != null) {
                name = (String)pds.property("NAME");
            }
            this.planes.put(name, pds);
        }
        Boolean xMono = (Boolean)x.property("MONOTONIC");
        if (xMono != null && xMono.booleanValue()) {
            this.properties.put("xMonotonic", Boolean.TRUE);
        }
        if ((cadence = (RankZeroDataSet)x.property("CADENCE")) != null) {
            Datum dcadence = DataSetUtil.asDatum((RankZeroDataSet)cadence);
            this.properties.put("xTagWidth", dcadence);
        }
        if (y.property("FILL_VALUE") != null || y.property("VALID_MIN") != null || y.property("VALID_MAX") != null) {
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)y);
            this.planes.put("weights", wds);
        }
        if ((dp = (QDataSet)this.y.property("DELTA_PLUS")) != null) {
            if (dp.property("UNITS") == null) {
                dp = DDataSet.copy((QDataSet)dp);
                ((MutablePropertyDataSet)dp).putProperty("UNITS", (Object)this.yunits.getOffsetUnits());
            }
            this.planes.put("Y_DELTA_PLUS", dp);
        }
        if ((dp = (QDataSet)this.y.property("DELTA_MINUS")) != null) {
            if (dp.property("UNITS") == null) {
                dp = DDataSet.copy((QDataSet)dp);
                ((MutablePropertyDataSet)dp).putProperty("UNITS", (Object)this.yunits.getOffsetUnits());
            }
            this.planes.put("Y_DELTA_MINUS", dp);
        }
    }

    public Datum getDatum(int i) {
        return this.yunits.createDatum(this.y.value(i));
    }

    public double getDouble(int i, Units units) {
        return this.yunits.convertDoubleTo(units, this.y.value(i));
    }

    public int getInt(int i, Units units) {
        return (int)this.yunits.convertDoubleTo(units, this.y.value(i));
    }

    public Object getProperty(String name) {
        Object result = this.properties.get(name);
        return result != null ? result : this.y.property(name);
    }

    public Map getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("UNITS", null);
        HashMap m = new HashMap(DataSetUtil.getProperties((QDataSet)this.y, result));
        m.putAll(this.properties);
        return m;
    }

    public Units getXUnits() {
        return this.xunits;
    }

    public Units getYUnits() {
        return this.yunits;
    }

    public Datum getXTagDatum(int i) {
        return this.xunits.createDatum(this.x.value(i));
    }

    public double getXTagDouble(int i, Units units) {
        return this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    public int getXTagInt(int i, Units units) {
        return (int)this.xunits.convertDoubleTo(units, this.x.value(i));
    }

    public int getXLength() {
        return this.x.length();
    }

    public DataSet getPlanarView(String planeID) {
        if (planeID.equals("")) {
            return this;
        }
        if (this.planes.containsKey(planeID)) {
            return new VectorDataSetAdapter(this.planes.get(planeID), this.x);
        }
        return null;
    }

    public String[] getPlaneIds() {
        return this.planes.keySet().toArray(new String[this.planes.keySet().size()]);
    }

    public String toString() {
        return DataSetUtil.toString((QDataSet)this.y);
    }
}

