/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.das2.event.DragRenderer;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasCanvasComponent;

public class BoxRenderer
implements DragRenderer {
    Rectangle dirtyBounds;
    DasCanvasComponent parent;
    boolean updating;
    Point overrideP1;

    public BoxRenderer(DasCanvasComponent parent, boolean updating) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
        this.updating = updating;
    }

    public BoxRenderer(DasCanvasComponent parent) {
        this(parent, false);
    }

    public void clear(Graphics g) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
        Graphics2D g = (Graphics2D)g1;
        if (this.overrideP1 != null) {
            p1 = this.overrideP1;
        }
        Rectangle r = new Rectangle(p1);
        r.add(p2);
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 100));
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.drawRect(r.x, r.y, r.width, r.height);
        g.setStroke(new BasicStroke());
        g.setColor(color0);
        g.drawRect(r.x, r.y, r.width, r.height);
        this.dirtyBounds.setLocation(r.x - 2, r.y - 3);
        this.dirtyBounds.add(r.x + r.width + 2, r.y + r.height + 3);
        return new Rectangle[]{this.dirtyBounds};
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        if (this.overrideP1 != null) {
            p1 = this.overrideP1;
        }
        return new MouseBoxEvent(source, p1, p2, isModified);
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isUpdatingDragSelection() {
        return this.updating;
    }

    public void setDragStart(Point p1) {
        this.overrideP1 = p1;
    }
}

