/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.das2.DasApplication;
import org.das2.components.propertyeditor.Editable;
import org.das2.event.BoxRenderer;
import org.das2.event.DragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;

public class DasMouseInputAdapter
extends MouseInputAdapter
implements Editable,
MouseWheelListener {
    private MouseModule primary = null;
    private MouseModule secondary = null;
    private Vector active = null;
    private boolean pinned = false;
    private Vector modules;
    private HashMap primaryActionButtonMap;
    private HashMap secondaryActionButtonMap;
    protected JPopupMenu primaryPopup;
    protected JPopupMenu secondaryPopup;
    private Point secondaryPopupLocation;
    private JPanel pngFileNamePanel;
    private JTextField pngFileTextField;
    private JFileChooser pngFileChooser;
    JCheckBoxMenuItem primarySelectedItem;
    JCheckBoxMenuItem secondarySelectedItem;
    Rectangle[] dirtyBoundsList;
    Logger log = DasLogger.getLogger(DasLogger.GUI_LOG);
    int numInserted;
    int numInsertedSecondary;
    protected ActionListener popupListener;
    protected DasCanvasComponent parent = null;
    private Point dSelectionStart;
    private Point dSelectionEnd;
    private MousePointSelectionEvent mousePointSelection;
    private int xOffset;
    private int yOffset;
    private int button = 0;
    private MouseMode mouseMode = MouseMode.idle;
    private boolean drawControlPoints = false;
    private DragRenderer resizeRenderer = null;
    private Point resizeStart = null;
    Vector hotSpots = null;
    Rectangle dirtyBounds = null;
    private boolean hasFocus = false;
    private Point pressPosition;
    private boolean headless;
    private boolean hoverHighlite = false;

    public DasMouseInputAdapter(DasCanvasComponent parent) {
        this.parent = parent;
        this.modules = new Vector();
        this.primaryActionButtonMap = new HashMap();
        this.secondaryActionButtonMap = new HashMap();
        this.headless = DasApplication.getDefaultApplication().isHeadless();
        if (!this.headless) {
            this.primaryPopup = new JPopupMenu();
            this.numInserted = this.createPopup(this.primaryPopup);
            this.secondaryPopup = new JPopupMenu();
            this.numInsertedSecondary = this.createPopup(this.secondaryPopup);
        }
        this.active = null;
        this.mousePointSelection = new MousePointSelectionEvent(this, 0, 0);
        this.resizeRenderer = new BoxRenderer(parent, false);
        this.dirtyBoundsList = new Rectangle[0];
    }

    public void replaceMouseModule(MouseModule oldModule, MouseModule newModule) {
        JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(oldModule);
        this.primaryActionButtonMap.put(newModule, j);
        this.primaryActionButtonMap.remove(oldModule);
        this.secondaryActionButtonMap.put(newModule, this.secondaryActionButtonMap.get(oldModule));
        this.secondaryActionButtonMap.remove(oldModule);
        this.modules.removeElement(oldModule);
        this.modules.addElement(newModule);
    }

    public void addMouseModule(MouseModule module) {
        if (this.headless) {
            DasLogger.getLogger(DasLogger.GUI_LOG).fine("not adding module since headless is true");
        } else {
            MouseModule preExisting = this.getModuleByLabel(module.getLabel());
            if (preExisting != null) {
                DasLogger.getLogger(DasLogger.GUI_LOG).fine("Replacing mouse module " + module.getLabel() + ".");
                this.replaceMouseModule(preExisting, module);
            } else {
                this.modules.add(module);
                String name = module.getLabel();
                JCheckBoxMenuItem primaryNewItem = new JCheckBoxMenuItem(name);
                JCheckBoxMenuItem secondaryNewItem = new JCheckBoxMenuItem(name);
                primaryNewItem.addActionListener(this.popupListener);
                primaryNewItem.setActionCommand("primary");
                secondaryNewItem.addActionListener(this.popupListener);
                secondaryNewItem.setActionCommand("secondary");
                this.primaryActionButtonMap.put(module, primaryNewItem);
                this.secondaryActionButtonMap.put(module, secondaryNewItem);
                try {
                    this.primaryPopup.add((Component)primaryNewItem, this.numInserted + 1 + this.primaryActionButtonMap.size() - 1);
                    this.secondaryPopup.add((Component)secondaryNewItem, this.numInsertedSecondary + 1 + this.secondaryActionButtonMap.size() - 1);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public JPopupMenu getPrimaryPopupMenu() {
        return this.primaryPopup;
    }

    public KeyAdapter getKeyAdapter() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                DasMouseInputAdapter.this.log.finest("keyPressed ");
                if (ev.getKeyCode() == 27 && DasMouseInputAdapter.this.active != null) {
                    DasMouseInputAdapter.this.active = null;
                    DasMouseInputAdapter.this.getGlassPane().setDragRenderer(null, null, null);
                    DasMouseInputAdapter.this.parent.getCanvas().paintImmediately(0, 0, DasMouseInputAdapter.this.parent.getCanvas().getWidth(), DasMouseInputAdapter.this.parent.getCanvas().getHeight());
                    DasMouseInputAdapter.this.refresh();
                    ev.consume();
                } else if (ev.getKeyCode() == 16) {
                    DasMouseInputAdapter.this.drawControlPoints = true;
                    DasMouseInputAdapter.this.parent.repaint();
                } else if (ev.getKeyChar() == 'p') {
                    DasMouseInputAdapter.this.pinned = true;
                    ev.consume();
                } else {
                    if (DasMouseInputAdapter.this.active == null) {
                        return;
                    }
                    for (int i = 0; i < DasMouseInputAdapter.this.active.size(); ++i) {
                        ((MouseModule)DasMouseInputAdapter.this.active.get(i)).keyPressed(ev);
                    }
                }
            }

            public void keyReleased(KeyEvent ev) {
                if (ev.getKeyCode() == 16) {
                    DasMouseInputAdapter.this.drawControlPoints = false;
                    DasMouseInputAdapter.this.parent.repaint();
                }
                if (DasMouseInputAdapter.this.active == null) {
                    return;
                }
                for (int i = 0; i < DasMouseInputAdapter.this.active.size(); ++i) {
                    ((MouseModule)DasMouseInputAdapter.this.active.get(i)).keyReleased(ev);
                }
            }

            public void keyTyped(KeyEvent ev) {
                if (DasMouseInputAdapter.this.active == null) {
                    return;
                }
                for (int i = 0; i < DasMouseInputAdapter.this.active.size(); ++i) {
                    ((MouseModule)DasMouseInputAdapter.this.active.get(i)).keyTyped(ev);
                }
            }
        };
    }

    public MouseModule getPrimaryModule() {
        ArrayList activ = new ArrayList();
        for (int i = 0; i < this.modules.size(); ++i) {
            JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(this.modules.get(i));
            if (!j.isSelected()) continue;
            activ.add(this.modules.get(i));
        }
        return (MouseModule)activ.get(0);
    }

    public MouseModule getSecondaryModule() {
        ArrayList activ = new ArrayList();
        for (int i = 0; i < this.modules.size(); ++i) {
            JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(this.modules.get(i));
            if (!j.isSelected()) continue;
            activ.add(this.modules.get(i));
        }
        return (MouseModule)activ.get(0);
    }

    public void setPrimaryModule(MouseModule module) {
        if (this.headless) {
            return;
        }
        JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(module);
        if (j == null) {
            this.addMouseModule(module);
        }
        Iterator i = this.primaryActionButtonMap.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Object ii = i.next().getValue();
                ((JCheckBoxMenuItem)ii).setSelected(false);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(module);
        if (j != null) {
            j.setSelected(true);
        }
        this.primarySelectedItem = j;
        this.primary = module;
        this.parent.setCursor(this.primary.getCursor());
    }

    public void setSecondaryModule(MouseModule module) {
        if (this.headless) {
            return;
        }
        JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(module);
        if (j == null) {
            this.addMouseModule(module);
        }
        Iterator i = this.secondaryActionButtonMap.entrySet().iterator();
        while (i.hasNext()) {
            try {
                Object ii = i.next().getValue();
                ((JCheckBoxMenuItem)ii).setSelected(false);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }
        j = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(module);
        if (j != null) {
            j.setSelected(true);
        }
        this.secondarySelectedItem = j;
        this.secondary = module;
    }

    private int createPopup(JPopupMenu popup) {
        this.popupListener = this.createPopupMenuListener();
        Action[] componentActions = this.parent.getActions();
        for (int iaction = 0; iaction < componentActions.length; ++iaction) {
            JMenuItem item = new JMenuItem();
            item.setAction(componentActions[iaction]);
            popup.add(item);
        }
        int numInsert = componentActions.length;
        popup.addSeparator();
        popup.addSeparator();
        Action[] canvasActions = DasCanvas.getActions();
        for (int iaction = 0; iaction < canvasActions.length; ++iaction) {
            JMenuItem item = new JMenuItem();
            item.setAction(canvasActions[iaction]);
            popup.add(item);
        }
        return numInsert;
    }

    private ActionListener createPopupMenuListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DasMouseInputAdapter outer = DasMouseInputAdapter.this;
                String command = e.getActionCommand();
                if (command.equals("properties")) {
                    DasMouseInputAdapter.this.parent.showProperties();
                } else if (command.equals("print")) {
                    Printable p = ((DasCanvas)DasMouseInputAdapter.this.parent.getParent()).getPrintable();
                    PrinterJob pj = PrinterJob.getPrinterJob();
                    pj.setPrintable(p);
                    if (pj.printDialog()) {
                        try {
                            pj.print();
                        }
                        catch (PrinterException pe) {
                            Object[] message = new Object[]{"Error printing", pe.getMessage()};
                            JOptionPane.showMessageDialog(null, message, "ERROR", 0);
                        }
                    }
                } else if (command.equals("toPng")) {
                    if (DasMouseInputAdapter.this.pngFileNamePanel == null) {
                        DasMouseInputAdapter.this.pngFileNamePanel = new JPanel();
                        DasMouseInputAdapter.this.pngFileNamePanel.setLayout(new BoxLayout(DasMouseInputAdapter.this.pngFileNamePanel, 0));
                        DasMouseInputAdapter.this.pngFileTextField = new JTextField(32);
                        DasMouseInputAdapter.this.pngFileTextField.setMaximumSize(DasMouseInputAdapter.this.pngFileTextField.getPreferredSize());
                        DasMouseInputAdapter.this.pngFileChooser = new JFileChooser();
                        DasMouseInputAdapter.this.pngFileChooser.setApproveButtonText("Select File");
                        DasMouseInputAdapter.this.pngFileChooser.setDialogTitle("Write to PNG");
                        JButton b = new JButton("Browse");
                        b.setActionCommand("pngBrowse");
                        b.addActionListener(this);
                        DasMouseInputAdapter.this.pngFileNamePanel.add(DasMouseInputAdapter.this.pngFileTextField);
                        DasMouseInputAdapter.this.pngFileNamePanel.add(b);
                    }
                    DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getCurrentDirectory().getPath());
                    Object[] options = new String[]{"Write to PNG", "Cancel"};
                    int choice = JOptionPane.showOptionDialog(DasMouseInputAdapter.this.parent, DasMouseInputAdapter.this.pngFileNamePanel, "Write to PNG", 0, 3, null, options, "Ok");
                    if (choice == 0) {
                        DasCanvas canvas = (DasCanvas)DasMouseInputAdapter.this.parent.getParent();
                        try {
                            canvas.writeToPng(DasMouseInputAdapter.this.pngFileTextField.getText());
                        }
                        catch (IOException ioe) {
                            DasExceptionHandler.handle((Throwable)ioe);
                        }
                    }
                } else if (command.equals("pngBrowse")) {
                    int choice = DasMouseInputAdapter.this.pngFileChooser.showDialog(DasMouseInputAdapter.this.parent, "Select File");
                    if (choice == 0) {
                        DasMouseInputAdapter.this.pngFileTextField.setText(DasMouseInputAdapter.this.pngFileChooser.getSelectedFile().getPath());
                    }
                } else if (!command.equals("close")) {
                    if (command.equals("primary")) {
                        if (DasMouseInputAdapter.this.primarySelectedItem != null) {
                            DasMouseInputAdapter.this.primarySelectedItem.setSelected(false);
                        }
                        for (int i = 0; i < DasMouseInputAdapter.this.modules.size(); ++i) {
                            JCheckBoxMenuItem j = (JCheckBoxMenuItem)DasMouseInputAdapter.this.primaryActionButtonMap.get(DasMouseInputAdapter.this.modules.get(i));
                            if (!j.isSelected()) continue;
                            DasMouseInputAdapter.this.primarySelectedItem = j;
                            break;
                        }
                        DasMouseInputAdapter.this.primarySelectedItem.setSelected(true);
                    } else if (command.equals("secondary")) {
                        if (DasMouseInputAdapter.this.secondarySelectedItem != null) {
                            DasMouseInputAdapter.this.secondarySelectedItem.setSelected(false);
                        }
                        Point l = DasMouseInputAdapter.this.secondaryPopupLocation;
                        for (int i = 0; i < DasMouseInputAdapter.this.modules.size(); ++i) {
                            JCheckBoxMenuItem j = (JCheckBoxMenuItem)DasMouseInputAdapter.this.secondaryActionButtonMap.get(DasMouseInputAdapter.this.modules.get(i));
                            if (!j.isSelected()) continue;
                            DasMouseInputAdapter.this.secondarySelectedItem = j;
                            break;
                        }
                    } else {
                        System.err.println("" + command);
                    }
                }
            }
        };
    }

    private void renderSelection(Graphics2D g2d) {
        try {
            for (int i = 0; i < this.active.size(); ++i) {
                DragRenderer dr = ((MouseModule)this.active.get(i)).getDragRenderer();
                this.getGlassPane().setDragRenderer(dr, this.dSelectionStart, this.dSelectionEnd);
            }
        }
        catch (RuntimeException e) {
            DasExceptionHandler.handle((Throwable)e);
        }
    }

    private synchronized void refresh() {
        if (this.dirtyBoundsList.length > 0) {
            int i;
            Rectangle[] dd = new Rectangle[this.dirtyBoundsList.length];
            for (i = 0; i < dd.length; ++i) {
                if (this.dirtyBoundsList[i] == null) continue;
                dd[i] = new Rectangle(this.dirtyBoundsList[i]);
            }
            for (i = 0; i < dd.length; ++i) {
                if (dd[i] == null) continue;
                this.parent.getCanvas().paintImmediately(dd[i]);
            }
            for (i = 0; i < this.dirtyBoundsList.length; ++i) {
                if (this.dirtyBoundsList[i] == null) continue;
                this.parent.getCanvas().paintImmediately(this.dirtyBoundsList[i]);
            }
        } else if (this.active != null) {
            this.parent.getCanvas().paintImmediately(0, 0, this.parent.getCanvas().getWidth(), this.parent.getCanvas().getHeight());
        }
        if (this.active == null) {
            this.dirtyBoundsList = new Rectangle[0];
        }
    }

    public void paint(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        g.translate(-this.parent.getX(), -this.parent.getY());
        if (this.active != null) {
            this.renderSelection(g);
        }
        if (this.hasFocus && this.hoverHighlite) {
            g.setColor(new Color(255, 0, 0, 10));
            g.setStroke(new BasicStroke(10.0f));
            g.draw(this.parent.getBounds());
            g.dispose();
            return;
        }
        if (this.hasFocus && this.drawControlPoints) {
            this.drawControlPoints(g);
        }
        g.dispose();
    }

    private void drawControlPoints(Graphics2D g) {
        if (this.parent.getRow() != DasRow.NULL && this.parent.getColumn() != DasColumn.NULL) {
            int xLeft = this.parent.getColumn().getDMinimum();
            int xRight = this.parent.getColumn().getDMaximum();
            int xMid = (xLeft + xRight) / 2;
            int yTop = this.parent.getRow().getDMinimum();
            int yBottom = this.parent.getRow().getDMaximum();
            int yMid = (yTop + yBottom) / 2;
            Graphics2D gg = (Graphics2D)g.create();
            gg.setColor(new Color(0, 0, 0, 255));
            int ss = 9;
            gg.fillRect(xLeft + 1, yTop + 1, ss - 2, ss - 2);
            gg.fillRect(xRight - ss + 1, yTop + 1, ss - 2, ss - 2);
            gg.fillRect(xLeft + 1, yBottom - ss + 1, ss - 2, ss - 2);
            gg.fillRect(xRight - ss + 1, yBottom - ss + 1, ss - 2, ss - 2);
            gg.fillRect(xMid + 1 - ss / 2, yTop + 1, ss - 2, ss - 2);
            gg.fillRect(xRight - ss + 1, yMid + 1 - ss / 2, ss - 2, ss - 2);
            gg.fillRect(xMid + 1 - ss / 2, yBottom - ss + 1, ss - 2, ss - 2);
            gg.fillRect(xLeft + 1, yMid - ss / 2 + 1, ss - 2, ss - 2);
            gg.setColor(new Color(255, 255, 255, 100));
            gg.drawRect(xLeft, yTop, ss, ss);
            gg.drawRect(xRight - ss, yTop, ss, ss);
            gg.drawRect(xLeft, yBottom - ss, ss, ss);
            gg.drawRect(xRight - ss, yBottom - ss, ss, ss);
            gg.drawRect(xMid - ss / 2, yTop + 1, ss, ss);
            gg.drawRect(xRight - ss, yMid - ss / 2, ss, ss);
            gg.drawRect(xMid - ss / 2, yBottom - ss, ss, ss);
            gg.drawRect(xLeft, yMid - ss / 2, ss, ss);
            int xmid = (xLeft + xRight) / 2;
            int ymid = (yTop + yBottom) / 2;
            int rr = 4;
            g.setColor(new Color(255, 255, 255, 100));
            gg.fillOval(xmid - rr - 1, ymid - rr - 1, rr * 2 + 3, rr * 2 + 3);
            gg.setColor(new Color(0, 0, 0, 255));
            gg.drawOval(xmid - rr, ymid - rr, rr * 2, rr * 2);
            gg.fillOval(xmid - 1, ymid - 1, 3, 3);
            gg.dispose();
        }
    }

    private MouseMode activateMouseMode(MouseEvent e) {
        boolean xLeftSide = false;
        boolean xRightSide = false;
        boolean xMiddle = false;
        boolean yTopSide = false;
        boolean yBottomSide = false;
        boolean yMiddle = false;
        Point mousePoint = e.getPoint();
        mousePoint.translate(this.parent.getX(), this.parent.getY());
        if (this.parent.getRow() != DasRow.NULL && this.parent.getColumn() != DasColumn.NULL) {
            int xLeft = this.parent.getColumn().getDMinimum();
            int xRight = this.parent.getColumn().getDMaximum();
            int yTop = this.parent.getRow().getDMinimum();
            int yBottom = this.parent.getRow().getDMaximum();
            int xmid = (xLeft + xRight) / 2;
            int ymid = (yTop + yBottom) / 2;
            xLeftSide = mousePoint.getX() < (double)(xLeft + 10);
            xRightSide = mousePoint.getX() > (double)(xRight - 10);
            xMiddle = Math.abs(mousePoint.getX() - (double)xmid) < 4.0;
            yTopSide = mousePoint.getY() < (double)(yTop + 10) && mousePoint.getY() >= (double)yTop;
            yBottomSide = mousePoint.getY() > (double)(yBottom - 10);
            yMiddle = Math.abs(mousePoint.getY() - (double)ymid) < 4.0;
        }
        MouseMode result = MouseMode.idle;
        Cursor cursor = new Cursor(0);
        if (!(this.parent instanceof DasAxis) && (e.getModifiersEx() & 0x40) == 64) {
            if (xLeftSide) {
                if (yTopSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(6);
                } else if (yBottomSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(4);
                } else if (yMiddle) {
                    result = MouseMode.resize;
                    cursor = new Cursor(10);
                }
            } else if (xRightSide) {
                if (yTopSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(7);
                } else if (yBottomSide) {
                    result = MouseMode.resize;
                    cursor = new Cursor(5);
                } else if (yMiddle) {
                    result = MouseMode.resize;
                    cursor = new Cursor(11);
                }
            } else if (xMiddle && yMiddle) {
                result = MouseMode.move;
                cursor = new Cursor(13);
            } else if (xMiddle && yTopSide) {
                result = MouseMode.resize;
                cursor = new Cursor(8);
            } else if (xMiddle && yBottomSide) {
                result = MouseMode.resize;
                cursor = new Cursor(9);
            }
        }
        if (result == MouseMode.resize) {
            result.resizeBottom = yBottomSide;
            result.resizeTop = yTopSide;
            result.resizeRight = xRightSide;
            result.resizeLeft = xLeftSide;
        } else if (result == MouseMode.move) {
            result.moveStart = e.getPoint();
            result.moveStart.translate(-this.parent.getX(), -this.parent.getY());
        }
        if (result != this.mouseMode) {
            this.getGlassPane().setCursor(cursor);
        }
        return result;
    }

    public void mouseMoved(MouseEvent e) {
        MouseMode m;
        this.log.finest("mouseMoved");
        Point l = this.parent.getLocation();
        this.xOffset = l.x;
        this.yOffset = l.y;
        boolean drawControlPoints0 = this.drawControlPoints;
        this.drawControlPoints = (e.getModifiersEx() & 0x40) == 64;
        if (drawControlPoints0 != this.drawControlPoints) {
            this.parent.repaint();
        }
        this.mouseMode = (m = this.activateMouseMode(e)) != null ? m : MouseMode.idle;
    }

    private void showPopup(JPopupMenu menu, MouseEvent ev) {
        this.log.finest("showPopup");
        if (menu != this.primaryPopup && menu != this.secondaryPopup) {
            throw new IllegalArgumentException("menu must be primary or secondary popup menu");
        }
        for (MouseModule mm : this.modules) {
            JCheckBoxMenuItem j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(mm);
            j.setText(mm.getLabel());
        }
        menu.show(ev.getComponent(), ev.getX(), ev.getY());
    }

    public void setPinned(boolean b) {
        this.pinned = b;
    }

    public boolean getPinned() {
        return this.pinned;
    }

    public void mousePressed(MouseEvent e) {
        this.log.finer("mousePressed " + this.mouseMode);
        if (this.pinned) {
            this.active = null;
            this.refresh();
        }
        this.pinned = false;
        Point l = this.parent.getLocation();
        this.parent.requestFocus();
        this.xOffset = l.x;
        this.yOffset = l.y;
        this.pressPosition = e.getPoint();
        Point cp = new Point(e.getPoint());
        cp.translate(this.xOffset, this.yOffset);
        if (!this.parent.acceptContext(cp.x, cp.y)) {
            return;
        }
        if (this.mouseMode == MouseMode.resize) {
            this.resizeStart = new Point(0, 0);
            this.resizeStart.x = this.mouseMode.resizeRight ? 0 + this.xOffset : (this.mouseMode.resizeLeft ? this.parent.getWidth() + this.xOffset : 0 + this.xOffset);
            this.resizeStart.y = this.mouseMode.resizeTop ? this.parent.getHeight() + this.yOffset : (this.mouseMode.resizeBottom ? 0 + this.yOffset : 0 + this.yOffset);
        } else if (this.mouseMode == MouseMode.move) {
            this.mouseMode.moveStart = e.getPoint();
            this.mouseMode.moveStart.translate(this.xOffset, this.yOffset);
        } else if (this.active == null) {
            this.button = e.getButton();
            this.dSelectionStart = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            this.dSelectionEnd = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            if (e.isControlDown() || this.button == 3) {
                if (this.button == 1 || this.button == 3) {
                    this.showPopup(this.primaryPopup, e);
                } else {
                    this.showPopup(this.secondaryPopup, e);
                }
            } else {
                Object j;
                int i;
                this.active = new Vector();
                if (this.button == 1 || this.button == 3) {
                    for (i = 0; i < this.modules.size(); ++i) {
                        j = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(this.modules.get(i));
                        if (!((AbstractButton)j).isSelected()) continue;
                        this.active.add(this.modules.get(i));
                    }
                } else {
                    for (i = 0; i < this.modules.size(); ++i) {
                        j = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(this.modules.get(i));
                        if (!((AbstractButton)j).isSelected()) continue;
                        this.active.add(this.modules.get(i));
                    }
                }
                this.mouseMode = MouseMode.moduleDrag;
                this.mousePointSelection.set(e.getX() + this.xOffset, e.getY() + this.yOffset);
                for (i = 0; i < this.active.size(); ++i) {
                    j = (MouseModule)this.active.get(i);
                    ((MouseModule)j).mousePressed(e);
                    if (!((MouseModule)j).dragRenderer.isPointSelection()) continue;
                    this.mouseDragged(e);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.log.finest("mouseDragged in " + this.mouseMode);
        if (this.mouseMode == MouseMode.resize) {
            Point p = e.getPoint();
            p.translate(this.parent.getX(), this.parent.getY());
            if (!this.mouseMode.resizeBottom && !this.mouseMode.resizeTop) {
                p.y = this.parent.getRow().getDMaximum();
            }
            if (!this.mouseMode.resizeRight && !this.mouseMode.resizeLeft) {
                p.x = this.parent.getColumn().getDMaximum();
            }
            this.getGlassPane().setDragRenderer(this.resizeRenderer, this.resizeStart, p);
            this.getGlassPane().repaint();
        } else if (this.mouseMode == MouseMode.move) {
            Point moveEnd = e.getPoint();
            moveEnd.translate(this.xOffset, this.yOffset);
            int dx = moveEnd.x - this.mouseMode.moveStart.x;
            int dy = moveEnd.y - this.mouseMode.moveStart.y;
            int xmin = this.parent.getColumn().getDMinimum();
            int xmax = this.parent.getColumn().getDMaximum();
            int ymin = this.parent.getRow().getDMinimum();
            int ymax = this.parent.getRow().getDMaximum();
            Point p1 = new Point(xmin + dx, ymin + dy);
            Point p2 = new Point(xmax + dx, ymax + dy);
            this.getGlassPane().setDragRenderer(this.resizeRenderer, p1, p2);
            this.getGlassPane().repaint();
        } else if (this.active != null) {
            this.dSelectionEnd = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            this.mousePointSelection.set((int)this.dSelectionEnd.getX(), (int)this.dSelectionEnd.getY());
            for (int i = 0; i < this.active.size(); ++i) {
                try {
                    MouseModule j = (MouseModule)this.active.get(i);
                    if (j.dragRenderer.isPointSelection()) {
                        this.log.finest("mousePointSelected");
                        j.mousePointSelected(this.mousePointSelection);
                    }
                    if (j.dragRenderer.isUpdatingDragSelection()) {
                        MouseDragEvent de = j.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, e.isShiftDown());
                        this.log.finest("mouseRangeSelected");
                        j.mouseRangeSelected(de);
                    }
                    j.mouseDragged(e);
                    continue;
                }
                catch (RuntimeException except) {
                    DasExceptionHandler.handle((Throwable)except);
                }
            }
            this.refresh();
        }
    }

    private void performResize(MouseEvent e) {
        int dxLeft = this.parent.getColumn().getDMinimum();
        int dxRight = this.parent.getColumn().getDMaximum();
        int dyTop = this.parent.getRow().getDMinimum();
        int dyBottom = this.parent.getRow().getDMaximum();
        int dx = e.getX() + this.xOffset;
        int dy = e.getY() + this.yOffset;
        if (this.mouseMode.resizeRight) {
            dxRight = dx;
        } else if (this.mouseMode.resizeLeft) {
            dxLeft = dx;
        }
        if (this.mouseMode.resizeTop) {
            dyTop = dy;
        } else if (this.mouseMode.resizeBottom) {
            dyBottom = dy;
        }
        this.parent.getColumn().setDPosition(dxLeft, dxRight);
        this.parent.getRow().setDPosition(dyTop, dyBottom);
        this.xOffset += dx;
        this.yOffset += dy;
        this.parent.resize();
        this.getGlassPane().setDragRenderer(null, null, null);
        this.getGlassPane().setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        this.log.finest("mouseReleased");
        if (this.mouseMode == MouseMode.resize) {
            this.performResize(e);
            this.getGlassPane().setDragRenderer(null, null, null);
            this.parent.getCanvas().paintImmediately(0, 0, this.parent.getCanvas().getWidth(), this.parent.getCanvas().getHeight());
            this.refresh();
        } else if (this.mouseMode == MouseMode.move) {
            this.performMove(e);
            this.getGlassPane().setDragRenderer(null, null, null);
            this.parent.getCanvas().paintImmediately(0, 0, this.parent.getCanvas().getWidth(), this.parent.getCanvas().getHeight());
            this.refresh();
        } else if (e.getButton() == this.button && this.active != null) {
            for (int i = 0; i < this.active.size(); ++i) {
                MouseModule j = (MouseModule)this.active.get(i);
                try {
                    MouseDragEvent de = j.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, e.isShiftDown());
                    j.mouseRangeSelected(de);
                    continue;
                }
                catch (RuntimeException ex) {
                    DasExceptionHandler.handle((Throwable)ex);
                    continue;
                }
                finally {
                    this.button = 0;
                    try {
                        j.mouseReleased(e);
                    }
                    catch (RuntimeException ex2) {
                        DasExceptionHandler.handle((Throwable)ex2);
                    }
                }
            }
            if (!this.pinned) {
                this.active = null;
                this.getGlassPane().setDragRenderer(null, null, null);
                this.parent.getCanvas().paintImmediately(0, 0, this.parent.getCanvas().getWidth(), this.parent.getCanvas().getHeight());
                this.refresh();
            }
        }
    }

    public void removeMouseModule(MouseModule module) {
    }

    public MouseModule getMouseModule(int i) {
        return (MouseModule)this.modules.get(i);
    }

    public MouseModule[] getMouseModules() {
        Object[] result = new MouseModule[this.modules.size()];
        this.modules.copyInto(result);
        return result;
    }

    public String getPrimaryModuleLabel() {
        MouseModule primary = this.getPrimaryModule();
        return primary == null ? "" : primary.getLabel();
    }

    public String getPrimaryModuleByLabel() {
        MouseModule primary = this.getPrimaryModule();
        return primary == null ? "" : primary.getLabel();
    }

    public void setPrimaryModuleByLabel(String label) {
        MouseModule mm = this.getModuleByLabel(label);
        if (mm != null) {
            this.setPrimaryModule(mm);
        }
    }

    public String getSecondaryModuleByLabel() {
        MouseModule secondary = this.getPrimaryModule();
        return secondary == null ? "" : secondary.getLabel();
    }

    public void setSecondaryModuleByLabel(String label) {
        MouseModule mm = this.getModuleByLabel(label);
        if (mm != null) {
            this.setSecondaryModule(mm);
        }
    }

    public void setMouseModule(int i, MouseModule mouseModule) {
        this.modules.set(i, mouseModule);
    }

    public void mouseEntered(MouseEvent e) {
        this.hasFocus = true;
        if (e.isShiftDown()) {
            this.parent.repaint();
        }
        if (this.primary != null) {
            this.getGlassPane().setCursor(this.primary.getCursor());
        }
    }

    public void mouseExited(MouseEvent e) {
        this.hasFocus = false;
        if (e.isShiftDown()) {
            this.parent.repaint();
        }
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
    }

    public synchronized void removeMenuItem(String label) {
        if (this.headless) {
            return;
        }
        MenuElement[] ele = this.primaryPopup.getSubElements();
        int index = -1;
        for (int i = 0; i < this.numInserted; ++i) {
            if (!(ele[i] instanceof JMenuItem) || !((JMenuItem)ele[i]).getText().contains(label)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.primaryPopup.remove(index);
            --this.numInserted;
        }
    }

    public synchronized void addMenuItem(Component b) {
        if (this.headless) {
            return;
        }
        if (this.numInserted == 0) {
            this.primaryPopup.insert(new JPopupMenu.Separator(), 0);
            ++this.numInserted;
        }
        if (b instanceof JPopupMenu) {
            if (this.numInserted > 1) {
                this.primaryPopup.insert(new JPopupMenu.Separator(), 0);
                ++this.numInserted;
            }
            JPopupMenu c = (JPopupMenu)b;
            for (MenuElement me : c.getSubElements()) {
                if (me.getComponent() instanceof JCheckBoxMenuItem) continue;
                this.primaryPopup.insert(me.getComponent(), this.numInserted);
                ++this.numInserted;
            }
        } else {
            this.primaryPopup.insert(b, this.numInserted);
            ++this.numInserted;
        }
    }

    public JMenu addMenu(String label) {
        JMenu result = new JMenu(label);
        this.addMenuItem(result);
        return result;
    }

    private DasCanvas.GlassPane getGlassPane() {
        DasCanvas.GlassPane r = (DasCanvas.GlassPane)((DasCanvas)this.parent.getParent()).getGlassPane();
        if (!r.isVisible()) {
            r.setVisible(true);
        }
        return r;
    }

    public MouseModule getModuleByLabel(String label) {
        MouseModule result = null;
        for (int i = 0; i < this.modules.size(); ++i) {
            if (!label.equals(((MouseModule)this.modules.get(i)).getLabel())) continue;
            result = (MouseModule)this.modules.get(i);
        }
        return result;
    }

    public boolean isHoverHighlite() {
        return this.hoverHighlite;
    }

    public void setHoverHighlite(boolean value) {
        this.hoverHighlite = value;
    }

    public Point getMousePressPosition() {
        return this.pressPosition;
    }

    private void performMove(MouseEvent e) {
        Point moveEnd = e.getPoint();
        moveEnd.translate(this.xOffset, this.yOffset);
        int dx = moveEnd.x - this.mouseMode.moveStart.x;
        int dy = moveEnd.y - this.mouseMode.moveStart.y;
        this.xOffset += dx;
        this.yOffset += dy;
        int min = this.parent.getColumn().getDMinimum();
        int max = this.parent.getColumn().getDMaximum();
        this.parent.getColumn().setDPosition(min + dx, max + dx);
        min = this.parent.getRow().getDMinimum();
        max = this.parent.getRow().getDMaximum();
        this.parent.getRow().setDPosition(min + dy, max + dy);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.secondary != null) {
            this.secondary.mouseWheelMoved(e);
        }
    }

    private static final class MouseMode {
        String s;
        boolean resizeTop = false;
        boolean resizeBottom = false;
        boolean resizeRight = false;
        boolean resizeLeft = false;
        Point moveStart = null;
        static final MouseMode idle = new MouseMode("idle");
        static final MouseMode resize = new MouseMode("resize");
        static final MouseMode move = new MouseMode("move");
        static final MouseMode moduleDrag = new MouseMode("moduleDrag");

        MouseMode(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

