/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import org.das2.event.DragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;

public class MoveComponentMouseModule
extends MouseModule {
    Point p0;

    public MoveComponentMouseModule(DasCanvasComponent parent) {
        super(parent, new MoveRenderer(parent), "Move Component");
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        Point p = e.getPoint();
        int dx = p.x - this.p0.x;
        int dy = p.y - this.p0.y;
        DasRow row = this.parent.getRow();
        row.setDPosition(row.getDMinimum() + dy, row.getDMaximum() + dy);
        DasColumn col = this.parent.getColumn();
        col.setDPosition(col.getDMinimum() + dx, col.getDMaximum() + dx);
        this.p0 = null;
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        ((MoveRenderer)this.dragRenderer).refreshImage();
        this.p0 = e.getPoint();
    }

    static class MoveRenderer
    implements DragRenderer {
        DasCanvasComponent c;
        BufferedImage i;

        MoveRenderer(DasCanvasComponent c) {
            this.c = c;
        }

        private void refreshImage() {
            Rectangle bounds = this.c.getActiveRegion().getBounds();
            this.i = new BufferedImage(bounds.width, bounds.height, 2);
            Graphics g = this.i.getGraphics();
            g.translate(this.c.getX(), this.c.getY());
            this.c.paint(g);
        }

        private Point center(Shape s) {
            long avgX = 0L;
            long avgY = 0L;
            double[] coords = new double[6];
            long count = 0L;
            PathIterator i = s.getPathIterator(null);
            while (!i.isDone()) {
                int type = i.currentSegment(coords);
                if (type == 1) {
                    avgX = (long)((double)avgX + coords[0]);
                    avgY = (long)((double)avgY + coords[1]);
                    ++count;
                }
                i.next();
            }
            return new Point((int)(avgX /= count), (int)(avgY /= count));
        }

        private Shape enlarge(Shape s, double scale) {
            Point center = this.center(s);
            AffineTransform at = new AffineTransform();
            at.translate(center.x, center.y);
            at.scale(scale, scale);
            GeneralPath gp = new GeneralPath(s);
            gp.transform(at);
            at = new AffineTransform();
            at.translate((double)(-center.x) * scale, (double)(-center.y) * scale);
            gp.transform(at);
            return gp;
        }

        public Rectangle[] renderDrag(Graphics g1, Point p1, Point p2) {
            Rectangle bounds = this.c.getActiveRegion().getBounds();
            bounds.translate(p2.x - p1.x, p2.y - p1.y);
            Graphics2D g = (Graphics2D)g1;
            g.setClip(null);
            g.setColor(Color.BLACK);
            g.draw(bounds);
            return new Rectangle[]{this.enlarge(bounds.getBounds(), 1.2).getBounds()};
        }

        public void clear(Graphics g) {
        }

        public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
            return null;
        }

        public boolean isPointSelection() {
            return false;
        }

        public boolean isUpdatingDragSelection() {
            return true;
        }
    }
}

