/*
 * Decompiled with CFR 0.152.
 */
package org.das2.fsm;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.das2.DasException;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;

public class FileStorageModelAvailabilityDataSetDescriptor
extends DataSetDescriptor {
    FileStorageModelNew fsm;

    public FileStorageModelAvailabilityDataSetDescriptor(FileStorageModelNew fsm) {
        this.fsm = fsm;
    }

    protected DataSet getDataSetImpl(Datum start, Datum end, Datum resolution, ProgressMonitor monitor) throws DasException {
        try {
            String[] names = this.fsm.getNamesFor(new DatumRange(start, end), monitor);
            String planeId = "xTagWidth";
            Units xUnits = this.getXUnits();
            Units offsetUnits = xUnits.getOffsetUnits();
            VectorDataSetBuilder builder = new VectorDataSetBuilder(xUnits, offsetUnits);
            builder.addPlane(planeId, offsetUnits);
            builder.setProperty("cacheTag", new CacheTag(start, end, null));
            for (int i = 0; i < names.length; ++i) {
                DatumRange range = this.fsm.getRangeFor(names[i]);
                builder.insertY(range.min().doubleValue(xUnits), range.width().doubleValue(offsetUnits), planeId, range.width().doubleValue(offsetUnits));
            }
            return builder.toVectorDataSet();
        }
        catch (IOException ex) {
            throw new DasException(ex);
        }
    }

    public Units getXUnits() {
        return Units.us2000;
    }

    public static void main(String[] args) throws Exception {
        FileSystem fs = FileSystem.create((URI)new URI("http://www-pw.physics.uiowa.edu/~jbf/cluster/obtdata/"));
        TimeParser.FieldHandler hexHandler = new TimeParser.FieldHandler(){

            public String configure(Map<String, String> args) {
                return null;
            }

            public void handleValue(String fieldContent, TimeUtil.TimeStruct startTime, TimeUtil.TimeStruct timeWidth, Map<String, String> extra) {
                double seconds;
                int i = Integer.decode("0x" + fieldContent);
                startTime.seconds = seconds = (double)(86400 * i / 256);
                timeWidth.seconds = 337.5;
            }
        };
        int cl = 4;
        FileStorageModelNew fsm = FileStorageModelNew.create(fs, "%y%2m/%y%2m%2d%2{hex}\\..C" + cl, "hex", hexHandler);
    }
}

