/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.das2.datum.Datum;
import org.das2.event.ArrowDragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MoveComponentMouseModule;
import org.das2.graph.Arrow;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;
import org.das2.util.GrannyTextRenderer;

public class DasAnnotation
extends DasCanvasComponent {
    String templateString;
    GrannyTextRenderer gtr;
    private PointDescriptor pointAt;
    private MouseModule arrowToMouseModule;
    float fontSize = 0.0f;
    private BorderType borderType = BorderType.NONE;
    public static final String PROP_BORDERTYPE = "borderType";
    private Arrow.HeadStyle arrowStyle = Arrow.HeadStyle.DRAFTING;
    public static final String PROP_ARROWSTYLE = "arrowStyle";

    public DasAnnotation(String string) {
        this.gtr = new GrannyTextRenderer();
        this.templateString = string;
        AbstractAction removeArrowAction = new AbstractAction("remove arrow"){

            public void actionPerformed(ActionEvent e) {
                DasAnnotation.this.pointAt = null;
                DasAnnotation.this.repaint();
            }
        };
        this.getDasMouseInputAdapter().addMenuItem(new JMenuItem(removeArrowAction));
        AbstractAction removeMeAction = new AbstractAction("remove"){

            public void actionPerformed(ActionEvent e) {
                DasCanvas canvas = DasAnnotation.this.getCanvas();
                canvas.remove(DasAnnotation.this);
                canvas.revalidate();
            }
        };
        this.getDasMouseInputAdapter().addMenuItem(new JMenuItem(removeMeAction));
        MoveComponentMouseModule mm = new MoveComponentMouseModule(this);
        this.getDasMouseInputAdapter().setPrimaryModule(mm);
        this.arrowToMouseModule = this.createArrowToMouseModule(this);
        this.getDasMouseInputAdapter().setSecondaryModule(this.arrowToMouseModule);
    }

    private MouseModule createArrowToMouseModule(final DasAnnotation anno) {
        return new MouseModule(this, new ArrowDragRenderer(), "Point At"){
            Point head;
            Point tail;

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.tail = e.getPoint();
                this.tail.translate(anno.getX(), anno.getY());
                Rectangle r = DasAnnotation.this.getActiveRegion().getBounds();
                if (!r.contains(this.tail)) {
                    this.tail = null;
                }
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (this.tail == null) {
                    return;
                }
                this.head = e.getPoint();
                this.head.translate(anno.getX(), anno.getY());
                DasCanvasComponent c = this.parent.getCanvas().getCanvasComponentAt(this.head.x, this.head.y);
                if (c instanceof DasPlot) {
                    DasPlot p = (DasPlot)c;
                    Datum x = p.getXAxis().invTransform(this.head.x);
                    Datum y = p.getYAxis().invTransform(this.head.y);
                    anno.setPointAt(new DatumPairPointDescriptor(p, x, y));
                    DasAnnotation.this.setBounds(DasAnnotation.this.calcBounds());
                }
            }
        };
    }

    public void setText(String string) {
        this.templateString = string;
        if (this.getGraphics() != null) {
            this.gtr.setString(this.getGraphics(), this.getString());
            this.calcBounds();
        }
        this.repaint();
    }

    public String getText() {
        return this.templateString;
    }

    public void resize() {
        super.resize();
        this.gtr.setString(this.getGraphics(), this.getString());
        Rectangle r = this.calcBounds();
        this.setBounds(r);
    }

    public Shape getActiveRegion() {
        Rectangle r = this.gtr.getBounds();
        int em = (int)this.getEmSize() / 2;
        r = new Rectangle(r.x, r.y + (int)this.gtr.getAscent(), r.width + 2 * em + 3, r.height + 2 * em + 3);
        r.translate(this.getColumn().getDMinimum(), this.getRow().getDMinimum());
        return r;
    }

    public boolean acceptContext(int x, int y) {
        if (this.getActiveRegion().contains(x, y)) {
            return true;
        }
        return this.pointAt != null && this.pointAt.getPoint().distance(x, y) < 5.0;
    }

    private Rectangle calcBounds() {
        Rectangle r = (Rectangle)this.getActiveRegion();
        int em = (int)this.getEmSize() / 2;
        if (this.pointAt != null) {
            Point head = this.pointAt.getPoint();
            r.add(head);
        }
        r.x -= em;
        r.y -= em;
        r.width += em * 2;
        r.height += em * 2;
        return r;
    }

    public void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1.create();
        g.translate(this.getColumn().getDMinimum() - this.getX(), this.getRow().getDMinimum() - this.getY());
        Color fore = g.getColor();
        Color canvasColor = this.getCanvas().getBackground();
        Color back = new Color(canvasColor.getRed(), canvasColor.getGreen(), canvasColor.getBlue(), 204);
        if (this.fontSize > 0.0f) {
            g.setFont(this.getFont().deriveFont(this.fontSize));
        }
        int em = (int)this.getEmSize() / 2;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.gtr.setString((Graphics)g, this.getString());
        Rectangle r = this.gtr.getBounds();
        r.x = em;
        r.y = em;
        r = new Rectangle(r.x - em + 1, r.y - em + 1, r.width + 2 * em - 1, r.height + 2 * em - 1);
        g.setColor(back);
        if (this.borderType == BorderType.RECTANGLE || this.borderType == BorderType.NONE) {
            g.fill(r);
        } else if (this.borderType == BorderType.ROUNDED_RECTANGLE) {
            g.fillRoundRect(r.x, r.y, r.width, r.height, em * 2, em * 2);
        }
        g.setColor(fore);
        this.gtr.draw((Graphics)g, (float)em, (float)em + (float)this.gtr.getAscent());
        if (this.pointAt != null) {
            double em2 = this.getCanvas().getFont().getSize();
            g.setStroke(new BasicStroke((float)(em2 / 8.0)));
            Point head = this.pointAt.getPoint();
            head.translate(-this.getColumn().getDMinimum(), -this.getRow().getDMinimum());
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setClip(null);
            Point2D.Double tail2d = new Point2D.Double(r.x + r.width / 2, r.y + r.y + r.height / 2);
            Point2D.Double head2d = new Point2D.Double(head.x, head.y);
            Rectangle2D.Double rect2d = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
            Point2D p2d = GraphUtil.lineRectangleIntersection(tail2d, head2d, rect2d);
            Point p = p2d == null ? head : new Point((int)p2d.getX(), (int)p2d.getY());
            Arrow.paintArrow(g2, head, p, em2, this.arrowStyle);
            g2.dispose();
        }
        if (this.borderType != BorderType.NONE) {
            if (this.borderType == BorderType.RECTANGLE) {
                g.draw(r);
            } else if (this.borderType == BorderType.ROUNDED_RECTANGLE) {
                g.drawRoundRect(r.x, r.y, r.width, r.height, em * 2, em * 2);
            }
        }
        g.dispose();
        this.getDasMouseInputAdapter().paint(g1);
    }

    public void setPointAt(PointDescriptor p) {
        this.pointAt = p;
        this.repaint();
    }

    private String getString() {
        String s = this.templateString;
        if (this.templateString != null && this.templateString.contains("%") && this.pointAt != null) {
            s = this.templateString.replace("%p", this.pointAt.getLabel());
        }
        return s;
    }

    public PointDescriptor getPointAt() {
        return this.pointAt;
    }

    protected void installComponent() {
        super.installComponent();
        this.gtr.setString(this.getFont(), this.getString());
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
        Font f = this.getFont();
        if (f == null) {
            f = this.getCanvas().getBaseFont();
        }
        if (fontSize > 0.0f) {
            f = f.deriveFont(fontSize);
        }
        Font newFont = f;
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setFont(newFont);
        this.gtr.setString(g, this.getString());
        this.setBounds(this.calcBounds());
        this.repaint();
    }

    public BorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(BorderType newborderType) {
        BorderType oldborderType = this.borderType;
        this.borderType = newborderType;
        this.repaint();
        this.firePropertyChange(PROP_BORDERTYPE, (Object)oldborderType, (Object)newborderType);
    }

    public Arrow.HeadStyle getArrowStyle() {
        return this.arrowStyle;
    }

    public void setArrowStyle(Arrow.HeadStyle newarrowStyle) {
        Arrow.HeadStyle oldarrowStyle = this.arrowStyle;
        this.arrowStyle = newarrowStyle;
        this.repaint();
        this.firePropertyChange(PROP_ARROWSTYLE, (Object)oldarrowStyle, (Object)newarrowStyle);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BorderType {
        NONE,
        RECTANGLE,
        ROUNDED_RECTANGLE;

    }

    public static interface PointDescriptor {
        public Point getPoint();

        public String getLabel();
    }

    public static class DatumPairPointDescriptor
    implements PointDescriptor {
        DasPlot p;
        Datum x;
        Datum y;

        public DatumPairPointDescriptor(DasPlot p, Datum x, Datum y) {
            this.x = x;
            this.y = y;
            this.p = p;
        }

        public Point getPoint() {
            int ix = (int)this.p.getXAxis().transform(this.x);
            int iy = (int)this.p.getYAxis().transform(this.y);
            return new Point(ix, iy);
        }

        public String getLabel() {
            return "" + this.x + "," + this.y;
        }
    }
}

