/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.util.ArrayList;
import java.util.List;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasRow;

public class Leveler {
    ArrayList rows;
    ArrayList weights;
    double interMargin;
    DasCanvas parent;
    DasRow row;

    public Leveler(DasCanvas parent) {
        this(parent, new DasRow(parent, 0.05, 0.9));
    }

    public Leveler(DasCanvas parent, DasRow row) {
        this.parent = parent;
        this.row = row;
        this.rows = new ArrayList();
        this.weights = new ArrayList();
        this.interMargin = 0.03;
    }

    public double getWeight(DasRow row) {
        int index = this.rows.indexOf(row);
        return (Double)this.weights.get(index);
    }

    public double getPosition(DasRow row) {
        return row.getMaximum();
    }

    public DasRow addRow(double nposition, double weight) {
        LevelRow r = new LevelRow(this.parent, this, nposition, weight);
        return r;
    }

    public DasRow addRow(double nposition) {
        LevelRow r = new LevelRow(this.parent, this, nposition);
        return r;
    }

    public DasRow addRow() {
        LevelRow r = new LevelRow(this.parent, this, 1.0);
        return r;
    }

    public DasRow whichRow(int y) {
        int i = this.objectIndexAt(y / this.parent.getHeight());
        if (i >= 0 && i < this.rows.size()) {
            return (DasRow)this.rows.get(i);
        }
        return null;
    }

    public int rowCount() {
        return this.rows.size();
    }

    public void deleteRow(DasRow row) {
        int i = this.rows.indexOf(row);
        this.rows.remove(i);
        this.weights.remove(i);
    }

    void insertAt(double nposition, DasDevicePosition row) {
        this.insertAt(nposition, row, 1.0);
    }

    void insertAt(double nposition, DasDevicePosition row, double weight) {
        int i;
        double[] tops = new double[this.rows.size()];
        for (i = 0; i < this.rows.size() && !(((DasRow)this.rows.get(i)).getMaximum() >= nposition); ++i) {
        }
        this.rows.add(i, row);
        this.weights.add(i, new Double(weight));
        for (int ii = 0; ii < this.rows.size(); ++ii) {
            ((DasRow)this.rows.get(ii)).fireUpdate();
        }
    }

    private int objectIndexAt(double nposition) {
        int i = 0;
        for (i = 0; !(i >= this.rows.size() || this.getMinimum(i) <= nposition && nposition < this.getMaximum(i)); ++i) {
        }
        return i;
    }

    private double integrateWeight(int nRows) {
        if (nRows == 0) {
            return 0.0;
        }
        double totalWeight = (Double)this.weights.get(0);
        for (int i = 1; i < nRows; ++i) {
            totalWeight += ((Double)this.weights.get(i)).doubleValue();
        }
        return totalWeight;
    }

    public void setInsideMargin(double n) {
        this.interMargin = n;
    }

    private double getMinimum(int i) {
        double totalWeight = this.integrateWeight(this.rows.size());
        double partialWeight = this.integrateWeight(i);
        double alphaFt = 1.0 - (1.0 - this.row.getMaximum()) - this.row.getMinimum() - (double)(this.rows.size() - 1) * this.interMargin;
        double nWeight = partialWeight / totalWeight;
        double plotsFt = alphaFt * nWeight;
        return this.row.getMinimum() + plotsFt + (double)i * this.interMargin;
    }

    double getMinimum(DasDevicePosition row) {
        int i = this.rows.indexOf(row);
        return this.getMinimum(i);
    }

    double getMaximum(int i) {
        return this.getMinimum(i + 1) - this.interMargin;
    }

    double getMaximum(DasDevicePosition row) {
        int i = this.rows.indexOf(row);
        return this.getMaximum(i);
    }

    private void printWeights() {
        for (int i = 0; i < this.weights.size(); ++i) {
            System.out.println("  " + i + ": " + this.weights.get(i));
        }
        System.out.println("total: " + this.integrateWeight(this.rows.size()));
    }

    double[] getMinima() {
        double[] result = new double[this.weights.size()];
        for (int i = 0; i < this.weights.size(); ++i) {
            result[i] = this.getMinimum(i);
        }
        return result;
    }

    double[] getMaxima() {
        double[] result = new double[this.weights.size()];
        for (int i = 0; i < this.weights.size(); ++i) {
            result[i] = this.getMaximum(i);
        }
        return result;
    }

    void setWeights(double[] minima, double[] maxima) {
        int j;
        double totalWeight = this.integrateWeight(this.rows.size());
        double[] ftWeight = new double[this.rows.size()];
        double ftTotalWeight = 0.0;
        for (j = 0; j < this.rows.size(); ++j) {
            ftWeight[j] = maxima[j] - minima[j];
            ftTotalWeight += ftWeight[j];
        }
        for (j = 0; j < this.rows.size(); ++j) {
            this.weights.set(j, new Double(totalWeight * ftWeight[j] / ftTotalWeight));
        }
    }

    public void setTopMargin(double nmargin) {
        this.row.setMinimum(nmargin);
    }

    public void setBottomMargin(double nmargin) {
        this.row.setMaximum(1.0 - nmargin);
    }

    void setMaximum(DasDevicePosition row, double nposition) {
        double[] minima = this.getMinima();
        double[] maxima = this.getMaxima();
        int i = this.rows.indexOf(row);
        maxima[i] = nposition;
        double alpha1 = nposition;
        double alpha2 = 1.0 - (1.0 - this.row.getMaximum());
        if (i == this.rows.size() - 1) {
            this.row.setMaximum(nposition);
        } else {
            int nBelow = this.rows.size() - 1 - i;
            double weight3 = this.integrateWeight(this.rows.size()) - this.integrateWeight(i + 1);
            double fractionalIntegratedWeight = 0.0;
            for (int j = 1; j < nBelow; ++j) {
                maxima[j + i] = alpha2 * (fractionalIntegratedWeight += (Double)this.weights.get(j + i) / weight3) + alpha1 * (1.0 - fractionalIntegratedWeight);
            }
        }
        for (int j = 1; j < this.rows.size(); ++j) {
            minima[j] = maxima[j - 1] + this.interMargin;
        }
        this.printArray("setMax: minima = ", minima);
        this.printArray("setMax: maxima = ", maxima);
        this.setWeights(minima, maxima);
    }

    void setMinimum(DasDevicePosition row, double nposition) {
        double[] minima = this.getMinima();
        double[] maxima = this.getMaxima();
        int i = this.rows.indexOf(row);
        minima[i] = nposition;
        double alpha1 = this.row.getMinimum();
        double alpha2 = nposition;
        if (i == 0) {
            this.row.setMinimum(nposition);
        } else {
            int nAbove = i;
            double weight3 = this.integrateWeight(i);
            double fractionalIntegratedWeight = 0.0;
            for (int j = 0; j < i; ++j) {
                minima[j] = alpha2 * fractionalIntegratedWeight + alpha1 * (1.0 - fractionalIntegratedWeight);
                fractionalIntegratedWeight += (Double)this.weights.get(j) / weight3;
            }
        }
        for (int j = 0; j < this.rows.size() - 1; ++j) {
            maxima[j] = minima[j + 1] - this.interMargin;
        }
        this.setWeights(minima, maxima);
    }

    private void printArray(String label, double[] values) {
        System.out.print(label);
        for (int i = 0; i < values.length - 1; ++i) {
            System.out.print((int)(values[i] * 100.0) + ",");
        }
        System.out.println((int)(values[values.length - 1] * 100.0));
    }

    public String toString() {
        String result = "--- leveler ---";
        for (int i = 0; i < this.rows.size(); ++i) {
            result = result + "\n" + this.rows.get(i).toString();
        }
        result = result + "-------------\n";
        return result;
    }

    public List getRows() {
        return new ArrayList(this.rows);
    }

    private static class LevelRow
    extends DasRow {
        Leveler lev;

        public LevelRow(DasCanvas parent, Leveler lev, double nposition, double weight) {
            super(parent, 0.0, 0.0);
            this.lev = lev;
            lev.insertAt(nposition, this, weight);
        }

        public LevelRow(DasCanvas parent, Leveler lev, double nposition) {
            this(parent, lev, nposition, 1.0);
        }

        public double getMaximum() {
            if (this.lev == null) {
                return 0.0;
            }
            return this.lev.getMaximum(this);
        }

        public double getMinimum() {
            if (this.lev == null) {
                return 0.0;
            }
            return this.lev.getMinimum(this);
        }

        public int getDMinimum() {
            return (int)(this.getMinimum() * (double)this.getDeviceSize());
        }

        public int getDMaximum() {
            return (int)(this.getMaximum() * (double)this.getDeviceSize());
        }

        public void setDPosition(int minimum, int maximum) {
            this.lev.setMaximum(this, (float)maximum / (float)this.getDeviceSize());
            this.lev.setMinimum(this, (float)minimum / (float)this.getDeviceSize());
        }

        public void setDMinimum(int minimum) {
            super.setDMinimum(minimum);
        }

        public void setDMaximum(int maximum) {
            super.setDMaximum(maximum);
        }
    }
}

