/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.Renderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;

public class PitchAngleDistributionRenderer
extends Renderer {
    protected DasColorBar colorBar = null;
    public static final String PROP_COLORBAR = "colorBar";
    PropertyChangeListener rebinListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent e) {
            PitchAngleDistributionRenderer.this.update();
            PitchAngleDistributionRenderer.this.refreshImage();
        }
    };
    public static final String PROP_ORIGINNORTH = "originNorth";
    protected boolean originNorth = false;
    protected boolean mirror = false;
    public static final String PROP_MIRROR = "mirror";

    public PitchAngleDistributionRenderer(DasColorBar cb) {
        this.setColorBar(cb);
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public Icon getListIcon() {
        return new ImageIcon(SpectrogramRenderer.class.getResource("/images/icons/pitchAngleDistribution.png"));
    }

    public final void setColorBar(DasColorBar colorBar) {
        DasColorBar oldColorBar = this.colorBar;
        if (this.colorBar != null) {
            colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            colorBar.removePropertyChangeListener("log", this.rebinListener);
            colorBar.removePropertyChangeListener("type", this.rebinListener);
            colorBar.removePropertyChangeListener("fillColor", this.rebinListener);
        }
        this.colorBar = colorBar;
        if (this.colorBar != null) {
            colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            colorBar.addPropertyChangeListener("log", this.rebinListener);
            colorBar.addPropertyChangeListener("type", this.rebinListener);
            colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_COLORBAR, oldColorBar, colorBar);
    }

    public static QDataSet doAutorange(QDataSet tds) {
        DDataSet xdesc;
        QDataSet zdesc = Ops.extent((QDataSet)tds);
        QDataSet ads = SemanticOps.xtagsDataSet((QDataSet)tds);
        QDataSet rds = SemanticOps.ytagsDataSet((QDataSet)tds);
        Units xunits = SemanticOps.getUnits((QDataSet)ads);
        Units yunits = SemanticOps.getUnits((QDataSet)rds);
        if (yunits.isConvertableTo(Units.degrees) && !xunits.isConvertableTo(Units.degrees)) {
            rds = SemanticOps.xtagsDataSet((QDataSet)tds);
        }
        DDataSet ydesc = xdesc = DDataSet.wrap((double[])new double[]{0.0, Ops.extent((QDataSet)rds).value(1)});
        xdesc = Ops.rescaleRange((QDataSet)xdesc, (double)-1.1, (double)1.1);
        ydesc = Ops.rescaleRange((QDataSet)ydesc, (double)-1.1, (double)1.1);
        JoinDataSet bds = new JoinDataSet(2);
        bds.join((QDataSet)xdesc);
        bds.join((QDataSet)ydesc);
        bds.join(zdesc);
        return bds;
    }

    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        QDataSet tds = this.ds;
        if (tds == null) {
            logger.fine("null data set");
            this.parent.postMessage(this, "no data set", 0, null, null);
            return;
        }
        if (!SemanticOps.isTableDataSet((QDataSet)tds)) {
            this.parent.postException(this, new IllegalArgumentException("expected Table: " + tds));
            return;
        }
        if (!xAxis.getUnits().isConvertableTo(yAxis.getUnits())) {
            this.parent.postException(this, new IllegalArgumentException("x and y axes have different units, x=" + xAxis.getUnits() + " y=" + yAxis.getUnits()));
            return;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.colorBar == null) {
            return;
        }
        QDataSet ads = SemanticOps.xtagsDataSet((QDataSet)tds);
        QDataSet rds = SemanticOps.ytagsDataSet((QDataSet)tds);
        Units xunits = SemanticOps.getUnits((QDataSet)ads);
        Units yunits = SemanticOps.getUnits((QDataSet)rds);
        if (yunits.isConvertableTo(Units.degrees) && !xunits.isConvertableTo(Units.degrees)) {
            rds = SemanticOps.xtagsDataSet((QDataSet)tds);
            ads = SemanticOps.ytagsDataSet((QDataSet)tds);
            xunits = SemanticOps.getUnits((QDataSet)ads);
            yunits = SemanticOps.getUnits((QDataSet)rds);
            tds = Ops.transpose((QDataSet)tds);
        }
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)tds);
        float[][] xx = new float[tds.length() + 1][tds.length(0) + 1];
        float[][] yy = new float[tds.length() + 1][tds.length(0) + 1];
        if (SemanticOps.getUnits((QDataSet)ads) == Units.dimensionless) {
            xunits = Units.radians;
        }
        Units zunits = SemanticOps.getUnits((QDataSet)tds);
        double da = (ads.value(1) - ads.value(0)) / 2.0;
        double x0 = xAxis.transform(0.0, yunits);
        double y0 = yAxis.transform(0.0, yunits);
        for (int iflip = 0; iflip < 2; ++iflip) {
            if (!this.mirror && iflip == 1) continue;
            for (int j = 0; j < rds.length() - 1; ++j) {
                double v1 = rds.value(j);
                double v2 = rds.value(j + 1);
                double r0x = xAxis.transform(v1, yunits) - x0;
                double r0y = y0 - yAxis.transform(v1, yunits);
                double r1x = xAxis.transform(v2, yunits) - x0;
                double r1y = y0 - yAxis.transform(v2, yunits);
                for (int i = 0; i < ads.length(); ++i) {
                    double a0 = ads.value(i) - da;
                    double a1 = ads.value(i) + da;
                    if (iflip == 1) {
                        a0 = -a0;
                        a1 = -a1;
                    }
                    if (xunits == Units.degrees) {
                        a0 = Math.toRadians(a0);
                        a1 = Math.toRadians(a1);
                    }
                    if (this.originNorth) {
                        yy[i][j] = (float)(y0 - Math.cos(a0) * r0y);
                        xx[i][j] = (float)(x0 - Math.sin(a0) * r0x);
                        yy[i][j + 1] = (float)(y0 - Math.cos(a0) * r1y);
                        xx[i][j + 1] = (float)(x0 - Math.sin(a0) * r1x);
                        yy[i + 1][j] = (float)(y0 - Math.cos(a1) * r0y);
                        xx[i + 1][j] = (float)(x0 - Math.sin(a1) * r0x);
                        yy[i + 1][j + 1] = (float)(y0 - Math.cos(a1) * r1y);
                        xx[i + 1][j + 1] = (float)(x0 - Math.sin(a1) * r1x);
                    } else {
                        xx[i][j] = (float)(x0 + Math.cos(a0) * r0x);
                        yy[i][j] = (float)(y0 - Math.sin(a0) * r0y);
                        xx[i][j + 1] = (float)(x0 + Math.cos(a0) * r1x);
                        yy[i][j + 1] = (float)(y0 - Math.sin(a0) * r1y);
                        xx[i + 1][j] = (float)(x0 + Math.cos(a1) * r0x);
                        yy[i + 1][j] = (float)(y0 - Math.sin(a1) * r0y);
                        xx[i + 1][j + 1] = (float)(x0 + Math.cos(a1) * r1x);
                        yy[i + 1][j + 1] = (float)(y0 - Math.sin(a1) * r1y);
                    }
                    if (!(wds.value(i, j) > 0.0)) continue;
                    int zz = this.colorBar.rgbTransform(tds.value(i, j), zunits);
                    g.setColor(new Color(zz));
                    GeneralPath gp = new GeneralPath(1, 6);
                    gp.moveTo(xx[i][j], yy[i][j]);
                    gp.lineTo(xx[i][j + 1], yy[i][j + 1]);
                    gp.lineTo(xx[i + 1][j + 1], yy[i + 1][j + 1]);
                    gp.lineTo(xx[i + 1][j], yy[i + 1][j]);
                    gp.lineTo(xx[i][j], yy[i][j]);
                    g.fill(gp);
                    g.draw(gp);
                }
            }
        }
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    public boolean isOriginNorth() {
        return this.originNorth;
    }

    public void setOriginNorth(boolean originNorth) {
        boolean oldOriginNorth = this.originNorth;
        this.originNorth = originNorth;
        this.propertyChangeSupport.firePropertyChange(PROP_ORIGINNORTH, oldOriginNorth, originNorth);
        this.update();
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        boolean oldMirror = this.mirror;
        this.mirror = mirror;
        this.propertyChangeSupport.firePropertyChange(PROP_MIRROR, oldMirror, mirror);
        this.update();
    }
}

