/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;

public class Psym
implements Enumeration,
Displayable {
    private static final String[] NAMES = new String[]{"none", "dots", "circles", "triangles", "cross"};
    public static final Psym NONE = new Psym(0);
    public static final Psym DOTS = new Psym(1);
    public static final Psym CIRCLES = new Psym(2);
    public static final Psym TRIANGLES = new Psym(3);
    public static final Psym CROSS = new Psym(4);
    private int nameIndex;
    private Line2D line = new Line2D.Double();
    private Ellipse2D ellipse = new Ellipse2D.Double();
    ImageIcon imageIcon;

    private Psym(int nameIndex) {
        this.nameIndex = nameIndex;
        this.line = new Line2D.Double();
        BufferedImage i = new BufferedImage(10, 10, 1);
        Graphics2D g = (Graphics2D)((Image)i).getGraphics();
        g.setBackground(Color.white);
        g.setRenderingHints(DasProperties.getRenderingHints());
        g.setColor(Color.white);
        g.fillRect(0, 0, 10, 10);
        g.setColor(Color.black);
        this.draw(g, 5.0, 5.0, 2.0f);
        this.imageIcon = new ImageIcon(i);
    }

    public String toString() {
        return NAMES[this.nameIndex];
    }

    public String getListLabel() {
        return NAMES[this.nameIndex];
    }

    public Icon getListIcon() {
        return this.imageIcon;
    }

    public void drawListIcon(Graphics2D g, int x, int y) {
        ImageIcon i = (ImageIcon)this.getListIcon();
        g.drawImage(i.getImage(), x, y, null);
    }

    public void draw(Graphics g, double x, double y, float size) {
        Graphics2D g2 = (Graphics2D)(g instanceof Graphics2D ? g : null);
        switch (this.nameIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (size < 1.0f) {
                    if (g instanceof Graphics2D) {
                        this.ellipse.setFrame(x, y, 1.0, 1.0);
                        g2.fill(this.ellipse);
                        break;
                    }
                    g.fillOval((int)x, (int)y, 1, 1);
                    break;
                }
                if (g instanceof Graphics2D) {
                    this.ellipse.setFrame(x - (double)size, y - (double)size, size * 2.0f, size * 2.0f);
                    g2.fill(this.ellipse);
                    break;
                }
                g.fillOval((int)(x - (double)size), (int)(x - (double)size), (int)(size * 2.0f), (int)(size * 2.0f));
                break;
            }
            case 2: {
                Color color0 = g.getColor();
                this.ellipse.setFrame(x - (double)size, y - (double)size, size * 2.0f, size * 2.0f);
                Color backgroundColor = Color.white;
                g.setColor(backgroundColor);
                if (g instanceof Graphics2D) {
                    g2.fill(this.ellipse);
                } else {
                    g.fillOval((int)(x - (double)size), (int)(y - (double)size), (int)(size * 2.0f), (int)(size * 2.0f));
                }
                g.setColor(color0);
                if (g instanceof Graphics2D) {
                    g2.draw(this.ellipse);
                    break;
                }
                g.drawOval((int)(x - (double)size), (int)(y - (double)size), (int)(size * 2.0f), (int)(size * 2.0f));
                break;
            }
            case 3: {
                this.drawTriangle(g, x, y, size);
                break;
            }
            case 4: {
                if (g instanceof Graphics2D) {
                    this.line.setLine(x - (double)size, y, x + (double)size, y);
                    g2.draw(this.line);
                    this.line.setLine(x, y - (double)size, x, y + (double)size);
                    g2.draw(this.line);
                    break;
                }
                g.drawLine((int)(x - (double)size), (int)y, (int)(x + (double)size), (int)y);
                g.drawLine((int)x, (int)(y - (double)size), (int)x, (int)(y + (double)size));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid nameIndex for psym");
            }
        }
    }

    public void drawTriangle(Graphics g, double x, double y, float size) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            this.line.setLine(x, y - (double)size, x + (double)size, y + (double)size);
            g2.draw(this.line);
            this.line.setLine(x + (double)size, y + (double)size, x - (double)size, y + (double)size);
            g2.draw(this.line);
            this.line.setLine(x - (double)size, y + (double)size, x, y - (double)size);
            g2.draw(this.line);
        } else {
            g.drawLine((int)x, (int)(y - (double)size), (int)(x + (double)size), (int)(y + (double)size));
            g.drawLine((int)(x + (double)size), (int)(y + (double)size), (int)(x - (double)size), (int)(y + (double)size));
            g.drawLine((int)(x - (double)size), (int)(y + (double)size), (int)x, (int)(y - (double)size));
        }
    }

    public static Psym parsePsym(String str) {
        if (str.equals("none")) {
            return NONE;
        }
        if (str.equals("dots")) {
            return DOTS;
        }
        if (str.equals("circles")) {
            return CIRCLES;
        }
        if (str.equals("triangles")) {
            return TRIANGLES;
        }
        if (str.equals("cross")) {
            return CROSS;
        }
        throw new IllegalArgumentException(str);
    }
}

