/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.EventsRenderer;
import org.das2.graph.ImageVectorDataSetRenderer;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;

public class SelectionUtil {
    public static final Shape NULL = new GeneralPath();

    public static Shape getSelectionArea(Renderer r) {
        if (r instanceof SeriesRenderer) {
            Shape a = ((SeriesRenderer)r).selectionArea();
            return a;
        }
        if (r instanceof SpectrogramRenderer) {
            return ((SpectrogramRenderer)r).selectionArea();
        }
        if (r instanceof DigitalRenderer) {
            return ((DigitalRenderer)r).selectionArea();
        }
        if (r instanceof EventsRenderer) {
            return ((EventsRenderer)r).selectionArea();
        }
        if (r instanceof ImageVectorDataSetRenderer) {
            return ((ImageVectorDataSetRenderer)r).selectionArea();
        }
        Rectangle rect = DasDevicePosition.toRectangle(r.getParent().getRow(), r.getParent().getColumn());
        rect = new Rectangle(rect.x + 5, rect.y + 5, rect.width - 10, rect.height - 10);
        return rect;
    }

    public static Shape getSelectionArea(DasCanvasComponent cc) {
        return cc.getActiveRegion();
    }
}

