/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.fft;

public class ComplexArray {
    public static Double newArray(double[] real) {
        double[] imag = new double[real.length];
        return new ComplexArrayDoubleDouble(real, imag);
    }

    public static Double newArrayCopy(double[] real) {
        double[] imag = new double[real.length];
        double[] realCopy = new double[real.length];
        for (int i = 0; i < real.length; ++i) {
            realCopy[i] = real[i];
        }
        return new ComplexArrayDoubleDouble(realCopy, imag);
    }

    public static Double newArray(double[] real, double[] imag) {
        return new ComplexArrayDoubleDouble(real, imag);
    }

    public static Float newArray(float[] real) {
        float[] imag = new float[real.length];
        return new ComplexArrayFloatFloat(real, imag);
    }

    public static Float newArray(float[] real, float[] imag) {
        return new ComplexArrayFloatFloat(real, imag);
    }

    public static String toString(Float array) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length(); ++i) {
            buf.append("(" + array.getReal(i) + ", " + array.getImag(i) + ") ");
        }
        return buf.toString();
    }

    public static String toString(Double array) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length(); ++i) {
            buf.append("(" + array.getReal(i) + ", " + array.getImag(i) + ") ");
        }
        return buf.toString();
    }

    public static double[] realPart(Double array) {
        double[] result = new double[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            result[i] = array.getReal(i);
        }
        return result;
    }

    public static double[] magnitude(Double array) {
        double[] result = new double[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            result[i] = ComplexArray.magnitude(array, i);
        }
        return result;
    }

    public static final double magnitude2(Double array, int i) {
        return Math.pow(array.getReal(i), 2.0) + Math.pow(array.getImag(i), 2.0);
    }

    public static final double magnitude(Double array, int i) {
        return Math.sqrt(Math.pow(array.getReal(i), 2.0) + Math.pow(array.getImag(i), 2.0));
    }

    public static final class ComplexArrayFloatFloat
    implements Float {
        final float[] real;
        final float[] imaginary;

        private ComplexArrayFloatFloat(float[] real, float[] imaginary) {
            this.real = real;
            this.imaginary = imaginary;
        }

        public float getImag(int i) {
            return this.imaginary[i];
        }

        public float getReal(int i) {
            return this.real[i];
        }

        public void setImag(int i, float value) {
            this.imaginary[i] = value;
        }

        public void setReal(int i, float value) {
            this.real[i] = value;
        }

        public int length() {
            return this.real.length;
        }
    }

    public static final class ComplexArrayDoubleDouble
    implements Double {
        final double[] real;
        final double[] imaginary;

        private ComplexArrayDoubleDouble(double[] real, double[] imaginary) {
            this.real = real;
            this.imaginary = imaginary;
        }

        public double getImag(int i) {
            return this.imaginary[i];
        }

        public double getReal(int i) {
            return this.real[i];
        }

        public void setImag(int i, double value) {
            this.imaginary[i] = value;
        }

        public void setReal(int i, double value) {
            this.real[i] = value;
        }

        public int length() {
            return this.real.length;
        }
    }

    public static interface Double {
        public double getReal(int var1);

        public double getImag(int var1);

        public void setReal(int var1, double var2);

        public void setImag(int var1, double var2);

        public int length();
    }

    public static interface Float {
        public float getReal(int var1);

        public float getImag(int var1);

        public void setReal(int var1, float var2);

        public void setImag(int var1, float var2);

        public int length();
    }
}

