/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.das2.components.DasProgressPanel;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.MonitorFactory;
import org.das2.util.monitor.ProgressMonitor;

public class DefaultMonitorFactory
implements MonitorFactory {
    LinkedHashMap monitors = new LinkedHashMap(){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > DefaultMonitorFactory.this.size;
        }
    };
    protected int size = 10;
    public static final String PROP_SIZE = "size";

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public ProgressMonitor getMonitor(DasCanvas canvas, String label, String description) {
        DasProgressPanel result = DasProgressPanel.createComponentPanel(canvas, label);
        this.putMonitor(result, label, description);
        return result;
    }

    public ProgressMonitor getMonitor(DasCanvasComponent context, String label, String description) {
        DasProgressPanel result = DasProgressPanel.createComponentPanel(context, label);
        this.putMonitor(result, label, description);
        return result;
    }

    public ProgressMonitor getMonitor(String label, String description) {
        DasProgressPanel result = DasProgressPanel.createFramed(label);
        this.putMonitor(result, label, description);
        return result;
    }

    private void putMonitor(ProgressMonitor monitor, String label, String description) {
        Long key = System.currentTimeMillis();
        this.monitors.put(key, new MonitorEntry(monitor, description));
    }

    public MonitorEntry[] getMonitors() {
        Collection set = this.monitors.values();
        return set.toArray(new MonitorEntry[set.size()]);
    }

    public MonitorEntry getMonitors(int i) {
        return this.getMonitors()[i];
    }

    public void setClear(boolean clear) {
        if (clear) {
            this.monitors.keySet().removeAll(this.monitors.keySet());
        }
    }

    public boolean isClear() {
        return false;
    }

    public class MonitorEntry {
        ProgressMonitor monitor;
        String description;

        MonitorEntry(ProgressMonitor monitor, String description) {
            this.monitor = monitor;
            this.description = description;
        }

        public String toString() {
            String desc = this.description;
            if (desc.length() > 50) {
                desc = "..." + this.description.substring(this.description.length() - 50);
            }
            return String.valueOf(this.monitor) + " " + desc;
        }
    }
}

