/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.das2.event.DasUpdateEvent;

public final class EventQueueBlocker {
    private static final Logger logger = Logger.getLogger("das2.system");
    static MyEventQueue myEventQueue = new MyEventQueue();

    private EventQueueBlocker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearEventQueueImmediately() {
        System.err.println(Thread.currentThread().getName());
        MyEventQueue myEventQueue = EventQueueBlocker.myEventQueue;
        synchronized (myEventQueue) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(EventQueueBlocker.myEventQueue);
            try {
                EventQueueBlocker.myEventQueue.wait();
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
        logger.info("no more pending events");
    }

    private static DasUpdateEvent findUpdateEvent(EventQueue eventQueue) {
        LinkedList<AWTEvent> queue = new LinkedList<AWTEvent>();
        AWTEvent evt = null;
        DasUpdateEvent result = null;
        while (eventQueue.peekEvent() != null) {
            try {
                evt = eventQueue.getNextEvent();
                if (evt instanceof DasUpdateEvent) {
                    result = (DasUpdateEvent)evt;
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            queue.add(evt);
        }
        while (queue.size() > 0) {
            eventQueue.postEvent((AWTEvent)queue.remove());
        }
        return result;
    }

    public static synchronized void clearEventQueue() throws InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            EventQueueBlocker.clearEventQueueImmediately();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        EventQueueBlocker.clearEventQueueImmediately();
                    }
                });
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            logger.finer("waiting for lockObject to indicate eventQueue is clear");
            logger.finer("event queue task complete");
        }
    }

    static class MyEventQueue
    extends EventQueue {
        MyEventQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchEvent(AWTEvent event) {
            super.dispatchEvent(event);
            if (myEventQueue.peekEvent(46288) == null) {
                MyEventQueue myEventQueue = this;
                synchronized (myEventQueue) {
                    this.pop();
                    this.notifyAll();
                }
            }
        }
    }
}

