/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.util.Random;
import org.das2.dataset.test.BigVectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.GraphUtil;
import org.das2.graph.LegendPosition;
import org.das2.graph.PsymConnector;
import org.das2.graph.SeriesRenderer;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;
import org.virbo.dsutil.DataSetBuilder;

public class PlotSymbolRendererDemo {
    public static DasPlot doit() {
        QDataSet vds = BigVectorDataSet.getDataSet(100000, (ProgressMonitor)new NullProgressMonitor());
        DasPlot p = GraphUtil.visualize(vds);
        return p;
    }

    public static DasPlot doit1() {
        QDataSet ds = BigVectorDataSet.getDataSet(1000, (ProgressMonitor)new NullProgressMonitor());
        QDataSet xds = ds.trim(0, 500);
        QDataSet yds = ds.trim(500, 1000);
        QDataSet ds2 = Ops.link((QDataSet)xds, (QDataSet)yds);
        DasPlot p = GraphUtil.visualize(ds2);
        return p;
    }

    public static DasPlot doit2(boolean bundleScheme) {
        int size = 20000;
        double dsize = size;
        System.err.println("enter getDataSet");
        long t0 = System.currentTimeMillis();
        Random random = new Random(0L);
        DataSetBuilder vbd = new DataSetBuilder(2, 100, 3);
        vbd.putProperty("FILL_VALUE", (Object)Units.dimensionless.getFillDouble());
        double y = 0.0;
        for (int i = 0; i < size; ++i) {
            y += random.nextDouble() - 0.5;
            if (i % 100 == 10) {
                vbd.putValue(i, 0, (double)i / dsize);
                vbd.putValue(i, 1, Units.dimensionless.getFillDouble());
                vbd.putValue(i, 2, 0.0);
                continue;
            }
            vbd.putValue(i, 0, (double)i / dsize);
            vbd.putValue(i, 1, y);
            vbd.putValue(i, 2, (double)((i - 10) / 100));
        }
        vbd.putProperty("DEPEND_1", (Object)Ops.labels((String[])new String[]{"x", "y", "color"}));
        DDataSet vds = vbd.getDataSet();
        if (!bundleScheme) {
            MutablePropertyDataSet vds1 = DataSetOps.slice1((QDataSet)vds, (int)1);
            vds1.putProperty("DEPEND_0", (Object)DataSetOps.slice1((QDataSet)vds, (int)0));
            vds1.putProperty("PLANE_0", (Object)DataSetOps.slice1((QDataSet)vds, (int)2));
            vds = vds1;
        }
        System.err.println("done getDataSet in " + (System.currentTimeMillis() - t0) + " ms");
        DasPlot p = GraphUtil.visualize((QDataSet)vds);
        p.getColumn().setEmMaximum(-10.0);
        p.removeRenderer(p.getRenderer(0));
        SeriesRenderer r2 = new SeriesRenderer();
        DasColorBar cb = new DasColorBar(Datum.create((int)0), Datum.create((int)100), false);
        p.getCanvas().add(cb, p.getRow(), DasColumn.create(null, p.getColumn(), "100%+2em", "100%+4em"));
        r2.setColorBar(cb);
        r2.setPsym(DefaultPlotSymbol.CIRCLES);
        r2.setSymSize(10.0);
        r2.setPsymConnector(PsymConnector.NONE);
        r2.setColorByDataSetId("color");
        p.addRenderer(r2);
        r2.setDataSet((QDataSet)vds);
        p.setPreviewEnabled(true);
        p.getXAxis().setAnimated(false);
        p.getYAxis().setAnimated(false);
        return p;
    }

    public static DasPlot doit3() {
        int len0 = 100;
        QDataSet dy = Ops.add((QDataSet)DataSetUtil.asDataSet((double)5.0), (QDataSet)Ops.randn((int)len0));
        MutablePropertyDataSet y = (MutablePropertyDataSet)Ops.multiply((QDataSet)DataSetUtil.asDataSet((double)30.0), (QDataSet)Ops.sin((QDataSet)Ops.linspace((double)0.0, (double)(Math.PI * 5), (int)len0)));
        y.putProperty("DELTA_MINUS", (Object)dy);
        y.putProperty("DELTA_PLUS", (Object)dy);
        DasPlot p = GraphUtil.visualize((QDataSet)y);
        return p;
    }

    public static DasPlot doit4() {
        QDataSet ds = BigVectorDataSet.getDataSet(1500, (ProgressMonitor)new NullProgressMonitor());
        QDataSet xds = ds.trim(0, 500);
        QDataSet yds = ds.trim(500, 1000);
        QDataSet cds = Ops.findgen((int)500);
        QDataSet ds2 = Ops.link((QDataSet)xds, (QDataSet)yds, (QDataSet)cds);
        DasPlot p = GraphUtil.visualize(ds2);
        return p;
    }

    public static void main(String[] args) {
        DasPlot p = PlotSymbolRendererDemo.doit4();
        p.setLegendPosition(LegendPosition.SE);
        p.getRenderer(0).setLegendLabel("Test!cTest");
        p.getRenderer(0).setDrawLegendLabel(true);
    }
}

