/*
 * Decompiled with CFR 0.152.
 */
package test.util;

import java.text.ParseException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;

public class TestTimeParser {
    private static boolean doTest(String format, String str, Datum ref) throws ParseException {
        TimeParser tp = TimeParser.create((String)format);
        DatumRange t = tp.parse(str).getTimeRange();
        if (!ref.equals(t.min())) {
            throw new IllegalArgumentException("test fails: " + str + " " + format);
        }
        System.err.println("okay: " + tp.format(t.min(), t.max()));
        return true;
    }

    public static void doTest2() throws ParseException {
        TimeParser tp = TimeParser.create((String)"file:///home/jbf/product_%Y-%j.png");
        System.err.println(tp.toString());
        tp.parse("file:///home/jbf/product_2009-230.png");
        System.err.println(tp.getTimeRange());
    }

    public static void main(String[] args) throws ParseException {
        TestTimeParser.doTest("%-1{j;Y=2008}", "1", TimeUtil.createValid((String)"20080101T00:00:00Z"));
        TestTimeParser.doTest2();
    }
}

